/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.BackgroundSyncThread;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.List;

class BackgroundSync {
    private static final String TAG = BackgroundSync.class.getSimpleName();
    private static final int MESSAGE_QUERY_INITIAL_RESULT_SIZE = 30;
    private State mState = State.INIT;
    private BackgroundSyncThread mNextThread;
    private BackgroundSyncThread mPrevThread;
    private boolean mIsSyncedOnce = false;
    private BaseChannel mChannel;
    private MessageFilter mFilter;
    private long mViewpointTimestamp;
    private int mBackgroundSyncFinishedCounter = 0;
    private BackgroundSyncEventListener mPrevEventListener;
    private BackgroundSyncEventListener mNextEventListener;

    BackgroundSync(BaseChannel channel, MessageFilter filter, long viewpointTimestamp) {
        this.mChannel = channel;
        this.mFilter = filter;
        this.mViewpointTimestamp = viewpointTimestamp;
    }

    State getState() {
        return this.mState;
    }

    boolean isSyncFinished(boolean isNext) {
        if (isNext) {
            if (this.mNextThread == null) {
                return false;
            }
            return this.mNextThread.isFinished();
        }
        if (this.mPrevThread == null) {
            return false;
        }
        return this.mPrevThread.isFinished();
    }

    void start() {
        Logger.i(TAG, "start()");
        new Thread(new Runnable(){

            @Override
            public void run() {
                BackgroundSync.this.mBackgroundSyncFinishedCounter = 0;
                final BackgroundSyncFinishedListener listener = new BackgroundSyncFinishedListener(){

                    @Override
                    public void onFinished() {
                        BackgroundSync.this.mBackgroundSyncFinishedCounter++;
                        if (BackgroundSync.this.mBackgroundSyncFinishedCounter == 2) {
                            BackgroundSync.this.mState = State.FINISHED;
                        }
                    }
                };
                MessageChunk chunk = MessageManager.getInstance().getMessageChunkContainer().getChunkByTimestamp(BackgroundSync.this.mChannel.getUrl(), BackgroundSync.this.mFilter, BackgroundSync.this.mViewpointTimestamp, false);
                if (chunk == null) {
                    BackgroundSync.this.mChannel.getPreviousAndNextMessagesByTimestamp(BackgroundSync.this.mViewpointTimestamp, 30, 30, false, BackgroundSync.this.mFilter.getMessageTypeFilter(), BackgroundSync.this.mFilter.getCustomType(), BackgroundSync.this.mFilter.getSenderUserIds(), new BaseChannel.GetMessagesHandler(){

                        public void onResult(final List<BaseMessage> list, SendBirdException e) {
                            Logger.d(TAG, "getPreviousAndNextMessagesByTimestamp. list size = " + (list == null ? "null" : Integer.valueOf(list.size())) + ", e = " + e);
                            if (e != null) {
                                e.printStackTrace();
                                return;
                            }
                            BackgroundSync.this.mIsSyncedOnce = true;
                            if (list.size() == 0) {
                                BackgroundSync.this.onSynced(true, e);
                                BackgroundSync.this.onSynced(false, e);
                            } else {
                                MessageManager.getInstance().getMessageContainer().upsertMessages(list, true, new MessageContainer.UpsertMessageHandler(){

                                    @Override
                                    public void onResult(List<BaseMessage> insertedMessages, List<BaseMessage> updatedMessages, SendBirdException e) {
                                        Logger.d(TAG, "upsertMessages. insertedMessage list size = " + insertedMessages.size() + " updatedMessage list size = " + updatedMessages.size() + ", e = " + e);
                                        long startAt = ((BaseMessage)list.get(0)).getCreatedAt();
                                        long endAt = ((BaseMessage)list.get(list.size() - 1)).getCreatedAt();
                                        final MessageChunk newChunk = new MessageChunk(BackgroundSync.this.mChannel.getUrl(), startAt, endAt, BackgroundSync.this.mFilter);
                                        MessageManager.getInstance().getMessageChunkContainer().mergeIntersectedChunks(newChunk, new CompletionHandler(){

                                            @Override
                                            public void onCompleted(SendBirdException e) {
                                                Logger.d(TAG, "mergeIntersectedChunks. e = " + e);
                                                BackgroundSync.this.onSynced(true, e);
                                                BackgroundSync.this.onSynced(false, e);
                                                BackgroundSync.this.startPrev(newChunk, listener);
                                                BackgroundSync.this.startNext(newChunk, listener);
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    });
                } else {
                    BackgroundSync.this.mIsSyncedOnce = true;
                    BackgroundSync.this.startPrev(chunk, listener);
                    BackgroundSync.this.startNext(chunk, listener);
                }
            }
        }).start();
        this.mState = State.RUNNING;
    }

    void stop() {
        if (this.mNextThread != null) {
            this.mNextThread.stopSync();
            this.mNextThread = null;
        }
        if (this.mPrevThread != null) {
            this.mPrevThread.stopSync();
            this.mPrevThread = null;
        }
        this.mState = this.mState == State.FINISHED ? State.FINISHED : State.STOPPED;
    }

    private void startNext(MessageChunk chunk, BackgroundSyncFinishedListener listener) {
        if (this.mNextThread == null) {
            this.mNextThread = new BackgroundSyncThread(this.mChannel, chunk, true, listener);
            this.mNextThread.setEventListener(new BackgroundSyncEventListener(){

                @Override
                public void onSynced(SendBirdException e) {
                    BackgroundSync.this.onSynced(true, e);
                }
            });
            this.mNextThread.start();
        }
    }

    private void startPrev(MessageChunk chunk, BackgroundSyncFinishedListener listener) {
        if (this.mPrevThread == null) {
            this.mPrevThread = new BackgroundSyncThread(this.mChannel, chunk, false, listener);
            this.mPrevThread.setEventListener(new BackgroundSyncEventListener(){

                @Override
                public void onSynced(SendBirdException e) {
                    BackgroundSync.this.onSynced(false, e);
                }
            });
            this.mPrevThread.start();
        }
    }

    void subscribe(boolean isNext, BackgroundSyncEventListener listener) {
        if (isNext) {
            this.mNextEventListener = listener;
        } else {
            this.mPrevEventListener = listener;
        }
    }

    boolean isSyncedOnce() {
        return this.mIsSyncedOnce;
    }

    private void onSynced(boolean isNext, SendBirdException e) {
        if (isNext) {
            if (this.mNextEventListener != null) {
                this.mNextEventListener.onSynced(e);
                this.mNextEventListener = null;
            }
        } else if (this.mPrevEventListener != null) {
            this.mPrevEventListener.onSynced(e);
            this.mPrevEventListener = null;
        }
    }

    static interface BackgroundSyncFinishedListener {
        public void onFinished();
    }

    static interface BackgroundSyncEventListener {
        public void onSynced(SendBirdException var1);
    }

    static enum State {
        INIT,
        RUNNING,
        STOPPED,
        FINISHED;

    }
}

