/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.state;

import com.sendbird.calls.DirectCall;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.internal.command.AcceptPushCommand;
import com.sendbird.calls.internal.command.AcceptRequest;
import com.sendbird.calls.internal.command.AcceptResponse;
import com.sendbird.calls.internal.command.AnswerPushCommand;
import com.sendbird.calls.internal.command.BaseEndPushCommand;
import com.sendbird.calls.internal.command.BaseEndResponse;
import com.sendbird.calls.internal.command.CandidatePushCommand;
import com.sendbird.calls.internal.command.Command;
import com.sendbird.calls.internal.command.DialResponse;
import com.sendbird.calls.internal.command.OfferPushCommand;
import com.sendbird.calls.internal.command.OtherDeviceAcceptedPushCommand;
import com.sendbird.calls.internal.command.RemoveCandidatesPushCommand;
import com.sendbird.calls.internal.command.SignalingPushCommand;
import com.sendbird.calls.internal.model.Candidate;
import com.sendbird.calls.internal.state.DirectCallState;
import com.sendbird.calls.internal.state.DirectCallStateManager;
import com.sendbird.calls.internal.util.ExtensionsKt;
import com.sendbird.calls.internal.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.IceCandidate;
import org.webrtc.SessionDescription;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0005J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0006\u0010\u001f\u001a\u00020\u0013J\u0006\u0010 \u001a\u00020\u0013J\u0006\u0010!\u001a\u00020\u0013J\u0006\u0010\"\u001a\u00020\u0013J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010$\u001a\u00020\u0013J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u0013J\u0006\u0010)\u001a\u00020\u0013J\b\u0010*\u001a\u00020+H\u0002J\u0006\u0010,\u001a\u00020\u0013R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/sendbird/calls/internal/state/DirectCallStateManager;", "", "directCall", "Lcom/sendbird/calls/DirectCall;", "currentState", "Lcom/sendbird/calls/internal/state/DirectCallState;", "(Lcom/sendbird/calls/DirectCall;Lcom/sendbird/calls/internal/state/DirectCallState;)V", "connectionTimer", "Ljava/util/Timer;", "<set-?>", "getCurrentState", "()Lcom/sendbird/calls/internal/state/DirectCallState;", "getDirectCall", "()Lcom/sendbird/calls/DirectCall;", "singleThreadExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "stateTimer", "accept", "", "changeState", "nextState", "doStateAction", "runnable", "Ljava/lang/Runnable;", "end", "handleReceivedCommand", "command", "Lcom/sendbird/calls/internal/command/Command;", "e", "Lcom/sendbird/calls/SendBirdException;", "onCreate", "onPeerConnectionClosed", "onPeerConnectionConnected", "onPeerConnectionReconnecting", "runOnSingleThreadExecutor", "startConnectionTimer", "startStateTimer", "delayMillis", "", "stopConnectionTimer", "stopStateTimer", "tag", "", "unknownEnd", "calls_release"})
public final class DirectCallStateManager {
    @NotNull
    private final DirectCall directCall;
    @NotNull
    private DirectCallState currentState;
    private final ExecutorService singleThreadExecutor;
    private Timer stateTimer;
    private Timer connectionTimer;

    @NotNull
    public final /* synthetic */ DirectCall getDirectCall() {
        return this.directCall;
    }

    @NotNull
    public final /* synthetic */ DirectCallState getCurrentState() {
        return this.currentState;
    }

    public final /* synthetic */ void onCreate() {
        this.currentState.onCreate(this);
    }

    public final /* synthetic */ void changeState(@NotNull DirectCallState nextState) {
        Intrinsics.checkParameterIsNotNull((Object)nextState, (String)"nextState");
        Logger.v(this.tag() + " changeState(). " + this.currentState.getStateName() + " => " + nextState.getStateName());
        if (Intrinsics.areEqual((Object)this.currentState.getStateName(), (Object)nextState.getStateName())) {
            return;
        }
        this.currentState.onDestroy(this);
        this.currentState = nextState;
        this.currentState.onCreate(this);
    }

    public final /* synthetic */ void startStateTimer(long delayMillis) {
        block0: {
            Logger.v(this.tag() + '[' + this.currentState.getStateName() + "] => startStateTimer(" + delayMillis + ")");
            Timer timer = this.stateTimer = new Timer();
            if (timer == null) break block0;
            timer.schedule(new TimerTask(this){
                final /* synthetic */ DirectCallStateManager this$0;

                public void run() {
                    DirectCallStateManager.access$doStateAction(this.this$0, new Runnable(this){
                        final /* synthetic */ startStateTimer.1 this$0;

                        public final void run() {
                            this.this$0.this$0.getCurrentState().onStateTimeout(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = $outer;
                }
            }, delayMillis);
        }
    }

    public final /* synthetic */ void stopStateTimer() {
        Logger.v(this.tag() + '[' + this.currentState.getStateName() + "] => stopStateTimer()");
        Timer timer = this.stateTimer;
        if (timer != null) {
            timer.cancel();
        }
        this.stateTimer = null;
    }

    public final /* synthetic */ void startConnectionTimer() {
        block0: {
            long delayMillis = (long)SendBirdCall.Options.getCallConnectionTimeoutSec() * (long)1000;
            Logger.v(this.tag() + '[' + this.currentState.getStateName() + "] => startConnectionTimer(" + delayMillis + ")");
            Timer timer = this.connectionTimer = new Timer();
            if (timer == null) break block0;
            timer.schedule(new TimerTask(this){
                final /* synthetic */ DirectCallStateManager this$0;

                public void run() {
                    DirectCallStateManager.access$doStateAction(this.this$0, new Runnable(this){
                        final /* synthetic */ startConnectionTimer.1 this$0;

                        public final void run() {
                            this.this$0.this$0.getCurrentState().onConnectionTimeout(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = $outer;
                }
            }, delayMillis);
        }
    }

    public final /* synthetic */ void stopConnectionTimer() {
        Logger.v(this.tag() + '[' + this.currentState.getStateName() + "] => stopConnectionTimer()");
        Timer timer = this.connectionTimer;
        if (timer != null) {
            timer.cancel();
        }
        this.connectionTimer = null;
    }

    public final /* synthetic */ void handleReceivedCommand(@NotNull Command command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        this.handleReceivedCommand(command, null);
    }

    public final /* synthetic */ void handleReceivedCommand(@NotNull Command command, @Nullable SendBirdException e) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Logger.v(this.tag() + " handleCommand(command: " + command + ", e: " + e + ')');
        this.doStateAction(new Runnable(this, command, e){
            final /* synthetic */ DirectCallStateManager this$0;
            final /* synthetic */ Command $command;
            final /* synthetic */ SendBirdException $e;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                block8: {
                    Command command;
                    block19: {
                        block17: {
                            String string;
                            block18: {
                                Object object;
                                block15: {
                                    String string2;
                                    block16: {
                                        Object object2;
                                        Command command2;
                                        block14: {
                                            block13: {
                                                block12: {
                                                    block11: {
                                                        block10: {
                                                            block9: {
                                                                block7: {
                                                                    command2 = this.$command;
                                                                    if (!(command2 instanceof DialResponse)) break block7;
                                                                    this.this$0.getCurrentState().onDialAckReceived(this.this$0, (DialResponse)this.$command, this.$e);
                                                                    break block8;
                                                                }
                                                                if (!(command2 instanceof AcceptRequest)) break block9;
                                                                this.this$0.getCurrentState().accept(this.this$0);
                                                                break block8;
                                                            }
                                                            if (!(command2 instanceof AcceptResponse)) break block10;
                                                            this.this$0.getCurrentState().onAcceptAckReceived(this.this$0, (AcceptResponse)this.$command, this.$e);
                                                            break block8;
                                                        }
                                                        if (!(command2 instanceof AcceptPushCommand)) break block11;
                                                        this.this$0.getCurrentState().onAcceptReceived(this.this$0, (AcceptPushCommand)this.$command);
                                                        break block8;
                                                    }
                                                    if (!(command2 instanceof OtherDeviceAcceptedPushCommand)) break block12;
                                                    this.this$0.getCurrentState().onOtherDeviceAccepted(this.this$0);
                                                    break block8;
                                                }
                                                if (!(command2 instanceof BaseEndResponse)) break block13;
                                                this.this$0.getCurrentState().onEndAckReceived(this.this$0, (BaseEndResponse)this.$command, this.$e);
                                                break block8;
                                            }
                                            if (!(command2 instanceof BaseEndPushCommand)) break block14;
                                            this.this$0.getCurrentState().onEndReceived(this.this$0, (BaseEndPushCommand)this.$command);
                                            break block8;
                                        }
                                        if (!(command2 instanceof SignalingPushCommand)) break block8;
                                        command = this.$command;
                                        if (!(command instanceof OfferPushCommand)) break block15;
                                        string2 = ((SignalingPushCommand)this.$command).getPeerConnectionId$calls_release();
                                        if (string2 == null) break block16;
                                        String string3 = string2;
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        String id = string3;
                                        boolean bl3 = false;
                                        String string4 = ((OfferPushCommand)this.$command).getSdp();
                                        if (string4 != null) {
                                            ExtensionsKt.uncompress(string4, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(id, this){
                                                final /* synthetic */ String $id;
                                                final /* synthetic */ handleReceivedCommand.1 this$0;
                                                {
                                                    this.$id = string;
                                                    this.this$0 = var2_2;
                                                    super(1);
                                                }

                                                public final void invoke(@Nullable String sdp) {
                                                    this.this$0.this$0.getDirectCall().setRemoteDescription$calls_release(SessionDescription.Type.OFFER, sdp, this.$id);
                                                }
                                            }));
                                            object2 = Unit.INSTANCE;
                                        } else {
                                            object2 = string2 = null;
                                        }
                                        if (object2 != null) break block8;
                                    }
                                    this.this$0.getCurrentState().onOfferReceived(this.this$0, (OfferPushCommand)this.$command);
                                    string2 = Unit.INSTANCE;
                                    break block8;
                                }
                                if (!(command instanceof AnswerPushCommand)) break block17;
                                string = ((SignalingPushCommand)this.$command).getPeerConnectionId$calls_release();
                                if (string == null) break block18;
                                String string5 = string;
                                boolean bl = false;
                                boolean bl4 = false;
                                String id2 = string5;
                                boolean bl5 = false;
                                String string6 = ((AnswerPushCommand)this.$command).getSdp();
                                if (string6 != null) {
                                    ExtensionsKt.uncompress(string6, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(id2, this){
                                        final /* synthetic */ String $id;
                                        final /* synthetic */ handleReceivedCommand.1 this$0;
                                        {
                                            this.$id = string;
                                            this.this$0 = var2_2;
                                            super(1);
                                        }

                                        public final void invoke(@Nullable String sdp) {
                                            this.this$0.this$0.getDirectCall().setRemoteDescription$calls_release(SessionDescription.Type.ANSWER, sdp, this.$id);
                                        }
                                    }));
                                    object = Unit.INSTANCE;
                                } else {
                                    object = string = null;
                                }
                                if (object != null) break block8;
                            }
                            this.this$0.getCurrentState().onAnswerReceived(this.this$0, (AnswerPushCommand)this.$command);
                            string = Unit.INSTANCE;
                            break block8;
                        }
                        if (!(command instanceof CandidatePushCommand)) break block19;
                        Candidate candidate = ((CandidatePushCommand)this.$command).getCandidate$calls_release();
                        if (candidate == null) break block8;
                        IceCandidate iceCandidate = new IceCandidate(candidate.getSdpMid$calls_release(), candidate.getSdpMLineIndex$calls_release(), candidate.getSdp$calls_release());
                        this.this$0.getDirectCall().addRemoteIceCandidate$calls_release(iceCandidate, ((SignalingPushCommand)this.$command).getPeerConnectionId$calls_release());
                        break block8;
                    }
                    if (!(command instanceof RemoveCandidatesPushCommand)) break block8;
                    List<Candidate> candidateList = ((RemoveCandidatesPushCommand)this.$command).getCandidates$calls_release();
                    Iterable<E> iceCandidate = candidateList;
                    boolean bl = false;
                    boolean id2 = false;
                    if (!(iceCandidate == null || iceCandidate.isEmpty())) {
                        void $this$toTypedArray$iv;
                        IceCandidate[] iceCandidateArray;
                        void $this$mapTo$iv$iv;
                        Collection $this$map$iv;
                        iceCandidate = candidateList;
                        DirectCall directCall = this.this$0.getDirectCall();
                        boolean $i$f$map = false;
                        void id2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Candidate candidate = (Candidate)item$iv$iv;
                            iceCandidateArray = destination$iv$iv;
                            boolean bl6 = false;
                            IceCandidate iceCandidate2 = new IceCandidate(it.getSdpMid$calls_release(), it.getSdpMLineIndex$calls_release(), it.getSdp$calls_release());
                            iceCandidateArray.add(iceCandidate2);
                        }
                        iceCandidateArray = (List)destination$iv$iv;
                        $this$map$iv = (Collection)iceCandidateArray;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        IceCandidate[] iceCandidateArray2 = thisCollection$iv.toArray(new IceCandidate[0]);
                        if (iceCandidateArray2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        iceCandidateArray = iceCandidateArray2;
                        directCall.removeRemoteIceCandidates$calls_release(iceCandidateArray, ((SignalingPushCommand)this.$command).getPeerConnectionId$calls_release());
                    }
                }
            }
            {
                this.this$0 = directCallStateManager;
                this.$command = command;
                this.$e = sendBirdException;
            }
        });
    }

    public static /* synthetic */ void handleReceivedCommand$default(DirectCallStateManager directCallStateManager, Command command, SendBirdException sendBirdException, int n, Object object) {
        if ((n & 2) != 0) {
            sendBirdException = null;
        }
        directCallStateManager.handleReceivedCommand(command, sendBirdException);
    }

    public final /* synthetic */ void accept() {
        this.runOnSingleThreadExecutor(new Runnable(this){
            final /* synthetic */ DirectCallStateManager this$0;

            public final void run() {
                DirectCallStateManager.access$doStateAction(this.this$0, new Runnable(this){
                    final /* synthetic */ accept.1 this$0;

                    public final void run() {
                        this.this$0.this$0.getCurrentState().accept(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = directCallStateManager;
            }
        });
    }

    public final /* synthetic */ void end() {
        this.runOnSingleThreadExecutor(new Runnable(this){
            final /* synthetic */ DirectCallStateManager this$0;

            public final void run() {
                DirectCallStateManager.access$doStateAction(this.this$0, new Runnable(this){
                    final /* synthetic */ end.1 this$0;

                    public final void run() {
                        this.this$0.this$0.getCurrentState().end(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = directCallStateManager;
            }
        });
    }

    public final /* synthetic */ void unknownEnd() {
        this.runOnSingleThreadExecutor(new Runnable(this){
            final /* synthetic */ DirectCallStateManager this$0;

            public final void run() {
                DirectCallStateManager.access$doStateAction(this.this$0, new Runnable(this){
                    final /* synthetic */ unknownEnd.1 this$0;

                    public final void run() {
                        this.this$0.this$0.getCurrentState().unknownEnd(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = directCallStateManager;
            }
        });
    }

    public final /* synthetic */ void onPeerConnectionConnected() {
        this.runOnSingleThreadExecutor(new Runnable(this){
            final /* synthetic */ DirectCallStateManager this$0;

            public final void run() {
                DirectCallStateManager.access$doStateAction(this.this$0, new Runnable(this){
                    final /* synthetic */ onPeerConnectionConnected.1 this$0;

                    public final void run() {
                        this.this$0.this$0.getCurrentState().onPeerConnectionConnected(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = directCallStateManager;
            }
        });
    }

    public final /* synthetic */ void onPeerConnectionReconnecting() {
        this.runOnSingleThreadExecutor(new Runnable(this){
            final /* synthetic */ DirectCallStateManager this$0;

            public final void run() {
                DirectCallStateManager.access$doStateAction(this.this$0, new Runnable(this){
                    final /* synthetic */ onPeerConnectionReconnecting.1 this$0;

                    public final void run() {
                        this.this$0.this$0.getCurrentState().onPeerConnectionReconnecting(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = directCallStateManager;
            }
        });
    }

    public final /* synthetic */ void onPeerConnectionClosed() {
        this.runOnSingleThreadExecutor(new Runnable(this){
            final /* synthetic */ DirectCallStateManager this$0;

            public final void run() {
                DirectCallStateManager.access$doStateAction(this.this$0, new Runnable(this){
                    final /* synthetic */ onPeerConnectionClosed.1 this$0;

                    public final void run() {
                        this.this$0.this$0.getCurrentState().onPeerConnectionClosed(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = directCallStateManager;
            }
        });
    }

    private final synchronized void doStateAction(Runnable runnable) {
        runnable.run();
    }

    private final void runOnSingleThreadExecutor(Runnable runnable) {
        ExecutorService executorService = this.singleThreadExecutor;
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"singleThreadExecutor");
        if (!executorService.isShutdown()) {
            this.singleThreadExecutor.execute(runnable);
        }
    }

    private final String tag() {
        return this.directCall.getAmICallee$calls_release() ? "[DirectCallStateManager][Callee]" : "[DirectCallStateManager][Caller]";
    }

    public DirectCallStateManager(@NotNull DirectCall directCall, @NotNull DirectCallState currentState) {
        Intrinsics.checkParameterIsNotNull((Object)directCall, (String)"directCall");
        Intrinsics.checkParameterIsNotNull((Object)currentState, (String)"currentState");
        this.directCall = directCall;
        this.currentState = currentState;
        this.singleThreadExecutor = Executors.newSingleThreadExecutor();
        this.stateTimer = new Timer();
        this.connectionTimer = new Timer();
    }

    public static final /* synthetic */ void access$doStateAction(DirectCallStateManager $this, Runnable runnable) {
        $this.doStateAction(runnable);
    }

    public static final /* synthetic */ DirectCallState access$getCurrentState$p(DirectCallStateManager $this) {
        return $this.currentState;
    }

    public static final /* synthetic */ void access$setCurrentState$p(DirectCallStateManager $this, DirectCallState directCallState) {
        $this.currentState = directCallState;
    }
}

