/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.pc;

import android.content.Context;
import com.getkeepsafe.relinker.ReLinker;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.internal.model.TransportPolicy;
import com.sendbird.calls.internal.pc.CameraManager;
import com.sendbird.calls.internal.pc.PeerConnection$PCObserver$WhenMappings;
import com.sendbird.calls.internal.pc.PeerConnectionEvents;
import com.sendbird.calls.internal.pc.PeerConnectionKt;
import com.sendbird.calls.internal.pc.PeerConnectionParameters;
import com.sendbird.calls.internal.pc.Resolution;
import com.sendbird.calls.internal.util.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.DataChannel;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.NativeLibraryLoader;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RTCStatsCollectorCallback;
import org.webrtc.RtpParameters;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;
import org.webrtc.RtpTransceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSink;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0006\u0089\u0001\u008a\u0001\u008b\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J$\u0010K\u001a\u00020L2\b\b\u0002\u0010M\u001a\u00020N2\b\b\u0002\u0010O\u001a\u00020N2\b\b\u0002\u0010P\u001a\u00020NJ\u000e\u0010Q\u001a\u00020L2\u0006\u0010R\u001a\u000208J\u0006\u0010S\u001a\u00020LJ\b\u0010T\u001a\u00020LH\u0002J\u0006\u0010U\u001a\u00020LJ\n\u0010V\u001a\u0004\u0018\u00010+H\u0002J\b\u0010W\u001a\u00020XH\u0002J\u000e\u0010Y\u001a\u00020L2\u0006\u0010Z\u001a\u00020\u0003J\u001e\u0010[\u001a\u00020\\2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020^0\u000b2\u0006\u0010_\u001a\u00020`H\u0002J\b\u0010a\u001a\u00020bH\u0002J\b\u0010c\u001a\u00020dH\u0002J\n\u0010e\u001a\u0004\u0018\u000101H\u0002J\b\u0010f\u001a\u00020LH\u0002J\n\u0010g\u001a\u0004\u0018\u00010/H\u0002J\b\u0010h\u001a\u00020iH\u0002J\n\u0010j\u001a\u0004\u0018\u000101H\u0002J\u0010\u0010k\u001a\u00020L2\b\u0010l\u001a\u0004\u0018\u00010mJ\b\u0010#\u001a\u00020\u0003H\u0002J\u0019\u0010n\u001a\u00020L2\f\u0010o\u001a\b\u0012\u0004\u0012\u0002080p\u00a2\u0006\u0002\u0010qJ\u0018\u0010r\u001a\u00020L2\u0006\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020\u0003H\u0002J\u0016\u0010v\u001a\u00020L2\f\u0010w\u001a\b\u0012\u0004\u0012\u00020L0xH\u0002J\u000e\u0010y\u001a\u00020\u00032\u0006\u0010z\u001a\u00020\u0003J\u001c\u0010{\u001a\u00020L2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020^0\u000b2\u0006\u0010_\u001a\u00020`J\u000e\u0010|\u001a\u00020L2\u0006\u0010}\u001a\u00020~J\u000f\u0010\u007f\u001a\u00020L2\u0007\u0010\u0080\u0001\u001a\u00020-J\"\u0010\u0081\u0001\u001a\u00020\u00032\u0006\u0010z\u001a\u00020\u00032\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0084\u0001\u001a\u00020\u0003J\u0007\u0010\u0085\u0001\u001a\u00020LJ\u0007\u0010\u0086\u0001\u001a\u00020LJ\t\u0010\u0087\u0001\u001a\u00020tH\u0002J\r\u0010\u0088\u0001\u001a\u00020L*\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00038@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010'\u001a\u00020\u00038F\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010 R \u0010(\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00038F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010 R \u0010)\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00038F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010 R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00102\u001a\u000603R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\n\u0012\u0004\u0012\u000208\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010:\u001a\u00020;X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u0012\u0010@\u001a\u00060AR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010D\u001a\u0004\u0018\u00010\u00128F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u0010\u0010I\u001a\u0004\u0018\u00010JX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008c\u0001"}, d2={"Lcom/sendbird/calls/internal/pc/PeerConnection;", "", "isInitiator", "", "appContext", "Landroid/content/Context;", "eglBase", "Lorg/webrtc/EglBase;", "peerConnectionParameters", "Lcom/sendbird/calls/internal/pc/PeerConnectionParameters;", "localVideoSinks", "", "Lorg/webrtc/VideoSink;", "remoteVideoSinks", "localSamplesReadyCallback", "Lorg/webrtc/audio/JavaAudioDeviceModule$SamplesReadyCallback;", "remoteSamplesReadyCallback", "videoCapturer", "Lorg/webrtc/VideoCapturer;", "events", "Lcom/sendbird/calls/internal/pc/PeerConnectionEvents;", "(ZLandroid/content/Context;Lorg/webrtc/EglBase;Lcom/sendbird/calls/internal/pc/PeerConnectionParameters;Ljava/util/List;Ljava/util/List;Lorg/webrtc/audio/JavaAudioDeviceModule$SamplesReadyCallback;Lorg/webrtc/audio/JavaAudioDeviceModule$SamplesReadyCallback;Lorg/webrtc/VideoCapturer;Lcom/sendbird/calls/internal/pc/PeerConnectionEvents;)V", "audioSource", "Lorg/webrtc/AudioSource;", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "factory", "Lorg/webrtc/PeerConnectionFactory;", "<set-?>", "isAudioEnabled", "isAudioEnabled$calls_release", "()Z", "setAudioEnabled$calls_release", "(Z)V", "isClosed", "isErrorOccurred", "isIceRestarting", "isPreferIsac", "isVideoCall", "isVideoEnabled", "isVideoSourceStopped", "localAudioTrack", "Lorg/webrtc/AudioTrack;", "localSdp", "Lorg/webrtc/SessionDescription;", "localVideoSender", "Lorg/webrtc/RtpSender;", "localVideoTrack", "Lorg/webrtc/VideoTrack;", "pcObserver", "Lcom/sendbird/calls/internal/pc/PeerConnection$PCObserver;", "peerConnection", "Lorg/webrtc/PeerConnection;", "queuedRemoteCandidates", "", "Lorg/webrtc/IceCandidate;", "remoteVideoTrack", "resolution", "Lcom/sendbird/calls/internal/pc/Resolution;", "getResolution$calls_release", "()Lcom/sendbird/calls/internal/pc/Resolution;", "setResolution$calls_release", "(Lcom/sendbird/calls/internal/pc/Resolution;)V", "sdpObserver", "Lcom/sendbird/calls/internal/pc/PeerConnection$SDPObserver;", "surfaceTextureHelper", "Lorg/webrtc/SurfaceTextureHelper;", "value", "getVideoCapturer", "()Lorg/webrtc/VideoCapturer;", "setVideoCapturer", "(Lorg/webrtc/VideoCapturer;)V", "videoSource", "Lorg/webrtc/VideoSource;", "adaptVideoOutput", "", "videoWidth", "", "videoHeight", "videoFps", "addRemoteIceCandidate", "candidate", "close", "closeInternal", "createAnswer", "createAudioTrack", "createJavaAudioDevice", "Lorg/webrtc/audio/AudioDeviceModule;", "createOffer", "isIceRestart", "createRTCConfiguration", "Lorg/webrtc/PeerConnection$RTCConfiguration;", "iceServers", "Lorg/webrtc/PeerConnection$IceServer;", "transportPolicy", "Lcom/sendbird/calls/internal/model/TransportPolicy;", "createVideoDecoderFactory", "Lorg/webrtc/VideoDecoderFactory;", "createVideoEncoderFactory", "Lorg/webrtc/VideoEncoderFactory;", "createVideoTrack", "drainCandidates", "findVideoSender", "getAudioConstraints", "Lorg/webrtc/MediaConstraints;", "getRemoteVideoTrack", "getStats", "callback", "Lorg/webrtc/RTCStatsCollectorCallback;", "removeRemoteIceCandidates", "candidates", "", "([Lorg/webrtc/IceCandidate;)V", "reportError", "errorMessage", "", "isAudioError", "runOnSingleThreadPool", "runnable", "Lkotlin/Function0;", "setAudioEnabled", "enable", "setConfiguration", "setDegradationPreference", "preference", "Lorg/webrtc/RtpParameters$DegradationPreference;", "setRemoteDescription", "sdp", "setVideoEnabled", "state", "Lcom/sendbird/calls/internal/pc/CameraManager$CameraState;", "isInitialValue", "startVideoCapturer", "stopVideoCapturer", "tag", "initialize", "PCObserver", "ReLinkerLibraryLoader", "SDPObserver", "calls_release"})
public final class PeerConnection {
    private final ExecutorService executor;
    private final PCObserver pcObserver;
    private final SDPObserver sdpObserver;
    private boolean isIceRestarting;
    private final PeerConnectionFactory factory;
    private org.webrtc.PeerConnection peerConnection;
    private AudioSource audioSource;
    private SurfaceTextureHelper surfaceTextureHelper;
    private VideoSource videoSource;
    private boolean isPreferIsac;
    private boolean isVideoSourceStopped;
    private boolean isErrorOccurred;
    private final boolean isVideoCall;
    private List<IceCandidate> queuedRemoteCandidates;
    private SessionDescription localSdp;
    private boolean isVideoEnabled;
    private VideoTrack localVideoTrack;
    private VideoTrack remoteVideoTrack;
    private RtpSender localVideoSender;
    private boolean isAudioEnabled;
    private AudioTrack localAudioTrack;
    private boolean isClosed;
    @NotNull
    private Resolution resolution;
    @Nullable
    private VideoCapturer videoCapturer;
    private final boolean isInitiator;
    private final Context appContext;
    private final EglBase eglBase;
    private final PeerConnectionParameters peerConnectionParameters;
    private final List<VideoSink> localVideoSinks;
    private final List<VideoSink> remoteVideoSinks;
    private final JavaAudioDeviceModule.SamplesReadyCallback localSamplesReadyCallback;
    private final JavaAudioDeviceModule.SamplesReadyCallback remoteSamplesReadyCallback;
    private final PeerConnectionEvents events;

    public final /* synthetic */ boolean isVideoSourceStopped() {
        return this.isVideoSourceStopped;
    }

    public final /* synthetic */ boolean isVideoCall() {
        return this.isVideoCall;
    }

    public final /* synthetic */ boolean isVideoEnabled() {
        return this.isVideoEnabled;
    }

    public final /* synthetic */ boolean isAudioEnabled$calls_release() {
        return this.isAudioEnabled;
    }

    public final /* synthetic */ void setAudioEnabled$calls_release(boolean bl) {
        this.isAudioEnabled = bl;
    }

    @NotNull
    public final Resolution getResolution$calls_release() {
        return this.resolution;
    }

    public final void setResolution$calls_release(@NotNull Resolution resolution) {
        Intrinsics.checkParameterIsNotNull((Object)resolution, (String)"<set-?>");
        this.resolution = resolution;
    }

    @Nullable
    public final /* synthetic */ VideoCapturer getVideoCapturer() {
        return this.videoCapturer;
    }

    public final /* synthetic */ void setVideoCapturer(@Nullable VideoCapturer value) {
        block8: {
            Logger.d(this.tag() + " setVideoCapturer(value: " + value + ')');
            if (!this.isVideoCall) break block8;
            try {
                VideoCapturer videoCapturer = this.videoCapturer;
                if (videoCapturer != null) {
                    videoCapturer.stopCapture();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            VideoCapturer videoCapturer = this.videoCapturer;
            if (videoCapturer != null) {
                videoCapturer.dispose();
            }
            this.videoCapturer = value;
            if (value == null) {
                return;
            }
            SurfaceTextureHelper surfaceTextureHelper = this.surfaceTextureHelper;
            if (surfaceTextureHelper != null) {
                surfaceTextureHelper.dispose();
            }
            this.surfaceTextureHelper = SurfaceTextureHelper.create("CaptureThread", this.eglBase.getEglBaseContext());
            this.initialize(value);
            Logger.d(this.tag() + " isVideoCapturerStopped: " + this.isVideoSourceStopped);
            if (!this.isVideoSourceStopped) {
                value.startCapture(this.resolution.getWidth$calls_release(), this.resolution.getHeight$calls_release(), 24);
            }
            VideoSource videoSource = this.videoSource;
            if (videoSource != null) {
                videoSource.setIsScreencast(value.isScreencast());
            }
        }
    }

    public final /* synthetic */ void setConfiguration(@NotNull List<? extends PeerConnection.IceServer> iceServers, @NotNull TransportPolicy transportPolicy) {
        block0: {
            Intrinsics.checkParameterIsNotNull(iceServers, (String)"iceServers");
            Intrinsics.checkParameterIsNotNull((Object)((Object)transportPolicy), (String)"transportPolicy");
            org.webrtc.PeerConnection peerConnection = this.peerConnection;
            if (peerConnection == null) break block0;
            peerConnection.setConfiguration(this.createRTCConfiguration(iceServers, transportPolicy));
        }
    }

    public final /* synthetic */ boolean setAudioEnabled(boolean enable) {
        Logger.d(this.tag() + " setAudioEnabled(enable: " + enable + ") isClosed: " + this.isClosed + ", isAudioEnabled: " + this.isAudioEnabled + '.');
        if (this.isClosed() || this.isAudioEnabled == enable) {
            return false;
        }
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, enable){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ boolean $enable;

            public final void invoke() {
                Logger.d(PeerConnection.access$tag(this.this$0) + " setAudioEnabled(enable: " + this.$enable + ") isClosed: " + PeerConnection.access$isClosed$p(this.this$0) + ", isAudioEnabled: " + this.this$0.isAudioEnabled$calls_release() + '.');
                if (PeerConnection.access$isClosed(this.this$0)) {
                    return;
                }
                if (this.this$0.isAudioEnabled$calls_release() != this.$enable) {
                    this.this$0.setAudioEnabled$calls_release(this.$enable);
                    AudioTrack audioTrack = PeerConnection.access$getLocalAudioTrack$p(this.this$0);
                    Boolean result = audioTrack != null ? Boolean.valueOf(audioTrack.setEnabled(this.this$0.isAudioEnabled$calls_release())) : null;
                    Logger.d(PeerConnection.access$tag(this.this$0) + " setAudioEnabled result: " + result);
                }
            }
            {
                this.this$0 = peerConnection;
                this.$enable = bl;
                super(0);
            }
        }));
        return true;
    }

    public final /* synthetic */ boolean setVideoEnabled(boolean enable, @NotNull CameraManager.CameraState state, boolean isInitialValue) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        if (this.isClosed() || this.isVideoEnabled == enable) {
            return false;
        }
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, enable, state, isInitialValue){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ boolean $enable;
            final /* synthetic */ CameraManager.CameraState $state;
            final /* synthetic */ boolean $isInitialValue;

            public final void invoke() {
                block4: {
                    Boolean isChanged;
                    Logger.v(PeerConnection.access$tag(this.this$0) + " setVideoEnabled(enable: " + this.$enable + ", state: " + (Object)((Object)this.$state) + ", isInitialValue: " + this.$isInitialValue + ") isClosed: " + PeerConnection.access$isClosed$p(this.this$0) + ", isVideoEnabled: " + this.this$0.isVideoEnabled() + '.');
                    if (PeerConnection.access$isClosed(this.this$0)) {
                        return;
                    }
                    if (this.this$0.isVideoEnabled() == this.$enable) break block4;
                    if (this.$enable && this.$state == CameraManager.CameraState.DISCONNECTED && this.this$0.getVideoCapturer() != null) {
                        this.this$0.startVideoCapturer();
                    }
                    VideoTrack videoTrack = PeerConnection.access$getLocalVideoTrack$p(this.this$0);
                    Boolean bl = isChanged = videoTrack != null ? Boolean.valueOf(videoTrack.setEnabled(this.$enable)) : null;
                    if (bl != null) {
                        Boolean bl2 = bl;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        boolean it = bl2;
                        boolean bl5 = false;
                        PeerConnection.access$setVideoEnabled$p(this.this$0, it ? this.$enable : this.this$0.isVideoEnabled());
                        if (it && !this.$isInitialValue) {
                            PeerConnection.access$getEvents$p(this.this$0).onLocalVideoSettingsChanged();
                        }
                    }
                }
            }
            {
                this.this$0 = peerConnection;
                this.$enable = bl;
                this.$state = cameraState;
                this.$isInitialValue = bl2;
                super(0);
            }
        }));
        return true;
    }

    public final /* synthetic */ void startVideoCapturer() {
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ PeerConnection this$0;

            public final void invoke() {
                Logger.v(PeerConnection.access$tag(this.this$0) + " startVideoCapturer() videoCapturer: " + this.this$0.getVideoCapturer() + ", videoCapturerStopped: " + this.this$0.isVideoSourceStopped());
                if (this.this$0.isVideoSourceStopped()) {
                    VideoCapturer videoCapturer = this.this$0.getVideoCapturer();
                    if (videoCapturer != null) {
                        videoCapturer.startCapture(this.this$0.getResolution$calls_release().getWidth$calls_release(), this.this$0.getResolution$calls_release().getHeight$calls_release(), 24);
                    }
                    PeerConnection.access$setVideoSourceStopped$p(this.this$0, false);
                }
            }
            {
                this.this$0 = peerConnection;
                super(0);
            }
        }));
    }

    public final /* synthetic */ void stopVideoCapturer() {
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ PeerConnection this$0;

            public final void invoke() {
                Logger.v(PeerConnection.access$tag(this.this$0) + " stopVideoCapturer() videoCapturer: " + this.this$0.getVideoCapturer() + ", videoCapturerStopped: " + this.this$0.isVideoSourceStopped());
                if (!this.this$0.isVideoSourceStopped()) {
                    try {
                        VideoCapturer videoCapturer = this.this$0.getVideoCapturer();
                        if (videoCapturer != null) {
                            videoCapturer.stopCapture();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    PeerConnection.access$setVideoSourceStopped$p(this.this$0, true);
                }
            }
            {
                this.this$0 = peerConnection;
                super(0);
            }
        }));
    }

    public final /* synthetic */ void adaptVideoOutput(int videoWidth, int videoHeight, int videoFps) {
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, videoWidth, videoHeight, videoFps){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ int $videoWidth;
            final /* synthetic */ int $videoHeight;
            final /* synthetic */ int $videoFps;

            public final void invoke() {
                block0: {
                    Logger.v(PeerConnection.access$tag(this.this$0) + " adaptVideoOutput(width: " + this.$videoWidth + ", height: " + this.$videoHeight + ", fps: " + this.$videoFps + ')');
                    int width = this.$videoWidth <= 0 || this.$videoHeight <= 0 ? PeerConnectionKt.getDEFAULT_RESOLUTION().getWidth$calls_release() : this.$videoWidth;
                    int height = this.$videoWidth <= 0 || this.$videoHeight <= 0 ? PeerConnectionKt.getDEFAULT_RESOLUTION().getHeight$calls_release() : this.$videoHeight;
                    int fps = this.$videoFps <= 0 ? 24 : this.$videoFps;
                    VideoSource videoSource = PeerConnection.access$getVideoSource$p(this.this$0);
                    if (videoSource == null) break block0;
                    videoSource.adaptOutputFormat(width, height, fps);
                }
            }
            {
                this.this$0 = peerConnection;
                this.$videoWidth = n;
                this.$videoHeight = n2;
                this.$videoFps = n3;
                super(0);
            }
        }));
    }

    public static /* synthetic */ void adaptVideoOutput$default(PeerConnection peerConnection, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = PeerConnectionKt.getDEFAULT_RESOLUTION().getWidth$calls_release();
        }
        if ((n4 & 2) != 0) {
            n2 = PeerConnectionKt.getDEFAULT_RESOLUTION().getHeight$calls_release();
        }
        if ((n4 & 4) != 0) {
            n3 = 24;
        }
        peerConnection.adaptVideoOutput(n, n2, n3);
    }

    public final void setDegradationPreference(@NotNull RtpParameters.DegradationPreference preference) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)preference), (String)"preference");
            RtpSender rtpSender = this.localVideoSender;
            if (rtpSender == null) break block0;
            RtpSender rtpSender2 = rtpSender;
            boolean bl = false;
            boolean bl2 = false;
            RtpSender it = rtpSender2;
            boolean bl3 = false;
            RtpParameters rtpParameters = it.getParameters();
            RtpSender rtpSender3 = it;
            boolean bl4 = false;
            boolean bl5 = false;
            RtpParameters $this$apply = rtpParameters;
            boolean bl6 = false;
            $this$apply.degradationPreference = preference;
            RtpParameters rtpParameters2 = rtpParameters;
            boolean isApplied = rtpSender3.setParameters(rtpParameters2);
            Logger.v(this.tag() + "setDegradationPreference(preference: " + (Object)((Object)preference) + ") isApplied: " + isApplied);
        }
    }

    public final /* synthetic */ void createOffer(boolean isIceRestart) {
        Logger.d(this.tag() + " createOffer()");
        if (!this.isInitiator) {
            Logger.e(this.tag() + " non-initiator requested createOffer()");
            return;
        }
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, isIceRestart){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ boolean $isIceRestart;

            public final void invoke() {
                block3: {
                    if (PeerConnection.access$isClosed(this.this$0)) {
                        return;
                    }
                    if (PeerConnection.access$isErrorOccurred$p(this.this$0)) break block3;
                    PeerConnection.access$setIceRestarting$p(this.this$0, this.$isIceRestart);
                    if (this.$isIceRestart) {
                        PeerConnection.access$setLocalSdp$p(this.this$0, null);
                    }
                    org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0);
                    if (peerConnection != null) {
                        peerConnection.createOffer(PeerConnection.access$getSdpObserver$p(this.this$0), PeerConnectionKt.access$getMediaConstraints(this.$isIceRestart, this.this$0.isVideoCall()));
                    }
                }
            }
            {
                this.this$0 = peerConnection;
                this.$isIceRestart = bl;
                super(0);
            }
        }));
    }

    public final /* synthetic */ void createAnswer() {
        Logger.d("[PeerConnection] createAnswer()");
        if (this.isInitiator) {
            return;
        }
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ PeerConnection this$0;

            public final void invoke() {
                block2: {
                    if (PeerConnection.access$isClosed(this.this$0)) {
                        return;
                    }
                    if (PeerConnection.access$isErrorOccurred$p(this.this$0)) break block2;
                    org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0);
                    if (peerConnection != null) {
                        peerConnection.createAnswer(PeerConnection.access$getSdpObserver$p(this.this$0), PeerConnectionKt.access$getMediaConstraints(false, this.this$0.isVideoCall()));
                    }
                }
            }
            {
                this.this$0 = peerConnection;
                super(0);
            }
        }));
    }

    public final /* synthetic */ void setRemoteDescription(@NotNull SessionDescription sdp) {
        Intrinsics.checkParameterIsNotNull((Object)sdp, (String)"sdp");
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, sdp){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ SessionDescription $sdp;

            public final void invoke() {
                block3: {
                    Logger.d(PeerConnection.access$tag(this.this$0) + " setRemoteDescription(" + (Object)((Object)this.$sdp.type) + ')');
                    if (PeerConnection.access$isClosed(this.this$0) || PeerConnection.access$isErrorOccurred$p(this.this$0)) {
                        return;
                    }
                    String sdpDescription = this.$sdp.description;
                    if (PeerConnection.access$isPreferIsac$p(this.this$0)) {
                        String string = sdpDescription;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdpDescription");
                        sdpDescription = PeerConnectionKt.access$preferCodec(string, "ISAC", true);
                    }
                    if (this.this$0.isVideoCall()) {
                        String string = sdpDescription;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdpDescription");
                        sdpDescription = PeerConnectionKt.access$preferCodec(string, PeerConnectionKt.access$getSdpVideoCodecName(PeerConnection.access$getPeerConnectionParameters$p(this.this$0)), false);
                    }
                    SessionDescription.Type type = this.$sdp.type;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)type), (String)"sdp.type");
                    String string = sdpDescription;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdpDescription");
                    SessionDescription sdpRemote = PeerConnectionKt.access$createSessionDescription(type, string);
                    org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0);
                    if (peerConnection == null) break block3;
                    peerConnection.setRemoteDescription(PeerConnection.access$getSdpObserver$p(this.this$0), sdpRemote);
                }
            }
            {
                this.this$0 = peerConnection;
                this.$sdp = sessionDescription;
                super(0);
            }
        }));
    }

    public final /* synthetic */ void addRemoteIceCandidate(@NotNull IceCandidate candidate) {
        Intrinsics.checkParameterIsNotNull((Object)candidate, (String)"candidate");
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, candidate){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ IceCandidate $candidate;

            public final void invoke() {
                block1: {
                    block2: {
                        if (PeerConnection.access$isClosed(this.this$0)) {
                            return;
                        }
                        if (PeerConnection.access$isErrorOccurred$p(this.this$0)) break block1;
                        List list = PeerConnection.access$getQueuedRemoteCandidates$p(this.this$0);
                        if (list == null) break block2;
                        list.add(this.$candidate);
                        break block1;
                    }
                    org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0);
                    if (peerConnection == null) break block1;
                    peerConnection.addIceCandidate(this.$candidate);
                }
            }
            {
                this.this$0 = peerConnection;
                this.$candidate = iceCandidate;
                super(0);
            }
        }));
    }

    public final /* synthetic */ void removeRemoteIceCandidates(@NotNull IceCandidate[] candidates) {
        Intrinsics.checkParameterIsNotNull((Object)candidates, (String)"candidates");
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, candidates){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ IceCandidate[] $candidates;

            public final void invoke() {
                block2: {
                    if (PeerConnection.access$isClosed(this.this$0)) {
                        return;
                    }
                    if (PeerConnection.access$isErrorOccurred$p(this.this$0)) break block2;
                    PeerConnection.access$drainCandidates(this.this$0);
                    org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0);
                    if (peerConnection != null) {
                        peerConnection.removeIceCandidates(this.$candidates);
                    }
                }
            }
            {
                this.this$0 = peerConnection;
                this.$candidates = iceCandidateArray;
                super(0);
            }
        }));
    }

    public final /* synthetic */ void getStats(@Nullable RTCStatsCollectorCallback callback) {
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, callback){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ RTCStatsCollectorCallback $callback;

            public final void invoke() {
                block2: {
                    if (PeerConnection.access$isClosed(this.this$0) || PeerConnection.access$isErrorOccurred$p(this.this$0)) {
                        RTCStatsCollectorCallback rTCStatsCollectorCallback = this.$callback;
                        if (rTCStatsCollectorCallback != null) {
                            rTCStatsCollectorCallback.onStatsDelivered(null);
                        }
                        return;
                    }
                    org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0);
                    if (peerConnection == null) break block2;
                    peerConnection.getStats(this.$callback);
                }
            }
            {
                this.this$0 = peerConnection;
                this.$callback = rTCStatsCollectorCallback;
                super(0);
            }
        }));
    }

    private final AudioTrack createAudioTrack() {
        AudioTrack audioTrack;
        block0: {
            AudioTrack audioTrack2 = audioTrack = this.factory.createAudioTrack("ARDAMSa0", this.audioSource);
            if (audioTrack2 == null) break block0;
            audioTrack2.setEnabled(this.isAudioEnabled);
        }
        return audioTrack;
    }

    private final VideoTrack createVideoTrack() {
        VideoTrack videoTrack;
        boolean isScreenCast;
        VideoCapturer videoCapturer = this.videoCapturer;
        boolean bl = isScreenCast = videoCapturer != null ? videoCapturer.isScreencast() : false;
        if (this.videoCapturer == null) {
            this.videoSource = this.factory.createVideoSource(isScreenCast);
        } else {
            this.videoSource = this.factory.createVideoSource(isScreenCast);
            this.surfaceTextureHelper = SurfaceTextureHelper.create("CaptureThread", this.eglBase.getEglBaseContext());
            VideoCapturer videoCapturer2 = this.videoCapturer;
            if (videoCapturer2 != null) {
                VideoSource videoSource = this.videoSource;
                videoCapturer2.initialize(this.surfaceTextureHelper, this.appContext, videoSource != null ? videoSource.getCapturerObserver() : null);
            }
        }
        VideoTrack videoTrack2 = videoTrack = this.factory.createVideoTrack("ARDAMSv0", this.videoSource);
        if (videoTrack2 != null) {
            videoTrack2.setEnabled(this.isVideoEnabled);
        }
        for (VideoSink localVideoSink2 : this.localVideoSinks) {
            VideoTrack videoTrack3 = videoTrack;
            if (videoTrack3 == null) continue;
            videoTrack3.addSink(localVideoSink2);
        }
        return videoTrack;
    }

    private final VideoTrack getRemoteVideoTrack() {
        org.webrtc.PeerConnection peerConnection = this.peerConnection;
        if (peerConnection != null) {
            org.webrtc.PeerConnection peerConnection2 = peerConnection;
            boolean bl = false;
            boolean bl2 = false;
            org.webrtc.PeerConnection pc = peerConnection2;
            boolean bl3 = false;
            Iterator<RtpTransceiver> iterator = pc.getTransceivers().iterator();
            while (iterator.hasNext()) {
                RtpTransceiver transceiver;
                RtpTransceiver rtpTransceiver = transceiver = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)rtpTransceiver, (String)"transceiver");
                MediaStreamTrack track = rtpTransceiver.getReceiver().track();
                if (!(track instanceof VideoTrack)) continue;
                return (VideoTrack)track;
            }
        }
        return null;
    }

    private final VideoEncoderFactory createVideoEncoderFactory() {
        boolean enableH264HighProfile = Intrinsics.areEqual((Object)"H264 High", (Object)this.peerConnectionParameters.getVideoCodec());
        return this.peerConnectionParameters.getVideoCodecHwAcceleration() ? (VideoEncoderFactory)new DefaultVideoEncoderFactory(this.eglBase.getEglBaseContext(), true, enableH264HighProfile) : (VideoEncoderFactory)new SoftwareVideoEncoderFactory();
    }

    private final VideoDecoderFactory createVideoDecoderFactory() {
        return this.peerConnectionParameters.getVideoCodecHwAcceleration() ? (VideoDecoderFactory)new DefaultVideoDecoderFactory(this.eglBase.getEglBaseContext()) : (VideoDecoderFactory)new SoftwareVideoDecoderFactory();
    }

    private final AudioDeviceModule createJavaAudioDevice() {
        JavaAudioDeviceModule.AudioRecordErrorCallback audioRecordErrorCallback2 = new JavaAudioDeviceModule.AudioRecordErrorCallback(this){
            final /* synthetic */ PeerConnection this$0;

            public void onWebRtcAudioRecordInitError(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PeerConnection.access$reportError(this.this$0, errorMessage, true);
            }

            public void onWebRtcAudioRecordStartError(@NotNull JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, @NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)errorCode), (String)"errorCode");
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PeerConnection.access$reportError(this.this$0, errorMessage, true);
            }

            public void onWebRtcAudioRecordError(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PeerConnection.access$reportError(this.this$0, errorMessage, true);
            }
            {
                this.this$0 = $outer;
            }
        };
        JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback2 = new JavaAudioDeviceModule.AudioTrackErrorCallback(this){
            final /* synthetic */ PeerConnection this$0;

            public void onWebRtcAudioTrackInitError(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PeerConnection.access$reportError(this.this$0, errorMessage, true);
            }

            public void onWebRtcAudioTrackStartError(@NotNull JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, @NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)errorCode), (String)"errorCode");
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PeerConnection.access$reportError(this.this$0, errorMessage, true);
            }

            public void onWebRtcAudioTrackError(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PeerConnection.access$reportError(this.this$0, errorMessage, true);
            }
            {
                this.this$0 = $outer;
            }
        };
        AudioDeviceModule audioDeviceModule = JavaAudioDeviceModule.builder(this.appContext).setUseHardwareAcousticEchoCanceler(!this.peerConnectionParameters.getDisableBuiltInAEC()).setUseHardwareNoiseSuppressor(!this.peerConnectionParameters.getDisableBuiltInNS()).setAudioRecordErrorCallback(audioRecordErrorCallback2).setAudioTrackErrorCallback(audioTrackErrorCallback2).setAudioSource(SendBirdCall.Options.getPreferredAudioSource()).setSamplesReadyCallback(this.localSamplesReadyCallback).setRemoteSamplesReadyCallback(this.remoteSamplesReadyCallback).createAudioDeviceModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)audioDeviceModule, (String)"JavaAudioDeviceModule.bu\u2026createAudioDeviceModule()");
        return audioDeviceModule;
    }

    private final PeerConnection.RTCConfiguration createRTCConfiguration(List<? extends PeerConnection.IceServer> iceServers, TransportPolicy transportPolicy) {
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
        rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.DISABLED;
        rtcConfig.bundlePolicy = PeerConnection.BundlePolicy.BALANCED;
        rtcConfig.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
        rtcConfig.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_CONTINUALLY;
        rtcConfig.keyType = PeerConnection.KeyType.ECDSA;
        rtcConfig.enableDtlsSrtp = true;
        rtcConfig.sdpSemantics = PeerConnection.SdpSemantics.UNIFIED_PLAN;
        if (transportPolicy == TransportPolicy.ALL) {
            rtcConfig.iceTransportsType = PeerConnection.IceTransportsType.ALL;
        } else if (transportPolicy == TransportPolicy.RELAY) {
            rtcConfig.iceTransportsType = PeerConnection.IceTransportsType.RELAY;
        }
        return rtcConfig;
    }

    private final RtpSender findVideoSender() {
        org.webrtc.PeerConnection peerConnection = this.peerConnection;
        if (peerConnection != null) {
            org.webrtc.PeerConnection peerConnection2 = peerConnection;
            boolean bl = false;
            boolean bl2 = false;
            org.webrtc.PeerConnection pc = peerConnection2;
            boolean bl3 = false;
            for (RtpSender sender : pc.getSenders()) {
                MediaStreamTrack mediaStreamTrack;
                if (sender.track() == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                MediaStreamTrack it = mediaStreamTrack;
                boolean bl6 = false;
                String trackType = it.kind();
                if (!Intrinsics.areEqual((Object)trackType, (Object)"video")) continue;
                return sender;
            }
        }
        return null;
    }

    private final void initialize(@NotNull VideoCapturer $this$initialize) {
        Logger.d(this.tag() + " VideoCapturer.initialize(videoCapturer: " + $this$initialize + ") isVideoCall: " + this.isVideoCall);
        if (!this.isVideoCall) {
            return;
        }
        VideoSource videoSource = this.videoSource;
        $this$initialize.initialize(this.surfaceTextureHelper, this.appContext, videoSource != null ? videoSource.getCapturerObserver() : null);
    }

    private final MediaConstraints getAudioConstraints() {
        MediaConstraints audioConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.getNoAudioProcessing()) {
            audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair("googEchoCancellation", "false"));
            audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair("googAutoGainControl", "false"));
            audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair("googHighpassFilter", "false"));
            audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair("googNoiseSuppression", "false"));
        }
        return audioConstraints;
    }

    private final void reportError(String errorMessage, boolean isAudioError) {
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, isAudioError, errorMessage){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ boolean $isAudioError;
            final /* synthetic */ String $errorMessage;

            public final void invoke() {
                if (this.$isAudioError) {
                    PeerConnection.access$getEvents$p(this.this$0).onPeerConnectionAudioError(this.$errorMessage);
                    return;
                }
                if (!PeerConnection.access$isErrorOccurred$p(this.this$0)) {
                    PeerConnection.access$setErrorOccurred$p(this.this$0, true);
                    PeerConnection.access$getEvents$p(this.this$0).onPeerConnectionError(this.$errorMessage);
                }
            }
            {
                this.this$0 = peerConnection;
                this.$isAudioError = bl;
                this.$errorMessage = string;
                super(0);
            }
        }));
    }

    private final void drainCandidates() {
        block1: {
            List<IceCandidate> list = this.queuedRemoteCandidates;
            if (list == null) break block1;
            List<IceCandidate> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<IceCandidate> it = list2;
            boolean bl3 = false;
            for (IceCandidate candidate : it) {
                org.webrtc.PeerConnection peerConnection = this.peerConnection;
                if (peerConnection == null) continue;
                peerConnection.addIceCandidate(candidate);
            }
            this.queuedRemoteCandidates = null;
        }
    }

    public final /* synthetic */ void close() {
        Logger.v(this.tag() + " close()");
        this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ PeerConnection this$0;

            public final void invoke() {
                PeerConnection.access$closeInternal(this.this$0);
            }
            {
                this.this$0 = peerConnection;
                super(0);
            }
        }));
    }

    private final boolean isClosed() {
        boolean bl = this.isClosed || this.peerConnection == null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean it = bl;
        boolean bl4 = false;
        if (it) {
            Logger.v("PeerConnection is closed.");
        }
        return bl;
    }

    private final void closeInternal() {
        Logger.v(this.tag() + " closeInternal() isClosed: " + this.isClosed);
        if (this.isClosed) {
            return;
        }
        org.webrtc.PeerConnection peerConnection = this.peerConnection;
        if (peerConnection != null) {
            peerConnection.dispose();
        }
        this.peerConnection = null;
        AudioSource audioSource = this.audioSource;
        if (audioSource != null) {
            audioSource.dispose();
        }
        this.audioSource = null;
        try {
            VideoCapturer videoCapturer = this.videoCapturer;
            if (videoCapturer != null) {
                videoCapturer.stopCapture();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.isVideoSourceStopped = true;
        this.setVideoCapturer(null);
        VideoSource videoSource = this.videoSource;
        if (videoSource != null) {
            videoSource.dispose();
        }
        this.videoSource = null;
        SurfaceTextureHelper surfaceTextureHelper = this.surfaceTextureHelper;
        if (surfaceTextureHelper != null) {
            surfaceTextureHelper.dispose();
        }
        this.surfaceTextureHelper = null;
        this.factory.dispose();
        this.eglBase.release();
        this.events.onPeerConnectionClosed();
        PeerConnectionFactory.stopInternalTracingCapture();
        PeerConnectionFactory.shutdownInternalTracer();
        this.isClosed = true;
        Logger.v(this.tag() + " closeInternal() finished.");
    }

    private final String tag() {
        return "[PeerConnection][isInitiator: " + this.isInitiator + "][direction: " + (Object)((Object)this.peerConnectionParameters.getDirection()) + "][" + this + ']';
    }

    private final void runOnSingleThreadPool(Function0<Unit> runnable) {
        this.executor.execute(new Runnable(runnable){
            final /* synthetic */ Function0 $runnable;

            public final void run() {
                this.$runnable.invoke();
            }
            {
                this.$runnable = function0;
            }
        });
    }

    public PeerConnection(boolean isInitiator, @NotNull Context appContext, @NotNull EglBase eglBase, @NotNull PeerConnectionParameters peerConnectionParameters, @NotNull List<? extends VideoSink> localVideoSinks, @NotNull List<? extends VideoSink> remoteVideoSinks, @NotNull JavaAudioDeviceModule.SamplesReadyCallback localSamplesReadyCallback, @NotNull JavaAudioDeviceModule.SamplesReadyCallback remoteSamplesReadyCallback, @Nullable VideoCapturer videoCapturer, @NotNull PeerConnectionEvents events) {
        block6: {
            org.webrtc.PeerConnection peerConnection;
            Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
            Intrinsics.checkParameterIsNotNull((Object)eglBase, (String)"eglBase");
            Intrinsics.checkParameterIsNotNull((Object)peerConnectionParameters, (String)"peerConnectionParameters");
            Intrinsics.checkParameterIsNotNull(localVideoSinks, (String)"localVideoSinks");
            Intrinsics.checkParameterIsNotNull(remoteVideoSinks, (String)"remoteVideoSinks");
            Intrinsics.checkParameterIsNotNull((Object)localSamplesReadyCallback, (String)"localSamplesReadyCallback");
            Intrinsics.checkParameterIsNotNull((Object)remoteSamplesReadyCallback, (String)"remoteSamplesReadyCallback");
            Intrinsics.checkParameterIsNotNull((Object)events, (String)"events");
            this.isInitiator = isInitiator;
            this.appContext = appContext;
            this.eglBase = eglBase;
            this.peerConnectionParameters = peerConnectionParameters;
            this.localVideoSinks = localVideoSinks;
            this.remoteVideoSinks = remoteVideoSinks;
            this.localSamplesReadyCallback = localSamplesReadyCallback;
            this.remoteSamplesReadyCallback = remoteSamplesReadyCallback;
            this.events = events;
            this.executor = Executors.newSingleThreadExecutor();
            this.pcObserver = new PCObserver();
            this.sdpObserver = new SDPObserver();
            this.isVideoSourceStopped = true;
            this.isVideoCall = this.peerConnectionParameters.getVideoCallEnabled();
            PeerConnection peerConnection2 = this;
            boolean bl = false;
            Object object = new ArrayList();
            peerConnection2.queuedRemoteCandidates = object;
            this.isVideoEnabled = true;
            this.isAudioEnabled = true;
            this.resolution = PeerConnectionKt.getDEFAULT_RESOLUTION();
            this.videoCapturer = videoCapturer;
            Logger.d(this.tag() + " init(direction: " + (Object)((Object)this.peerConnectionParameters.getDirection()) + ')');
            this.isPreferIsac = Intrinsics.areEqual((Object)this.peerConnectionParameters.getAudioCodec(), (Object)"ISAC");
            String fieldTrials = PeerConnectionKt.access$getFieldTrials(this.peerConnectionParameters);
            PeerConnectionFactory.initialize(PeerConnectionFactory.InitializationOptions.builder(this.appContext).setNativeLibraryLoader(new ReLinkerLibraryLoader(this.appContext)).setFieldTrials(fieldTrials).setEnableInternalTracer(true).createInitializationOptions());
            AudioDeviceModule adm = this.createJavaAudioDevice();
            PeerConnectionFactory peerConnectionFactory = PeerConnectionFactory.builder().setOptions(new PeerConnectionFactory.Options()).setAudioDeviceModule(adm).setVideoEncoderFactory(this.createVideoEncoderFactory()).setVideoDecoderFactory(this.createVideoDecoderFactory()).createPeerConnectionFactory();
            Intrinsics.checkExpressionValueIsNotNull((Object)peerConnectionFactory, (String)"PeerConnectionFactory.bu\u2026tePeerConnectionFactory()");
            this.factory = peerConnectionFactory;
            adm.release();
            PeerConnection peerConnection3 = this;
            PeerConnectionFactory peerConnectionFactory2 = this.factory;
            if (peerConnectionFactory2 != null) {
                PeerConnection peerConnection4 = this;
                object = peerConnectionFactory2;
                peerConnection2 = peerConnection3;
                boolean bl2 = false;
                List list = CollectionsKt.emptyList();
                peerConnection3 = peerConnection2;
                peerConnection = ((PeerConnectionFactory)object).createPeerConnection(peerConnection4.createRTCConfiguration(list, TransportPolicy.ALL), (PeerConnection.Observer)this.pcObserver);
            } else {
                peerConnection = null;
            }
            peerConnection3.peerConnection = peerConnection;
            List mediaStreamLabels = CollectionsKt.listOf((Object)"ARDAMS");
            if (this.isVideoCall) {
                this.localVideoTrack = this.createVideoTrack();
                org.webrtc.PeerConnection peerConnection5 = this.peerConnection;
                if (peerConnection5 != null) {
                    peerConnection5.addTrack(this.localVideoTrack, mediaStreamLabels);
                }
                VideoTrack videoTrack = this.remoteVideoTrack = this.getRemoteVideoTrack();
                if (videoTrack != null) {
                    VideoTrack videoTrack2 = videoTrack;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    VideoTrack it = videoTrack2;
                    boolean bl5 = false;
                    it.setEnabled(this.isVideoEnabled);
                    for (VideoSink remoteVideoSink2 : this.remoteVideoSinks) {
                        it.addSink(remoteVideoSink2);
                    }
                }
                this.localVideoSender = this.findVideoSender();
            }
            PeerConnectionFactory peerConnectionFactory3 = this.factory;
            this.audioSource = peerConnectionFactory3 != null ? peerConnectionFactory3.createAudioSource(this.getAudioConstraints()) : null;
            this.localAudioTrack = this.createAudioTrack();
            org.webrtc.PeerConnection peerConnection6 = this.peerConnection;
            if (peerConnection6 == null) break block6;
            peerConnection6.addTrack(this.localAudioTrack, mediaStreamLabels);
        }
    }

    public static final /* synthetic */ PeerConnectionEvents access$getEvents$p(PeerConnection $this) {
        return $this.events;
    }

    public static final /* synthetic */ void access$setPreferIsac$p(PeerConnection $this, boolean bl) {
        $this.isPreferIsac = bl;
    }

    public static final /* synthetic */ boolean access$isClosed(PeerConnection $this) {
        return $this.isClosed();
    }

    public static final /* synthetic */ boolean access$isErrorOccurred$p(PeerConnection $this) {
        return $this.isErrorOccurred;
    }

    public static final /* synthetic */ void access$setErrorOccurred$p(PeerConnection $this, boolean bl) {
        $this.isErrorOccurred = bl;
    }

    public static final /* synthetic */ org.webrtc.PeerConnection access$getPeerConnection$p(PeerConnection $this) {
        return $this.peerConnection;
    }

    public static final /* synthetic */ void access$setPeerConnection$p(PeerConnection $this, org.webrtc.PeerConnection peerConnection) {
        $this.peerConnection = peerConnection;
    }

    public static final /* synthetic */ SDPObserver access$getSdpObserver$p(PeerConnection $this) {
        return $this.sdpObserver;
    }

    public static final /* synthetic */ boolean access$isInitiator$p(PeerConnection $this) {
        return $this.isInitiator;
    }

    public static final /* synthetic */ boolean access$isIceRestarting$p(PeerConnection $this) {
        return $this.isIceRestarting;
    }

    public static final /* synthetic */ void access$setIceRestarting$p(PeerConnection $this, boolean bl) {
        $this.isIceRestarting = bl;
    }

    public static final /* synthetic */ void access$drainCandidates(PeerConnection $this) {
        $this.drainCandidates();
    }

    public static final /* synthetic */ boolean access$isClosed$p(PeerConnection $this) {
        return $this.isClosed;
    }

    public static final /* synthetic */ void access$setClosed$p(PeerConnection $this, boolean bl) {
        $this.isClosed = bl;
    }

    public static final /* synthetic */ AudioTrack access$getLocalAudioTrack$p(PeerConnection $this) {
        return $this.localAudioTrack;
    }

    public static final /* synthetic */ void access$setLocalAudioTrack$p(PeerConnection $this, AudioTrack audioTrack) {
        $this.localAudioTrack = audioTrack;
    }

    public static final /* synthetic */ boolean access$isVideoEnabled$p(PeerConnection $this) {
        return $this.isVideoEnabled;
    }

    public static final /* synthetic */ void access$setVideoEnabled$p(PeerConnection $this, boolean bl) {
        $this.isVideoEnabled = bl;
    }

    public static final /* synthetic */ VideoTrack access$getLocalVideoTrack$p(PeerConnection $this) {
        return $this.localVideoTrack;
    }

    public static final /* synthetic */ void access$setLocalVideoTrack$p(PeerConnection $this, VideoTrack videoTrack) {
        $this.localVideoTrack = videoTrack;
    }

    public static final /* synthetic */ boolean access$isVideoSourceStopped$p(PeerConnection $this) {
        return $this.isVideoSourceStopped;
    }

    public static final /* synthetic */ void access$setVideoSourceStopped$p(PeerConnection $this, boolean bl) {
        $this.isVideoSourceStopped = bl;
    }

    public static final /* synthetic */ VideoSource access$getVideoSource$p(PeerConnection $this) {
        return $this.videoSource;
    }

    public static final /* synthetic */ void access$setVideoSource$p(PeerConnection $this, VideoSource videoSource) {
        $this.videoSource = videoSource;
    }

    public static final /* synthetic */ List access$getQueuedRemoteCandidates$p(PeerConnection $this) {
        return $this.queuedRemoteCandidates;
    }

    public static final /* synthetic */ void access$setQueuedRemoteCandidates$p(PeerConnection $this, List list) {
        $this.queuedRemoteCandidates = list;
    }

    public static final /* synthetic */ void access$closeInternal(PeerConnection $this) {
        $this.closeInternal();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J#\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001b\u0010\u0016\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010!\u001a\u00020\u0004H\u0016J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0016\u00a8\u0006'"}, d2={"Lcom/sendbird/calls/internal/pc/PeerConnection$PCObserver;", "Lorg/webrtc/PeerConnection$Observer;", "(Lcom/sendbird/calls/internal/pc/PeerConnection;)V", "onAddStream", "", "stream", "Lorg/webrtc/MediaStream;", "onAddTrack", "receiver", "Lorg/webrtc/RtpReceiver;", "mediaStreams", "", "(Lorg/webrtc/RtpReceiver;[Lorg/webrtc/MediaStream;)V", "onConnectionChange", "newState", "Lorg/webrtc/PeerConnection$PeerConnectionState;", "onDataChannel", "dc", "Lorg/webrtc/DataChannel;", "onIceCandidate", "candidate", "Lorg/webrtc/IceCandidate;", "onIceCandidatesRemoved", "candidates", "([Lorg/webrtc/IceCandidate;)V", "onIceConnectionChange", "Lorg/webrtc/PeerConnection$IceConnectionState;", "onIceConnectionReceivingChange", "receiving", "", "onIceGatheringChange", "Lorg/webrtc/PeerConnection$IceGatheringState;", "onRemoveStream", "onRenegotiationNeeded", "onSignalingChange", "Lorg/webrtc/PeerConnection$SignalingState;", "onTrack", "transceiver", "Lorg/webrtc/RtpTransceiver;", "calls_release"})
    private final class PCObserver
    implements PeerConnection.Observer {
        @Override
        public void onIceCandidate(@NotNull IceCandidate candidate) {
            Intrinsics.checkParameterIsNotNull((Object)candidate, (String)"candidate");
            Logger.v(PeerConnection.this.tag() + " PCObserver => onIceCandidate()");
            PeerConnection.this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, candidate){
                final /* synthetic */ PCObserver this$0;
                final /* synthetic */ IceCandidate $candidate;

                public final void invoke() {
                    PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onIceCandidate(this.$candidate);
                }
                {
                    this.this$0 = pCObserver;
                    this.$candidate = iceCandidate;
                    super(0);
                }
            }));
        }

        @Override
        public void onIceCandidatesRemoved(@NotNull IceCandidate[] candidates) {
            Intrinsics.checkParameterIsNotNull((Object)candidates, (String)"candidates");
            Logger.v(PeerConnection.this.tag() + " PCObserver => onIceCandidatesRemoved() => candidates: " + candidates.length);
            PeerConnection.this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, candidates){
                final /* synthetic */ PCObserver this$0;
                final /* synthetic */ IceCandidate[] $candidates;

                public final void invoke() {
                    PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onIceCandidatesRemoved(this.$candidates);
                }
                {
                    this.this$0 = pCObserver;
                    this.$candidates = iceCandidateArray;
                    super(0);
                }
            }));
        }

        @Override
        public void onSignalingChange(@NotNull PeerConnection.SignalingState newState) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)newState), (String)"newState");
            Logger.v(PeerConnection.this.tag() + " PCObserver => onSignalingChange() => SignalingState: " + (Object)((Object)newState));
        }

        @Override
        public void onIceConnectionChange(@NotNull PeerConnection.IceConnectionState newState) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)newState), (String)"newState");
            PeerConnection.this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, newState){
                final /* synthetic */ PCObserver this$0;
                final /* synthetic */ PeerConnection.IceConnectionState $newState;

                public final void invoke() {
                    Logger.v(PeerConnection.access$tag(this.this$0.PeerConnection.this) + " PCObserver => onIceConnectionChange() => IceConnectionState: " + (Object)((Object)this.$newState));
                    switch (PeerConnection$PCObserver$WhenMappings.$EnumSwitchMapping$0[this.$newState.ordinal()]) {
                        case 1: {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onIceConnected();
                            break;
                        }
                        case 2: {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onIceDisconnected();
                            break;
                        }
                        case 3: {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onIceFailed();
                            break;
                        }
                    }
                }
                {
                    this.this$0 = pCObserver;
                    this.$newState = iceConnectionState;
                    super(0);
                }
            }));
        }

        @Override
        public void onConnectionChange(@NotNull PeerConnection.PeerConnectionState newState) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)newState), (String)"newState");
            PeerConnection.this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, newState){
                final /* synthetic */ PCObserver this$0;
                final /* synthetic */ PeerConnection.PeerConnectionState $newState;

                public final void invoke() {
                    Logger.v(PeerConnection.access$tag(this.this$0.PeerConnection.this) + " PCObserver => onConnectionChange() => PeerConnectionState: " + (Object)((Object)this.$newState));
                    switch (PeerConnection$PCObserver$WhenMappings.$EnumSwitchMapping$1[this.$newState.ordinal()]) {
                        case 1: {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onConnected();
                            break;
                        }
                        case 2: {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onDisconnected();
                            break;
                        }
                        case 3: {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onFailed();
                            break;
                        }
                    }
                }
                {
                    this.this$0 = pCObserver;
                    this.$newState = peerConnectionState;
                    super(0);
                }
            }));
        }

        @Override
        public void onIceGatheringChange(@NotNull PeerConnection.IceGatheringState newState) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)newState), (String)"newState");
            Logger.v(PeerConnection.this.tag() + " PCObserver => onIceGatheringChange() => IceGatheringState: " + (Object)((Object)newState));
        }

        @Override
        public void onIceConnectionReceivingChange(boolean receiving) {
            Logger.v(PeerConnection.this.tag() + " PCObserver => onIceConnectionReceivingChange() => IceConnectionReceiving changed to " + receiving);
        }

        @Override
        public void onAddStream(@NotNull MediaStream stream) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Logger.v(PeerConnection.this.tag() + " PCObserver => onAddStream()");
        }

        @Override
        public void onRemoveStream(@NotNull MediaStream stream) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Logger.v(PeerConnection.this.tag() + " PCObserver => onRemoveStream()");
        }

        @Override
        public void onDataChannel(@NotNull DataChannel dc) {
            Intrinsics.checkParameterIsNotNull((Object)dc, (String)"dc");
        }

        @Override
        public void onRenegotiationNeeded() {
            Logger.v(PeerConnection.this.tag() + ' ' + (Object)((Object)PeerConnection.this.peerConnectionParameters.getDirection()) + " PCObserver => onRenegotiationNeeded()");
        }

        @Override
        public void onAddTrack(@NotNull RtpReceiver receiver, @NotNull MediaStream[] mediaStreams) {
            Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
            Intrinsics.checkParameterIsNotNull((Object)mediaStreams, (String)"mediaStreams");
            Logger.v(PeerConnection.this.tag() + ' ' + (Object)((Object)PeerConnection.this.peerConnectionParameters.getDirection()) + " PCObserver => onAddTrack(receiver: " + receiver + ')');
        }

        @Override
        public void onTrack(@NotNull RtpTransceiver transceiver) {
            Intrinsics.checkParameterIsNotNull((Object)transceiver, (String)"transceiver");
            Logger.v(PeerConnection.this.tag() + ' ' + (Object)((Object)PeerConnection.this.peerConnectionParameters.getDirection()) + " PCObserver => onTrack(" + (Object)((Object)transceiver.getMediaType()) + '/' + (Object)((Object)transceiver.getDirection()) + ')');
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016\u00a8\u0006\f"}, d2={"Lcom/sendbird/calls/internal/pc/PeerConnection$SDPObserver;", "Lorg/webrtc/SdpObserver;", "(Lcom/sendbird/calls/internal/pc/PeerConnection;)V", "onCreateFailure", "", "error", "", "onCreateSuccess", "origSdp", "Lorg/webrtc/SessionDescription;", "onSetFailure", "onSetSuccess", "calls_release"})
    private final class SDPObserver
    implements SdpObserver {
        @Override
        public void onCreateSuccess(@NotNull SessionDescription origSdp) {
            Intrinsics.checkParameterIsNotNull((Object)origSdp, (String)"origSdp");
            if (PeerConnection.this.localSdp != null) {
                PeerConnection.this.reportError("Multiple SDP create.", false);
                return;
            }
            String sdpDescription = origSdp.description;
            if (PeerConnection.this.isPreferIsac) {
                String string = sdpDescription;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdpDescription");
                sdpDescription = PeerConnectionKt.access$preferCodec(string, "ISAC", true);
            }
            if (PeerConnection.this.isVideoCall()) {
                String string = sdpDescription;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdpDescription");
                sdpDescription = PeerConnectionKt.access$preferCodec(string, PeerConnectionKt.access$getSdpVideoCodecName(PeerConnection.this.peerConnectionParameters), false);
            }
            SessionDescription.Type type = origSdp.type;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)type), (String)"origSdp.type");
            String string = sdpDescription;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdpDescription");
            SessionDescription sdp = PeerConnectionKt.access$createSessionDescription(type, string);
            PeerConnection.this.localSdp = sdp;
            PeerConnection.this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this, sdp){
                final /* synthetic */ SDPObserver this$0;
                final /* synthetic */ SessionDescription $sdp;

                public final void invoke() {
                    block2: {
                        if (PeerConnection.access$isClosed(this.this$0.PeerConnection.this)) {
                            return;
                        }
                        if (PeerConnection.access$isErrorOccurred$p(this.this$0.PeerConnection.this)) break block2;
                        org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0.PeerConnection.this);
                        if (peerConnection != null) {
                            peerConnection.setLocalDescription(PeerConnection.access$getSdpObserver$p(this.this$0.PeerConnection.this), this.$sdp);
                        }
                    }
                }
                {
                    this.this$0 = sDPObserver;
                    this.$sdp = sessionDescription;
                    super(0);
                }
            }));
        }

        @Override
        public void onSetSuccess() {
            PeerConnection.this.runOnSingleThreadPool((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ SDPObserver this$0;

                public final void invoke() {
                    if (PeerConnection.access$isClosed(this.this$0.PeerConnection.this) || PeerConnection.access$isErrorOccurred$p(this.this$0.PeerConnection.this)) {
                        return;
                    }
                    if (PeerConnection.access$isInitiator$p(this.this$0.PeerConnection.this)) {
                        if (PeerConnection.access$isIceRestarting$p(this.this$0.PeerConnection.this)) {
                            PeerConnection.access$setIceRestarting$p(this.this$0.PeerConnection.this, false);
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onLocalDescription(true, PeerConnection.access$getLocalSdp$p(this.this$0.PeerConnection.this));
                            return;
                        }
                        org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0.PeerConnection.this);
                        if ((peerConnection != null ? peerConnection.getRemoteDescription() : null) == null) {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onLocalDescription(PeerConnection.access$isInitiator$p(this.this$0.PeerConnection.this), PeerConnection.access$getLocalSdp$p(this.this$0.PeerConnection.this));
                        } else {
                            PeerConnection.access$drainCandidates(this.this$0.PeerConnection.this);
                        }
                    } else {
                        org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0.PeerConnection.this);
                        if ((peerConnection != null ? peerConnection.getLocalDescription() : null) != null) {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onLocalDescription(PeerConnection.access$isInitiator$p(this.this$0.PeerConnection.this), PeerConnection.access$getLocalSdp$p(this.this$0.PeerConnection.this));
                            PeerConnection.access$drainCandidates(this.this$0.PeerConnection.this);
                        }
                    }
                }
                {
                    this.this$0 = sDPObserver;
                    super(0);
                }
            }));
        }

        @Override
        public void onCreateFailure(@NotNull String error) {
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            PeerConnection.this.reportError("createSDP error: " + error, false);
        }

        @Override
        public void onSetFailure(@NotNull String error) {
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            PeerConnection.this.reportError("setSDP error: " + error, false);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/sendbird/calls/internal/pc/PeerConnection$ReLinkerLibraryLoader;", "Lorg/webrtc/NativeLibraryLoader;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "load", "", "name", "", "calls_release"})
    private static final class ReLinkerLibraryLoader
    implements NativeLibraryLoader {
        @NotNull
        private final Context context;

        @Override
        public boolean load(@Nullable String name) {
            boolean bl;
            try {
                ReLinker.loadLibrary((Context)this.context, (String)name);
                bl = true;
            }
            catch (Exception e) {
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        public ReLinkerLibraryLoader(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }
}

