/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.client;

import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.internal.client.WebSocketClient;
import com.sendbird.calls.internal.command.Command;
import com.sendbird.calls.internal.command.CommandFactory;
import com.sendbird.calls.internal.command.ErrorResponse;
import com.sendbird.calls.internal.command.LoginPushCommand;
import com.sendbird.calls.internal.command.WebSocketRequest;
import com.sendbird.calls.internal.util.Logger;
import com.sendbird.calls.shadow.okhttp3.OkHttpClient;
import com.sendbird.calls.shadow.okhttp3.Request;
import com.sendbird.calls.shadow.okhttp3.Response;
import com.sendbird.calls.shadow.okhttp3.WebSocket;
import com.sendbird.calls.shadow.okhttp3.WebSocketListener;
import com.sendbird.calls.shadow.okio.ByteString;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0003;<=B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\r\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\r\u0010$\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b%J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(H\u0002J\r\u0010)\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u0003H\u0002J\b\u0010-\u001a\u00020\"H\u0002J\b\u0010.\u001a\u00020\"H\u0002JY\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u0002012B\u00102\u001a>\u0012\u0015\u0012\u0013\u0018\u00010(\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(6\u0012\u0015\u0012\u0013\u0018\u000107\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(8\u0012\u0004\u0012\u00020\"\u0018\u000103j\u0004\u0018\u0001`9H\u0000\u00a2\u0006\u0002\b:R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00038@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u0006\u001a\u0004\u0018\u00010\u00198@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/sendbird/calls/internal/client/WebSocketClient;", "", "webSocketHost", "", "clientId", "(Ljava/lang/String;Ljava/lang/String;)V", "<set-?>", "Lcom/sendbird/calls/internal/client/WebSocketClient$ConnectionState;", "connectionState", "getConnectionState$calls_release", "()Lcom/sendbird/calls/internal/client/WebSocketClient$ConnectionState;", "setConnectionState$calls_release", "(Lcom/sendbird/calls/internal/client/WebSocketClient$ConnectionState;)V", "explicitDisconnect", "", "receiveExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "sessionToken", "getSessionToken$calls_release", "()Ljava/lang/String;", "setSessionToken$calls_release", "(Ljava/lang/String;)V", "webSocket", "Lcom/sendbird/calls/shadow/okhttp3/WebSocket;", "Lcom/sendbird/calls/internal/client/WebSocketClient$WebSocketEventListener;", "webSocketEventListener", "getWebSocketEventListener$calls_release", "()Lcom/sendbird/calls/internal/client/WebSocketClient$WebSocketEventListener;", "setWebSocketEventListener$calls_release", "(Lcom/sendbird/calls/internal/client/WebSocketClient$WebSocketEventListener;)V", "webSocketListener", "Lcom/sendbird/calls/shadow/okhttp3/WebSocketListener;", "connect", "", "connect$calls_release", "disconnect", "disconnect$calls_release", "dispatchCommand", "command", "Lcom/sendbird/calls/internal/command/Command;", "isConnectingOrConnected", "isConnectingOrConnected$calls_release", "onMessageReceived", "text", "quit", "reconnect", "send", "request", "Lcom/sendbird/calls/internal/command/WebSocketRequest;", "handler", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "response", "Lcom/sendbird/calls/SendBirdException;", "e", "Lcom/sendbird/calls/internal/util/ResponseHandler;", "send$calls_release", "Companion", "ConnectionState", "WebSocketEventListener", "calls_release"})
public final class WebSocketClient {
    @Nullable
    private String sessionToken;
    @Nullable
    private WebSocketEventListener webSocketEventListener;
    @NotNull
    private ConnectionState connectionState;
    private WebSocket webSocket;
    private final ExecutorService receiveExecutor;
    private boolean explicitDisconnect;
    private final WebSocketListener webSocketListener;
    private final String webSocketHost;
    private final String clientId;
    private static final long RECONNECTION_BACK_OFF_PERIOD = 1000L;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final /* synthetic */ String getSessionToken$calls_release() {
        return this.sessionToken;
    }

    public final /* synthetic */ void setSessionToken$calls_release(@Nullable String string) {
        this.sessionToken = string;
    }

    @Nullable
    public final /* synthetic */ WebSocketEventListener getWebSocketEventListener$calls_release() {
        return this.webSocketEventListener;
    }

    public final /* synthetic */ void setWebSocketEventListener$calls_release(@Nullable WebSocketEventListener webSocketEventListener2) {
        this.webSocketEventListener = webSocketEventListener2;
    }

    @NotNull
    public final /* synthetic */ ConnectionState getConnectionState$calls_release() {
        return this.connectionState;
    }

    public final /* synthetic */ void setConnectionState$calls_release(@NotNull ConnectionState connectionState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)connectionState), (String)"<set-?>");
        this.connectionState = connectionState;
    }

    public final /* synthetic */ boolean isConnectingOrConnected$calls_release() {
        return this.connectionState == ConnectionState.CONNECTING || this.connectionState == ConnectionState.CONNECTED;
    }

    public final /* synthetic */ void send$calls_release(@NotNull WebSocketRequest request, @Nullable Function2<? super Command, ? super SendBirdException, Unit> handler) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                if (this.connectionState != ConnectionState.CONNECTED) break block0;
                Logger.v("[WebSocketClient] Send message: " + request.getClass().getSimpleName() + " " + request.getPayload());
                WebSocket webSocket = this.webSocket;
                if (webSocket == null) break block1;
                webSocket.send(request.getPayload() + "\n");
                break block1;
            }
            int code = 1800204;
            String message = "Connection closed.";
            Function2<? super Command, ? super SendBirdException, Unit> function2 = handler;
            if (function2 == null) break block1;
            Unit cfr_ignored_0 = (Unit)function2.invoke((Object)new ErrorResponse(request.getRequestId(), code, message), (Object)SendBirdException.Companion.getSendBirdExceptionWithMessage$calls_release(code, message));
        }
    }

    public final synchronized /* synthetic */ void connect$calls_release() {
        Logger.v("[WebSocketClient] connect(). currentState = " + (Object)((Object)this.connectionState));
        if (this.connectionState == ConnectionState.CONNECTED || this.connectionState == ConnectionState.CONNECTING) {
            return;
        }
        if (this.sessionToken == null) {
            Logger.e("[WebSocketClient] connect(). sessionToken is null.");
            return;
        }
        this.explicitDisconnect = false;
        String string = this.webSocketHost + "/?sendbird_app_id=" + SendBirdCall.getApplicationId() + "&sbcall_session_token=" + this.sessionToken + "&sbcall_client_id=" + this.clientId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder(webSocketH\u2026              .toString()");
        String url = string;
        Request request = new Request.Builder().header("User-Agent", "calls-android/1.5.3").header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(url).build();
        Logger.v("[WebSocketClient] WS request: " + url);
        OkHttpClient okHttpClient = new OkHttpClient.Builder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
        this.connectionState = ConnectionState.CONNECTING;
        this.webSocket = okHttpClient.newWebSocket(request, this.webSocketListener);
        okHttpClient.dispatcher().executorService().shutdown();
    }

    public final /* synthetic */ void disconnect$calls_release() {
        this.explicitDisconnect = true;
        this.quit();
    }

    private final synchronized void quit() {
        block5: {
            Logger.v("[WebSocketClient] quit() explicitDisconnect: " + this.explicitDisconnect);
            if (!this.explicitDisconnect) {
                WebSocket webSocket = this.webSocket;
                if (webSocket != null) {
                    webSocket.cancel();
                }
            }
            try {
                WebSocket webSocket = this.webSocket;
                Boolean isClosedGracefully = webSocket != null ? Boolean.valueOf(webSocket.close(1000, "")) : null;
                Logger.v("[WebSocketClient] isClosedGracefully: " + isClosedGracefully);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.connectionState = ConnectionState.CLOSED;
            this.webSocket = null;
            if (!this.explicitDisconnect) break block5;
            WebSocketEventListener webSocketEventListener2 = this.webSocketEventListener;
            if (webSocketEventListener2 != null) {
                webSocketEventListener2.onClosed();
            }
        }
    }

    private final void reconnect() {
        this.quit();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.connect$calls_release();
    }

    private final void onMessageReceived(String text) {
        Command command = CommandFactory.Companion.parseCallCommand$calls_release(text);
        if (command == null) {
            Logger.e("[WebSocketClient] Failed to parse received text into Command.");
            return;
        }
        if (command instanceof LoginPushCommand) {
            return;
        }
        this.dispatchCommand(command);
    }

    private final void dispatchCommand(Command command) {
        block0: {
            Logger.v("[WebSocketClient] dispatchCommand(command: " + command.getClass().getSimpleName() + ")");
            WebSocketEventListener webSocketEventListener2 = this.webSocketEventListener;
            if (webSocketEventListener2 == null) break block0;
            webSocketEventListener2.onCommandReceived(command);
        }
    }

    public WebSocketClient(@NotNull String webSocketHost, @NotNull String clientId) {
        Intrinsics.checkParameterIsNotNull((Object)webSocketHost, (String)"webSocketHost");
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        this.webSocketHost = webSocketHost;
        this.clientId = clientId;
        this.connectionState = ConnectionState.CLOSED;
        this.receiveExecutor = Executors.newSingleThreadExecutor();
        Logger.v("[WebSocketClient] init(webSocketHost: " + this.webSocketHost + ", clientId: " + this.clientId + ')');
        this.webSocketListener = new WebSocketListener(this){
            final /* synthetic */ WebSocketClient this$0;

            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    Logger.v("[WebSocketClient] onOpen().");
                    this.this$0.setConnectionState$calls_release(ConnectionState.CONNECTED);
                    WebSocketEventListener webSocketEventListener2 = this.this$0.getWebSocketEventListener$calls_release();
                    if (webSocketEventListener2 == null) break block0;
                    webSocketEventListener2.onOpened();
                }
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
                Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Logger.v("[WebSocketClient][" + WebSocketClient.access$getClientId$p(this.this$0) + "] onMessage(). Received text: \n" + text);
                WebSocketClient.access$getReceiveExecutor$p(this.this$0).execute(new Runnable(this, text){
                    final /* synthetic */ webSocketListener.1 this$0;
                    final /* synthetic */ String $text;

                    public final void run() {
                        WebSocketClient.access$onMessageReceived(this.this$0.this$0, this.$text);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$text = string;
                    }
                });
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
                Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
                Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
                Logger.v("[WebSocketClient] onMessage(). bytes = " + bytes);
            }

            public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
                Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                Logger.v("[WebSocketClient] onClosing(code: " + code + ", reason: " + reason + ')');
                this.this$0.setConnectionState$calls_release(ConnectionState.CLOSING);
                if (!WebSocketClient.access$getExplicitDisconnect$p(this.this$0)) {
                    WebSocketClient.access$reconnect(this.this$0);
                }
            }

            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
                Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                Logger.v("[WebSocketClient] onClosed(code: " + code + ", reason: " + reason + ')');
                if (!WebSocketClient.access$getExplicitDisconnect$p(this.this$0)) {
                    WebSocketClient.access$reconnect(this.this$0);
                }
            }

            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
                Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                Logger.v("[WebSocketClient] onFailure(t: " + t.getMessage() + ')');
                if (!WebSocketClient.access$getExplicitDisconnect$p(this.this$0)) {
                    WebSocketClient.access$reconnect(this.this$0);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ String access$getClientId$p(WebSocketClient $this) {
        return $this.clientId;
    }

    public static final /* synthetic */ ExecutorService access$getReceiveExecutor$p(WebSocketClient $this) {
        return $this.receiveExecutor;
    }

    public static final /* synthetic */ void access$onMessageReceived(WebSocketClient $this, String text) {
        $this.onMessageReceived(text);
    }

    public static final /* synthetic */ boolean access$getExplicitDisconnect$p(WebSocketClient $this) {
        return $this.explicitDisconnect;
    }

    public static final /* synthetic */ void access$setExplicitDisconnect$p(WebSocketClient $this, boolean bl) {
        $this.explicitDisconnect = bl;
    }

    public static final /* synthetic */ void access$reconnect(WebSocketClient $this) {
        $this.reconnect();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lcom/sendbird/calls/internal/client/WebSocketClient$WebSocketEventListener;", "", "onClosed", "", "onCommandReceived", "command", "Lcom/sendbird/calls/internal/command/Command;", "onOpened", "calls_release"})
    public static interface WebSocketEventListener {
        public /* synthetic */ void onOpened();

        public /* synthetic */ void onClosed();

        public /* synthetic */ void onCommandReceived(@NotNull Command var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/sendbird/calls/internal/client/WebSocketClient$ConnectionState;", "", "(Ljava/lang/String;I)V", "CLOSED", "CLOSING", "CONNECTING", "CONNECTED", "calls_release"})
    public static final class ConnectionState
    extends Enum<ConnectionState> {
        public static final /* enum */ ConnectionState CLOSED;
        public static final /* enum */ ConnectionState CLOSING;
        public static final /* enum */ ConnectionState CONNECTING;
        public static final /* enum */ ConnectionState CONNECTED;
        private static final /* synthetic */ ConnectionState[] $VALUES;

        static {
            ConnectionState[] connectionStateArray = new ConnectionState[4];
            ConnectionState[] connectionStateArray2 = connectionStateArray;
            connectionStateArray[0] = CLOSED = new ConnectionState();
            connectionStateArray[1] = CLOSING = new ConnectionState();
            connectionStateArray[2] = CONNECTING = new ConnectionState();
            connectionStateArray[3] = CONNECTED = new ConnectionState();
            $VALUES = connectionStateArray;
        }

        public static ConnectionState[] values() {
            return (ConnectionState[])$VALUES.clone();
        }

        public static ConnectionState valueOf(String string) {
            return Enum.valueOf(ConnectionState.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/sendbird/calls/internal/client/WebSocketClient$Companion;", "", "()V", "RECONNECTION_BACK_OFF_PERIOD", "", "calls_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

