/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.pc;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.UiThread;
import androidx.annotation.RequiresApi;
import com.sendbird.calls.AudioDevice;
import com.sendbird.calls.CallOptions;
import com.sendbird.calls.RecordingOptions;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.SendBirdVideoView;
import com.sendbird.calls.VideoDevice;
import com.sendbird.calls.handler.CaptureVideoViewHandler;
import com.sendbird.calls.handler.CompletionHandler;
import com.sendbird.calls.internal.model.TransportPolicy;
import com.sendbird.calls.internal.pc.AppRTCAudioManager;
import com.sendbird.calls.internal.pc.CameraManager;
import com.sendbird.calls.internal.pc.PeerConnection;
import com.sendbird.calls.internal.pc.PeerConnectionClient;
import com.sendbird.calls.internal.pc.PeerConnectionClientEvent;
import com.sendbird.calls.internal.pc.PeerConnectionClientStatus;
import com.sendbird.calls.internal.pc.PeerConnectionEvents;
import com.sendbird.calls.internal.pc.PeerConnectionKt;
import com.sendbird.calls.internal.pc.PeerConnectionParameters;
import com.sendbird.calls.internal.pc.Recorder;
import com.sendbird.calls.internal.pc.state.PeerConnectionIceRestartAnsweringState;
import com.sendbird.calls.internal.pc.state.PeerConnectionIceRestartOfferingState;
import com.sendbird.calls.internal.pc.state.PeerConnectionIdleState;
import com.sendbird.calls.internal.pc.state.PeerConnectionReconnectingState;
import com.sendbird.calls.internal.pc.state.PeerConnectionState;
import com.sendbird.calls.internal.util.ExtensionsKt;
import com.sendbird.calls.internal.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.SessionDescription;
import org.webrtc.StatsReport;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.audio.JavaAudioDeviceModule;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0006\u00a0\u0001\u00a1\u0001\u00a2\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0000\u00a2\u0006\u0002\bLJ\u0018\u0010M\u001a\u00020I2\u0006\u0010N\u001a\u00020\u00052\b\u0010O\u001a\u0004\u0018\u00010PJ\u0015\u0010Q\u001a\u00020I2\u0006\u0010R\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\bSJ\u0006\u0010T\u001a\u00020IJ\r\u0010U\u001a\u00020IH\u0000\u00a2\u0006\u0002\bVJ\b\u0010W\u001a\u00020XH\u0002J\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0ZJ\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]J\b\u0010_\u001a\u0004\u0018\u00010[J\b\u0010`\u001a\u0004\u0018\u00010^J\r\u0010a\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bbJ\u001d\u0010c\u001a\u00020I2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020K0eH\u0000\u00a2\u0006\u0004\bf\u0010gJ\u0010\u0010h\u001a\u00020\u00052\u0006\u0010i\u001a\u00020[H\u0007J\u000e\u0010j\u001a\u00020\u00052\u0006\u0010k\u001a\u00020\u0005J\u0012\u0010l\u001a\u00020I2\b\u0010m\u001a\u0004\u0018\u00010nH\u0007J#\u0010o\u001a\u00020I2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020q0]2\u0006\u0010r\u001a\u00020sH\u0000\u00a2\u0006\u0002\btJ\u0010\u0010u\u001a\u00020I2\b\u0010v\u001a\u0004\u0018\u00010wJ\u0012\u0010x\u001a\u00020I2\b\u0010y\u001a\u0004\u0018\u00010#H\u0007J\u001a\u0010z\u001a\u00020I2\b\u0010y\u001a\u0004\u0018\u00010#2\u0006\u0010{\u001a\u00020\u0005H\u0002J\u000e\u0010|\u001a\u00020I2\u0006\u0010}\u001a\u00020~J\u0018\u0010\u007f\u001a\u00020I2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0000\u00a2\u0006\u0003\b\u0082\u0001J\u0013\u0010\u0083\u0001\u001a\u00020I2\b\u0010y\u001a\u0004\u0018\u00010#H\u0007J\u0011\u0010\u0084\u0001\u001a\u00020I2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0018\u0010\u0085\u0001\u001a\u00020I2\u0006\u0010k\u001a\u00020\u00052\u0007\u0010\u0086\u0001\u001a\u00020\u0005J^\u0010\u0087\u0001\u001a\u00020I2\u0006\u0010\u0004\u001a\u00020\u00052K\u0010\u0088\u0001\u001aF\u0012\u0018\u0012\u0016\u0018\u00010[\u00a2\u0006\u000f\b\u008a\u0001\u0012\n\b\u008b\u0001\u0012\u0005\b\b(\u008c\u0001\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020[0Z\u00a2\u0006\u000f\b\u008a\u0001\u0012\n\b\u008b\u0001\u0012\u0005\b\b(\u008d\u0001\u0012\u0004\u0012\u00020I0\u0089\u0001j\u0003`\u008e\u0001H\u0007J\u009b\u0001\u0010\u008f\u0001\u001a\u00020~2\u0007\u0010\u0090\u0001\u001a\u00020\n2\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012}\u0010\u0093\u0001\u001ax\u0012\u0016\u0012\u00140\n\u00a2\u0006\u000f\b\u008a\u0001\u0012\n\b\u008b\u0001\u0012\u0005\b\b(\u0095\u0001\u0012\u0017\u0012\u00150\u0092\u0001\u00a2\u0006\u000f\b\u008a\u0001\u0012\n\b\u008b\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\u0018\u0012\u0016\u0018\u00010\n\u00a2\u0006\u000f\b\u008a\u0001\u0012\n\b\u008b\u0001\u0012\u0005\b\b(\u0097\u0001\u0012\u0019\u0012\u0017\u0018\u00010\u0098\u0001\u00a2\u0006\u000f\b\u008a\u0001\u0012\n\b\u008b\u0001\u0012\u0005\b\b(\u0099\u0001\u0012\u0004\u0012\u00020I\u0018\u00010\u0094\u0001j\u0005\u0018\u0001`\u009a\u0001H\u0007J\t\u0010\u009b\u0001\u001a\u00020IH\u0007J\u0007\u0010\u009c\u0001\u001a\u00020IJ\u001d\u0010\u009d\u0001\u001a\u00020I2\t\u0010\u009e\u0001\u001a\u0004\u0018\u00010^2\t\u0010O\u001a\u0005\u0018\u00010\u009f\u0001J\u0012\u0010\u009d\u0001\u001a\u00020I2\t\u0010O\u001a\u0005\u0018\u00010\u009f\u0001R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\f0\f8@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#8@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0013\u0010)\u001a\u00020*8F\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R*\u0010.\u001a\u0004\u0018\u00010-2\b\u0010\"\u001a\u0004\u0018\u00010-8@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u000604R\u00020\u00008@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u000e\u00109\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010<\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#8@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010&\"\u0004\b>\u0010(R\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010G\u00a8\u0006\u00a3\u0001"}, d2={"Lcom/sendbird/calls/internal/pc/PeerConnectionClient;", "", "context", "Landroid/content/Context;", "isVideoCall", "", "isInitiator", "status", "Lcom/sendbird/calls/internal/pc/PeerConnectionClientStatus;", "peerConnectionId", "", "sharedEglBase", "Lorg/webrtc/EglBase;", "isIceServerRequired", "(Landroid/content/Context;ZZLcom/sendbird/calls/internal/pc/PeerConnectionClientStatus;Ljava/lang/String;Lorg/webrtc/EglBase;Z)V", "audioManager", "Lcom/sendbird/calls/internal/pc/AppRTCAudioManager;", "cameraManager", "Lcom/sendbird/calls/internal/pc/CameraManager;", "currentState", "Lcom/sendbird/calls/internal/pc/state/PeerConnectionState;", "eglBase", "kotlin.jvm.PlatformType", "getEglBase$calls_release", "()Lorg/webrtc/EglBase;", "isIceServerSet", "isInitiator$calls_release", "()Z", "isSwappedFeeds", "localAudioRecordingProxy", "Lcom/sendbird/calls/internal/pc/PeerConnectionClient$ProxyAudioSamplesReadyCallback;", "localProxyVideoSink", "Lcom/sendbird/calls/internal/pc/PeerConnectionClient$ProxyVideoSink;", "localVideoRecordingProxy", "<set-?>", "Lcom/sendbird/calls/SendBirdVideoView;", "localVideoView", "getLocalVideoView$calls_release", "()Lcom/sendbird/calls/SendBirdVideoView;", "setLocalVideoView$calls_release", "(Lcom/sendbird/calls/SendBirdVideoView;)V", "peerConnection", "Lcom/sendbird/calls/internal/pc/PeerConnection;", "getPeerConnection", "()Lcom/sendbird/calls/internal/pc/PeerConnection;", "Lcom/sendbird/calls/internal/pc/PeerConnectionClientEvent;", "peerConnectionClientEvent", "getPeerConnectionClientEvent$calls_release", "()Lcom/sendbird/calls/internal/pc/PeerConnectionClientEvent;", "setPeerConnectionClientEvent$calls_release", "(Lcom/sendbird/calls/internal/pc/PeerConnectionClientEvent;)V", "peerConnectionEventsImpl", "Lcom/sendbird/calls/internal/pc/PeerConnectionClient$PeerConnectionEventsImpl;", "getPeerConnectionEventsImpl$calls_release", "()Lcom/sendbird/calls/internal/pc/PeerConnectionClient$PeerConnectionEventsImpl;", "getPeerConnectionId$calls_release", "()Ljava/lang/String;", "remoteAudioRecordingProxy", "remoteProxyVideoSink", "remoteVideoRecordingProxy", "remoteVideoView", "getRemoteVideoView$calls_release", "setRemoteVideoView$calls_release", "signalingQueue", "", "Ljava/lang/Runnable;", "stateExecutor", "Ljava/util/concurrent/ExecutorService;", "getStatus$calls_release", "()Lcom/sendbird/calls/internal/pc/PeerConnectionClientStatus;", "setStatus$calls_release", "(Lcom/sendbird/calls/internal/pc/PeerConnectionClientStatus;)V", "addRemoteIceCandidate", "", "candidate", "Lorg/webrtc/IceCandidate;", "addRemoteIceCandidate$calls_release", "captureVideoView", "isLocal", "handler", "Lcom/sendbird/calls/handler/CaptureVideoViewHandler;", "changeState", "nextState", "changeState$calls_release", "close", "createOffer", "createOffer$calls_release", "createPeerConnectionParameter", "Lcom/sendbird/calls/internal/pc/PeerConnectionParameters;", "getAvailableAudioDevices", "", "Lcom/sendbird/calls/AudioDevice;", "getAvailableVideoDevices", "", "Lcom/sendbird/calls/VideoDevice;", "getCurrentAudioDevice", "getCurrentVideoDevice", "isRestarting", "isRestarting$calls_release", "removeRemoteIceCandidates", "iceCandidates", "", "removeRemoteIceCandidates$calls_release", "([Lorg/webrtc/IceCandidate;)V", "selectAudioDevice", "audioDevice", "setAudioEnabled", "isEnabled", "setCallOptions", "callOptions", "Lcom/sendbird/calls/CallOptions;", "setConfiguration", "iceServers", "Lorg/webrtc/PeerConnection$IceServer;", "transportPolicy", "Lcom/sendbird/calls/internal/model/TransportPolicy;", "setConfiguration$calls_release", "setCustomVideoCapturer", "videoCapturer", "Lorg/webrtc/VideoCapturer;", "setLocalVideoView", "videoView", "setMirror", "tryToMirror", "setRecorderEventListeners", "recorder", "Lcom/sendbird/calls/internal/pc/Recorder;", "setRemoteDescription", "sdp", "Lorg/webrtc/SessionDescription;", "setRemoteDescription$calls_release", "setRemoteVideoView", "setSwappedFeeds", "setVideoEnabled", "isCallOption", "startAudioManager", "audioManagerEvents", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "selectedAudioDevice", "availableAudioDevices", "Lcom/sendbird/calls/internal/util/AudioManagerEvents;", "startRecording", "callId", "recordingOptions", "Lcom/sendbird/calls/RecordingOptions;", "listener", "Lkotlin/Function4;", "recordingId", "recordingOption", "filePath", "Lcom/sendbird/calls/SendBirdException;", "e", "Lcom/sendbird/calls/internal/util/DirectCallRecordingListener;", "stopAudioManager", "stopRecording", "switchCamera", "videoDevice", "Lcom/sendbird/calls/handler/CompletionHandler;", "PeerConnectionEventsImpl", "ProxyAudioSamplesReadyCallback", "ProxyVideoSink", "calls_release"})
public final class PeerConnectionClient {
    @Nullable
    private PeerConnectionClientEvent peerConnectionClientEvent;
    private final EglBase eglBase;
    private final ProxyVideoSink remoteProxyVideoSink;
    private final ProxyVideoSink localProxyVideoSink;
    private final ProxyVideoSink remoteVideoRecordingProxy;
    private final ProxyVideoSink localVideoRecordingProxy;
    private final ProxyAudioSamplesReadyCallback remoteAudioRecordingProxy;
    private final ProxyAudioSamplesReadyCallback localAudioRecordingProxy;
    @NotNull
    private final PeerConnection peerConnection;
    private AppRTCAudioManager audioManager;
    private final CameraManager cameraManager;
    @Nullable
    private SendBirdVideoView localVideoView;
    @Nullable
    private SendBirdVideoView remoteVideoView;
    private boolean isSwappedFeeds;
    private boolean isIceServerSet;
    private final List<Runnable> signalingQueue;
    private PeerConnectionState currentState;
    private final ExecutorService stateExecutor;
    @NotNull
    private final PeerConnectionEventsImpl peerConnectionEventsImpl;
    private final Context context;
    private final boolean isVideoCall;
    private final boolean isInitiator;
    @NotNull
    private PeerConnectionClientStatus status;
    @Nullable
    private final String peerConnectionId;
    private final boolean isIceServerRequired;

    @Nullable
    public final /* synthetic */ PeerConnectionClientEvent getPeerConnectionClientEvent$calls_release() {
        return this.peerConnectionClientEvent;
    }

    public final /* synthetic */ void setPeerConnectionClientEvent$calls_release(@Nullable PeerConnectionClientEvent peerConnectionClientEvent) {
        this.peerConnectionClientEvent = peerConnectionClientEvent;
    }

    public final /* synthetic */ EglBase getEglBase$calls_release() {
        return this.eglBase;
    }

    @NotNull
    public final /* synthetic */ PeerConnection getPeerConnection() {
        return this.peerConnection;
    }

    @Nullable
    public final /* synthetic */ SendBirdVideoView getLocalVideoView$calls_release() {
        return this.localVideoView;
    }

    public final /* synthetic */ void setLocalVideoView$calls_release(@Nullable SendBirdVideoView sendBirdVideoView) {
        this.localVideoView = sendBirdVideoView;
    }

    @Nullable
    public final /* synthetic */ SendBirdVideoView getRemoteVideoView$calls_release() {
        return this.remoteVideoView;
    }

    public final /* synthetic */ void setRemoteVideoView$calls_release(@Nullable SendBirdVideoView sendBirdVideoView) {
        this.remoteVideoView = sendBirdVideoView;
    }

    @NotNull
    public final /* synthetic */ PeerConnectionEventsImpl getPeerConnectionEventsImpl$calls_release() {
        return this.peerConnectionEventsImpl;
    }

    private final PeerConnectionParameters createPeerConnectionParameter() {
        boolean videoCallEnabled = this.isVideoCall;
        int videoMaxBitrate = 0;
        String videoCodec = "VP8";
        boolean videoCodecHwAcceleration = true;
        boolean videoFlexFecEnabled = false;
        int audioStartBitrate = 0;
        String audioCodec = "OPUS";
        boolean noAudioProcessing = false;
        boolean useOpenSLES = false;
        boolean disableBuiltInAEC = false;
        boolean disableBuiltInAGC = false;
        boolean disableBuiltInNS = false;
        boolean disableWebRtcAGCAndHPF = false;
        return new PeerConnectionParameters(videoCallEnabled, videoMaxBitrate, videoCodec, videoCodecHwAcceleration, videoFlexFecEnabled, audioStartBitrate, audioCodec, noAudioProcessing, useOpenSLES, disableBuiltInAEC, disableBuiltInAGC, disableBuiltInNS, disableWebRtcAGCAndHPF);
    }

    public final /* synthetic */ void createOffer$calls_release() {
        Logger.v("[PeerConnectionClient] createOffer()");
        this.stateExecutor.execute(new Runnable(this){
            final /* synthetic */ PeerConnectionClient this$0;

            public final void run() {
                PeerConnectionClient.access$getCurrentState$p(this.this$0).createOffer(this.this$0);
            }
            {
                this.this$0 = peerConnectionClient;
            }
        });
    }

    public final /* synthetic */ void setRemoteDescription$calls_release(@NotNull SessionDescription sdp) {
        Intrinsics.checkParameterIsNotNull((Object)sdp, (String)"sdp");
        Logger.v("[PeerConnectionClient] setRemoteDescription() isIceServerSet: " + this.isIceServerSet);
        Runnable runnable = new Runnable(this, sdp){
            final /* synthetic */ PeerConnectionClient this$0;
            final /* synthetic */ SessionDescription $sdp;

            public final void run() {
                PeerConnectionClient.access$getStateExecutor$p(this.this$0).execute(new Runnable(this){
                    final /* synthetic */ setRemoteDescription.1 this$0;

                    public final void run() {
                        if (this.this$0.$sdp.type == SessionDescription.Type.OFFER) {
                            PeerConnectionClient.access$getCurrentState$p(this.this$0.this$0).setOffer(this.this$0.this$0, this.this$0.$sdp);
                        } else {
                            PeerConnectionClient.access$getCurrentState$p(this.this$0.this$0).setAnswer(this.this$0.this$0, this.this$0.$sdp);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = peerConnectionClient;
                this.$sdp = sessionDescription;
            }
        };
        boolean bl = false;
        boolean bl2 = false;
        Runnable it = runnable;
        boolean bl3 = false;
        if (!this.isIceServerRequired | this.isIceServerSet) {
            it.run();
        } else {
            this.signalingQueue.add(0, it);
        }
    }

    public final /* synthetic */ void addRemoteIceCandidate$calls_release(@NotNull IceCandidate candidate) {
        Intrinsics.checkParameterIsNotNull((Object)candidate, (String)"candidate");
        Logger.d("[PeerConnectionClient] addRemoteIceCandidate() isIceServerSet: " + this.isIceServerSet);
        Runnable runnable = new Runnable(this, candidate){
            final /* synthetic */ PeerConnectionClient this$0;
            final /* synthetic */ IceCandidate $candidate;

            public final void run() {
                PeerConnectionClient.access$getStateExecutor$p(this.this$0).execute(new Runnable(this){
                    final /* synthetic */ addRemoteIceCandidate.1 this$0;

                    public final void run() {
                        this.this$0.this$0.getPeerConnection().addRemoteIceCandidate(this.this$0.$candidate);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = peerConnectionClient;
                this.$candidate = iceCandidate;
            }
        };
        boolean bl = false;
        boolean bl2 = false;
        Runnable it = runnable;
        boolean bl3 = false;
        if (!this.isIceServerRequired | this.isIceServerSet) {
            it.run();
        } else {
            this.signalingQueue.add(it);
        }
    }

    public final /* synthetic */ void removeRemoteIceCandidates$calls_release(@NotNull IceCandidate[] iceCandidates) {
        Intrinsics.checkParameterIsNotNull((Object)iceCandidates, (String)"iceCandidates");
        Logger.d("[PeerConnectionClient] removeRemoteIceCandidates() isIceServerSet: " + this.isIceServerSet);
        Runnable runnable = new Runnable(this, iceCandidates){
            final /* synthetic */ PeerConnectionClient this$0;
            final /* synthetic */ IceCandidate[] $iceCandidates;

            public final void run() {
                PeerConnectionClient.access$getStateExecutor$p(this.this$0).execute(new Runnable(this){
                    final /* synthetic */ removeRemoteIceCandidates.1 this$0;

                    public final void run() {
                        this.this$0.this$0.getPeerConnection().removeRemoteIceCandidates(this.this$0.$iceCandidates);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = peerConnectionClient;
                this.$iceCandidates = iceCandidateArray;
            }
        };
        boolean bl = false;
        boolean bl2 = false;
        Runnable it = runnable;
        boolean bl3 = false;
        if (!this.isIceServerRequired | this.isIceServerSet) {
            it.run();
        } else {
            this.signalingQueue.add(it);
        }
    }

    public final void setConfiguration$calls_release(@NotNull List<? extends PeerConnection.IceServer> iceServers, @NotNull TransportPolicy transportPolicy) {
        Intrinsics.checkParameterIsNotNull(iceServers, (String)"iceServers");
        Intrinsics.checkParameterIsNotNull((Object)((Object)transportPolicy), (String)"transportPolicy");
        Logger.d("[PeerConnectionClient] setConfiguration() " + this.signalingQueue.size());
        this.peerConnection.setConfiguration(iceServers, transportPolicy);
        if (this.isIceServerRequired && !this.isIceServerSet) {
            Iterable $this$forEach$iv = this.signalingQueue;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Runnable it = (Runnable)element$iv;
                boolean bl = false;
                it.run();
            }
            this.signalingQueue.clear();
            this.isIceServerSet = true;
        }
    }

    @UiThread
    public final /* synthetic */ void setCallOptions(@Nullable CallOptions callOptions) {
        if (callOptions == null) {
            return;
        }
        this.peerConnection.setVideoConstraints(callOptions.getVideoWidth$calls_release(), callOptions.getVideoHeight$calls_release(), callOptions.getVideoFps$calls_release());
        this.setLocalVideoView(callOptions.getLocalVideoView$calls_release());
        this.setRemoteVideoView(callOptions.getRemoteVideoView$calls_release());
        this.setVideoEnabled(callOptions.getVideoEnabled$calls_release(), true);
        this.setAudioEnabled(callOptions.getAudioEnabled$calls_release());
        if (this.cameraManager.isFrontCamera() != null && Intrinsics.areEqual((Object)this.cameraManager.isFrontCamera(), (Object)callOptions.getFrontCamera$calls_release()) ^ true) {
            this.cameraManager.switchCamera(null);
        }
    }

    public final /* synthetic */ void setVideoEnabled(boolean isEnabled, boolean isCallOption) {
        this.peerConnection.setVideoEnabled(isEnabled, this.cameraManager.getCameraState(), isCallOption);
    }

    public final /* synthetic */ boolean setAudioEnabled(boolean isEnabled) {
        return this.peerConnection.setAudioEnabled(isEnabled);
    }

    @UiThread
    public final /* synthetic */ void setLocalVideoView(@Nullable SendBirdVideoView videoView) {
        Logger.d("[PeerConnectionClient] setLocalVideoView(" + videoView + ')');
        if (videoView == this.localVideoView) {
            return;
        }
        if (videoView == null) {
            this.localProxyVideoSink.setTarget(null);
            SendBirdVideoView sendBirdVideoView = this.localVideoView;
            if (sendBirdVideoView != null) {
                sendBirdVideoView.release();
            }
            this.localVideoView = null;
            return;
        }
        if (videoView == this.remoteVideoView) {
            this.localVideoView = videoView;
            this.remoteVideoView = null;
            this.remoteProxyVideoSink.setTarget(null);
        } else {
            this.localProxyVideoSink.setTarget(null);
            videoView.release();
            SendBirdVideoView sendBirdVideoView = this.localVideoView;
            if (sendBirdVideoView != null) {
                sendBirdVideoView.release();
            }
            SendBirdVideoView sendBirdVideoView2 = this.localVideoView = videoView;
            if (sendBirdVideoView2 != null) {
                EglBase eglBase = this.eglBase;
                Intrinsics.checkExpressionValueIsNotNull((Object)eglBase, (String)"eglBase");
                sendBirdVideoView2.init(eglBase.getEglBaseContext(), null);
            }
        }
        this.setMirror(this.localVideoView, true);
        this.localProxyVideoSink.setTarget(this.localVideoView);
        if (this.peerConnection.isVideoEnabled() && this.peerConnection.isVideoCapturerStopped()) {
            this.peerConnection.startVideoSource();
        }
    }

    @UiThread
    public final /* synthetic */ void setRemoteVideoView(@Nullable SendBirdVideoView videoView) {
        Logger.d("[PeerConnectionClient] setRemoteVideoView(" + videoView + ')');
        if (videoView == this.remoteVideoView) {
            return;
        }
        if (videoView == null) {
            this.remoteProxyVideoSink.setTarget(null);
            SendBirdVideoView sendBirdVideoView = this.remoteVideoView;
            if (sendBirdVideoView != null) {
                sendBirdVideoView.release();
            }
            this.remoteVideoView = null;
            return;
        }
        if (videoView == this.localVideoView) {
            this.remoteVideoView = videoView;
            this.localVideoView = null;
            this.localProxyVideoSink.setTarget(null);
        } else {
            this.remoteProxyVideoSink.setTarget(null);
            videoView.release();
            SendBirdVideoView sendBirdVideoView = this.remoteVideoView;
            if (sendBirdVideoView != null) {
                sendBirdVideoView.release();
            }
            SendBirdVideoView sendBirdVideoView2 = this.remoteVideoView = videoView;
            if (sendBirdVideoView2 != null) {
                EglBase eglBase = this.eglBase;
                Intrinsics.checkExpressionValueIsNotNull((Object)eglBase, (String)"eglBase");
                sendBirdVideoView2.init(eglBase.getEglBaseContext(), null);
            }
        }
        this.setMirror(this.remoteVideoView, false);
        this.remoteProxyVideoSink.setTarget(this.remoteVideoView);
    }

    public final /* synthetic */ void captureVideoView(boolean isLocal, @Nullable CaptureVideoViewHandler handler) {
        SendBirdVideoView videoView;
        SendBirdVideoView sendBirdVideoView = videoView = isLocal ? this.localVideoView : this.remoteVideoView;
        if (videoView == null) {
            SendBirdCall.runOnThreadOption$calls_release((Function0<Unit>)((Function0)new Function0<Unit>(handler){
                final /* synthetic */ CaptureVideoViewHandler $handler;

                @Nullable
                public final Unit invoke() {
                    Unit unit;
                    CaptureVideoViewHandler captureVideoViewHandler = this.$handler;
                    if (captureVideoViewHandler != null) {
                        captureVideoViewHandler.onCaptured(null, SendBirdException.Companion.getSendBirdException$calls_release(1800601));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
                {
                    this.$handler = captureVideoViewHandler;
                    super(0);
                }
            }));
            return;
        }
        Timer timer = new Timer();
        EglRenderer.FrameListener frameListener2 = new EglRenderer.FrameListener(timer, handler){
            final /* synthetic */ Timer $timer;
            final /* synthetic */ CaptureVideoViewHandler $handler;

            public final void onFrame(@Nullable Bitmap frame) {
                this.$timer.cancel();
                SendBirdCall.runOnThreadOption$calls_release((Function0<Unit>)((Function0)new Function0<Unit>(this, frame){
                    final /* synthetic */ captureVideoView.frameListener.1 this$0;
                    final /* synthetic */ Bitmap $frame;

                    @Nullable
                    public final Unit invoke() {
                        Unit unit;
                        CaptureVideoViewHandler captureVideoViewHandler = this.this$0.$handler;
                        if (captureVideoViewHandler != null) {
                            captureVideoViewHandler.onCaptured(this.$frame, null);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$frame = bitmap;
                        super(0);
                    }
                }));
            }
            {
                this.$timer = timer;
                this.$handler = captureVideoViewHandler;
            }
        };
        videoView.addFrameListener(frameListener2, 1.0f);
        timer.schedule(new TimerTask(videoView, frameListener2, handler){
            final /* synthetic */ SendBirdVideoView $videoView;
            final /* synthetic */ EglRenderer.FrameListener $frameListener;
            final /* synthetic */ CaptureVideoViewHandler $handler;

            public void run() {
                this.$videoView.removeFrameListener(this.$frameListener);
                SendBirdCall.runOnThreadOption$calls_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ captureVideoView.2 this$0;

                    @Nullable
                    public final Unit invoke() {
                        Unit unit;
                        CaptureVideoViewHandler captureVideoViewHandler = this.this$0.$handler;
                        if (captureVideoViewHandler != null) {
                            captureVideoViewHandler.onCaptured(null, SendBirdException.Companion.getSendBirdException$calls_release(1800603));
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$videoView = $captured_local_variable$0;
                this.$frameListener = $captured_local_variable$1;
                this.$handler = $captured_local_variable$2;
            }
        }, 1000L);
    }

    public final /* synthetic */ void switchCamera(@Nullable VideoDevice videoDevice, @Nullable CompletionHandler handler) {
        block1: {
            block0: {
                if (!this.peerConnection.isVideoCall()) break block0;
                this.cameraManager.switchCamera(videoDevice, (Function1<? super SendBirdException, Unit>)((Function1)new Function1<SendBirdException, Unit>(this, handler){
                    final /* synthetic */ PeerConnectionClient this$0;
                    final /* synthetic */ CompletionHandler $handler;

                    public final void invoke(@Nullable SendBirdException e) {
                        block0: {
                            PeerConnectionClient.access$setMirror(this.this$0, this.this$0.getLocalVideoView$calls_release(), true);
                            CompletionHandler completionHandler = this.$handler;
                            if (completionHandler == null) break block0;
                            completionHandler.onResult(e);
                        }
                    }
                    {
                        this.this$0 = peerConnectionClient;
                        this.$handler = completionHandler;
                        super(1);
                    }
                }));
                break block1;
            }
            CompletionHandler completionHandler = handler;
            if (completionHandler == null) break block1;
            completionHandler.onResult(SendBirdException.Companion.getSendBirdException$calls_release(1800401));
        }
    }

    public final /* synthetic */ void switchCamera(@Nullable CompletionHandler handler) {
        block1: {
            block0: {
                if (!this.peerConnection.isVideoCall()) break block0;
                this.cameraManager.switchCamera((Function1<? super SendBirdException, Unit>)((Function1)new Function1<SendBirdException, Unit>(this, handler){
                    final /* synthetic */ PeerConnectionClient this$0;
                    final /* synthetic */ CompletionHandler $handler;

                    public final void invoke(@Nullable SendBirdException e) {
                        block0: {
                            PeerConnectionClient.access$setMirror(this.this$0, this.this$0.getLocalVideoView$calls_release(), true);
                            CompletionHandler completionHandler = this.$handler;
                            if (completionHandler == null) break block0;
                            completionHandler.onResult(e);
                        }
                    }
                    {
                        this.this$0 = peerConnectionClient;
                        this.$handler = completionHandler;
                        super(1);
                    }
                }));
                break block1;
            }
            CompletionHandler completionHandler = handler;
            if (completionHandler == null) break block1;
            completionHandler.onResult(SendBirdException.Companion.getSendBirdException$calls_release(1800401));
        }
    }

    @RequiresApi(value=18)
    @NotNull
    public final /* synthetic */ Recorder startRecording(@NotNull String callId, @NotNull RecordingOptions recordingOptions, @Nullable Function4<? super String, ? super RecordingOptions, ? super String, ? super SendBirdException, Unit> listener) throws SendBirdException {
        Intrinsics.checkParameterIsNotNull((Object)callId, (String)"callId");
        Intrinsics.checkParameterIsNotNull((Object)recordingOptions, (String)"recordingOptions");
        Recorder recorder = new Recorder(callId, recordingOptions);
        boolean bl = false;
        boolean bl2 = false;
        Recorder $this$apply = recorder;
        boolean bl3 = false;
        $this$apply.setRecordingListener(listener);
        this.setRecorderEventListeners($this$apply);
        Recorder recorder2 = recorder;
        int width = PeerConnectionKt.getHD_VIDEO_WIDTH();
        int height = PeerConnectionKt.getHD_VIDEO_HEIGHT();
        if (ExtensionsKt.isVideoCallRequired(recordingOptions.getRecordingType$calls_release())) {
            ProxyVideoSink proxyVideoSink = recordingOptions.getRecordingType$calls_release() == RecordingOptions.RecordingType.LOCAL_AUDIO_AND_VIDEO_REMOTE_AUDIO ? this.localProxyVideoSink : this.remoteProxyVideoSink;
            Double d = proxyVideoSink.getWhRatio$calls_release();
            if (d != null) {
                Double d2 = d;
                boolean bl4 = false;
                boolean bl5 = false;
                double it = ((Number)d2).doubleValue();
                boolean bl6 = false;
                if (it < 1.0) {
                    width = PeerConnectionKt.getHD_VIDEO_HEIGHT();
                    height = PeerConnectionKt.getHD_VIDEO_WIDTH();
                }
            }
        }
        EglBase eglBase = this.eglBase;
        Intrinsics.checkExpressionValueIsNotNull((Object)eglBase, (String)"eglBase");
        EglBase.Context context = eglBase.getEglBaseContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"eglBase.eglBaseContext");
        recorder2.initEncoders$calls_release(context, width, height);
        return recorder2;
    }

    public final /* synthetic */ void stopRecording() {
        this.localAudioRecordingProxy.setTarget(null);
        this.localVideoRecordingProxy.setTarget(null);
        this.remoteAudioRecordingProxy.setTarget(null);
        this.remoteVideoRecordingProxy.setTarget(null);
    }

    public final /* synthetic */ void setRecorderEventListeners(@NotNull Recorder recorder) {
        Intrinsics.checkParameterIsNotNull((Object)recorder, (String)"recorder");
        this.localAudioRecordingProxy.setTarget(recorder.getLocalAudioSamplesReadyCallback());
        this.localVideoRecordingProxy.setTarget(recorder.getLocalVideoSink());
        this.remoteAudioRecordingProxy.setTarget(recorder.getRemoteAudioSamplesReadyCallback());
        this.remoteVideoRecordingProxy.setTarget(recorder.getRemoteVideoSink());
    }

    @UiThread
    public final /* synthetic */ void startAudioManager(boolean isVideoCall, @NotNull Function2<? super AudioDevice, ? super Set<? extends AudioDevice>, Unit> audioManagerEvents) {
        block1: {
            Intrinsics.checkParameterIsNotNull(audioManagerEvents, (String)"audioManagerEvents");
            Logger.v("[PeerConnectionClient] startAudioManager()");
            if (this.audioManager != null) break block1;
            AppRTCAudioManager appRTCAudioManager = this.audioManager = AppRTCAudioManager.Companion.create(this.context, isVideoCall);
            if (appRTCAudioManager != null) {
                appRTCAudioManager.start(audioManagerEvents);
            }
        }
    }

    @Nullable
    public final /* synthetic */ AudioDevice getCurrentAudioDevice() {
        AppRTCAudioManager appRTCAudioManager = this.audioManager;
        return appRTCAudioManager != null ? appRTCAudioManager.getSelectedAudioDevice() : null;
    }

    @NotNull
    public final /* synthetic */ Set<AudioDevice> getAvailableAudioDevices() {
        Object object = this.audioManager;
        if (object == null || (object = ((AppRTCAudioManager)object).getAudioDevices()) == null) {
            boolean bl = false;
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Nullable
    public final /* synthetic */ VideoDevice getCurrentVideoDevice() {
        return this.cameraManager.getCurrentVideoDevice();
    }

    @NotNull
    public final /* synthetic */ List<VideoDevice> getAvailableVideoDevices() {
        return this.cameraManager.getVideoDevices();
    }

    @UiThread
    public final /* synthetic */ boolean selectAudioDevice(@NotNull AudioDevice audioDevice) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)audioDevice), (String)"audioDevice");
        AppRTCAudioManager appRTCAudioManager = this.audioManager;
        if (appRTCAudioManager != null) {
            AppRTCAudioManager appRTCAudioManager2 = appRTCAudioManager;
            boolean bl = false;
            boolean bl2 = false;
            AppRTCAudioManager it = appRTCAudioManager2;
            boolean bl3 = false;
            Logger.v("[PeerConnectionClient] selectAudioDevice " + it.getAudioDevices());
            if (audioDevice == AudioDevice.SPEAKERPHONE) {
                it.setDefaultAudioDeviceWithoutUpdate(AudioDevice.SPEAKERPHONE);
            } else {
                it.setDefaultAudioDeviceWithoutUpdate(AudioDevice.EARPIECE);
            }
            return it.selectAudioDevice(audioDevice);
        }
        return false;
    }

    public final /* synthetic */ void close() {
        this.status = PeerConnectionClientStatus.INACTIVE;
        this.isSwappedFeeds = false;
        this.localProxyVideoSink.setTarget(null);
        this.remoteProxyVideoSink.setTarget(null);
        SendBirdVideoView sendBirdVideoView = this.localVideoView;
        if (sendBirdVideoView != null) {
            sendBirdVideoView.release();
        }
        this.localVideoView = null;
        SendBirdVideoView sendBirdVideoView2 = this.remoteVideoView;
        if (sendBirdVideoView2 != null) {
            sendBirdVideoView2.release();
        }
        this.remoteVideoView = null;
        this.stateExecutor.execute(new Runnable(this){
            final /* synthetic */ PeerConnectionClient this$0;

            public final void run() {
                PeerConnectionClient.access$getCurrentState$p(this.this$0).close(this.this$0);
            }
            {
                this.this$0 = peerConnectionClient;
            }
        });
    }

    @UiThread
    public final void stopAudioManager() {
        AppRTCAudioManager appRTCAudioManager = this.audioManager;
        if (appRTCAudioManager != null) {
            appRTCAudioManager.stop();
        }
        this.audioManager = null;
    }

    public final synchronized void changeState$calls_release(@NotNull PeerConnectionState nextState) {
        Intrinsics.checkParameterIsNotNull((Object)nextState, (String)"nextState");
        Logger.d("[PeerConnectionClient] changeState(). " + this.currentState.getStateName() + " => " + nextState.getStateName());
        if (Intrinsics.areEqual((Object)this.currentState.getStateName(), (Object)nextState.getStateName())) {
            return;
        }
        this.currentState.onDestroy(this);
        this.currentState = nextState;
        this.currentState.onCreate(this);
    }

    public final boolean isRestarting$calls_release() {
        return this.currentState instanceof PeerConnectionIceRestartOfferingState || this.currentState instanceof PeerConnectionIceRestartAnsweringState || this.currentState instanceof PeerConnectionReconnectingState;
    }

    private final void setSwappedFeeds(boolean isSwappedFeeds) {
        SendBirdVideoView it;
        boolean bl;
        boolean bl2;
        SendBirdVideoView sendBirdVideoView;
        this.isSwappedFeeds = isSwappedFeeds;
        SendBirdVideoView sendBirdVideoView2 = this.localVideoView;
        if (sendBirdVideoView2 != null) {
            sendBirdVideoView = sendBirdVideoView2;
            bl2 = false;
            bl = false;
            it = sendBirdVideoView;
            boolean bl3 = false;
            this.setMirror(it, !isSwappedFeeds);
        }
        SendBirdVideoView sendBirdVideoView3 = this.remoteVideoView;
        if (sendBirdVideoView3 != null) {
            sendBirdVideoView = sendBirdVideoView3;
            bl2 = false;
            bl = false;
            it = sendBirdVideoView;
            boolean bl4 = false;
            this.setMirror(it, isSwappedFeeds);
        }
        this.localProxyVideoSink.setTarget(isSwappedFeeds ? this.remoteVideoView : this.localVideoView);
        this.remoteProxyVideoSink.setTarget(isSwappedFeeds ? this.localVideoView : this.remoteVideoView);
    }

    private final void setMirror(SendBirdVideoView videoView, boolean tryToMirror) {
        block0: {
            Boolean isFrontCamera = this.cameraManager.isFrontCamera();
            boolean doMirror = tryToMirror && isFrontCamera != null && isFrontCamera != false;
            Logger.v("[PeerConnectionClient] setMirror(mirror: " + doMirror + ") => isFrontCamera: " + isFrontCamera);
            SendBirdVideoView sendBirdVideoView = videoView;
            if (sendBirdVideoView == null) break block0;
            sendBirdVideoView.setMirror(doMirror);
        }
    }

    public final /* synthetic */ void setCustomVideoCapturer(@Nullable VideoCapturer videoCapturer) {
        this.peerConnection.setVideoCapturer(videoCapturer);
    }

    public final boolean isInitiator$calls_release() {
        return this.isInitiator;
    }

    @NotNull
    public final PeerConnectionClientStatus getStatus$calls_release() {
        return this.status;
    }

    public final void setStatus$calls_release(@NotNull PeerConnectionClientStatus peerConnectionClientStatus) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)peerConnectionClientStatus), (String)"<set-?>");
        this.status = peerConnectionClientStatus;
    }

    @Nullable
    public final String getPeerConnectionId$calls_release() {
        return this.peerConnectionId;
    }

    public PeerConnectionClient(@NotNull Context context, boolean isVideoCall, boolean isInitiator, @NotNull PeerConnectionClientStatus status, @Nullable String peerConnectionId, @Nullable EglBase sharedEglBase, boolean isIceServerRequired) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        this.context = context;
        this.isVideoCall = isVideoCall;
        this.isInitiator = isInitiator;
        this.status = status;
        this.peerConnectionId = peerConnectionId;
        this.isIceServerRequired = isIceServerRequired;
        this.eglBase = sharedEglBase == null ? EglBase.create() : EglBase.create(sharedEglBase.getEglBaseContext());
        PeerConnectionClient peerConnectionClient = this;
        boolean bl = false;
        peerConnectionClient.signalingQueue = list = (List)new ArrayList();
        this.currentState = new PeerConnectionIdleState();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
        this.stateExecutor = executorService;
        this.peerConnectionEventsImpl = new PeerConnectionEventsImpl();
        this.remoteProxyVideoSink = new ProxyVideoSink(true);
        this.localProxyVideoSink = new ProxyVideoSink(false);
        this.remoteVideoRecordingProxy = new ProxyVideoSink(true);
        this.localVideoRecordingProxy = new ProxyVideoSink(false);
        this.remoteAudioRecordingProxy = new ProxyAudioSamplesReadyCallback(true);
        this.localAudioRecordingProxy = new ProxyAudioSamplesReadyCallback(false);
        this.cameraManager = new CameraManager(this.context);
        VideoCapturer videoCapturer = null;
        if (this.isVideoCall) {
            videoCapturer = this.cameraManager.createVideoCapturer(this.context, true);
        }
        EglBase eglBase = this.eglBase;
        Intrinsics.checkExpressionValueIsNotNull((Object)eglBase, (String)"eglBase");
        this.peerConnection = new PeerConnection(this.context, eglBase, this.createPeerConnectionParameter(), CollectionsKt.listOf((Object[])new ProxyVideoSink[]{this.localProxyVideoSink, this.localVideoRecordingProxy}), CollectionsKt.listOf((Object[])new ProxyVideoSink[]{this.remoteProxyVideoSink, this.remoteVideoRecordingProxy}), this.localAudioRecordingProxy, this.remoteAudioRecordingProxy, videoCapturer, this.peerConnectionEventsImpl);
        this.cameraManager.setCameraDisconnectedListener((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.getPeerConnection().setVideoEnabled(false, cameraManager.getCameraState(), false);
                this.getPeerConnection().stopVideoSource();
            }
        }));
        this.setSwappedFeeds(false);
    }

    public /* synthetic */ PeerConnectionClient(Context context, boolean bl, boolean bl2, PeerConnectionClientStatus peerConnectionClientStatus, String string, EglBase eglBase, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            eglBase = null;
        }
        if ((n & 0x40) != 0) {
            bl3 = true;
        }
        this(context, bl, bl2, peerConnectionClientStatus, string, eglBase, bl3);
    }

    public static final /* synthetic */ PeerConnectionState access$getCurrentState$p(PeerConnectionClient $this) {
        return $this.currentState;
    }

    public static final /* synthetic */ void access$setCurrentState$p(PeerConnectionClient $this, PeerConnectionState peerConnectionState) {
        $this.currentState = peerConnectionState;
    }

    public static final /* synthetic */ void access$setMirror(PeerConnectionClient $this, SendBirdVideoView videoView, boolean tryToMirror) {
        $this.setMirror(videoView, tryToMirror);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/sendbird/calls/internal/pc/PeerConnectionClient$ProxyVideoSink;", "Lorg/webrtc/VideoSink;", "isRemote", "", "(Z)V", "isFirstFrameReceived", "()Z", "target", "whRatio", "", "getWhRatio$calls_release", "()Ljava/lang/Double;", "setWhRatio$calls_release", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "onFrame", "", "frame", "Lorg/webrtc/VideoFrame;", "setTarget", "calls_release"})
    private static final class ProxyVideoSink
    implements VideoSink {
        private boolean isFirstFrameReceived;
        private VideoSink target;
        @Nullable
        private Double whRatio;
        private final boolean isRemote;

        @Nullable
        public final Double getWhRatio$calls_release() {
            return this.whRatio;
        }

        public final void setWhRatio$calls_release(@Nullable Double d) {
            this.whRatio = d;
        }

        @Override
        public synchronized void onFrame(@NotNull VideoFrame frame) {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
                if (this.whRatio == null) {
                    this.whRatio = (double)frame.getRotatedWidth() / (double)frame.getRotatedHeight();
                }
                if (this.isRemote && !this.isFirstFrameReceived) {
                    Logger.d("[PeerConnectionClient] first remote video frame received.");
                    this.isFirstFrameReceived = true;
                }
                VideoSink videoSink = this.target;
                if (videoSink == null) break block2;
                videoSink.onFrame(frame);
            }
        }

        public final synchronized void setTarget(@Nullable VideoSink target) {
            this.target = target;
        }

        public final boolean isRemote() {
            return this.isRemote;
        }

        public ProxyVideoSink(boolean isRemote) {
            this.isRemote = isRemote;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/sendbird/calls/internal/pc/PeerConnectionClient$ProxyAudioSamplesReadyCallback;", "Lorg/webrtc/audio/JavaAudioDeviceModule$SamplesReadyCallback;", "isRemote", "", "(Z)V", "isFirstPacketReceived", "()Z", "target", "onWebRtcAudioRecordSamplesReady", "", "samples", "Lorg/webrtc/audio/JavaAudioDeviceModule$AudioSamples;", "setTarget", "calls_release"})
    private static final class ProxyAudioSamplesReadyCallback
    implements JavaAudioDeviceModule.SamplesReadyCallback {
        private JavaAudioDeviceModule.SamplesReadyCallback target;
        private boolean isFirstPacketReceived;
        private final boolean isRemote;

        @Override
        public synchronized void onWebRtcAudioRecordSamplesReady(@Nullable JavaAudioDeviceModule.AudioSamples samples) {
            block1: {
                if (this.isRemote && !this.isFirstPacketReceived) {
                    Logger.d("[PeerConnectionClient] first remote audio packet received.");
                    this.isFirstPacketReceived = true;
                }
                JavaAudioDeviceModule.SamplesReadyCallback samplesReadyCallback = this.target;
                if (samplesReadyCallback == null) break block1;
                samplesReadyCallback.onWebRtcAudioRecordSamplesReady(samples);
            }
        }

        public final synchronized void setTarget(@Nullable JavaAudioDeviceModule.SamplesReadyCallback target) {
            this.target = target;
        }

        public final boolean isRemote() {
            return this.isRemote;
        }

        public ProxyAudioSamplesReadyCallback(boolean isRemote) {
            this.isRemote = isRemote;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u001b\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u001a\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001b\u0010\u001c\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\fH\u0016\u00a2\u0006\u0002\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/sendbird/calls/internal/pc/PeerConnectionClient$PeerConnectionEventsImpl;", "Lcom/sendbird/calls/internal/pc/PeerConnectionEvents;", "(Lcom/sendbird/calls/internal/pc/PeerConnectionClient;)V", "onConnected", "", "onDisconnected", "onFailed", "onIceCandidate", "candidate", "Lorg/webrtc/IceCandidate;", "onIceCandidatesRemoved", "candidates", "", "([Lorg/webrtc/IceCandidate;)V", "onIceConnected", "onIceDisconnected", "onIceFailed", "onLocalDescription", "isInitiator", "", "sdp", "Lorg/webrtc/SessionDescription;", "onLocalVideoSettingsChanged", "onPeerConnectionAudioError", "description", "", "onPeerConnectionClosed", "onPeerConnectionError", "onPeerConnectionStatsReady", "reports", "Lorg/webrtc/StatsReport;", "([Lorg/webrtc/StatsReport;)V", "calls_release"})
    public final class PeerConnectionEventsImpl
    implements PeerConnectionEvents {
        @Override
        public void onLocalDescription(boolean isInitiator, @Nullable SessionDescription sdp) {
            block1: {
                Logger.d("[PeerConnectionClient] onLocalDescription(isInitiator: " + isInitiator + ", sdp: " + sdp + ')');
                SessionDescription sessionDescription = sdp;
                if (sessionDescription == null) break block1;
                SessionDescription sessionDescription2 = sessionDescription;
                boolean bl = false;
                boolean bl2 = false;
                SessionDescription it = sessionDescription2;
                boolean bl3 = false;
                PeerConnectionClientEvent peerConnectionClientEvent = PeerConnectionClient.this.getPeerConnectionClientEvent$calls_release();
                if (peerConnectionClientEvent != null) {
                    peerConnectionClientEvent.onLocalDescription(isInitiator, it);
                }
            }
        }

        @Override
        public void onIceCandidate(@NotNull IceCandidate candidate) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)candidate, (String)"candidate");
                Logger.d("[PeerConnectionClient] onIceCandidate(candidate: " + candidate + ')');
                PeerConnectionClientEvent peerConnectionClientEvent = PeerConnectionClient.this.getPeerConnectionClientEvent$calls_release();
                if (peerConnectionClientEvent == null) break block0;
                peerConnectionClientEvent.onIceCandidate(candidate);
            }
        }

        @Override
        public void onIceCandidatesRemoved(@NotNull IceCandidate[] candidates) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)candidates, (String)"candidates");
                Logger.d("[PeerConnectionClient] onIceCandidatesRemoved(candidate: " + candidates + ')');
                PeerConnectionClientEvent peerConnectionClientEvent = PeerConnectionClient.this.getPeerConnectionClientEvent$calls_release();
                if (peerConnectionClientEvent == null) break block0;
                peerConnectionClientEvent.onIceCandidatesRemoved(candidates);
            }
        }

        @Override
        public void onIceConnected() {
            Logger.d("[PeerConnectionClient] onIceConnected()");
            PeerConnectionClient.this.stateExecutor.execute(new Runnable(this){
                final /* synthetic */ PeerConnectionEventsImpl this$0;

                public final void run() {
                    PeerConnectionClient.access$getCurrentState$p(this.this$0.PeerConnectionClient.this).onIceConnected(this.this$0.PeerConnectionClient.this);
                }
                {
                    this.this$0 = peerConnectionEventsImpl;
                }
            });
        }

        @Override
        public void onIceDisconnected() {
            Logger.d("[PeerConnectionClient] onIceDisconnected()");
            PeerConnectionClient.this.stateExecutor.execute(new Runnable(this){
                final /* synthetic */ PeerConnectionEventsImpl this$0;

                public final void run() {
                    PeerConnectionClient.access$getCurrentState$p(this.this$0.PeerConnectionClient.this).onIceDisconnected(this.this$0.PeerConnectionClient.this);
                }
                {
                    this.this$0 = peerConnectionEventsImpl;
                }
            });
        }

        @Override
        public void onIceFailed() {
            Logger.d("[PeerConnectionClient] onIceFailed()");
            PeerConnectionClient.this.stateExecutor.execute(new Runnable(this){
                final /* synthetic */ PeerConnectionEventsImpl this$0;

                public final void run() {
                    PeerConnectionClient.access$getCurrentState$p(this.this$0.PeerConnectionClient.this).onIceFailed(this.this$0.PeerConnectionClient.this);
                }
                {
                    this.this$0 = peerConnectionEventsImpl;
                }
            });
        }

        @Override
        public void onConnected() {
            Logger.d("[PeerConnectionClient] onConnected()");
        }

        @Override
        public void onDisconnected() {
            Logger.d("[PeerConnectionClient] onDisconnected()");
        }

        @Override
        public void onFailed() {
            Logger.d("[PeerConnectionClient] onFailed()");
        }

        @Override
        public void onPeerConnectionClosed() {
            Logger.d("[PeerConnectionClient] onPeerConnectionClosed()");
            PeerConnectionClient.this.stateExecutor.execute(new Runnable(this){
                final /* synthetic */ PeerConnectionEventsImpl this$0;

                public final void run() {
                    PeerConnectionClient.access$getCurrentState$p(this.this$0.PeerConnectionClient.this).onPeerConnectionClosed(this.this$0.PeerConnectionClient.this);
                }
                {
                    this.this$0 = peerConnectionEventsImpl;
                }
            });
        }

        @Override
        public void onPeerConnectionStatsReady(@NotNull StatsReport[] reports) {
            Intrinsics.checkParameterIsNotNull((Object)reports, (String)"reports");
            Logger.d("[PeerConnectionClient] onPeerConnectionStatsReady(reports: " + reports + ')');
        }

        @Override
        public void onPeerConnectionError(@NotNull String description) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
                Logger.d("[PeerConnectionClient] onPeerConnectionError(description: " + description + ')');
                PeerConnectionClientEvent peerConnectionClientEvent = PeerConnectionClient.this.getPeerConnectionClientEvent$calls_release();
                if (peerConnectionClientEvent == null) break block0;
                peerConnectionClientEvent.onPeerConnectionError(description);
            }
        }

        @Override
        public void onPeerConnectionAudioError(@NotNull String description) {
            Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
            Logger.d("[PeerConnectionClient] onPeerConnectionAudioError(description: " + description + ')');
        }

        @Override
        public void onLocalVideoSettingsChanged() {
            block0: {
                Logger.d("[PeerConnectionClient] onLocalVideoSettingsChanged()");
                PeerConnectionClientEvent peerConnectionClientEvent = PeerConnectionClient.this.getPeerConnectionClientEvent$calls_release();
                if (peerConnectionClientEvent == null) break block0;
                peerConnectionClientEvent.onLocalVideoSettingsChanged();
            }
        }
    }
}

