/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.pc;

import android.content.Context;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.internal.model.TransportPolicy;
import com.sendbird.calls.internal.pc.CameraManager;
import com.sendbird.calls.internal.pc.PeerConnection$PCObserver$WhenMappings;
import com.sendbird.calls.internal.pc.PeerConnectionEvents;
import com.sendbird.calls.internal.pc.PeerConnectionKt;
import com.sendbird.calls.internal.pc.PeerConnectionParameters;
import com.sendbird.calls.internal.util.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.DataChannel;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RTCStatsCollectorCallback;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;
import org.webrtc.RtpTransceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSink;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002z{B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u000207J\u0006\u0010K\u001a\u00020IJ\b\u0010L\u001a\u00020IH\u0002J\u0006\u0010M\u001a\u00020IJ\n\u0010N\u001a\u0004\u0018\u00010(H\u0002J\b\u0010O\u001a\u00020PH\u0002J\u000e\u0010Q\u001a\u00020I2\u0006\u0010R\u001a\u00020\u001cJ\u001e\u0010S\u001a\u00020T2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020V0\t2\u0006\u0010W\u001a\u00020XH\u0002J\b\u0010Y\u001a\u00020ZH\u0002J\b\u0010[\u001a\u00020\\H\u0002J\n\u0010]\u001a\u0004\u0018\u00010.H\u0002J\b\u0010^\u001a\u00020IH\u0002J\n\u0010_\u001a\u0004\u0018\u00010,H\u0002J\b\u0010`\u001a\u00020aH\u0002J\n\u0010b\u001a\u0004\u0018\u00010.H\u0002J\u0010\u0010c\u001a\u00020I2\b\u0010d\u001a\u0004\u0018\u00010eJ\u0019\u0010f\u001a\u00020I2\f\u0010g\u001a\b\u0012\u0004\u0012\u0002070h\u00a2\u0006\u0002\u0010iJ\u0018\u0010j\u001a\u00020I2\u0006\u0010k\u001a\u00020l2\u0006\u0010m\u001a\u00020\u001cH\u0002J\u000e\u0010n\u001a\u00020\u001c2\u0006\u0010o\u001a\u00020\u001cJ\u001c\u0010p\u001a\u00020I2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020V0\t2\u0006\u0010W\u001a\u00020XJ\u000e\u0010q\u001a\u00020I2\u0006\u0010r\u001a\u00020*J\u001e\u0010s\u001a\u00020I2\u0006\u0010G\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\u0006\u0010B\u001a\u00020CJ\u001e\u0010t\u001a\u00020I2\u0006\u0010o\u001a\u00020\u001c2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020\u001cJ\u0006\u0010x\u001a\u00020IJ\u0006\u0010y\u001a\u00020IR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\"\u001a\u00020\u001c8F\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R \u0010%\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R \u0010&\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010#R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u001cX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00101\u001a\u000602R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00105\u001a\n\u0012\u0004\u0012\u000207\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00109\u001a\u00060:R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010=\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u000e\u0010B\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u0004\u0018\u00010FX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lcom/sendbird/calls/internal/pc/PeerConnection;", "", "appContext", "Landroid/content/Context;", "eglBase", "Lorg/webrtc/EglBase;", "peerConnectionParameters", "Lcom/sendbird/calls/internal/pc/PeerConnectionParameters;", "localVideoSinks", "", "Lorg/webrtc/VideoSink;", "remoteVideoSinks", "localSamplesReadyCallback", "Lorg/webrtc/audio/JavaAudioDeviceModule$SamplesReadyCallback;", "remoteSamplesReadyCallback", "videoCapturer", "Lorg/webrtc/VideoCapturer;", "events", "Lcom/sendbird/calls/internal/pc/PeerConnectionEvents;", "(Landroid/content/Context;Lorg/webrtc/EglBase;Lcom/sendbird/calls/internal/pc/PeerConnectionParameters;Ljava/util/List;Ljava/util/List;Lorg/webrtc/audio/JavaAudioDeviceModule$SamplesReadyCallback;Lorg/webrtc/audio/JavaAudioDeviceModule$SamplesReadyCallback;Lorg/webrtc/VideoCapturer;Lcom/sendbird/calls/internal/pc/PeerConnectionEvents;)V", "audioSource", "Lorg/webrtc/AudioSource;", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "factory", "Lorg/webrtc/PeerConnectionFactory;", "isAudioEnabled", "", "isClosed", "isErrorOccurred", "isIceRestarting", "isInitiator", "isPreferIsac", "isVideoCall", "()Z", "<set-?>", "isVideoCapturerStopped", "isVideoEnabled", "localAudioTrack", "Lorg/webrtc/AudioTrack;", "localSdp", "Lorg/webrtc/SessionDescription;", "localVideoSender", "Lorg/webrtc/RtpSender;", "localVideoTrack", "Lorg/webrtc/VideoTrack;", "mIsSwitchingCamera", "mIsSwitchingCameraObject", "pcObserver", "Lcom/sendbird/calls/internal/pc/PeerConnection$PCObserver;", "peerConnection", "Lorg/webrtc/PeerConnection;", "queuedRemoteCandidates", "", "Lorg/webrtc/IceCandidate;", "remoteVideoTrack", "sdpObserver", "Lcom/sendbird/calls/internal/pc/PeerConnection$SDPObserver;", "surfaceTextureHelper", "Lorg/webrtc/SurfaceTextureHelper;", "value", "getVideoCapturer", "()Lorg/webrtc/VideoCapturer;", "setVideoCapturer", "(Lorg/webrtc/VideoCapturer;)V", "videoFps", "", "videoHeight", "videoSource", "Lorg/webrtc/VideoSource;", "videoWidth", "addRemoteIceCandidate", "", "candidate", "close", "closeInternal", "createAnswer", "createAudioTrack", "createJavaAudioDevice", "Lorg/webrtc/audio/AudioDeviceModule;", "createOffer", "isIceRestart", "createRTCConfiguration", "Lorg/webrtc/PeerConnection$RTCConfiguration;", "iceServers", "Lorg/webrtc/PeerConnection$IceServer;", "transportPolicy", "Lcom/sendbird/calls/internal/model/TransportPolicy;", "createVideoDecoderFactory", "Lorg/webrtc/VideoDecoderFactory;", "createVideoEncoderFactory", "Lorg/webrtc/VideoEncoderFactory;", "createVideoTrack", "drainCandidates", "findVideoSender", "getAudioConstraints", "Lorg/webrtc/MediaConstraints;", "getRemoteVideoTrack", "getStats", "callback", "Lorg/webrtc/RTCStatsCollectorCallback;", "removeRemoteIceCandidates", "candidates", "", "([Lorg/webrtc/IceCandidate;)V", "reportError", "errorMessage", "", "isAudioError", "setAudioEnabled", "enable", "setConfiguration", "setRemoteDescription", "sdp", "setVideoConstraints", "setVideoEnabled", "state", "Lcom/sendbird/calls/internal/pc/CameraManager$CameraState;", "isCallOption", "startVideoSource", "stopVideoSource", "PCObserver", "SDPObserver", "calls_release"})
public final class PeerConnection {
    private final ExecutorService executor;
    private final PCObserver pcObserver;
    private final SDPObserver sdpObserver;
    private boolean isIceRestarting;
    private PeerConnectionFactory factory;
    private org.webrtc.PeerConnection peerConnection;
    private AudioSource audioSource;
    private SurfaceTextureHelper surfaceTextureHelper;
    private VideoSource videoSource;
    private boolean isPreferIsac;
    private boolean isVideoCapturerStopped;
    private boolean isErrorOccurred;
    private final boolean isVideoCall;
    private int videoWidth;
    private int videoHeight;
    private int videoFps;
    private List<IceCandidate> queuedRemoteCandidates;
    private boolean isInitiator;
    private SessionDescription localSdp;
    private boolean isVideoEnabled;
    private VideoTrack localVideoTrack;
    private VideoTrack remoteVideoTrack;
    private RtpSender localVideoSender;
    private boolean isAudioEnabled;
    private AudioTrack localAudioTrack;
    private boolean isClosed;
    private final Object mIsSwitchingCameraObject;
    private final boolean mIsSwitchingCamera = false;
    @Nullable
    private VideoCapturer videoCapturer;
    private final Context appContext;
    private final EglBase eglBase;
    private final PeerConnectionParameters peerConnectionParameters;
    private final List<VideoSink> localVideoSinks;
    private final List<VideoSink> remoteVideoSinks;
    private final JavaAudioDeviceModule.SamplesReadyCallback localSamplesReadyCallback;
    private final JavaAudioDeviceModule.SamplesReadyCallback remoteSamplesReadyCallback;
    private final PeerConnectionEvents events;

    public final /* synthetic */ boolean isVideoCapturerStopped() {
        return this.isVideoCapturerStopped;
    }

    public final /* synthetic */ boolean isVideoCall() {
        return this.isVideoCall;
    }

    public final /* synthetic */ boolean isVideoEnabled() {
        return this.isVideoEnabled;
    }

    @Nullable
    public final /* synthetic */ VideoCapturer getVideoCapturer() {
        return this.videoCapturer;
    }

    public final /* synthetic */ void setVideoCapturer(@Nullable VideoCapturer value) {
        Logger.d("[PeerConnection] setVideoCapturer()");
        if (this.isVideoCall) {
            org.webrtc.PeerConnection peerConnection = this.peerConnection;
            if (peerConnection != null) {
                peerConnection.removeTrack(this.localVideoSender);
            }
            try {
                VideoCapturer videoCapturer = this.videoCapturer;
                if (videoCapturer != null) {
                    videoCapturer.stopCapture();
                }
            }
            catch (InterruptedException e) {
                throw (Throwable)new RuntimeException(e);
            }
            VideoCapturer videoCapturer = this.videoCapturer;
            if (videoCapturer != null) {
                videoCapturer.dispose();
            }
            this.videoCapturer = value;
            List mediaStreamLabels = CollectionsKt.listOf((Object)"ARDAMS");
            org.webrtc.PeerConnection peerConnection2 = this.peerConnection;
            if (peerConnection2 != null) {
                peerConnection2.addTrack(this.createVideoTrack(), mediaStreamLabels);
            }
            if (!this.isVideoCapturerStopped) {
                this.stopVideoSource();
                this.startVideoSource();
            }
        }
    }

    public final /* synthetic */ void setConfiguration(@NotNull List<? extends PeerConnection.IceServer> iceServers, @NotNull TransportPolicy transportPolicy) {
        block0: {
            Intrinsics.checkParameterIsNotNull(iceServers, (String)"iceServers");
            Intrinsics.checkParameterIsNotNull((Object)((Object)transportPolicy), (String)"transportPolicy");
            org.webrtc.PeerConnection peerConnection = this.peerConnection;
            if (peerConnection == null) break block0;
            peerConnection.setConfiguration(this.createRTCConfiguration(iceServers, transportPolicy));
        }
    }

    public final /* synthetic */ boolean setAudioEnabled(boolean enable) {
        if (this.peerConnection == null) {
            return false;
        }
        this.executor.execute(new Runnable(this, enable){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ boolean $enable;

            public final void run() {
                block1: {
                    if (PeerConnection.access$isAudioEnabled$p(this.this$0) == this.$enable) break block1;
                    PeerConnection.access$setAudioEnabled$p(this.this$0, this.$enable);
                    AudioTrack audioTrack = PeerConnection.access$getLocalAudioTrack$p(this.this$0);
                    if (audioTrack != null) {
                        audioTrack.setEnabled(PeerConnection.access$isAudioEnabled$p(this.this$0));
                    }
                }
            }
            {
                this.this$0 = peerConnection;
                this.$enable = bl;
            }
        });
        return true;
    }

    public final /* synthetic */ void setVideoEnabled(boolean enable, @NotNull CameraManager.CameraState state, boolean isCallOption) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        if (this.peerConnection == null) {
            return;
        }
        this.executor.execute(new Runnable(this, enable, state, isCallOption){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ boolean $enable;
            final /* synthetic */ CameraManager.CameraState $state;
            final /* synthetic */ boolean $isCallOption;

            public final void run() {
                block3: {
                    Boolean isChanged;
                    Logger.v("[_PeerConnectionClient] setVideoEnabled(enable: " + this.$enable + ", state: " + (Object)((Object)this.$state) + ", isCallOption: " + this.$isCallOption + ')');
                    if (this.this$0.isVideoEnabled() == this.$enable) break block3;
                    if (this.$enable && this.$state == CameraManager.CameraState.DISCONNECTED && this.this$0.getVideoCapturer() != null) {
                        this.this$0.startVideoSource();
                    }
                    VideoTrack videoTrack = PeerConnection.access$getLocalVideoTrack$p(this.this$0);
                    Boolean bl = isChanged = videoTrack != null ? Boolean.valueOf(videoTrack.setEnabled(this.$enable)) : null;
                    if (bl != null) {
                        Boolean bl2 = bl;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        boolean it = bl2;
                        boolean bl5 = false;
                        PeerConnection.access$setVideoEnabled$p(this.this$0, it ? this.$enable : this.this$0.isVideoEnabled());
                        if (it && !this.$isCallOption) {
                            PeerConnection.access$getEvents$p(this.this$0).onLocalVideoSettingsChanged();
                        }
                    }
                }
            }
            {
                this.this$0 = peerConnection;
                this.$enable = bl;
                this.$state = cameraState;
                this.$isCallOption = bl2;
            }
        });
    }

    public final /* synthetic */ void startVideoSource() {
        this.executor.execute(new Runnable(this){
            final /* synthetic */ PeerConnection this$0;

            public final void run() {
                block1: {
                    Logger.v("[_PeerConnectionClient] startVideoSource() videoCapturer: " + this.this$0.getVideoCapturer() + ", videoCapturerStopped: " + this.this$0.isVideoCapturerStopped());
                    if (!this.this$0.isVideoCapturerStopped()) break block1;
                    VideoCapturer videoCapturer = this.this$0.getVideoCapturer();
                    if (videoCapturer != null) {
                        VideoCapturer videoCapturer2 = videoCapturer;
                        boolean bl = false;
                        boolean bl2 = false;
                        VideoCapturer it = videoCapturer2;
                        boolean bl3 = false;
                        it.startCapture(PeerConnection.access$getVideoWidth$p(this.this$0), PeerConnection.access$getVideoHeight$p(this.this$0), PeerConnection.access$getVideoFps$p(this.this$0));
                        PeerConnection.access$setVideoCapturerStopped$p(this.this$0, false);
                    }
                }
            }
            {
                this.this$0 = peerConnection;
            }
        });
    }

    public final /* synthetic */ void stopVideoSource() {
        this.executor.execute(new Runnable(this){
            final /* synthetic */ PeerConnection this$0;

            public final void run() {
                block3: {
                    Logger.v("[_PeerConnectionClient] stopVideoSource() videoCapturer: " + this.this$0.getVideoCapturer() + ", videoCapturerStopped: " + this.this$0.isVideoCapturerStopped());
                    if (this.this$0.isVideoCapturerStopped()) break block3;
                    VideoCapturer videoCapturer = this.this$0.getVideoCapturer();
                    if (videoCapturer != null) {
                        VideoCapturer videoCapturer2 = videoCapturer;
                        boolean bl = false;
                        boolean bl2 = false;
                        VideoCapturer it = videoCapturer2;
                        boolean bl3 = false;
                        try {
                            it.stopCapture();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        PeerConnection.access$setVideoCapturerStopped$p(this.this$0, true);
                    }
                }
            }
            {
                this.this$0 = peerConnection;
            }
        });
    }

    public final /* synthetic */ void setVideoConstraints(int videoWidth, int videoHeight, int videoFps) {
        if (this.isVideoCall) {
            this.videoWidth = videoWidth;
            this.videoHeight = videoHeight;
            this.videoFps = videoFps;
            if (this.videoWidth == 0 || this.videoHeight == 0) {
                this.videoWidth = PeerConnectionKt.getHD_VIDEO_WIDTH();
                this.videoHeight = PeerConnectionKt.getHD_VIDEO_HEIGHT();
            }
            if (this.videoFps == 0) {
                this.videoFps = 24;
            }
            if (!this.isVideoCapturerStopped) {
                this.stopVideoSource();
                this.startVideoSource();
            }
        }
    }

    public final /* synthetic */ void createOffer(boolean isIceRestart) {
        this.executor.execute(new Runnable(this, isIceRestart){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ boolean $isIceRestart;

            public final void run() {
                block2: {
                    if (PeerConnection.access$isErrorOccurred$p(this.this$0)) break block2;
                    PeerConnection.access$setIceRestarting$p(this.this$0, this.$isIceRestart);
                    if (this.$isIceRestart) {
                        PeerConnection.access$setLocalSdp$p(this.this$0, null);
                    }
                    PeerConnection.access$setInitiator$p(this.this$0, true);
                    org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0);
                    if (peerConnection != null) {
                        peerConnection.createOffer(PeerConnection.access$getSdpObserver$p(this.this$0), PeerConnectionKt.access$getMediaConstraints(this.$isIceRestart, this.this$0.isVideoCall()));
                    }
                }
            }
            {
                this.this$0 = peerConnection;
                this.$isIceRestart = bl;
            }
        });
    }

    public final /* synthetic */ void createAnswer() {
        this.executor.execute(new Runnable(this){
            final /* synthetic */ PeerConnection this$0;

            public final void run() {
                block1: {
                    if (PeerConnection.access$isErrorOccurred$p(this.this$0)) break block1;
                    PeerConnection.access$setInitiator$p(this.this$0, false);
                    org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0);
                    if (peerConnection != null) {
                        peerConnection.createAnswer(PeerConnection.access$getSdpObserver$p(this.this$0), PeerConnectionKt.access$getMediaConstraints(false, this.this$0.isVideoCall()));
                    }
                }
            }
            {
                this.this$0 = peerConnection;
            }
        });
    }

    public final /* synthetic */ void setRemoteDescription(@NotNull SessionDescription sdp) {
        Intrinsics.checkParameterIsNotNull((Object)sdp, (String)"sdp");
        this.executor.execute(new Runnable(this, sdp){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ SessionDescription $sdp;

            public final void run() {
                block3: {
                    if (PeerConnection.access$getPeerConnection$p(this.this$0) == null || PeerConnection.access$isErrorOccurred$p(this.this$0)) {
                        return;
                    }
                    String sdpDescription = this.$sdp.description;
                    if (PeerConnection.access$isPreferIsac$p(this.this$0)) {
                        String string = sdpDescription;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdpDescription");
                        sdpDescription = PeerConnectionKt.access$preferCodec(string, "ISAC", true);
                    }
                    if (this.this$0.isVideoCall()) {
                        String string = sdpDescription;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdpDescription");
                        sdpDescription = PeerConnectionKt.access$preferCodec(string, PeerConnectionKt.access$getSdpVideoCodecName(PeerConnection.access$getPeerConnectionParameters$p(this.this$0)), false);
                    }
                    SessionDescription.Type type = this.$sdp.type;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)type), (String)"sdp.type");
                    String string = sdpDescription;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdpDescription");
                    SessionDescription sdpRemote = PeerConnectionKt.access$createSessionDescription(type, string);
                    org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0);
                    if (peerConnection == null) break block3;
                    peerConnection.setRemoteDescription(PeerConnection.access$getSdpObserver$p(this.this$0), sdpRemote);
                }
            }
            {
                this.this$0 = peerConnection;
                this.$sdp = sessionDescription;
            }
        });
    }

    public final /* synthetic */ void addRemoteIceCandidate(@NotNull IceCandidate candidate) {
        Intrinsics.checkParameterIsNotNull((Object)candidate, (String)"candidate");
        this.executor.execute(new Runnable(this, candidate){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ IceCandidate $candidate;

            public final void run() {
                block0: {
                    block1: {
                        if (PeerConnection.access$isErrorOccurred$p(this.this$0)) break block0;
                        List list = PeerConnection.access$getQueuedRemoteCandidates$p(this.this$0);
                        if (list == null) break block1;
                        list.add(this.$candidate);
                        break block0;
                    }
                    org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0);
                    if (peerConnection == null) break block0;
                    peerConnection.addIceCandidate(this.$candidate);
                }
            }
            {
                this.this$0 = peerConnection;
                this.$candidate = iceCandidate;
            }
        });
    }

    public final /* synthetic */ void removeRemoteIceCandidates(@NotNull IceCandidate[] candidates) {
        Intrinsics.checkParameterIsNotNull((Object)candidates, (String)"candidates");
        this.executor.execute(new Runnable(this, candidates){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ IceCandidate[] $candidates;

            public final void run() {
                block1: {
                    if (PeerConnection.access$isErrorOccurred$p(this.this$0)) break block1;
                    PeerConnection.access$drainCandidates(this.this$0);
                    org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0);
                    if (peerConnection != null) {
                        peerConnection.removeIceCandidates(this.$candidates);
                    }
                }
            }
            {
                this.this$0 = peerConnection;
                this.$candidates = iceCandidateArray;
            }
        });
    }

    public final /* synthetic */ void getStats(@Nullable RTCStatsCollectorCallback callback) {
        if (this.peerConnection == null || this.isErrorOccurred) {
            RTCStatsCollectorCallback rTCStatsCollectorCallback = callback;
            if (rTCStatsCollectorCallback != null) {
                rTCStatsCollectorCallback.onStatsDelivered(null);
            }
            return;
        }
        this.executor.execute(new Runnable(this, callback){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ RTCStatsCollectorCallback $callback;

            public final void run() {
                block0: {
                    org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0);
                    if (peerConnection == null) break block0;
                    peerConnection.getStats(this.$callback);
                }
            }
            {
                this.this$0 = peerConnection;
                this.$callback = rTCStatsCollectorCallback;
            }
        });
    }

    private final AudioTrack createAudioTrack() {
        AudioTrack audioTrack;
        block0: {
            PeerConnectionFactory peerConnectionFactory = this.factory;
            AudioTrack audioTrack2 = audioTrack = peerConnectionFactory != null ? peerConnectionFactory.createAudioTrack("ARDAMSa0", this.audioSource) : null;
            if (audioTrack2 == null) break block0;
            audioTrack2.setEnabled(this.isAudioEnabled);
        }
        return audioTrack;
    }

    private final VideoTrack createVideoTrack() {
        VideoTrack videoTrack;
        boolean isScreenCast;
        VideoCapturer videoCapturer = this.videoCapturer;
        boolean bl = isScreenCast = videoCapturer != null ? videoCapturer.isScreencast() : false;
        if (this.videoCapturer == null) {
            PeerConnectionFactory peerConnectionFactory = this.factory;
            this.videoSource = peerConnectionFactory != null ? peerConnectionFactory.createVideoSource(isScreenCast) : null;
        } else {
            PeerConnectionFactory peerConnectionFactory = this.factory;
            this.videoSource = peerConnectionFactory != null ? peerConnectionFactory.createVideoSource(isScreenCast) : null;
            this.surfaceTextureHelper = SurfaceTextureHelper.create("CaptureThread", this.eglBase.getEglBaseContext());
            VideoCapturer videoCapturer2 = this.videoCapturer;
            if (videoCapturer2 != null) {
                VideoSource videoSource = this.videoSource;
                videoCapturer2.initialize(this.surfaceTextureHelper, this.appContext, videoSource != null ? videoSource.getCapturerObserver() : null);
            }
        }
        PeerConnectionFactory peerConnectionFactory = this.factory;
        VideoTrack videoTrack2 = videoTrack = peerConnectionFactory != null ? peerConnectionFactory.createVideoTrack("ARDAMSv0", this.videoSource) : null;
        if (videoTrack2 != null) {
            videoTrack2.setEnabled(this.isVideoEnabled);
        }
        for (VideoSink localVideoSink2 : this.localVideoSinks) {
            VideoTrack videoTrack3 = videoTrack;
            if (videoTrack3 == null) continue;
            videoTrack3.addSink(localVideoSink2);
        }
        return videoTrack;
    }

    private final VideoTrack getRemoteVideoTrack() {
        org.webrtc.PeerConnection peerConnection = this.peerConnection;
        if (peerConnection != null) {
            org.webrtc.PeerConnection peerConnection2 = peerConnection;
            boolean bl = false;
            boolean bl2 = false;
            org.webrtc.PeerConnection pc = peerConnection2;
            boolean bl3 = false;
            Iterator<RtpTransceiver> iterator = pc.getTransceivers().iterator();
            while (iterator.hasNext()) {
                RtpTransceiver transceiver;
                RtpTransceiver rtpTransceiver = transceiver = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)rtpTransceiver, (String)"transceiver");
                MediaStreamTrack track = rtpTransceiver.getReceiver().track();
                if (!(track instanceof VideoTrack)) continue;
                return (VideoTrack)track;
            }
        }
        return null;
    }

    private final VideoEncoderFactory createVideoEncoderFactory() {
        boolean enableH264HighProfile = Intrinsics.areEqual((Object)"H264 High", (Object)this.peerConnectionParameters.getVideoCodec());
        return this.peerConnectionParameters.getVideoCodecHwAcceleration() ? (VideoEncoderFactory)new DefaultVideoEncoderFactory(this.eglBase.getEglBaseContext(), true, enableH264HighProfile) : (VideoEncoderFactory)new SoftwareVideoEncoderFactory();
    }

    private final VideoDecoderFactory createVideoDecoderFactory() {
        return this.peerConnectionParameters.getVideoCodecHwAcceleration() ? (VideoDecoderFactory)new DefaultVideoDecoderFactory(this.eglBase.getEglBaseContext()) : (VideoDecoderFactory)new SoftwareVideoDecoderFactory();
    }

    private final AudioDeviceModule createJavaAudioDevice() {
        JavaAudioDeviceModule.AudioRecordErrorCallback audioRecordErrorCallback2 = new JavaAudioDeviceModule.AudioRecordErrorCallback(this){
            final /* synthetic */ PeerConnection this$0;

            public void onWebRtcAudioRecordInitError(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PeerConnection.access$reportError(this.this$0, errorMessage, true);
            }

            public void onWebRtcAudioRecordStartError(@NotNull JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, @NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)errorCode), (String)"errorCode");
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PeerConnection.access$reportError(this.this$0, errorMessage, true);
            }

            public void onWebRtcAudioRecordError(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PeerConnection.access$reportError(this.this$0, errorMessage, true);
            }
            {
                this.this$0 = $outer;
            }
        };
        JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback2 = new JavaAudioDeviceModule.AudioTrackErrorCallback(this){
            final /* synthetic */ PeerConnection this$0;

            public void onWebRtcAudioTrackInitError(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PeerConnection.access$reportError(this.this$0, errorMessage, true);
            }

            public void onWebRtcAudioTrackStartError(@NotNull JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, @NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)errorCode), (String)"errorCode");
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PeerConnection.access$reportError(this.this$0, errorMessage, true);
            }

            public void onWebRtcAudioTrackError(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PeerConnection.access$reportError(this.this$0, errorMessage, true);
            }
            {
                this.this$0 = $outer;
            }
        };
        AudioDeviceModule audioDeviceModule = JavaAudioDeviceModule.builder(this.appContext).setUseHardwareAcousticEchoCanceler(!this.peerConnectionParameters.getDisableBuiltInAEC()).setUseHardwareNoiseSuppressor(!this.peerConnectionParameters.getDisableBuiltInNS()).setAudioRecordErrorCallback(audioRecordErrorCallback2).setAudioTrackErrorCallback(audioTrackErrorCallback2).setAudioSource(SendBirdCall.Options.getPreferredAudioSource()).setSamplesReadyCallback(this.localSamplesReadyCallback).setRemoteSamplesReadyCallback(this.remoteSamplesReadyCallback).createAudioDeviceModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)audioDeviceModule, (String)"JavaAudioDeviceModule.bu\u2026createAudioDeviceModule()");
        return audioDeviceModule;
    }

    private final PeerConnection.RTCConfiguration createRTCConfiguration(List<? extends PeerConnection.IceServer> iceServers, TransportPolicy transportPolicy) {
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
        rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.DISABLED;
        rtcConfig.bundlePolicy = PeerConnection.BundlePolicy.MAXBUNDLE;
        rtcConfig.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
        rtcConfig.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_CONTINUALLY;
        rtcConfig.keyType = PeerConnection.KeyType.ECDSA;
        rtcConfig.enableDtlsSrtp = true;
        rtcConfig.sdpSemantics = PeerConnection.SdpSemantics.UNIFIED_PLAN;
        if (transportPolicy == TransportPolicy.ALL) {
            rtcConfig.iceTransportsType = PeerConnection.IceTransportsType.ALL;
        } else if (transportPolicy == TransportPolicy.RELAY) {
            rtcConfig.iceTransportsType = PeerConnection.IceTransportsType.RELAY;
        }
        return rtcConfig;
    }

    private final RtpSender findVideoSender() {
        org.webrtc.PeerConnection peerConnection = this.peerConnection;
        if (peerConnection != null) {
            org.webrtc.PeerConnection peerConnection2 = peerConnection;
            boolean bl = false;
            boolean bl2 = false;
            org.webrtc.PeerConnection pc = peerConnection2;
            boolean bl3 = false;
            for (RtpSender sender : pc.getSenders()) {
                MediaStreamTrack mediaStreamTrack;
                if (sender.track() == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                MediaStreamTrack it = mediaStreamTrack;
                boolean bl6 = false;
                String trackType = it.kind();
                if (!Intrinsics.areEqual((Object)trackType, (Object)"video")) continue;
                return sender;
            }
        }
        return null;
    }

    private final MediaConstraints getAudioConstraints() {
        MediaConstraints audioConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.getNoAudioProcessing()) {
            audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair("googEchoCancellation", "false"));
            audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair("googAutoGainControl", "false"));
            audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair("googHighpassFilter", "false"));
            audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair("googNoiseSuppression", "false"));
        }
        return audioConstraints;
    }

    private final void reportError(String errorMessage, boolean isAudioError) {
        this.executor.execute(new Runnable(this, isAudioError, errorMessage){
            final /* synthetic */ PeerConnection this$0;
            final /* synthetic */ boolean $isAudioError;
            final /* synthetic */ String $errorMessage;

            public final void run() {
                if (this.$isAudioError) {
                    PeerConnection.access$getEvents$p(this.this$0).onPeerConnectionAudioError(this.$errorMessage);
                    return;
                }
                if (!PeerConnection.access$isErrorOccurred$p(this.this$0)) {
                    PeerConnection.access$setErrorOccurred$p(this.this$0, true);
                    PeerConnection.access$getEvents$p(this.this$0).onPeerConnectionError(this.$errorMessage);
                }
            }
            {
                this.this$0 = peerConnection;
                this.$isAudioError = bl;
                this.$errorMessage = string;
            }
        });
    }

    private final void drainCandidates() {
        block1: {
            List<IceCandidate> list = this.queuedRemoteCandidates;
            if (list == null) break block1;
            List<IceCandidate> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<IceCandidate> it = list2;
            boolean bl3 = false;
            for (IceCandidate candidate : it) {
                org.webrtc.PeerConnection peerConnection = this.peerConnection;
                if (peerConnection == null) continue;
                peerConnection.addIceCandidate(candidate);
            }
            this.queuedRemoteCandidates = null;
        }
    }

    public final /* synthetic */ void close() {
        Logger.v("[_PeerConnectionClient] close()");
        this.executor.execute(new Runnable(this){
            final /* synthetic */ PeerConnection this$0;

            public final void run() {
                PeerConnection.access$closeInternal(this.this$0);
            }
            {
                this.this$0 = peerConnection;
            }
        });
    }

    private final void closeInternal() {
        Logger.v("[_PeerConnectionClient] closeInternal()");
        if (this.isClosed) {
            return;
        }
        org.webrtc.PeerConnection peerConnection = this.peerConnection;
        if (peerConnection != null) {
            peerConnection.dispose();
        }
        this.peerConnection = null;
        AudioSource audioSource = this.audioSource;
        if (audioSource != null) {
            audioSource.dispose();
        }
        this.audioSource = null;
        try {
            VideoCapturer videoCapturer = this.videoCapturer;
            if (videoCapturer != null) {
                videoCapturer.stopCapture();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.isVideoCapturerStopped = true;
        VideoCapturer videoCapturer = this.videoCapturer;
        if (videoCapturer != null) {
            videoCapturer.dispose();
        }
        this.setVideoCapturer(null);
        VideoSource videoSource = this.videoSource;
        if (videoSource != null) {
            videoSource.dispose();
        }
        this.videoSource = null;
        SurfaceTextureHelper surfaceTextureHelper = this.surfaceTextureHelper;
        if (surfaceTextureHelper != null) {
            surfaceTextureHelper.dispose();
        }
        this.surfaceTextureHelper = null;
        PeerConnectionFactory peerConnectionFactory = this.factory;
        if (peerConnectionFactory != null) {
            peerConnectionFactory.dispose();
        }
        this.factory = null;
        this.eglBase.release();
        this.events.onPeerConnectionClosed();
        PeerConnectionFactory.stopInternalTracingCapture();
        PeerConnectionFactory.shutdownInternalTracer();
        this.isClosed = true;
        Logger.v("[_PeerConnectionClient] closeInternal() finished.");
    }

    public PeerConnection(@NotNull Context appContext, @NotNull EglBase eglBase, @NotNull PeerConnectionParameters peerConnectionParameters, @NotNull List<? extends VideoSink> localVideoSinks, @NotNull List<? extends VideoSink> remoteVideoSinks, @NotNull JavaAudioDeviceModule.SamplesReadyCallback localSamplesReadyCallback, @NotNull JavaAudioDeviceModule.SamplesReadyCallback remoteSamplesReadyCallback, @Nullable VideoCapturer videoCapturer, @NotNull PeerConnectionEvents events) {
        block6: {
            org.webrtc.PeerConnection peerConnection;
            Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
            Intrinsics.checkParameterIsNotNull((Object)eglBase, (String)"eglBase");
            Intrinsics.checkParameterIsNotNull((Object)peerConnectionParameters, (String)"peerConnectionParameters");
            Intrinsics.checkParameterIsNotNull(localVideoSinks, (String)"localVideoSinks");
            Intrinsics.checkParameterIsNotNull(remoteVideoSinks, (String)"remoteVideoSinks");
            Intrinsics.checkParameterIsNotNull((Object)localSamplesReadyCallback, (String)"localSamplesReadyCallback");
            Intrinsics.checkParameterIsNotNull((Object)remoteSamplesReadyCallback, (String)"remoteSamplesReadyCallback");
            Intrinsics.checkParameterIsNotNull((Object)events, (String)"events");
            this.appContext = appContext;
            this.eglBase = eglBase;
            this.peerConnectionParameters = peerConnectionParameters;
            this.localVideoSinks = localVideoSinks;
            this.remoteVideoSinks = remoteVideoSinks;
            this.localSamplesReadyCallback = localSamplesReadyCallback;
            this.remoteSamplesReadyCallback = remoteSamplesReadyCallback;
            this.events = events;
            this.executor = Executors.newSingleThreadExecutor();
            this.pcObserver = new PCObserver();
            this.sdpObserver = new SDPObserver();
            this.isVideoCapturerStopped = true;
            this.isVideoCall = this.peerConnectionParameters.getVideoCallEnabled();
            this.videoWidth = PeerConnectionKt.getHD_VIDEO_WIDTH();
            this.videoHeight = PeerConnectionKt.getHD_VIDEO_HEIGHT();
            this.videoFps = 24;
            PeerConnection peerConnection2 = this;
            boolean bl = false;
            Object object = new ArrayList();
            peerConnection2.queuedRemoteCandidates = object;
            this.isVideoEnabled = true;
            this.isAudioEnabled = true;
            this.mIsSwitchingCameraObject = new Object();
            this.videoCapturer = videoCapturer;
            this.isPreferIsac = Intrinsics.areEqual((Object)this.peerConnectionParameters.getAudioCodec(), (Object)"ISAC");
            String fieldTrials = PeerConnectionKt.access$getFieldTrials(this.peerConnectionParameters);
            PeerConnectionFactory.initialize(PeerConnectionFactory.InitializationOptions.builder(this.appContext).setFieldTrials(fieldTrials).setEnableInternalTracer(true).createInitializationOptions());
            AudioDeviceModule adm = this.createJavaAudioDevice();
            this.factory = PeerConnectionFactory.builder().setOptions(new PeerConnectionFactory.Options()).setAudioDeviceModule(adm).setVideoEncoderFactory(this.createVideoEncoderFactory()).setVideoDecoderFactory(this.createVideoDecoderFactory()).createPeerConnectionFactory();
            adm.release();
            PeerConnection peerConnection3 = this;
            PeerConnectionFactory peerConnectionFactory = this.factory;
            if (peerConnectionFactory != null) {
                PeerConnection peerConnection4 = this;
                object = peerConnectionFactory;
                peerConnection2 = peerConnection3;
                boolean bl2 = false;
                List list = CollectionsKt.emptyList();
                peerConnection3 = peerConnection2;
                peerConnection = ((PeerConnectionFactory)object).createPeerConnection(peerConnection4.createRTCConfiguration(list, TransportPolicy.ALL), (PeerConnection.Observer)this.pcObserver);
            } else {
                peerConnection = null;
            }
            peerConnection3.peerConnection = peerConnection;
            List mediaStreamLabels = CollectionsKt.listOf((Object)"ARDAMS");
            if (this.isVideoCall) {
                this.localVideoTrack = this.createVideoTrack();
                org.webrtc.PeerConnection peerConnection5 = this.peerConnection;
                if (peerConnection5 != null) {
                    peerConnection5.addTrack(this.localVideoTrack, mediaStreamLabels);
                }
                VideoTrack videoTrack = this.remoteVideoTrack = this.getRemoteVideoTrack();
                if (videoTrack != null) {
                    VideoTrack videoTrack2 = videoTrack;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    VideoTrack it = videoTrack2;
                    boolean bl5 = false;
                    it.setEnabled(this.isVideoEnabled);
                    for (VideoSink remoteVideoSink2 : this.remoteVideoSinks) {
                        it.addSink(remoteVideoSink2);
                    }
                }
                this.localVideoSender = this.findVideoSender();
            }
            PeerConnectionFactory peerConnectionFactory2 = this.factory;
            this.audioSource = peerConnectionFactory2 != null ? peerConnectionFactory2.createAudioSource(this.getAudioConstraints()) : null;
            this.localAudioTrack = this.createAudioTrack();
            org.webrtc.PeerConnection peerConnection6 = this.peerConnection;
            if (peerConnection6 == null) break block6;
            peerConnection6.addTrack(this.localAudioTrack, mediaStreamLabels);
        }
    }

    public static final /* synthetic */ PeerConnectionEvents access$getEvents$p(PeerConnection $this) {
        return $this.events;
    }

    public static final /* synthetic */ void access$setPreferIsac$p(PeerConnection $this, boolean bl) {
        $this.isPreferIsac = bl;
    }

    public static final /* synthetic */ boolean access$isErrorOccurred$p(PeerConnection $this) {
        return $this.isErrorOccurred;
    }

    public static final /* synthetic */ void access$setErrorOccurred$p(PeerConnection $this, boolean bl) {
        $this.isErrorOccurred = bl;
    }

    public static final /* synthetic */ org.webrtc.PeerConnection access$getPeerConnection$p(PeerConnection $this) {
        return $this.peerConnection;
    }

    public static final /* synthetic */ void access$setPeerConnection$p(PeerConnection $this, org.webrtc.PeerConnection peerConnection) {
        $this.peerConnection = peerConnection;
    }

    public static final /* synthetic */ SDPObserver access$getSdpObserver$p(PeerConnection $this) {
        return $this.sdpObserver;
    }

    public static final /* synthetic */ boolean access$isInitiator$p(PeerConnection $this) {
        return $this.isInitiator;
    }

    public static final /* synthetic */ void access$setInitiator$p(PeerConnection $this, boolean bl) {
        $this.isInitiator = bl;
    }

    public static final /* synthetic */ boolean access$isIceRestarting$p(PeerConnection $this) {
        return $this.isIceRestarting;
    }

    public static final /* synthetic */ void access$setIceRestarting$p(PeerConnection $this, boolean bl) {
        $this.isIceRestarting = bl;
    }

    public static final /* synthetic */ void access$drainCandidates(PeerConnection $this) {
        $this.drainCandidates();
    }

    public static final /* synthetic */ boolean access$isAudioEnabled$p(PeerConnection $this) {
        return $this.isAudioEnabled;
    }

    public static final /* synthetic */ void access$setAudioEnabled$p(PeerConnection $this, boolean bl) {
        $this.isAudioEnabled = bl;
    }

    public static final /* synthetic */ AudioTrack access$getLocalAudioTrack$p(PeerConnection $this) {
        return $this.localAudioTrack;
    }

    public static final /* synthetic */ void access$setLocalAudioTrack$p(PeerConnection $this, AudioTrack audioTrack) {
        $this.localAudioTrack = audioTrack;
    }

    public static final /* synthetic */ boolean access$isVideoEnabled$p(PeerConnection $this) {
        return $this.isVideoEnabled;
    }

    public static final /* synthetic */ void access$setVideoEnabled$p(PeerConnection $this, boolean bl) {
        $this.isVideoEnabled = bl;
    }

    public static final /* synthetic */ VideoTrack access$getLocalVideoTrack$p(PeerConnection $this) {
        return $this.localVideoTrack;
    }

    public static final /* synthetic */ void access$setLocalVideoTrack$p(PeerConnection $this, VideoTrack videoTrack) {
        $this.localVideoTrack = videoTrack;
    }

    public static final /* synthetic */ boolean access$isVideoCapturerStopped$p(PeerConnection $this) {
        return $this.isVideoCapturerStopped;
    }

    public static final /* synthetic */ void access$setVideoCapturerStopped$p(PeerConnection $this, boolean bl) {
        $this.isVideoCapturerStopped = bl;
    }

    public static final /* synthetic */ int access$getVideoWidth$p(PeerConnection $this) {
        return $this.videoWidth;
    }

    public static final /* synthetic */ void access$setVideoWidth$p(PeerConnection $this, int n) {
        $this.videoWidth = n;
    }

    public static final /* synthetic */ int access$getVideoHeight$p(PeerConnection $this) {
        return $this.videoHeight;
    }

    public static final /* synthetic */ void access$setVideoHeight$p(PeerConnection $this, int n) {
        $this.videoHeight = n;
    }

    public static final /* synthetic */ int access$getVideoFps$p(PeerConnection $this) {
        return $this.videoFps;
    }

    public static final /* synthetic */ void access$setVideoFps$p(PeerConnection $this, int n) {
        $this.videoFps = n;
    }

    public static final /* synthetic */ List access$getQueuedRemoteCandidates$p(PeerConnection $this) {
        return $this.queuedRemoteCandidates;
    }

    public static final /* synthetic */ void access$setQueuedRemoteCandidates$p(PeerConnection $this, List list) {
        $this.queuedRemoteCandidates = list;
    }

    public static final /* synthetic */ void access$closeInternal(PeerConnection $this) {
        $this.closeInternal();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J#\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001b\u0010\u0016\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010!\u001a\u00020\u0004H\u0016J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020#H\u0016\u00a8\u0006$"}, d2={"Lcom/sendbird/calls/internal/pc/PeerConnection$PCObserver;", "Lorg/webrtc/PeerConnection$Observer;", "(Lcom/sendbird/calls/internal/pc/PeerConnection;)V", "onAddStream", "", "stream", "Lorg/webrtc/MediaStream;", "onAddTrack", "receiver", "Lorg/webrtc/RtpReceiver;", "mediaStreams", "", "(Lorg/webrtc/RtpReceiver;[Lorg/webrtc/MediaStream;)V", "onConnectionChange", "newState", "Lorg/webrtc/PeerConnection$PeerConnectionState;", "onDataChannel", "dc", "Lorg/webrtc/DataChannel;", "onIceCandidate", "candidate", "Lorg/webrtc/IceCandidate;", "onIceCandidatesRemoved", "candidates", "([Lorg/webrtc/IceCandidate;)V", "onIceConnectionChange", "Lorg/webrtc/PeerConnection$IceConnectionState;", "onIceConnectionReceivingChange", "receiving", "", "onIceGatheringChange", "Lorg/webrtc/PeerConnection$IceGatheringState;", "onRemoveStream", "onRenegotiationNeeded", "onSignalingChange", "Lorg/webrtc/PeerConnection$SignalingState;", "calls_release"})
    private final class PCObserver
    implements PeerConnection.Observer {
        @Override
        public void onIceCandidate(@NotNull IceCandidate candidate) {
            Intrinsics.checkParameterIsNotNull((Object)candidate, (String)"candidate");
            Logger.v("[_PeerConnectionClient] PCObserver => onIceCandidate()");
            PeerConnection.this.executor.execute(new Runnable(this, candidate){
                final /* synthetic */ PCObserver this$0;
                final /* synthetic */ IceCandidate $candidate;

                public final void run() {
                    PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onIceCandidate(this.$candidate);
                }
                {
                    this.this$0 = pCObserver;
                    this.$candidate = iceCandidate;
                }
            });
        }

        @Override
        public void onIceCandidatesRemoved(@NotNull IceCandidate[] candidates) {
            Intrinsics.checkParameterIsNotNull((Object)candidates, (String)"candidates");
            Logger.v("[_PeerConnectionClient] PCObserver => onIceCandidatesRemoved() => candidates: " + candidates.length);
            PeerConnection.this.executor.execute(new Runnable(this, candidates){
                final /* synthetic */ PCObserver this$0;
                final /* synthetic */ IceCandidate[] $candidates;

                public final void run() {
                    PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onIceCandidatesRemoved(this.$candidates);
                }
                {
                    this.this$0 = pCObserver;
                    this.$candidates = iceCandidateArray;
                }
            });
        }

        @Override
        public void onSignalingChange(@NotNull PeerConnection.SignalingState newState) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)newState), (String)"newState");
            Logger.v("[_PeerConnectionClient] PCObserver => onSignalingChange() => SignalingState: " + (Object)((Object)newState));
        }

        @Override
        public void onIceConnectionChange(@NotNull PeerConnection.IceConnectionState newState) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)newState), (String)"newState");
            PeerConnection.this.executor.execute(new Runnable(this, newState){
                final /* synthetic */ PCObserver this$0;
                final /* synthetic */ PeerConnection.IceConnectionState $newState;

                public final void run() {
                    Logger.v("[_PeerConnectionClient] PCObserver => onIceConnectionChange() => IceConnectionState: " + (Object)((Object)this.$newState));
                    switch (PeerConnection$PCObserver$WhenMappings.$EnumSwitchMapping$0[this.$newState.ordinal()]) {
                        case 1: {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onIceConnected();
                            break;
                        }
                        case 2: {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onIceDisconnected();
                            break;
                        }
                        case 3: {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onIceFailed();
                            break;
                        }
                    }
                }
                {
                    this.this$0 = pCObserver;
                    this.$newState = iceConnectionState;
                }
            });
        }

        @Override
        public void onConnectionChange(@NotNull PeerConnection.PeerConnectionState newState) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)newState), (String)"newState");
            PeerConnection.this.executor.execute(new Runnable(this, newState){
                final /* synthetic */ PCObserver this$0;
                final /* synthetic */ PeerConnection.PeerConnectionState $newState;

                public final void run() {
                    Logger.v("[_PeerConnectionClient] PCObserver => onConnectionChange() => PeerConnectionState: " + (Object)((Object)this.$newState));
                    switch (PeerConnection$PCObserver$WhenMappings.$EnumSwitchMapping$1[this.$newState.ordinal()]) {
                        case 1: {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onConnected();
                            break;
                        }
                        case 2: {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onDisconnected();
                            break;
                        }
                        case 3: {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onFailed();
                            break;
                        }
                    }
                }
                {
                    this.this$0 = pCObserver;
                    this.$newState = peerConnectionState;
                }
            });
        }

        @Override
        public void onIceGatheringChange(@NotNull PeerConnection.IceGatheringState newState) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)newState), (String)"newState");
            Logger.v("[_PeerConnectionClient] PCObserver => onIceGatheringChange() => IceGatheringState: " + (Object)((Object)newState));
        }

        @Override
        public void onIceConnectionReceivingChange(boolean receiving) {
            Logger.v("[_PeerConnectionClient] PCObserver => onIceConnectionReceivingChange() => IceConnectionReceiving changed to " + receiving);
        }

        @Override
        public void onAddStream(@NotNull MediaStream stream) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Logger.v("[_PeerConnectionClient] PCObserver => onAddStream()");
        }

        @Override
        public void onRemoveStream(@NotNull MediaStream stream) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Logger.v("[_PeerConnectionClient] PCObserver => onRemoveStream()");
        }

        @Override
        public void onDataChannel(@NotNull DataChannel dc) {
            Intrinsics.checkParameterIsNotNull((Object)dc, (String)"dc");
        }

        @Override
        public void onRenegotiationNeeded() {
            Logger.v("[_PeerConnectionClient] PCObserver => onRenegotiationNeeded()");
        }

        @Override
        public void onAddTrack(@NotNull RtpReceiver receiver, @NotNull MediaStream[] mediaStreams) {
            Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
            Intrinsics.checkParameterIsNotNull((Object)mediaStreams, (String)"mediaStreams");
            Logger.v("[_PeerConnectionClient] PCObserver => onAddTrack()");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016\u00a8\u0006\f"}, d2={"Lcom/sendbird/calls/internal/pc/PeerConnection$SDPObserver;", "Lorg/webrtc/SdpObserver;", "(Lcom/sendbird/calls/internal/pc/PeerConnection;)V", "onCreateFailure", "", "error", "", "onCreateSuccess", "origSdp", "Lorg/webrtc/SessionDescription;", "onSetFailure", "onSetSuccess", "calls_release"})
    private final class SDPObserver
    implements SdpObserver {
        @Override
        public void onCreateSuccess(@NotNull SessionDescription origSdp) {
            Intrinsics.checkParameterIsNotNull((Object)origSdp, (String)"origSdp");
            if (PeerConnection.this.localSdp != null) {
                PeerConnection.this.reportError("Multiple SDP create.", false);
                return;
            }
            String sdpDescription = origSdp.description;
            if (PeerConnection.this.isPreferIsac) {
                String string = sdpDescription;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdpDescription");
                sdpDescription = PeerConnectionKt.access$preferCodec(string, "ISAC", true);
            }
            if (PeerConnection.this.isVideoCall()) {
                String string = sdpDescription;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdpDescription");
                sdpDescription = PeerConnectionKt.access$preferCodec(string, PeerConnectionKt.access$getSdpVideoCodecName(PeerConnection.this.peerConnectionParameters), false);
            }
            SessionDescription.Type type = origSdp.type;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)type), (String)"origSdp.type");
            String string = sdpDescription;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdpDescription");
            SessionDescription sdp = PeerConnectionKt.access$createSessionDescription(type, string);
            PeerConnection.this.localSdp = sdp;
            PeerConnection.this.executor.execute(new Runnable(this, sdp){
                final /* synthetic */ SDPObserver this$0;
                final /* synthetic */ SessionDescription $sdp;

                public final void run() {
                    block1: {
                        if (PeerConnection.access$isErrorOccurred$p(this.this$0.PeerConnection.this)) break block1;
                        org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0.PeerConnection.this);
                        if (peerConnection != null) {
                            peerConnection.setLocalDescription(PeerConnection.access$getSdpObserver$p(this.this$0.PeerConnection.this), this.$sdp);
                        }
                    }
                }
                {
                    this.this$0 = sDPObserver;
                    this.$sdp = sessionDescription;
                }
            });
        }

        @Override
        public void onSetSuccess() {
            PeerConnection.this.executor.execute(new Runnable(this){
                final /* synthetic */ SDPObserver this$0;

                public final void run() {
                    if (PeerConnection.access$getPeerConnection$p(this.this$0.PeerConnection.this) == null || PeerConnection.access$isErrorOccurred$p(this.this$0.PeerConnection.this)) {
                        return;
                    }
                    if (PeerConnection.access$isInitiator$p(this.this$0.PeerConnection.this)) {
                        if (PeerConnection.access$isIceRestarting$p(this.this$0.PeerConnection.this)) {
                            PeerConnection.access$setIceRestarting$p(this.this$0.PeerConnection.this, false);
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onLocalDescription(true, PeerConnection.access$getLocalSdp$p(this.this$0.PeerConnection.this));
                            return;
                        }
                        org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0.PeerConnection.this);
                        if ((peerConnection != null ? peerConnection.getRemoteDescription() : null) == null) {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onLocalDescription(PeerConnection.access$isInitiator$p(this.this$0.PeerConnection.this), PeerConnection.access$getLocalSdp$p(this.this$0.PeerConnection.this));
                        } else {
                            PeerConnection.access$drainCandidates(this.this$0.PeerConnection.this);
                        }
                    } else {
                        org.webrtc.PeerConnection peerConnection = PeerConnection.access$getPeerConnection$p(this.this$0.PeerConnection.this);
                        if ((peerConnection != null ? peerConnection.getLocalDescription() : null) != null) {
                            PeerConnection.access$getEvents$p(this.this$0.PeerConnection.this).onLocalDescription(PeerConnection.access$isInitiator$p(this.this$0.PeerConnection.this), PeerConnection.access$getLocalSdp$p(this.this$0.PeerConnection.this));
                            PeerConnection.access$drainCandidates(this.this$0.PeerConnection.this);
                        }
                    }
                }
                {
                    this.this$0 = sDPObserver;
                }
            });
        }

        @Override
        public void onCreateFailure(@NotNull String error) {
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            PeerConnection.this.reportError("createSDP error: " + error, false);
        }

        @Override
        public void onSetFailure(@NotNull String error) {
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            PeerConnection.this.reportError("setSDP error: " + error, false);
        }
    }
}

