/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.pc;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.support.annotation.RequiresApi;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.internal.pc.MediaEncoder;
import com.sendbird.calls.internal.util.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000  2\u00020\u0001:\u0002 !B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\r\u0010\u001e\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001fR\u0013\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/sendbird/calls/internal/pc/MediaMixer;", "Lcom/sendbird/calls/internal/pc/MediaEncoder$MediaEncoderListener;", "filePath", "", "mediaEncoders", "", "Lcom/sendbird/calls/internal/pc/MediaEncoder;", "(Ljava/lang/String;Ljava/util/List;)V", "getFilePath", "()Ljava/lang/String;", "isMuxerStarted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "mediaMuxer", "Landroid/media/MediaMuxer;", "numberOfEncodes", "", "trackInfos", "", "Lcom/sendbird/calls/internal/pc/MediaEncoder$Type;", "Lcom/sendbird/calls/internal/pc/MediaMixer$TrackInfo;", "onEncoded", "", "type", "encodedBuffer", "Ljava/nio/ByteBuffer;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "onFormatChanged", "mediaFormat", "Landroid/media/MediaFormat;", "release", "release$calls_release", "Companion", "TrackInfo", "calls_release"})
@RequiresApi(api=18)
public final class MediaMixer
implements MediaEncoder.MediaEncoderListener {
    @NotNull
    private final String filePath;
    private int numberOfEncodes;
    private MediaMuxer mediaMuxer;
    private final AtomicBoolean isMuxerStarted;
    private final Map<MediaEncoder.Type, TrackInfo> trackInfos;
    private static final String TAG;
    public static final Companion Companion;

    @NotNull
    public final /* synthetic */ String getFilePath() {
        return this.filePath;
    }

    public final /* synthetic */ void release$calls_release() {
        Logger.v('[' + TAG + "] release()");
        if (this.isMuxerStarted.get()) {
            try {
                MediaMuxer mediaMuxer = this.mediaMuxer;
                if (mediaMuxer != null) {
                    mediaMuxer.stop();
                }
                MediaMuxer mediaMuxer2 = this.mediaMuxer;
                if (mediaMuxer2 != null) {
                    mediaMuxer2.release();
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public /* synthetic */ void onFormatChanged(@NotNull MediaEncoder.Type type, @NotNull MediaFormat mediaFormat) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)mediaFormat, (String)"mediaFormat");
        Logger.v(TAG + " onFormatChanged(type: " + (Object)((Object)type) + ", mediaFormat: " + mediaFormat + ')');
        MediaMuxer mediaMuxer = this.mediaMuxer;
        if (mediaMuxer == null) {
            return;
        }
        MediaMuxer mediaMuxer2 = mediaMuxer;
        if (!this.trackInfos.containsKey((Object)type)) {
            try {
                int trackId = mediaMuxer2.addTrack(mediaFormat);
                this.trackInfos.put(type, new TrackInfo(trackId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Logger.v(TAG + " new track has been created. " + (Object)((Object)type) + " : " + this.trackInfos.get((Object)type));
        }
        if (this.numberOfEncodes == this.trackInfos.size() && !this.isMuxerStarted.get()) {
            Logger.v(TAG + " mediaMuxer started");
            mediaMuxer2.start();
            this.isMuxerStarted.set(true);
        }
    }

    @Override
    public /* synthetic */ void onEncoded(@NotNull MediaEncoder.Type type, @NotNull ByteBuffer encodedBuffer, @NotNull MediaCodec.BufferInfo bufferInfo) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)encodedBuffer, (String)"encodedBuffer");
        Intrinsics.checkParameterIsNotNull((Object)bufferInfo, (String)"bufferInfo");
        if (!this.isMuxerStarted.get()) {
            return;
        }
        MediaMuxer mediaMuxer = this.mediaMuxer;
        if (mediaMuxer == null) {
            return;
        }
        MediaMuxer mediaMuxer2 = mediaMuxer;
        TrackInfo trackInfo = this.trackInfos.get((Object)type);
        if (trackInfo == null) {
            return;
        }
        TrackInfo trackInfo2 = trackInfo;
        if (trackInfo2.getStartedAt() == 0L && bufferInfo.presentationTimeUs != 0L) {
            trackInfo2.setStartedAt(bufferInfo.presentationTimeUs);
        }
        bufferInfo.presentationTimeUs -= trackInfo2.getStartedAt();
        try {
            mediaMuxer2.writeSampleData(trackInfo2.getTrackId(), encodedBuffer, bufferInfo);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public MediaMixer(@NotNull String filePath, @NotNull List<MediaEncoder> mediaEncoders) {
        Collection<MediaEncoder.Type> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull(mediaEncoders, (String)"mediaEncoders");
        this.filePath = filePath;
        this.isMuxerStarted = new AtomicBoolean(false);
        this.trackInfos = new ConcurrentHashMap();
        try {
            this.mediaMuxer = new MediaMuxer(filePath, 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw (Throwable)new SendBirdException(iOException.getMessage(), 1800613);
        }
        for (MediaEncoder mediaEncoder : mediaEncoders) {
            mediaEncoder.setListener$calls_release(this);
        }
        this.numberOfEncodes = mediaEncoders.size();
        Iterable iterable = mediaEncoders;
        StringBuilder stringBuilder = new StringBuilder().append('[').append(TAG).append("] ");
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaEncoder mediaEncoder = (MediaEncoder)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            MediaEncoder.Type type = it.getType$calls_release();
            collection.add(type);
        }
        collection = (List)destination$iv$iv;
        Logger.v(stringBuilder.append(CollectionsKt.toList((Iterable)collection)).append(" filePath: ").append(filePath).toString());
    }

    static {
        Companion = new Companion(null);
        String string = MediaMixer.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MediaMixer::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004\u00a8\u0006\u0017"}, d2={"Lcom/sendbird/calls/internal/pc/MediaMixer$TrackInfo;", "", "trackId", "", "(I)V", "<set-?>", "", "startedAt", "getStartedAt", "()J", "setStartedAt", "(J)V", "getTrackId", "()I", "setTrackId", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "calls_release"})
    public static final class TrackInfo {
        private long startedAt;
        private int trackId;

        public final /* synthetic */ long getStartedAt() {
            return this.startedAt;
        }

        public final /* synthetic */ void setStartedAt(long l) {
            this.startedAt = l;
        }

        public final int getTrackId() {
            return this.trackId;
        }

        public final void setTrackId(int n) {
            this.trackId = n;
        }

        public TrackInfo(int trackId) {
            this.trackId = trackId;
        }

        public final int component1() {
            return this.trackId;
        }

        @NotNull
        public final TrackInfo copy(int trackId) {
            return new TrackInfo(trackId);
        }

        public static /* synthetic */ TrackInfo copy$default(TrackInfo trackInfo, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = trackInfo.trackId;
            }
            return trackInfo.copy(n);
        }

        @NotNull
        public String toString() {
            return "TrackInfo(trackId=" + this.trackId + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.trackId);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TrackInfo)) break block3;
                    TrackInfo trackInfo = (TrackInfo)object;
                    if (this.trackId != trackInfo.trackId) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/sendbird/calls/internal/pc/MediaMixer$Companion;", "", "()V", "TAG", "", "calls_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

