/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.pc;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.RequiresApi;
import android.view.Surface;
import com.sendbird.calls.internal.util.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.EglBase;
import org.webrtc.GlRectDrawer;
import org.webrtc.VideoFrame;
import org.webrtc.VideoFrameDrawer;
import org.webrtc.VideoSink;
import org.webrtc.audio.JavaAudioDeviceModule;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0001\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0003@ABB'\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nB\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000bJ\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\u0018\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bH\u0002J\b\u00102\u001a\u00020-H\u0002J\u0012\u00103\u001a\u00020-2\b\u00104\u001a\u0004\u0018\u000105H\u0016J\u0012\u00106\u001a\u00020-2\b\u00107\u001a\u0004\u0018\u000108H\u0016J\u001b\u00109\u001a\u00020-2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020-0;H\u0000\u00a2\u0006\u0002\b<J\u0010\u0010=\u001a\u00020-2\u0006\u00104\u001a\u000205H\u0002J\u0015\u0010>\u001a\u00020-2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b?R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0003\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00048@@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/sendbird/calls/internal/pc/MediaEncoder;", "Lorg/webrtc/audio/JavaAudioDeviceModule$SamplesReadyCallback;", "Lorg/webrtc/VideoSink;", "type", "Lcom/sendbird/calls/internal/pc/MediaEncoder$Type;", "sharedContext", "Lorg/webrtc/EglBase$Context;", "width", "", "height", "(Lcom/sendbird/calls/internal/pc/MediaEncoder$Type;Lorg/webrtc/EglBase$Context;II)V", "(Lcom/sendbird/calls/internal/pc/MediaEncoder$Type;)V", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "drawer", "Lorg/webrtc/GlRectDrawer;", "eglBase", "Lorg/webrtc/EglBase;", "encoder", "Landroid/media/MediaCodec;", "frameDrawer", "Lorg/webrtc/VideoFrameDrawer;", "handler", "Landroid/os/Handler;", "handlerThread", "Landroid/os/HandlerThread;", "inputBuffers", "", "Ljava/nio/ByteBuffer;", "[Ljava/nio/ByteBuffer;", "isRunning", "Ljava/util/concurrent/atomic/AtomicBoolean;", "listener", "Lcom/sendbird/calls/internal/pc/MediaEncoder$MediaEncoderListener;", "listenerLock", "", "outputBuffers", "presTime", "", "surface", "Landroid/view/Surface;", "<set-?>", "getType$calls_release", "()Lcom/sendbird/calls/internal/pc/MediaEncoder$Type;", "drainAudio", "", "drainVideo", "initAudioEncoder", "channelCount", "sampleRate", "initVideoEncoder", "onFrame", "frame", "Lorg/webrtc/VideoFrame;", "onWebRtcAudioRecordSamplesReady", "samples", "Lorg/webrtc/audio/JavaAudioDeviceModule$AudioSamples;", "release", "completionHandler", "Lkotlin/Function0;", "release$calls_release", "renderFrameOnRenderThread", "setListener", "setListener$calls_release", "Companion", "MediaEncoderListener", "Type", "calls_release"})
@RequiresApi(api=18)
public final class MediaEncoder
implements JavaAudioDeviceModule.SamplesReadyCallback,
VideoSink {
    private MediaCodec encoder;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    @NotNull
    private Type type;
    private int width;
    private int height;
    private HandlerThread handlerThread;
    private Handler handler;
    private MediaCodec.BufferInfo bufferInfo;
    private EglBase eglBase;
    private EglBase.Context sharedContext;
    private Surface surface;
    private GlRectDrawer drawer;
    private VideoFrameDrawer frameDrawer;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private MediaEncoderListener listener;
    private final Object listenerLock = new Object();
    private long presTime;
    private static final String TAG;
    private static final String VIDEO_MIME_TYPE = "video/avc";
    private static final int FRAME_RATE = 24;
    private static final int IFRAME_INTERVAL = 5;
    private static final String AUDIO_MIME_TYPE = "audio/mp4a-latm";
    public static final Companion Companion;

    @NotNull
    public final /* synthetic */ Type getType$calls_release() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final /* synthetic */ void setListener$calls_release(@NotNull MediaEncoderListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Object object = this.listenerLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.listener = listener;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void initVideoEncoder() {
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)VIDEO_MIME_TYPE, (int)this.width, (int)this.height);
        Intrinsics.checkExpressionValueIsNotNull((Object)mediaFormat, (String)"MediaFormat.createVideoF\u2026MIME_TYPE, width, height)");
        MediaFormat format = mediaFormat;
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", 3000000);
        format.setInteger("frame-rate", 24);
        format.setInteger("i-frame-interval", 5);
        try {
            MediaCodec mediaCodec = this.encoder = MediaCodec.createEncoderByType((String)VIDEO_MIME_TYPE);
            if (mediaCodec != null) {
                mediaCodec.configure(format, null, null, 1);
            }
            this.handler.post(new Runnable(this){
                final /* synthetic */ MediaEncoder this$0;

                public final void run() {
                    MediaEncoder.access$setEglBase$p(this.this$0, EglBase.create(MediaEncoder.access$getSharedContext$p(this.this$0), EglBase.CONFIG_RECORDABLE));
                    MediaCodec mediaCodec = MediaEncoder.access$getEncoder$p(this.this$0);
                    MediaEncoder.access$setSurface$p(this.this$0, (Surface)(mediaCodec != null ? mediaCodec.createInputSurface() : null));
                    EglBase eglBase = MediaEncoder.access$getEglBase$p(this.this$0);
                    if (eglBase != null) {
                        eglBase.createSurface(MediaEncoder.access$getSurface$p(this.this$0));
                    }
                    EglBase eglBase2 = MediaEncoder.access$getEglBase$p(this.this$0);
                    if (eglBase2 != null) {
                        eglBase2.makeCurrent();
                    }
                    MediaEncoder.access$setDrawer$p(this.this$0, new GlRectDrawer());
                    MediaCodec mediaCodec2 = MediaEncoder.access$getEncoder$p(this.this$0);
                    if (mediaCodec2 != null) {
                        mediaCodec2.start();
                    }
                    MediaCodec mediaCodec3 = MediaEncoder.access$getEncoder$p(this.this$0);
                    MediaEncoder.access$setOutputBuffers$p(this.this$0, (ByteBuffer[])(mediaCodec3 != null ? mediaCodec3.getOutputBuffers() : null));
                }
                {
                    this.this$0 = mediaEncoder;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void initAudioEncoder(int channelCount, int sampleRate) {
        Logger.v('[' + TAG + "] initAudioEncoder(channelCount: " + channelCount + ", sampleRate: " + sampleRate + ')');
        try {
            this.encoder = MediaCodec.createEncoderByType((String)AUDIO_MIME_TYPE);
            MediaFormat format = new MediaFormat();
            format.setString("mime", AUDIO_MIME_TYPE);
            format.setInteger("channel-count", channelCount);
            format.setInteger("sample-rate", sampleRate);
            format.setInteger("bitrate", 65536);
            format.setInteger("aac-profile", 2);
            MediaCodec mediaCodec = this.encoder;
            if (mediaCodec != null) {
                mediaCodec.configure(format, null, null, 1);
            }
            MediaCodec mediaCodec2 = this.encoder;
            if (mediaCodec2 != null) {
                mediaCodec2.start();
            }
            MediaCodec mediaCodec3 = this.encoder;
            this.inputBuffers = mediaCodec3 != null ? mediaCodec3.getInputBuffers() : null;
            MediaCodec mediaCodec4 = this.encoder;
            this.outputBuffers = mediaCodec4 != null ? mediaCodec4.getOutputBuffers() : null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final /* synthetic */ void release$calls_release(@NotNull Function0<Unit> completionHandler) {
        Intrinsics.checkParameterIsNotNull(completionHandler, (String)"completionHandler");
        Logger.v('[' + TAG + "] type: " + (Object)((Object)this.type) + ", release()");
        this.isRunning.set(false);
        this.handler.post(new Runnable(this, completionHandler){
            final /* synthetic */ MediaEncoder this$0;
            final /* synthetic */ Function0 $completionHandler;

            public final void run() {
                MediaCodec mediaCodec = MediaEncoder.access$getEncoder$p(this.this$0);
                if (mediaCodec != null) {
                    mediaCodec.stop();
                }
                MediaCodec mediaCodec2 = MediaEncoder.access$getEncoder$p(this.this$0);
                if (mediaCodec2 != null) {
                    mediaCodec2.release();
                }
                EglBase eglBase = MediaEncoder.access$getEglBase$p(this.this$0);
                if (eglBase != null) {
                    eglBase.release();
                }
                MediaEncoder.access$getHandlerThread$p(this.this$0).quit();
                Logger.v('[' + MediaEncoder.access$getTAG$cp() + "] type: " + (Object)((Object)this.this$0.getType$calls_release()) + ", release() finished.");
                this.$completionHandler.invoke();
            }
            {
                this.this$0 = mediaEncoder;
                this.$completionHandler = function0;
            }
        });
    }

    private final void renderFrameOnRenderThread(VideoFrame frame) {
        block1: {
            VideoFrameDrawer videoFrameDrawer = this.frameDrawer;
            if (videoFrameDrawer != null) {
                videoFrameDrawer.drawFrame(frame, this.drawer, null, 0, 0, this.width, this.height);
            }
            frame.release();
            this.drainVideo();
            EglBase eglBase = this.eglBase;
            if (eglBase == null) break block1;
            eglBase.swapBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void drainVideo() {
        MediaCodec mediaCodec = this.encoder;
        if (mediaCodec == null) {
            return;
        }
        MediaCodec encoder = mediaCodec;
        while (true) {
            ByteBuffer encodedData;
            boolean bl;
            Object object;
            StringCompanionObject newFormat;
            if (!this.isRunning.get()) {
                return;
            }
            int encoderStatus = encoder.dequeueOutputBuffer(this.bufferInfo, 10000L);
            if (encoderStatus == -1) return;
            if (encoderStatus == -3) {
                this.outputBuffers = encoder.getOutputBuffers();
                continue;
            }
            if (encoderStatus == -2) {
                Intrinsics.checkExpressionValueIsNotNull((Object)encoder.getOutputFormat(), (String)"encoder.outputFormat");
                String string = String.format("[%s] encoder output format changed: %s", TAG, newFormat);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(\u2026ged: %s\", TAG, newFormat)");
                Logger.v(string);
                object = this.listenerLock;
                boolean bl2 = false;
                boolean bl32 = false;
                synchronized (object) {
                    Unit unit;
                    bl = false;
                    MediaEncoderListener mediaEncoderListener = this.listener;
                    if (mediaEncoderListener != null) {
                        mediaEncoderListener.onFormatChanged(this.type, (MediaFormat)newFormat);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
            }
            if (encoderStatus < 0) {
                newFormat = StringCompanionObject.INSTANCE;
                object = "[%s] unexpected result from encoder.dequeueOutputBuffer: %s";
                Object[] objectArray = new Object[]{TAG, encoderStatus};
                boolean bl4 = false;
                String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
                Logger.v(string);
                continue;
            }
            ByteBuffer byteBuffer = encodedData = this.outputBuffers != null ? this.outputBuffers[encoderStatus] : null;
            if (encodedData == null) {
                object = StringCompanionObject.INSTANCE;
                String string = "[%s] encoderOutputBuffer %s was null";
                Object[] objectArray = new Object[]{TAG, encoderStatus};
                bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                Logger.v(string2);
                return;
            }
            encodedData.position(this.bufferInfo.offset);
            encodedData.limit(this.bufferInfo.offset + this.bufferInfo.size);
            object = this.listenerLock;
            boolean bl5 = false;
            boolean bl6 = false;
            synchronized (object) {
                Unit unit;
                boolean bl7 = false;
                MediaEncoderListener mediaEncoderListener = this.listener;
                if (mediaEncoderListener != null) {
                    mediaEncoderListener.onEncoded(this.type, encodedData, this.bufferInfo);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit3 = unit;
            }
            this.isRunning.set(this.isRunning.get() && (this.bufferInfo.flags & 4) == 0);
            encoder.releaseOutputBuffer(encoderStatus, false);
            if ((this.bufferInfo.flags & 4) != 0) return;
            continue;
            break;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void drainAudio() {
        int encoderStatus;
        MediaCodec mediaCodec = this.encoder;
        if (mediaCodec == null) {
            return;
        }
        MediaCodec encoder = mediaCodec;
        while ((encoderStatus = encoder.dequeueOutputBuffer(this.bufferInfo, 10000L)) != -1) {
            boolean bl;
            StringCompanionObject newFormat;
            Object object;
            Object object2;
            if (encoderStatus == -3) {
                this.outputBuffers = encoder.getOutputBuffers();
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                object2 = "[%s] encoder output buffers changed";
                object = new Object[]{TAG};
                boolean bl2 = false;
                String string = String.format((String)object2, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
                Logger.v(string);
                continue;
            }
            if (encoderStatus == -2) {
                Intrinsics.checkExpressionValueIsNotNull((Object)encoder.getOutputFormat(), (String)"encoder.outputFormat");
                String string = String.format("[%s] encoder output format changed: %s", TAG, newFormat);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(\u2026ged: %s\", TAG, newFormat)");
                Logger.v(string);
                object2 = this.listenerLock;
                boolean bl3 = false;
                boolean bl4 = false;
                synchronized (object2) {
                    Unit unit;
                    bl = false;
                    MediaEncoderListener mediaEncoderListener = this.listener;
                    if (mediaEncoderListener != null) {
                        mediaEncoderListener.onFormatChanged(this.type, (MediaFormat)newFormat);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                    continue;
                }
            }
            if (encoderStatus < 0) {
                newFormat = StringCompanionObject.INSTANCE;
                object2 = "[%s] unexpected result from encoder.dequeueOutputBuffer: %s";
                object = new Object[]{TAG, encoderStatus};
                boolean bl5 = false;
                String string = String.format((String)object2, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
                Logger.v(string);
                continue;
            }
            try {
                ByteBuffer encodedData;
                ByteBuffer byteBuffer = encodedData = this.outputBuffers != null ? this.outputBuffers[encoderStatus] : null;
                if (encodedData == null) {
                    object2 = StringCompanionObject.INSTANCE;
                    object = "[%s] encoderOutputBuffer %s was null";
                    Object[] objectArray = new Object[]{TAG, encoderStatus};
                    bl = false;
                    String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
                    Logger.v(string);
                    break;
                }
                encodedData.position(this.bufferInfo.offset);
                encodedData.limit(this.bufferInfo.offset + this.bufferInfo.size);
                object2 = this.listenerLock;
                boolean bl6 = false;
                boolean bl7 = false;
                synchronized (object2) {
                    Unit unit;
                    boolean bl8 = false;
                    MediaEncoderListener mediaEncoderListener = this.listener;
                    if (mediaEncoderListener != null) {
                        mediaEncoderListener.onEncoded(this.type, encodedData, this.bufferInfo);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit3 = unit;
                }
                this.isRunning.set(this.isRunning.get() && (this.bufferInfo.flags & 4) == 0);
                encoder.releaseOutputBuffer(encoderStatus, false);
                if ((this.bufferInfo.flags & 4) == 0) continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break;
        }
    }

    @Override
    public /* synthetic */ void onWebRtcAudioRecordSamplesReady(@Nullable JavaAudioDeviceModule.AudioSamples samples) {
        if (samples == null) {
            return;
        }
        if (!this.isRunning.get()) {
            return;
        }
        if (this.encoder == null) {
            this.initAudioEncoder(samples.getChannelCount(), samples.getSampleRate());
        }
        MediaCodec mediaCodec = this.encoder;
        if (mediaCodec == null) {
            return;
        }
        MediaCodec encoder = mediaCodec;
        this.handler.post(new Runnable(this, encoder, samples){
            final /* synthetic */ MediaEncoder this$0;
            final /* synthetic */ MediaCodec $encoder;
            final /* synthetic */ JavaAudioDeviceModule.AudioSamples $samples;

            public final void run() {
                try {
                    int bufferIndex = this.$encoder.dequeueInputBuffer(0L);
                    if (bufferIndex >= 0) {
                        ByteBuffer buffer;
                        ByteBuffer[] byteBufferArray = MediaEncoder.access$getInputBuffers$p(this.this$0);
                        ByteBuffer byteBuffer = buffer = byteBufferArray != null ? byteBufferArray[bufferIndex] : null;
                        if (byteBuffer != null) {
                            byteBuffer.clear();
                        }
                        byte[] byArray = this.$samples.getData();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"samples.data");
                        byte[] data = byArray;
                        ByteBuffer byteBuffer2 = buffer;
                        if (byteBuffer2 != null) {
                            byteBuffer2.put(data);
                        }
                        this.$encoder.queueInputBuffer(bufferIndex, 0, data.length, MediaEncoder.access$getPresTime$p(this.this$0), 0);
                        MediaEncoder mediaEncoder = this.this$0;
                        MediaEncoder.access$setPresTime$p(mediaEncoder, MediaEncoder.access$getPresTime$p(mediaEncoder) + (long)(data.length * 1000 * 1000 / 2 / this.$samples.getSampleRate()));
                    }
                    MediaEncoder.access$drainAudio(this.this$0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            {
                this.this$0 = mediaEncoder;
                this.$encoder = mediaCodec;
                this.$samples = audioSamples;
            }
        });
    }

    @Override
    public /* synthetic */ void onFrame(@Nullable VideoFrame frame) {
        block0: {
            VideoFrame videoFrame = frame;
            if (videoFrame == null) break block0;
            VideoFrame videoFrame2 = videoFrame;
            boolean bl = false;
            boolean bl2 = false;
            VideoFrame it = videoFrame2;
            boolean bl3 = false;
            it.retain();
            this.handler.post(new Runnable(it, this){
                final /* synthetic */ VideoFrame $it;
                final /* synthetic */ MediaEncoder this$0;
                {
                    this.$it = videoFrame;
                    this.this$0 = mediaEncoder;
                }

                public final void run() {
                    MediaEncoder.access$renderFrameOnRenderThread(this.this$0, this.$it);
                }
            });
        }
    }

    private MediaEncoder(Type type, EglBase.Context sharedContext, int width, int height) {
        this.handlerThread = new HandlerThread(TAG + " " + UUID.randomUUID().toString());
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
        this.bufferInfo = new MediaCodec.BufferInfo();
        this.type = type;
        this.sharedContext = sharedContext;
        this.width = width;
        this.height = height;
        this.frameDrawer = new VideoFrameDrawer();
        this.initVideoEncoder();
    }

    private MediaEncoder(Type type) {
        this.handlerThread = new HandlerThread(TAG + " " + UUID.randomUUID().toString());
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
        this.bufferInfo = new MediaCodec.BufferInfo();
        this.type = type;
    }

    static {
        Companion = new Companion(null);
        String string = MediaEncoder.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MediaEncoder::class.java.simpleName");
        TAG = string;
    }

    public static final /* synthetic */ EglBase access$getEglBase$p(MediaEncoder $this) {
        return $this.eglBase;
    }

    public static final /* synthetic */ void access$setEglBase$p(MediaEncoder $this, EglBase eglBase) {
        $this.eglBase = eglBase;
    }

    public static final /* synthetic */ EglBase.Context access$getSharedContext$p(MediaEncoder $this) {
        return $this.sharedContext;
    }

    public static final /* synthetic */ void access$setSharedContext$p(MediaEncoder $this, EglBase.Context context) {
        $this.sharedContext = context;
    }

    public static final /* synthetic */ Surface access$getSurface$p(MediaEncoder $this) {
        return $this.surface;
    }

    public static final /* synthetic */ void access$setSurface$p(MediaEncoder $this, Surface surface) {
        $this.surface = surface;
    }

    public static final /* synthetic */ MediaCodec access$getEncoder$p(MediaEncoder $this) {
        return $this.encoder;
    }

    public static final /* synthetic */ void access$setEncoder$p(MediaEncoder $this, MediaCodec mediaCodec) {
        $this.encoder = mediaCodec;
    }

    public static final /* synthetic */ GlRectDrawer access$getDrawer$p(MediaEncoder $this) {
        return $this.drawer;
    }

    public static final /* synthetic */ void access$setDrawer$p(MediaEncoder $this, GlRectDrawer glRectDrawer) {
        $this.drawer = glRectDrawer;
    }

    public static final /* synthetic */ ByteBuffer[] access$getOutputBuffers$p(MediaEncoder $this) {
        return $this.outputBuffers;
    }

    public static final /* synthetic */ void access$setOutputBuffers$p(MediaEncoder $this, ByteBuffer[] byteBufferArray) {
        $this.outputBuffers = byteBufferArray;
    }

    public static final /* synthetic */ HandlerThread access$getHandlerThread$p(MediaEncoder $this) {
        return $this.handlerThread;
    }

    public static final /* synthetic */ void access$setHandlerThread$p(MediaEncoder $this, HandlerThread handlerThread) {
        $this.handlerThread = handlerThread;
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ Type access$getType$p(MediaEncoder $this) {
        return $this.type;
    }

    public static final /* synthetic */ void access$setType$p(MediaEncoder $this, Type type) {
        $this.type = type;
    }

    public static final /* synthetic */ ByteBuffer[] access$getInputBuffers$p(MediaEncoder $this) {
        return $this.inputBuffers;
    }

    public static final /* synthetic */ void access$setInputBuffers$p(MediaEncoder $this, ByteBuffer[] byteBufferArray) {
        $this.inputBuffers = byteBufferArray;
    }

    public static final /* synthetic */ long access$getPresTime$p(MediaEncoder $this) {
        return $this.presTime;
    }

    public static final /* synthetic */ void access$setPresTime$p(MediaEncoder $this, long l) {
        $this.presTime = l;
    }

    public static final /* synthetic */ void access$drainAudio(MediaEncoder $this) {
        $this.drainAudio();
    }

    public static final /* synthetic */ void access$renderFrameOnRenderThread(MediaEncoder $this, VideoFrame frame) {
        $this.renderFrameOnRenderThread(frame);
    }

    public /* synthetic */ MediaEncoder(Type type, DefaultConstructorMarker $constructor_marker) {
        this(type);
    }

    public /* synthetic */ MediaEncoder(Type type, EglBase.Context sharedContext, int width, int height, DefaultConstructorMarker $constructor_marker) {
        this(type, sharedContext, width, height);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/sendbird/calls/internal/pc/MediaEncoder$Type;", "", "(Ljava/lang/String;I)V", "AUDIO", "VIDEO", "calls_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type AUDIO;
        public static final /* enum */ Type VIDEO;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[2];
            Type[] typeArray2 = typeArray;
            typeArray[0] = AUDIO = new Type();
            typeArray[1] = VIDEO = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r"}, d2={"Lcom/sendbird/calls/internal/pc/MediaEncoder$MediaEncoderListener;", "", "onEncoded", "", "type", "Lcom/sendbird/calls/internal/pc/MediaEncoder$Type;", "encodedBuffer", "Ljava/nio/ByteBuffer;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "onFormatChanged", "mediaFormat", "Landroid/media/MediaFormat;", "calls_release"})
    public static interface MediaEncoderListener {
        public void onFormatChanged(@NotNull Type var1, @NotNull MediaFormat var2);

        public void onEncoded(@NotNull Type var1, @NotNull ByteBuffer var2, @NotNull MediaCodec.BufferInfo var3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ-\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/sendbird/calls/internal/pc/MediaEncoder$Companion;", "", "()V", "AUDIO_MIME_TYPE", "", "FRAME_RATE", "", "IFRAME_INTERVAL", "TAG", "VIDEO_MIME_TYPE", "createAudioEncoder", "Lcom/sendbird/calls/internal/pc/MediaEncoder;", "type", "Lcom/sendbird/calls/internal/pc/MediaEncoder$Type;", "createAudioEncoder$calls_release", "createVideoEncoder", "sharedContext", "Lorg/webrtc/EglBase$Context;", "width", "height", "createVideoEncoder$calls_release", "calls_release"})
    public static final class Companion {
        @NotNull
        public final /* synthetic */ MediaEncoder createAudioEncoder$calls_release(@NotNull Type type) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
            return new MediaEncoder(type, null);
        }

        @NotNull
        public final /* synthetic */ MediaEncoder createVideoEncoder$calls_release(@NotNull Type type, @NotNull EglBase.Context sharedContext, int width, int height) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)sharedContext, (String)"sharedContext");
            return new MediaEncoder(type, sharedContext, width, height, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

