/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.pc;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.text.TextUtils;
import android.util.AndroidException;
import android.util.Size;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.VideoDevice;
import com.sendbird.calls.internal.util.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.VideoCapturer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\"\u001a\u00020\u001a2\b\u0010#\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u001aJ\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010)\u001a\u00020*H\u0002J\u0014\u0010,\u001a\u00020\f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ-\u0010.\u001a\u00020\f2%\u0010/\u001a!\u0012\u0015\u0012\u0013\u0018\u000101\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\f\u0018\u000100J7\u0010.\u001a\u00020\f2\b\u00105\u001a\u0004\u0018\u00010\u00072%\u0010/\u001a!\u0012\u0015\u0012\u0013\u0018\u000101\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\f\u0018\u000100J\b\u00106\u001a\u00020\fH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00078F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00068"}, d2={"Lcom/sendbird/calls/internal/pc/CameraManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "_videoDevices", "", "Lcom/sendbird/calls/VideoDevice;", "camera2Manager", "Landroid/hardware/camera2/CameraManager;", "cameraDisconnectedListener", "Lkotlin/Function0;", "", "cameraEnumerator", "Lorg/webrtc/CameraEnumerator;", "<set-?>", "Lcom/sendbird/calls/internal/pc/CameraManager$CameraState;", "cameraState", "getCameraState", "()Lcom/sendbird/calls/internal/pc/CameraManager$CameraState;", "cameraVideoCapturer", "Lorg/webrtc/CameraVideoCapturer;", "currentVideoDevice", "getCurrentVideoDevice", "()Lcom/sendbird/calls/VideoDevice;", "isFrontCamera", "", "()Ljava/lang/Boolean;", "isSwitchingCamera", "Ljava/util/concurrent/atomic/AtomicBoolean;", "videoDevices", "", "getVideoDevices", "()Ljava/util/List;", "canCauseCrash", "videoDevice", "createVideoCapturer", "Lorg/webrtc/VideoCapturer;", "useFrontCamera", "getCameraCharacteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "deviceName", "", "getVideoDevice", "setCameraDisconnectedListener", "listener", "switchCamera", "handler", "Lkotlin/Function1;", "Lcom/sendbird/calls/SendBirdException;", "Lkotlin/ParameterName;", "name", "e", "device", "updateVideoDevices", "CameraState", "calls_release"})
public final class CameraManager {
    private android.hardware.camera2.CameraManager camera2Manager;
    private CameraEnumerator cameraEnumerator;
    private final List<VideoDevice> _videoDevices;
    private CameraVideoCapturer cameraVideoCapturer;
    private final AtomicBoolean isSwitchingCamera;
    private Function0<Unit> cameraDisconnectedListener;
    @Nullable
    private VideoDevice currentVideoDevice;
    @NotNull
    private CameraState cameraState;
    private final Context context;

    @NotNull
    public final /* synthetic */ List<VideoDevice> getVideoDevices() {
        return CollectionsKt.toList((Iterable)this._videoDevices);
    }

    @Nullable
    public final /* synthetic */ VideoDevice getCurrentVideoDevice() {
        return this.currentVideoDevice;
    }

    @NotNull
    public final /* synthetic */ CameraState getCameraState() {
        return this.cameraState;
    }

    @Nullable
    public final /* synthetic */ Boolean isFrontCamera() {
        VideoDevice videoDevice = this.currentVideoDevice;
        return (videoDevice != null ? videoDevice.getPosition() : null) == VideoDevice.Position.FRONT;
    }

    @Nullable
    public final /* synthetic */ VideoCapturer createVideoCapturer(@NotNull Context context, boolean useFrontCamera) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Logger.v("[CameraManager] createVideoCapturer");
        if (Build.VERSION.SDK_INT >= 23 && context.checkCallingOrSelfPermission("android.permission.CAMERA") != 0) {
            Logger.v("[CameraManager] CAMERA permission not granted.");
            return null;
        }
        if (this._videoDevices.size() == 0) {
            Logger.v("[CameraManager] createVideoCapturer() videoDevices is empty.");
            return null;
        }
        CameraVideoCapturer.CameraEventsHandler cameraEventsHandler2 = new CameraVideoCapturer.CameraEventsHandler(this){
            final /* synthetic */ CameraManager this$0;

            public void onCameraError(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                Logger.v("[CameraManager] onCameraError(s: " + s + ')');
            }

            public void onCameraDisconnected() {
                block0: {
                    Logger.v("[CameraManager] onCameraDisconnected()");
                    CameraManager.access$setCameraState$p(this.this$0, CameraState.DISCONNECTED);
                    Function0 function0 = CameraManager.access$getCameraDisconnectedListener$p(this.this$0);
                    if (function0 == null) break block0;
                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                }
            }

            public void onCameraFreezed(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                Logger.v("[CameraManager] onCameraFreeze(s: " + s + ')');
            }

            public void onCameraOpening(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                Logger.v("[CameraManager] onCameraOpening(s: " + s + ')');
                CameraManager.access$setCameraState$p(this.this$0, CameraState.OPENED);
            }

            public void onFirstFrameAvailable() {
                Logger.v("[CameraManager] onFirstFrameAvailable()");
            }

            public void onCameraClosed() {
                Logger.v("[CameraManager] onCameraClosed()");
                if (this.this$0.getCameraState() != CameraState.DISCONNECTED) {
                    CameraManager.access$setCameraState$p(this.this$0, CameraState.CLOSED);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        for (VideoDevice videoDevice : this._videoDevices) {
            if (useFrontCamera && videoDevice.getPosition() == VideoDevice.Position.FRONT) {
                this.currentVideoDevice = videoDevice;
                CameraEnumerator cameraEnumerator = this.cameraEnumerator;
                if (cameraEnumerator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cameraEnumerator");
                }
                this.cameraVideoCapturer = cameraEnumerator.createCapturer(videoDevice.getDeviceName(), cameraEventsHandler2);
                return this.cameraVideoCapturer;
            }
            if (useFrontCamera || videoDevice.getPosition() != VideoDevice.Position.BACK) continue;
            this.currentVideoDevice = videoDevice;
            CameraEnumerator cameraEnumerator = this.cameraEnumerator;
            if (cameraEnumerator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cameraEnumerator");
            }
            this.cameraVideoCapturer = cameraEnumerator.createCapturer(videoDevice.getDeviceName(), cameraEventsHandler2);
            return this.cameraVideoCapturer;
        }
        VideoDevice firstVideoDevice = this._videoDevices.get(0);
        CameraEnumerator cameraEnumerator = this.cameraEnumerator;
        if (cameraEnumerator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraEnumerator");
        }
        this.cameraVideoCapturer = cameraEnumerator.createCapturer(firstVideoDevice.getDeviceName(), cameraEventsHandler2);
        return this.cameraVideoCapturer;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ void switchCamera(@Nullable Function1<? super SendBirdException, Unit> handler) {
        VideoDevice nextDevice = null;
        if (this._videoDevices.size() > 0) {
            int indexOfCurrentDevice = CollectionsKt.indexOf(this._videoDevices, (Object)this.currentVideoDevice);
            boolean targetFound = false;
            int n = 1;
            int n2 = this._videoDevices.size();
            if (n <= n2) {
                while (true) {
                    void i;
                    int nextDeviceIndex;
                    if (!this.canCauseCrash(nextDevice = this._videoDevices.get(nextDeviceIndex = (indexOfCurrentDevice + i) % this._videoDevices.size()))) {
                        targetFound = true;
                        break;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (!targetFound) {
                nextDevice = null;
            }
        }
        this.switchCamera(nextDevice, handler);
    }

    public final /* synthetic */ void switchCamera(@Nullable VideoDevice device, @Nullable Function1<? super SendBirdException, Unit> handler) {
        block4: {
            Logger.v("[CameraManager] switchCamera. device => " + device);
            if (this.cameraVideoCapturer == null || device == null || this._videoDevices.size() == 0) {
                Function1<? super SendBirdException, Unit> function1 = handler;
                if (function1 != null) {
                    Function1<? super SendBirdException, Unit> function12 = function1;
                    boolean bl = false;
                    boolean bl2 = false;
                    Function1<? super SendBirdException, Unit> it = function12;
                    boolean bl3 = false;
                    it.invoke((Object)SendBirdException.Companion.getSendBirdException$calls_release(1800401));
                }
                return;
            }
            if (this.isSwitchingCamera.get()) {
                Function1<? super SendBirdException, Unit> function1 = handler;
                if (function1 != null) {
                    Function1<? super SendBirdException, Unit> function13 = function1;
                    boolean bl = false;
                    boolean bl4 = false;
                    Function1<? super SendBirdException, Unit> it = function13;
                    boolean bl5 = false;
                    it.invoke((Object)SendBirdException.Companion.getSendBirdException$calls_release(1800400));
                }
                return;
            }
            CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler2 = new CameraVideoCapturer.CameraSwitchHandler(this, device, handler){
                final /* synthetic */ CameraManager this$0;
                final /* synthetic */ VideoDevice $device;
                final /* synthetic */ Function1 $handler;

                public void onCameraSwitchDone(boolean isFrontCamera) {
                    block0: {
                        CameraManager.access$setCurrentVideoDevice$p(this.this$0, this.$device);
                        Logger.v("[CameraManager] onCameraSwitchDone. currentDevice => " + this.this$0.getCurrentVideoDevice());
                        CameraManager.access$isSwitchingCamera$p(this.this$0).set(false);
                        Function1 function1 = this.$handler;
                        if (function1 == null) break block0;
                        Function1 function12 = function1;
                        boolean bl = false;
                        boolean bl2 = false;
                        Function1 it = function12;
                        boolean bl3 = false;
                        it.invoke(null);
                    }
                }

                public void onCameraSwitchError(@NotNull String s) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                        Logger.e("[CameraManager] onCameraSwitchError() => " + s);
                        CameraManager.access$isSwitchingCamera$p(this.this$0).set(false);
                        Function1 function1 = this.$handler;
                        if (function1 == null) break block0;
                        Function1 function12 = function1;
                        boolean bl = false;
                        boolean bl2 = false;
                        Function1 it = function12;
                        boolean bl3 = false;
                        it.invoke((Object)SendBirdException.Companion.getSendBirdException$calls_release(1800401));
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$device = $captured_local_variable$1;
                    this.$handler = $captured_local_variable$2;
                }
            };
            this.isSwitchingCamera.set(true);
            CameraVideoCapturer cameraVideoCapturer = this.cameraVideoCapturer;
            if (cameraVideoCapturer == null) break block4;
            cameraVideoCapturer.switchCamera(cameraSwitchHandler2, device.getDeviceName());
        }
    }

    public final /* synthetic */ void setCameraDisconnectedListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.cameraDisconnectedListener = listener;
    }

    private final void updateVideoDevices() {
        Logger.v("[CameraManager] updateVideoDevices()");
        this._videoDevices.clear();
        CameraEnumerator cameraEnumerator = this.cameraEnumerator = Camera2Enumerator.isSupported(this.context) ? (CameraEnumerator)new Camera2Enumerator(this.context) : (CameraEnumerator)new Camera1Enumerator(true);
        if (cameraEnumerator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraEnumerator");
        }
        String[] stringArray = cameraEnumerator.getDeviceNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"cameraEnumerator.deviceNames");
        String[] $this$forEach$iv = stringArray;
        boolean $i$f$forEach = false;
        String[] stringArray2 = $this$forEach$iv;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            VideoDevice.Position position;
            String element$iv;
            String it = element$iv = stringArray2[i];
            boolean bl = false;
            CameraEnumerator cameraEnumerator2 = this.cameraEnumerator;
            if (cameraEnumerator2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cameraEnumerator");
            }
            if (cameraEnumerator2.isBackFacing(it)) {
                position = VideoDevice.Position.BACK;
            } else {
                CameraEnumerator cameraEnumerator3 = this.cameraEnumerator;
                if (cameraEnumerator3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cameraEnumerator");
                }
                position = cameraEnumerator3.isFrontFacing(it) ? VideoDevice.Position.FRONT : VideoDevice.Position.UNSPECIFIED;
            }
            VideoDevice.Position position2 = position;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            VideoDevice device = VideoDevice.Companion.createVideoDevice$calls_release(string, position2, this.getCameraCharacteristics(it));
            if (this.canCauseCrash(device)) continue;
            this._videoDevices.add(device);
        }
    }

    private final CameraCharacteristics getCameraCharacteristics(String deviceName) {
        CameraCharacteristics cameraCharacteristics;
        if (this.camera2Manager == null || Build.VERSION.SDK_INT < 21) {
            cameraCharacteristics = null;
        } else {
            CameraCharacteristics cameraCharacteristics2;
            try {
                android.hardware.camera2.CameraManager cameraManager = this.camera2Manager;
                cameraCharacteristics2 = cameraManager != null ? cameraManager.getCameraCharacteristics(deviceName) : null;
            }
            catch (AndroidException e) {
                cameraCharacteristics2 = null;
            }
            catch (IllegalArgumentException e) {
                cameraCharacteristics2 = null;
            }
            cameraCharacteristics = cameraCharacteristics2;
        }
        return cameraCharacteristics;
    }

    private final VideoDevice getVideoDevice(String deviceName) {
        for (VideoDevice videoDevice : this._videoDevices) {
            if (!TextUtils.equals((CharSequence)videoDevice.getDeviceName(), (CharSequence)deviceName)) continue;
            return videoDevice;
        }
        return null;
    }

    private final boolean canCauseCrash(VideoDevice videoDevice) {
        VideoDevice videoDevice2 = videoDevice;
        if ((videoDevice2 != null ? videoDevice2.getCameraCharacteristics() : null) == null) {
            return false;
        }
        CameraCharacteristics characteristics = videoDevice.getCameraCharacteristics();
        if (Build.VERSION.SDK_INT >= 21) {
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (streamConfigurationMap == null) {
                return true;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)streamConfigurationMap, (String)"characteristics.get(Came\u2026           ?: return true");
            StreamConfigurationMap streamMap = streamConfigurationMap;
            Size[] nativeSizes = streamMap.getOutputSizes(SurfaceTexture.class);
            return nativeSizes == null;
        }
        return false;
    }

    public CameraManager(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        CameraManager cameraManager = this;
        boolean bl = false;
        List list = new ArrayList();
        List list2 = Collections.synchronizedList(list);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.synchronizedList(mutableListOf())");
        cameraManager._videoDevices = list2;
        this.isSwitchingCamera = new AtomicBoolean(false);
        this.cameraState = CameraState.IDLE;
        if (Build.VERSION.SDK_INT >= 21) {
            Object object = this.context.getSystemService("camera");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
            }
            this.camera2Manager = (android.hardware.camera2.CameraManager)object;
        }
        this.updateVideoDevices();
    }

    public static final /* synthetic */ CameraState access$getCameraState$p(CameraManager $this) {
        return $this.cameraState;
    }

    public static final /* synthetic */ void access$setCameraState$p(CameraManager $this, CameraState cameraState) {
        $this.cameraState = cameraState;
    }

    public static final /* synthetic */ Function0 access$getCameraDisconnectedListener$p(CameraManager $this) {
        return $this.cameraDisconnectedListener;
    }

    public static final /* synthetic */ void access$setCameraDisconnectedListener$p(CameraManager $this, Function0 function0) {
        $this.cameraDisconnectedListener = function0;
    }

    public static final /* synthetic */ VideoDevice access$getCurrentVideoDevice$p(CameraManager $this) {
        return $this.currentVideoDevice;
    }

    public static final /* synthetic */ void access$setCurrentVideoDevice$p(CameraManager $this, VideoDevice videoDevice) {
        $this.currentVideoDevice = videoDevice;
    }

    public static final /* synthetic */ AtomicBoolean access$isSwitchingCamera$p(CameraManager $this) {
        return $this.isSwitchingCamera;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/sendbird/calls/internal/pc/CameraManager$CameraState;", "", "(Ljava/lang/String;I)V", "IDLE", "OPENED", "DISCONNECTED", "CLOSED", "calls_release"})
    public static final class CameraState
    extends Enum<CameraState> {
        public static final /* enum */ CameraState IDLE;
        public static final /* enum */ CameraState OPENED;
        public static final /* enum */ CameraState DISCONNECTED;
        public static final /* enum */ CameraState CLOSED;
        private static final /* synthetic */ CameraState[] $VALUES;

        static {
            CameraState[] cameraStateArray = new CameraState[4];
            CameraState[] cameraStateArray2 = cameraStateArray;
            cameraStateArray[0] = IDLE = new CameraState();
            cameraStateArray[1] = OPENED = new CameraState();
            cameraStateArray[2] = DISCONNECTED = new CameraState();
            cameraStateArray[3] = CLOSED = new CameraState();
            $VALUES = cameraStateArray;
        }

        public static CameraState[] values() {
            return (CameraState[])$VALUES.clone();
        }

        public static CameraState valueOf(String string) {
            return Enum.valueOf(CameraState.class, string);
        }
    }
}

