/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.model;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import com.sendbird.calls.internal.model.TransportInfo;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.webrtc.RTCStats;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u001a \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\"\u0010\u0014\u001a\u0004\u0018\u00010\u0001*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001aA\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001e\u001a\u0018\u0010\u001f\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u001a\u001a\u0010 \u001a\u0004\u0018\u00010!*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"INBOUND_AUDIO", "", "INBOUND_VIDEO", "OUTBOUND_AUDIO", "OUTBOUND_VIDEO", "RECEIVER_VIDEO", "REMOTE_INBOUND_AUDIO", "REMOTE_INBOUND_VIDEO", "SENDER_VIDEO", "VIDEO_SOURCE", "getMos", "", "jitter", "", "latency", "packetsLostRate", "getNetworkOperator", "context", "Landroid/content/Context;", "getWifiLevel", "getCodec", "", "Lorg/webrtc/RTCStats;", "isVideoCall", "", "getMember", "T", "key", "memberId", "kind", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "getTimestamp", "getTransportInfo", "Lcom/sendbird/calls/internal/model/TransportInfo;", "calls_release"})
public final class StatsKt {
    private static final String INBOUND_AUDIO = "RTCInboundRTPAudioStream";
    private static final String OUTBOUND_AUDIO = "RTCOutboundRTPAudioStream";
    private static final String REMOTE_INBOUND_AUDIO = "RTCRemoteInboundRtpAudioStream";
    private static final String INBOUND_VIDEO = "RTCInboundRTPVideoStream";
    private static final String RECEIVER_VIDEO = "RTCMediaStreamTrack_receiver";
    private static final String SENDER_VIDEO = "RTCMediaStreamTrack_sender";
    private static final String VIDEO_SOURCE = "RTCVideoSource";
    private static final String OUTBOUND_VIDEO = "RTCOutboundRTPVideoStream";
    private static final String REMOTE_INBOUND_VIDEO = "RTCRemoteInboundRtpVideoStream";

    private static final double getTimestamp(@NotNull Map<String, ? extends RTCStats> $this$getTimestamp) {
        Object v0;
        block2: {
            Iterable iterable = $this$getTimestamp.keySet();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                String it = (String)t;
                boolean bl3 = false;
                if (!StringsKt.startsWith$default((String)it, (String)"RTCRemoteInbound", (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        String string = v0;
        if (string == null) {
            return 0.0;
        }
        String key = string;
        RTCStats rTCStats = $this$getTimestamp.get(key);
        return rTCStats != null ? rTCStats.getTimestampUs() : 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private static final TransportInfo getTransportInfo(@NotNull Map<String, ? extends RTCStats> $this$getTransportInfo) {
        Map.Entry element$iv$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = $this$getTransportInfo;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var6_8 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_8.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!(StringsKt.startsWith$default((String)((String)it.getKey()), (String)"RTCTransport", (boolean)false, (int)2, null) && ((RTCStats)it.getValue()).getMembers().containsKey("selectedCandidatePairId"))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        map = $this$forEach$iv;
        boolean bl3 = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object v2;
            Map.Entry element$iv;
            Map.Entry $dstr$_u24__u24$value = element$iv = iterator2.next();
            boolean bl4 = false;
            element$iv$iv = $dstr$_u24__u24$value;
            boolean it = false;
            RTCStats value = (RTCStats)element$iv$iv.getValue();
            Object object = value.getMembers().get("selectedCandidatePairId");
            if (!(object instanceof String)) {
                object = null;
            }
            String selectedCandidatePairId = (String)object;
            Map map2 = $this$getTransportInfo;
            boolean bl5 = false;
            RTCStats selectedCandidateStat = (RTCStats)map2.get(selectedCandidatePairId);
            Object object2 = selectedCandidateStat;
            if (!((object2 != null && (object2 = ((RTCStats)object2).getMembers()) != null ? object2.get("localCandidateId") : (v2 = null)) instanceof String)) {
                v2 = null;
            }
            String localCandidateId = v2;
            Map map3 = $this$getTransportInfo;
            boolean bl6 = false;
            RTCStats rTCStats = (RTCStats)map3.get(localCandidateId);
            if (rTCStats == null) {
                continue;
            }
            RTCStats localCandidateStat = rTCStats;
            Object object3 = localCandidateStat.getMembers().get("networkType");
            if (!(object3 instanceof String)) {
                object3 = null;
            }
            String networkType = (String)object3;
            Object object4 = localCandidateStat.getMembers().get("ip");
            if (!(object4 instanceof String)) {
                object4 = null;
            }
            String ip = (String)object4;
            Object object5 = localCandidateStat.getMembers().get("port");
            if (!(object5 instanceof Integer)) {
                object5 = null;
            }
            Integer port = (Integer)object5;
            Object object6 = localCandidateStat.getMembers().get("protocol");
            if (!(object6 instanceof String)) {
                object6 = null;
            }
            String protocol = (String)object6;
            Object object7 = localCandidateStat.getMembers().get("relayProtocol");
            if (!(object7 instanceof String)) {
                object7 = null;
            }
            String relayProtocol = (String)object7;
            Object object8 = localCandidateStat.getMembers().get("candidateType");
            if (!(object8 instanceof String)) {
                object8 = null;
            }
            String candidateType = (String)object8;
            return new TransportInfo(networkType, ip, port, protocol, relayProtocol, candidateType);
        }
        return null;
    }

    private static final String getNetworkOperator(Context context) {
        TelephonyManager telephonyManager;
        Object object;
        Object object2 = context.getSystemService("phone");
        if (!(object2 instanceof TelephonyManager)) {
            object2 = null;
        }
        if ((object = (telephonyManager = (TelephonyManager)object2)) == null || (object = object.getNetworkOperatorName()) == null) {
            object = "";
        }
        return object;
    }

    private static final int getWifiLevel(Context context) {
        Object object = context.getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wifiManager = (WifiManager)object;
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)wifiInfo, (String)"wifiManager.connectionInfo");
        int rssi = wifiInfo.getRssi();
        return WifiManager.calculateSignalLevel((int)rssi, (int)5);
    }

    private static final String getCodec(@NotNull Map<String, ? extends RTCStats> $this$getCodec, boolean isVideoCall) {
        String string;
        Object v0;
        boolean bl;
        Object object;
        block6: {
            String key = isVideoCall ? INBOUND_VIDEO : INBOUND_AUDIO;
            object = $this$getCodec.entrySet();
            bl = false;
            Iterable iterable = object;
            boolean bl2 = false;
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl3 = false;
                if (!StringsKt.startsWith$default((String)((String)it.getKey()), (String)key, (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        if (entry != null) {
            Object v6;
            object = entry;
            bl = false;
            boolean bl4 = false;
            Object entry2 = object;
            boolean bl5 = false;
            Map<String, Object> map = ((RTCStats)entry2.getValue()).getMembers();
            Object object2 = map != null ? map.get("codecId") : null;
            if (!(object2 instanceof String)) {
                object2 = null;
            }
            String string2 = (String)object2;
            if (string2 == null) {
                return null;
            }
            String codecId = string2;
            Object object3 = $this$getCodec.get(codecId);
            if (!((object3 != null && (object3 = ((RTCStats)object3).getMembers()) != null ? object3.get("mimeType") : (v6 = null)) instanceof String)) {
                v6 = null;
            }
            string = v6;
        } else {
            string = null;
        }
        return string;
    }

    private static final <T> T getMember(@NotNull Map<String, ? extends RTCStats> $this$getMember, String key, String memberId, String kind) {
        Object object;
        try {
            Object object2;
            Object v0;
            boolean bl;
            block6: {
                object = $this$getMember.entrySet();
                bl = false;
                Iterable iterable = object;
                boolean bl2 = false;
                for (Object t : iterable) {
                    Map.Entry it = (Map.Entry)t;
                    boolean bl3 = false;
                    if (!(StringsKt.startsWith$default((String)((String)it.getKey()), (String)key, (boolean)false, (int)2, null) && (kind != null ? Intrinsics.areEqual((Object)((RTCStats)it.getValue()).getMembers().get("kind"), (Object)kind) : true))) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            if (entry != null) {
                object = entry;
                bl = false;
                boolean bl4 = false;
                Object entry2 = object;
                boolean bl5 = false;
                Map<String, Object> map = ((RTCStats)entry2.getValue()).getMembers();
                object2 = map != null ? map.get(memberId) : null;
                if (!(object2 instanceof Object)) {
                    object2 = null;
                }
            } else {
                object2 = null;
            }
            object = object2;
        }
        catch (Exception e) {
            e.printStackTrace();
            object = null;
        }
        return (T)object;
    }

    static /* synthetic */ Object getMember$default(Map map, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return StatsKt.getMember(map, string, string2, string3);
    }

    private static final double getMos(int jitter, int latency, double packetsLostRate) {
        if (jitter < 0 || latency < 0 || Double.isNaN(packetsLostRate)) {
            return 0.0;
        }
        double effectiveLatency = (double)(latency + 2 * jitter) + 10.0;
        double R = effectiveLatency < (double)160 ? 93.2 - effectiveLatency / 40.0 : 93.2 - (effectiveLatency - 120.0) / 10.0;
        return R < 0.0 ? 1.0 : (R >= (double)100 ? 4.5 : 1.0 + 0.035 * (R -= 2.5 * packetsLostRate) + 7.0E-6 * R * (R - (double)60) * ((double)100 - R));
    }

    public static final /* synthetic */ double access$getTimestamp(Map $this$access_u24getTimestamp) {
        return StatsKt.getTimestamp($this$access_u24getTimestamp);
    }

    public static final /* synthetic */ TransportInfo access$getTransportInfo(Map $this$access_u24getTransportInfo) {
        return StatsKt.getTransportInfo($this$access_u24getTransportInfo);
    }

    public static final /* synthetic */ String access$getNetworkOperator(Context context) {
        return StatsKt.getNetworkOperator(context);
    }

    public static final /* synthetic */ int access$getWifiLevel(Context context) {
        return StatsKt.getWifiLevel(context);
    }

    public static final /* synthetic */ double access$getMos(int jitter, int latency, double packetsLostRate) {
        return StatsKt.getMos(jitter, latency, packetsLostRate);
    }

    public static final /* synthetic */ String access$getCodec(Map $this$access_u24getCodec, boolean isVideoCall) {
        return StatsKt.getCodec($this$access_u24getCodec, isVideoCall);
    }

    public static final /* synthetic */ Object access$getMember(Map $this$access_u24getMember, String key, String memberId, String kind) {
        return StatsKt.getMember($this$access_u24getMember, key, memberId, kind);
    }
}

