/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.sendbird.calls.AudioDevice;
import com.sendbird.calls.DialParams;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.RecordingOptions;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.User;
import com.sendbird.calls.handler.DialHandler;
import com.sendbird.calls.handler.RecordingListener;
import com.sendbird.calls.handler.SendBirdCallListener;
import com.sendbird.calls.internal.CallManager;
import com.sendbird.calls.internal.CallManager$createDirectCall$;
import com.sendbird.calls.internal.SoundManager;
import com.sendbird.calls.internal.client.CommandSender;
import com.sendbird.calls.internal.command.CallPushCommand;
import com.sendbird.calls.internal.command.CancelPushCommand;
import com.sendbird.calls.internal.command.Command;
import com.sendbird.calls.internal.command.DialPushCommand;
import com.sendbird.calls.internal.command.DirectCallSnapshotCommand;
import com.sendbird.calls.internal.command.OtherDeviceDeclinedPushCommand;
import com.sendbird.calls.internal.command.UploadLogsPushCommand;
import com.sendbird.calls.internal.command.WebSocketConnectedCommand;
import com.sendbird.calls.internal.model.DirectCallSnapshot;
import com.sendbird.calls.internal.util.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b5J\u001d\u00106\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020'H\u0000\u00a2\u0006\u0002\b7J\b\u00108\u001a\u00020\u000fH\u0001J\u0012\u00109\u001a\u00020\u00142\b\u0010:\u001a\u0004\u0018\u00010\u0013H\u0002J'\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010AH\u0000\u00a2\u0006\u0002\bBJ\r\u0010C\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\bDJ\u0019\u0010E\u001a\u0004\u0018\u00010\u00142\b\u0010:\u001a\u0004\u0018\u00010\u0013H\u0000\u00a2\u0006\u0002\bFJ\u0019\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020'0HH\u0000\u00a2\u0006\u0002\bIJ\u0010\u0010J\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0014H\u0002J\u0018\u0010O\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0014H\u0002J\r\u0010Q\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\bRJ\r\u0010S\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\bTJ\u0010\u0010U\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0014H\u0002J\u0017\u0010V\u001a\u0004\u0018\u00010\"2\u0006\u00103\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bWJ\u0017\u0010X\u001a\u0004\u0018\u00010'2\u0006\u00103\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bYJ\u0010\u0010Z\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020\u0013H\u0002J\r\u0010[\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\\RJ\u0010\u0007\u001a>\u0012\u0015\u0012\u0013\u0018\u00010\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\bj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u0017\u001a!\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u000f0\u0018j\u0002`\u001b8@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\"0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010#\u001a!\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u000f0\u0018j\u0002`%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020'0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\u00020)8@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R$\u0010-\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0016@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010 \"\u0004\b/\u00100R\u001a\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/sendbird/calls/internal/CallManager;", "", "context", "Landroid/content/Context;", "commandSender", "Lcom/sendbird/calls/internal/client/CommandSender;", "(Landroid/content/Context;Lcom/sendbird/calls/internal/client/CommandSender;)V", "audioDeviceChangeListener", "Lkotlin/Function2;", "Lcom/sendbird/calls/AudioDevice;", "Lkotlin/ParameterName;", "name", "currentAudioDevice", "", "availableAudioDevices", "", "Lcom/sendbird/calls/internal/util/AudioDeviceChangeListener;", "callMap", "", "", "Lcom/sendbird/calls/DirectCall;", "callSummaryMeasureInterval", "", "eventListener", "Lkotlin/Function1;", "Lcom/sendbird/calls/internal/command/Command;", "command", "Lcom/sendbird/calls/internal/util/EventListener;", "getEventListener$calls_release", "()Lkotlin/jvm/functions/Function1;", "ongoingCallCount", "getOngoingCallCount$calls_release", "()I", "recordingListeners", "Lcom/sendbird/calls/handler/RecordingListener;", "ringingListener", "call", "Lcom/sendbird/calls/internal/util/RingingListener;", "sendBirdCallListeners", "Lcom/sendbird/calls/handler/SendBirdCallListener;", "soundManager", "Lcom/sendbird/calls/internal/SoundManager;", "getSoundManager$calls_release", "()Lcom/sendbird/calls/internal/SoundManager;", "<set-?>", "statsInterval", "getStatsInterval$calls_release", "setStatsInterval$calls_release", "(I)V", "tempCallMap", "addRecordingListener", "identifier", "listener", "addRecordingListener$calls_release", "addSendBirdCallListener", "addSendBirdCallListener$calls_release", "clearAllCalls", "createDirectCall", "callId", "dial", "currentUser", "Lcom/sendbird/calls/User;", "params", "Lcom/sendbird/calls/DialParams;", "handler", "Lcom/sendbird/calls/handler/DialHandler;", "dial$calls_release", "endAllCalls", "endAllCalls$calls_release", "getCall", "getCall$calls_release", "getSendBirdCallListeners", "", "getSendBirdCallListeners$calls_release", "onCancelReceivedWithoutCall", "Lcom/sendbird/calls/internal/command/CancelPushCommand;", "onDialReceived", "Lcom/sendbird/calls/internal/command/DialPushCommand;", "putCall", "putTempCall", "tempCallId", "removeAllRecordingListeners", "removeAllRecordingListeners$calls_release", "removeAllSendBirdCallListeners", "removeAllSendBirdCallListeners$calls_release", "removeCall", "removeRecordingListener", "removeRecordingListener$calls_release", "removeSendBirdCallListener", "removeSendBirdCallListener$calls_release", "removeTempCall", "retrieveCommands", "retrieveCommands$calls_release", "calls_release"})
public final class CallManager {
    private final Context context;
    private final Map<String, DirectCall> callMap;
    private final Map<String, DirectCall> tempCallMap;
    private final CommandSender commandSender;
    private final Map<String, SendBirdCallListener> sendBirdCallListeners;
    private final Map<String, RecordingListener> recordingListeners;
    private final Function2<AudioDevice, Set<? extends AudioDevice>, Unit> audioDeviceChangeListener;
    private final Function1<DirectCall, Unit> ringingListener;
    private final int callSummaryMeasureInterval = 1;
    private int statsInterval;
    @NotNull
    private final SoundManager soundManager;
    @NotNull
    private final Function1<Command, Unit> eventListener;

    public final int getStatsInterval$calls_release() {
        return this.statsInterval;
    }

    public final /* synthetic */ void setStatsInterval$calls_release(int n) {
        this.statsInterval = n;
    }

    @NotNull
    public final /* synthetic */ SoundManager getSoundManager$calls_release() {
        return this.soundManager;
    }

    @NotNull
    public final /* synthetic */ Function1<Command, Unit> getEventListener$calls_release() {
        return this.eventListener;
    }

    public final /* synthetic */ int getOngoingCallCount$calls_release() {
        int ongoingCalls = 0;
        for (DirectCall call : this.callMap.values()) {
            if (!call.isOngoing()) continue;
            ++ongoingCalls;
        }
        for (DirectCall call : this.tempCallMap.values()) {
            if (!call.isOngoing()) continue;
            ++ongoingCalls;
        }
        return ongoingCalls;
    }

    @Nullable
    public final /* synthetic */ DirectCall getCall$calls_release(@Nullable String callId) {
        DirectCall call = null;
        if (callId != null) {
            call = this.callMap.get(callId);
            Logger.v("[CallManager] getCall(callId: " + callId + ") => " + (call != null));
        }
        return call;
    }

    @NotNull
    public final /* synthetic */ Map<String, SendBirdCallListener> getSendBirdCallListeners$calls_release() {
        return this.sendBirdCallListeners;
    }

    public final /* synthetic */ void addSendBirdCallListener$calls_release(@NotNull String identifier, @NotNull SendBirdCallListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Logger.v("[CallManager] addListener(identifier: " + identifier + ')');
        this.sendBirdCallListeners.put(identifier, listener);
    }

    @Nullable
    public final /* synthetic */ SendBirdCallListener removeSendBirdCallListener$calls_release(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Logger.v("[CallManager] removeListener(identifier: " + identifier + ')');
        return this.sendBirdCallListeners.remove(identifier);
    }

    public final /* synthetic */ void removeAllSendBirdCallListeners$calls_release() {
        Logger.v("[CallManager] removeAllListeners()");
        for (String identifier : this.sendBirdCallListeners.keySet()) {
            this.removeSendBirdCallListener$calls_release(identifier);
        }
    }

    public final /* synthetic */ void addRecordingListener$calls_release(@NotNull String identifier, @NotNull RecordingListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Logger.v("[CallManager] addRecordingListener(" + identifier + ", " + listener + ')');
        this.recordingListeners.put(identifier, listener);
    }

    @Nullable
    public final /* synthetic */ RecordingListener removeRecordingListener$calls_release(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Logger.v("[CallManager] removeRecordingListener(" + identifier + ')');
        return this.recordingListeners.remove(identifier);
    }

    public final /* synthetic */ void removeAllRecordingListeners$calls_release() {
        this.recordingListeners.clear();
    }

    @NotNull
    public final /* synthetic */ DirectCall dial$calls_release(@NotNull User currentUser, @NotNull DialParams params, @Nullable DialHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)currentUser, (String)"currentUser");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        Logger.v("[CallManager] dial(calleeId: " + params.getCalleeId$calls_release() + ")");
        DirectCall directCall = this.createDirectCall(null);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        String tempCallId = string;
        this.putTempCall(tempCallId, directCall);
        directCall.dial$calls_release(currentUser, params, new DialHandler(this, tempCallId, handler){
            final /* synthetic */ CallManager this$0;
            final /* synthetic */ String $tempCallId;
            final /* synthetic */ DialHandler $handler;

            public void onResult(@Nullable DirectCall call, @Nullable SendBirdException e) {
                Logger.i("[CallManager] onDialAckReceived(e: " + e + ')');
                CallManager.access$removeTempCall(this.this$0, this.$tempCallId);
                if (call == null) {
                    SendBirdCall.runOnThreadOption$calls_release((Function0<Unit>)((Function0)new Function0<Unit>(this, e){
                        final /* synthetic */ dial.1 this$0;
                        final /* synthetic */ SendBirdException $e;

                        @Nullable
                        public final Unit invoke() {
                            Unit unit;
                            DialHandler dialHandler = this.this$0.$handler;
                            if (dialHandler != null) {
                                dialHandler.onResult(null, this.$e);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            return unit;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$e = sendBirdException;
                            super(0);
                        }
                    }));
                } else {
                    CallManager.access$putCall(this.this$0, call);
                    SendBirdCall.runOnThreadOption$calls_release((Function0<Unit>)((Function0)new Function0<Unit>(this, call){
                        final /* synthetic */ dial.1 this$0;
                        final /* synthetic */ DirectCall $call;

                        @Nullable
                        public final Unit invoke() {
                            Unit unit;
                            DialHandler dialHandler = this.this$0.$handler;
                            if (dialHandler != null) {
                                dialHandler.onResult(this.$call, null);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            return unit;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$call = directCall;
                            super(0);
                        }
                    }));
                }
            }
            {
                this.this$0 = $outer;
                this.$tempCallId = $captured_local_variable$1;
                this.$handler = $captured_local_variable$2;
            }
        });
        return directCall;
    }

    public final /* synthetic */ void retrieveCommands$calls_release() {
        List ongoingCallIds = new ArrayList();
        for (DirectCall call : this.callMap.values()) {
            String string;
            if (!call.isOngoing()) continue;
            if (call.getCallId() == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            ongoingCallIds.add(it);
        }
        this.commandSender.retrieveCommands(ongoingCallIds);
    }

    public final /* synthetic */ void endAllCalls$calls_release() {
        Logger.v("[CallManager] endAllCalls() calls = " + this.callMap.size());
        List calls = new ArrayList<DirectCall>(this.callMap.values());
        CountDownLatch lock = new CountDownLatch(calls.size());
        this.callMap.clear();
        for (DirectCall call : calls) {
            if (call.isOngoing()) {
                call.setEndListener$calls_release((Function1<? super DirectCall, Unit>)((Function1)new Function1<DirectCall, Unit>(lock){
                    final /* synthetic */ CountDownLatch $lock;

                    public final void invoke(@NotNull DirectCall it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$lock.countDown();
                    }
                    {
                        this.$lock = countDownLatch;
                        super(1);
                    }
                }));
                call.end();
                continue;
            }
            lock.countDown();
        }
        try {
            lock.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private final void putCall(DirectCall call) {
        block0: {
            Logger.v("[CallManager] putCall(callId: " + call.getCallId() + ")");
            String string = call.getCallId();
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.callMap.put(it, call);
        }
    }

    private final void removeCall(DirectCall call) {
        block0: {
            Logger.v("[CallManager] removeCall(callId: " + call.getCallId() + ")");
            String string = call.getCallId();
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.callMap.remove(it);
        }
    }

    private final void putTempCall(String tempCallId, DirectCall call) {
        Logger.v("[CallManager] putTempCall(tempCallId: " + tempCallId + ')');
        if (call.getCallId() == null) {
            this.tempCallMap.put(tempCallId, call);
        }
    }

    private final void removeTempCall(String tempCallId) {
        Logger.v("[CallManager] removeTempCall(tempCallId: " + tempCallId + ')');
        this.tempCallMap.remove(tempCallId);
    }

    private final void onDialReceived(DialPushCommand command) {
        Logger.v("[CallManager] onDialReceived(callId: " + command.getCallId$calls_release() + ")");
        DirectCall directCall = this.getCall$calls_release(command.getCallId$calls_release());
        if (directCall == null) {
            directCall = this.createDirectCall(command.getCallId$calls_release());
            this.putCall(directCall);
            directCall.onDialReceived$calls_release(command);
        }
    }

    private final void onCancelReceivedWithoutCall(CancelPushCommand command) {
        Logger.v("[CallManager] onCancelReceivedWithoutCall()");
        DirectCall directCall = this.createDirectCall(command.getCallId$calls_release());
        this.putCall(directCall);
        directCall.onCancelReceivedWithoutCall$calls_release(command);
    }

    private final DirectCall createDirectCall(String callId) {
        DirectCall directCall = DirectCall.Companion.createDirectCall$calls_release(this.context, this.commandSender, this.soundManager, callId, this.callSummaryMeasureInterval, this.statsInterval);
        boolean bl = false;
        boolean bl2 = false;
        DirectCall $this$apply = directCall;
        boolean bl3 = false;
        $this$apply.setRingingListener$calls_release(this.ringingListener);
        $this$apply.setAudioDeviceChangeListener$calls_release(this.audioDeviceChangeListener);
        $this$apply.setRecordingListener$calls_release((Function4<? super String, ? super RecordingOptions, ? super String, ? super SendBirdException, Unit>)((Function4)new Function4<String, RecordingOptions, String, SendBirdException, Unit>($this$apply, this){
            final /* synthetic */ DirectCall $this_apply;
            final /* synthetic */ CallManager this$0;
            {
                this.$this_apply = directCall;
                this.this$0 = callManager;
                super(4);
            }

            public final void invoke(@NotNull String recordingId, @NotNull RecordingOptions recordingOption, @Nullable String filePath, @Nullable SendBirdException e) {
                Intrinsics.checkParameterIsNotNull((Object)recordingId, (String)"recordingId");
                Intrinsics.checkParameterIsNotNull((Object)recordingOption, (String)"recordingOption");
                if (e != null) {
                    Logger.i("[CallManager] onRecordingFailed. recordingId: " + recordingId);
                    SendBirdCall.runOnThreadOption$calls_release((Function0<Unit>)((Function0)new Function0<Unit>(this, recordingId, e){
                        final /* synthetic */ createDirectCall$$inlined$apply$lambda$1 this$0;
                        final /* synthetic */ String $recordingId;
                        final /* synthetic */ SendBirdException $e;
                        {
                            this.this$0 = var1_1;
                            this.$recordingId = string;
                            this.$e = sendBirdException;
                            super(0);
                        }

                        public final void invoke() {
                            Map $this$forEach$iv = CallManager.access$getRecordingListeners$p(this.this$0.this$0);
                            boolean $i$f$forEach = false;
                            Map map = $this$forEach$iv;
                            boolean bl = false;
                            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry<K, V> element$iv;
                                Map.Entry<K, V> it = element$iv = iterator.next();
                                boolean bl2 = false;
                                ((RecordingListener)it.getValue()).onRecordingFailed(this.this$0.$this_apply, this.$recordingId, this.$e);
                            }
                        }
                    }));
                } else if (filePath != null) {
                    Logger.i("[CallManager] onRecordingSucceeded. recordingId: " + recordingId);
                    SendBirdCall.runOnThreadOption$calls_release((Function0<Unit>)((Function0)new Function0<Unit>(this, recordingId, recordingOption, filePath){
                        final /* synthetic */ createDirectCall$$inlined$apply$lambda$1 this$0;
                        final /* synthetic */ String $recordingId;
                        final /* synthetic */ RecordingOptions $recordingOption;
                        final /* synthetic */ String $filePath;
                        {
                            this.this$0 = var1_1;
                            this.$recordingId = string;
                            this.$recordingOption = recordingOptions;
                            this.$filePath = string2;
                            super(0);
                        }

                        public final void invoke() {
                            Map $this$forEach$iv = CallManager.access$getRecordingListeners$p(this.this$0.this$0);
                            boolean $i$f$forEach = false;
                            Map map = $this$forEach$iv;
                            boolean bl = false;
                            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry<K, V> element$iv;
                                Map.Entry<K, V> it = element$iv = iterator.next();
                                boolean bl2 = false;
                                ((RecordingListener)it.getValue()).onRecordingSucceeded(this.this$0.$this_apply, this.$recordingId, this.$recordingOption, this.$filePath);
                            }
                        }
                    }));
                } else {
                    Logger.v("[CallManager] Weird behavior. SendBirdException is null but there is no file path");
                }
            }
        }));
        return directCall;
    }

    @JvmName(name="clearAllCalls")
    @VisibleForTesting
    public final /* synthetic */ void clearAllCalls() {
        for (DirectCall call : this.callMap.values()) {
            call.setListener(null);
        }
        this.callMap.clear();
    }

    public CallManager(@NotNull Context context, @NotNull CommandSender commandSender) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)commandSender, (String)"commandSender");
        this.callSummaryMeasureInterval = 1;
        this.statsInterval = 3;
        Logger.v("[CallManager] CallManager()");
        this.context = context;
        this.soundManager = new SoundManager(context);
        this.callMap = new ConcurrentHashMap();
        this.tempCallMap = new ConcurrentHashMap();
        this.commandSender = commandSender;
        this.sendBirdCallListeners = new ConcurrentHashMap();
        this.recordingListeners = new ConcurrentHashMap();
        this.audioDeviceChangeListener = (Function2)new Function2<AudioDevice, Set<? extends AudioDevice>, Unit>(){

            public final void invoke(@Nullable AudioDevice currentAudioDevice, @NotNull Set<? extends AudioDevice> availableAudioDevices) {
                Intrinsics.checkParameterIsNotNull(availableAudioDevices, (String)"availableAudioDevices");
                Logger.v("[CallManager] onAudioDeviceChanged(currentAudioDevice: " + (Object)((Object)currentAudioDevice) + ',' + " availableAudioDevices: " + availableAudioDevices + ')');
                for (DirectCall call : callMap.values()) {
                    if (!call.isOngoing()) continue;
                    call.onAudioDeviceChanged(currentAudioDevice, availableAudioDevices);
                }
            }
        };
        this.ringingListener = (Function1)new Function1<DirectCall, Unit>(){

            public final void invoke(final @NotNull DirectCall call) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                for (String identifier : sendBirdCallListeners.keySet()) {
                    final SendBirdCallListener handler = (SendBirdCallListener)sendBirdCallListeners.get(identifier);
                    SendBirdCall.runOnThreadOption$calls_release((Function0<Unit>)((Function0)new Function0<Unit>(){

                        @Nullable
                        public final Unit invoke() {
                            Unit unit;
                            Logger.i("[CallManager] onRinging(callId: " + call.getCallId() + ")");
                            SendBirdCallListener sendBirdCallListener = handler;
                            if (sendBirdCallListener != null) {
                                sendBirdCallListener.onRinging(call);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            return unit;
                        }
                    }));
                }
            }
        };
        this.eventListener = (Function1)new Function1<Command, Unit>(){

            public final void invoke(@NotNull Command command) {
                block1: {
                    Command command2;
                    block6: {
                        DirectCall call;
                        block5: {
                            block4: {
                                DirectCall call2;
                                block2: {
                                    DirectCall call3;
                                    String callId;
                                    block3: {
                                        block0: {
                                            Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
                                            command2 = command;
                                            if (!(command2 instanceof DialPushCommand)) break block0;
                                            Logger.v("[CallManager] onEvent(command: DialPushCommand)");
                                            this.onDialReceived((DialPushCommand)command);
                                            break block1;
                                        }
                                        if (!(command2 instanceof CallPushCommand)) break block2;
                                        callId = ((CallPushCommand)command).getCallId$calls_release();
                                        call3 = this.getCall$calls_release(callId);
                                        if (call3 != null || !(command instanceof CancelPushCommand)) break block3;
                                        Logger.v("[CallManager] onEvent(command: CancelPushCommand, callId: " + callId + ')');
                                        this.onCancelReceivedWithoutCall((CancelPushCommand)command);
                                        break block1;
                                    }
                                    Logger.v("[CallManager] onEvent(command: " + ((CallPushCommand)command).getClass().getSimpleName() + ", callId: " + callId + ")");
                                    DirectCall directCall = call3;
                                    if (directCall == null) break block1;
                                    directCall.onEvent$calls_release(command);
                                    break block1;
                                }
                                if (!(command2 instanceof DirectCallSnapshotCommand)) break block4;
                                String callId = ((DirectCallSnapshotCommand)command).getCallId$calls_release();
                                DirectCallSnapshot snapshot = ((DirectCallSnapshotCommand)command).getSnapshot$calls_release();
                                DirectCall directCall = call2 = this.getCall$calls_release(callId);
                                if (directCall == null) break block1;
                                directCall.onSnapshotReceived$calls_release(snapshot);
                                break block1;
                            }
                            if (!(command2 instanceof WebSocketConnectedCommand)) break block5;
                            Logger.v("[CallManager] " + ((WebSocketConnectedCommand)command).getClass().getSimpleName() + " received.");
                            this.retrieveCommands$calls_release();
                            break block1;
                        }
                        if (!(command2 instanceof OtherDeviceDeclinedPushCommand)) break block6;
                        String callId = ((OtherDeviceDeclinedPushCommand)command).getCallId$calls_release();
                        DirectCall directCall = call = this.getCall$calls_release(callId);
                        if (directCall == null) break block1;
                        directCall.onEvent$calls_release(command);
                        break block1;
                    }
                    if (!(command2 instanceof UploadLogsPushCommand)) break block1;
                    Logger.sendLogsToServer(((UploadLogsPushCommand)command).getLogLevel());
                }
            }
        };
    }

    public static final /* synthetic */ void access$removeTempCall(CallManager $this, String tempCallId) {
        $this.removeTempCall(tempCallId);
    }

    public static final /* synthetic */ void access$putCall(CallManager $this, DirectCall call) {
        $this.putCall(call);
    }

    public static final /* synthetic */ Map access$getRecordingListeners$p(CallManager $this) {
        return $this.recordingListeners;
    }
}

