/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.pc;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import com.sendbird.calls.internal.pc.AppRTCAudioManager;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.webrtc.ThreadUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 92\u00020\u0001:\u0004789:B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\"\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u001aH\u0002J\u0018\u0010&\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\nH\u0003J\u0018\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u0010/\u001a\u00020\u001fJ\u0006\u00100\u001a\u00020#J\b\u00101\u001a\u00020\u001fH\u0002J\u0006\u00102\u001a\u00020\u001fJ\u0006\u00103\u001a\u00020\u001fJ\u0012\u00104\u001a\u00020\u001f2\b\u0010,\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u00105\u001a\u00020\u001fH\u0002J\u0006\u00106\u001a\u00020\u001fR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006;"}, d2={"Lcom/sendbird/calls/internal/pc/AppRTCBluetoothManager;", "", "context", "Landroid/content/Context;", "audioManager", "Lcom/sendbird/calls/internal/pc/AppRTCAudioManager;", "(Landroid/content/Context;Lcom/sendbird/calls/internal/pc/AppRTCAudioManager;)V", "apprtcAudioManager", "Landroid/media/AudioManager;", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "bluetoothDevice", "Landroid/bluetooth/BluetoothDevice;", "bluetoothHeadset", "Landroid/bluetooth/BluetoothHeadset;", "bluetoothHeadsetReceiver", "Landroid/content/BroadcastReceiver;", "bluetoothServiceListener", "Landroid/bluetooth/BluetoothProfile$ServiceListener;", "bluetoothState", "Lcom/sendbird/calls/internal/pc/AppRTCBluetoothManager$State;", "bluetoothTimeoutRunnable", "Ljava/lang/Runnable;", "handler", "Landroid/os/Handler;", "scoConnectionAttempts", "", "state", "getState", "()Lcom/sendbird/calls/internal/pc/AppRTCBluetoothManager$State;", "bluetoothTimeout", "", "cancelTimer", "getAudioManager", "getBluetoothProfileProxy", "", "listener", "profile", "hasPermission", "permission", "", "logBluetoothAdapterInfo", "localAdapter", "registerReceiver", "receiver", "filter", "Landroid/content/IntentFilter;", "start", "startScoAudio", "startTimer", "stop", "stopScoAudio", "unregisterReceiver", "updateAudioDeviceState", "updateDevice", "BluetoothHeadsetBroadcastReceiver", "BluetoothServiceListener", "Companion", "State", "calls_release"})
public final class AppRTCBluetoothManager {
    private final AppRTCAudioManager apprtcAudioManager;
    private final AudioManager audioManager;
    private final Handler handler;
    private int scoConnectionAttempts;
    private State bluetoothState;
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothHeadset bluetoothHeadset;
    private BluetoothDevice bluetoothDevice;
    private final BluetoothProfile.ServiceListener bluetoothServiceListener;
    private final BroadcastReceiver bluetoothHeadsetReceiver;
    private final Runnable bluetoothTimeoutRunnable;
    private final Context context;
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 4000;
    private static final int MAX_SCO_CONNECTION_ATTEMPTS = 2;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final /* synthetic */ State getState() {
        ThreadUtils.checkIsOnMainThread();
        return this.bluetoothState;
    }

    public final /* synthetic */ void start() {
        ThreadUtils.checkIsOnMainThread();
        if (!this.hasPermission(this.context, "android.permission.BLUETOOTH")) {
            return;
        }
        if (this.bluetoothState != State.UNINITIALIZED) {
            return;
        }
        this.bluetoothHeadset = null;
        this.bluetoothDevice = null;
        this.scoConnectionAttempts = 0;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null) {
            return;
        }
        if (!this.audioManager.isBluetoothScoAvailableOffCall()) {
            return;
        }
        BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
        if (bluetoothAdapter != null) {
            BluetoothAdapter bluetoothAdapter2 = bluetoothAdapter;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothAdapter it = bluetoothAdapter2;
            boolean bl3 = false;
            this.logBluetoothAdapterInfo(it);
        }
        if (!this.getBluetoothProfileProxy(this.context, this.bluetoothServiceListener, 1)) {
            return;
        }
        IntentFilter bluetoothHeadsetFilter = new IntentFilter();
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        this.registerReceiver(this.bluetoothHeadsetReceiver, bluetoothHeadsetFilter);
        this.bluetoothState = State.HEADSET_UNAVAILABLE;
    }

    public final /* synthetic */ void stop() {
        ThreadUtils.checkIsOnMainThread();
        if (this.bluetoothAdapter == null) {
            return;
        }
        this.stopScoAudio();
        if (this.bluetoothState == State.UNINITIALIZED) {
            return;
        }
        this.unregisterReceiver(this.bluetoothHeadsetReceiver);
        this.cancelTimer();
        BluetoothHeadset bluetoothHeadset = this.bluetoothHeadset;
        if (bluetoothHeadset != null) {
            BluetoothHeadset bluetoothHeadset2 = bluetoothHeadset;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothHeadset it = bluetoothHeadset2;
            boolean bl3 = false;
            BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
            if (bluetoothAdapter != null) {
                bluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)it);
            }
            this.bluetoothHeadset = null;
        }
        this.bluetoothAdapter = null;
        this.bluetoothDevice = null;
        this.bluetoothState = State.UNINITIALIZED;
    }

    public final /* synthetic */ boolean startScoAudio() {
        ThreadUtils.checkIsOnMainThread();
        if (this.scoConnectionAttempts >= 2) {
            return false;
        }
        if (this.bluetoothState != State.HEADSET_AVAILABLE) {
            return false;
        }
        this.bluetoothState = State.SCO_CONNECTING;
        this.audioManager.startBluetoothSco();
        this.audioManager.setBluetoothScoOn(true);
        int n = this.scoConnectionAttempts;
        this.scoConnectionAttempts = n + 1;
        this.startTimer();
        return true;
    }

    public final /* synthetic */ void stopScoAudio() {
        ThreadUtils.checkIsOnMainThread();
        if (this.bluetoothState != State.SCO_CONNECTING && this.bluetoothState != State.SCO_CONNECTED) {
            return;
        }
        this.cancelTimer();
        this.audioManager.stopBluetoothSco();
        this.audioManager.setBluetoothScoOn(false);
        this.bluetoothState = State.SCO_DISCONNECTING;
    }

    public final /* synthetic */ void updateDevice() {
        block3: {
            if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
                return;
            }
            Object object = this.bluetoothHeadset;
            if (object == null || (object = object.getConnectedDevices()) == null) break block3;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object devices = object2;
            boolean bl3 = false;
            if (devices.isEmpty()) {
                this.bluetoothDevice = null;
                this.bluetoothState = State.HEADSET_UNAVAILABLE;
            } else {
                this.bluetoothDevice = (BluetoothDevice)devices.get(0);
                this.bluetoothState = State.HEADSET_AVAILABLE;
            }
        }
    }

    private final AudioManager getAudioManager(Context context) {
        Object object = context.getSystemService("audio");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
        }
        return (AudioManager)object;
    }

    private final void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.context.registerReceiver(receiver, filter);
    }

    private final void unregisterReceiver(BroadcastReceiver receiver) {
        this.context.unregisterReceiver(receiver);
    }

    private final boolean getBluetoothProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
        return bluetoothAdapter != null ? bluetoothAdapter.getProfileProxy(context, listener, profile) : false;
    }

    private final boolean hasPermission(Context context, String permission) {
        return context.checkPermission(permission, Process.myPid(), Process.myUid()) == 0;
    }

    @SuppressLint(value={"HardwareIds"})
    private final void logBluetoothAdapterInfo(BluetoothAdapter localAdapter) {
        Set pairedDevices = localAdapter.getBondedDevices();
        if (!pairedDevices.isEmpty()) {
            for (BluetoothDevice bluetoothDevice : pairedDevices) {
            }
        }
    }

    private final void updateAudioDeviceState() {
        ThreadUtils.checkIsOnMainThread();
        this.apprtcAudioManager.updateAudioDeviceState();
    }

    private final void startTimer() {
        ThreadUtils.checkIsOnMainThread();
        this.handler.postDelayed(this.bluetoothTimeoutRunnable, (long)4000);
    }

    private final void cancelTimer() {
        ThreadUtils.checkIsOnMainThread();
        this.handler.removeCallbacks(this.bluetoothTimeoutRunnable);
    }

    private final void bluetoothTimeout() {
        List devices;
        ThreadUtils.checkIsOnMainThread();
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        if (this.bluetoothState != State.SCO_CONNECTING) {
            return;
        }
        boolean scoConnected = false;
        BluetoothHeadset bluetoothHeadset = this.bluetoothHeadset;
        if (bluetoothHeadset == null) {
            Intrinsics.throwNpe();
        }
        if ((devices = bluetoothHeadset.getConnectedDevices()).size() > 0) {
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            BluetoothHeadset bluetoothHeadset2 = this.bluetoothHeadset;
            if (bluetoothHeadset2 == null) {
                Intrinsics.throwNpe();
            }
            if (bluetoothHeadset2.isAudioConnected(this.bluetoothDevice)) {
                scoConnected = true;
            }
        }
        if (scoConnected) {
            this.bluetoothState = State.SCO_CONNECTED;
            this.scoConnectionAttempts = 0;
        } else {
            this.stopScoAudio();
        }
        this.updateAudioDeviceState();
    }

    private AppRTCBluetoothManager(Context context, AppRTCAudioManager audioManager) {
        this.context = context;
        this.bluetoothTimeoutRunnable = new Runnable(this){
            final /* synthetic */ AppRTCBluetoothManager this$0;

            public final void run() {
                AppRTCBluetoothManager.access$bluetoothTimeout(this.this$0);
            }
            {
                this.this$0 = appRTCBluetoothManager;
            }
        };
        ThreadUtils.checkIsOnMainThread();
        this.apprtcAudioManager = audioManager;
        this.audioManager = this.getAudioManager(this.context);
        this.bluetoothState = State.UNINITIALIZED;
        this.bluetoothServiceListener = new BluetoothServiceListener();
        this.bluetoothHeadsetReceiver = new BluetoothHeadsetBroadcastReceiver();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public static final /* synthetic */ BluetoothHeadset access$getBluetoothHeadset$p(AppRTCBluetoothManager $this) {
        return $this.bluetoothHeadset;
    }

    public static final /* synthetic */ BluetoothDevice access$getBluetoothDevice$p(AppRTCBluetoothManager $this) {
        return $this.bluetoothDevice;
    }

    public static final /* synthetic */ int access$getScoConnectionAttempts$p(AppRTCBluetoothManager $this) {
        return $this.scoConnectionAttempts;
    }

    public static final /* synthetic */ void access$bluetoothTimeout(AppRTCBluetoothManager $this) {
        $this.bluetoothTimeout();
    }

    public /* synthetic */ AppRTCBluetoothManager(Context context, AppRTCAudioManager audioManager, DefaultConstructorMarker $constructor_marker) {
        this(context, audioManager);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/sendbird/calls/internal/pc/AppRTCBluetoothManager$State;", "", "(Ljava/lang/String;I)V", "UNINITIALIZED", "ERROR", "HEADSET_UNAVAILABLE", "HEADSET_AVAILABLE", "SCO_DISCONNECTING", "SCO_CONNECTING", "SCO_CONNECTED", "calls_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State UNINITIALIZED;
        public static final /* enum */ State ERROR;
        public static final /* enum */ State HEADSET_UNAVAILABLE;
        public static final /* enum */ State HEADSET_AVAILABLE;
        public static final /* enum */ State SCO_DISCONNECTING;
        public static final /* enum */ State SCO_CONNECTING;
        public static final /* enum */ State SCO_CONNECTED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[7];
            State[] stateArray2 = stateArray;
            stateArray[0] = UNINITIALIZED = new State();
            stateArray[1] = ERROR = new State();
            stateArray[2] = HEADSET_UNAVAILABLE = new State();
            stateArray[3] = HEADSET_AVAILABLE = new State();
            stateArray[4] = SCO_DISCONNECTING = new State();
            stateArray[5] = SCO_CONNECTING = new State();
            stateArray[6] = SCO_CONNECTED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/sendbird/calls/internal/pc/AppRTCBluetoothManager$BluetoothServiceListener;", "Landroid/bluetooth/BluetoothProfile$ServiceListener;", "(Lcom/sendbird/calls/internal/pc/AppRTCBluetoothManager;)V", "onServiceConnected", "", "profile", "", "proxy", "Landroid/bluetooth/BluetoothProfile;", "onServiceDisconnected", "calls_release"})
    private final class BluetoothServiceListener
    implements BluetoothProfile.ServiceListener {
        public void onServiceConnected(int profile, @NotNull BluetoothProfile proxy) {
            Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
            if (profile != 1 || AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            AppRTCBluetoothManager.this.bluetoothHeadset = (BluetoothHeadset)proxy;
            AppRTCBluetoothManager.this.updateAudioDeviceState();
        }

        public void onServiceDisconnected(int profile) {
            if (profile != 1 || AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            AppRTCBluetoothManager.this.stopScoAudio();
            AppRTCBluetoothManager.this.bluetoothHeadset = null;
            AppRTCBluetoothManager.this.bluetoothDevice = null;
            AppRTCBluetoothManager.this.bluetoothState = State.HEADSET_UNAVAILABLE;
            AppRTCBluetoothManager.this.updateAudioDeviceState();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/sendbird/calls/internal/pc/AppRTCBluetoothManager$BluetoothHeadsetBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "(Lcom/sendbird/calls/internal/pc/AppRTCBluetoothManager;)V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "calls_release"})
    private final class BluetoothHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            if (AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            String action = intent.getAction();
            if (Intrinsics.areEqual((Object)action, (Object)"android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                if (state == 2) {
                    AppRTCBluetoothManager.this.scoConnectionAttempts = 0;
                    AppRTCBluetoothManager.this.updateAudioDeviceState();
                } else if (state != 1 && state != 3 && state == 0) {
                    AppRTCBluetoothManager.this.stopScoAudio();
                    AppRTCBluetoothManager.this.updateAudioDeviceState();
                }
            } else if (Intrinsics.areEqual((Object)action, (Object)"android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 10);
                if (state == 12) {
                    AppRTCBluetoothManager.this.cancelTimer();
                    if (AppRTCBluetoothManager.this.bluetoothState == State.SCO_CONNECTING) {
                        AppRTCBluetoothManager.this.bluetoothState = State.SCO_CONNECTED;
                        AppRTCBluetoothManager.this.scoConnectionAttempts = 0;
                        AppRTCBluetoothManager.this.updateAudioDeviceState();
                    }
                } else if (state != 11 && state == 10) {
                    if (this.isInitialStickyBroadcast()) {
                        return;
                    }
                    AppRTCBluetoothManager.this.updateAudioDeviceState();
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/sendbird/calls/internal/pc/AppRTCBluetoothManager$Companion;", "", "()V", "BLUETOOTH_SCO_TIMEOUT_MS", "", "MAX_SCO_CONNECTION_ATTEMPTS", "create", "Lcom/sendbird/calls/internal/pc/AppRTCBluetoothManager;", "context", "Landroid/content/Context;", "audioManager", "Lcom/sendbird/calls/internal/pc/AppRTCAudioManager;", "calls_release"})
    public static final class Companion {
        @NotNull
        public final /* synthetic */ AppRTCBluetoothManager create(@NotNull Context context, @NotNull AppRTCAudioManager audioManager) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)audioManager, (String)"audioManager");
            return new AppRTCBluetoothManager(context, audioManager, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

