/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.client;

import android.os.Build;
import android.util.Log;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.internal.client.ApiClient$WhenMappings;
import com.sendbird.calls.internal.command.ApiRequest;
import com.sendbird.calls.internal.command.ApiResponse;
import com.sendbird.calls.internal.command.Command;
import com.sendbird.calls.internal.command.CommandFactory;
import com.sendbird.calls.internal.command.ErrorResponse;
import com.sendbird.calls.internal.command.Request;
import com.sendbird.calls.internal.util.Logger;
import com.sendbird.calls.shadow.okhttp3.Call;
import com.sendbird.calls.shadow.okhttp3.Callback;
import com.sendbird.calls.shadow.okhttp3.MediaType;
import com.sendbird.calls.shadow.okhttp3.OkHttpClient;
import com.sendbird.calls.shadow.okhttp3.Request;
import com.sendbird.calls.shadow.okhttp3.RequestBody;
import com.sendbird.calls.shadow.okhttp3.Response;
import com.sendbird.calls.shadow.okhttp3.ResponseBody;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0002JT\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00172B\u0010\u0018\u001a>\u0012\u0015\u0012\u0013\u0018\u00010\u0003\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0015\u0012\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0019j\u0004\u0018\u0001`\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0002JY\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2B\u0010\u0018\u001a>\u0012\u0015\u0012\u0013\u0018\u00010%\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(!\u0012\u0015\u0012\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0019j\u0004\u0018\u0001`&H\u0000\u00a2\u0006\u0002\b'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00038@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lcom/sendbird/calls/internal/client/ApiClient;", "", "baseUrl", "", "clientId", "(Ljava/lang/String;Ljava/lang/String;)V", "getClientId$calls_release", "()Ljava/lang/String;", "mediaTypeJson", "Lcom/sendbird/calls/shadow/okhttp3/MediaType;", "okHttpClient", "Lcom/sendbird/calls/shadow/okhttp3/OkHttpClient;", "<set-?>", "sessionToken", "getSessionToken$calls_release", "setSessionToken$calls_release", "(Ljava/lang/String;)V", "getHttpUrl", "request", "Lcom/sendbird/calls/internal/command/ApiRequest;", "getOSVersion", "newCall", "", "Lcom/sendbird/calls/shadow/okhttp3/Request;", "handler", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "body", "Lcom/sendbird/calls/SendBirdException;", "e", "Lcom/sendbird/calls/internal/client/ApiResponseHandler;", "parseResponse", "response", "Lcom/sendbird/calls/shadow/okhttp3/Response;", "send", "command", "Lcom/sendbird/calls/internal/command/Command;", "Lcom/sendbird/calls/internal/util/ResponseHandler;", "send$calls_release", "calls_release"})
public final class ApiClient {
    @NotNull
    private final String clientId;
    @NotNull
    private String sessionToken;
    private final OkHttpClient okHttpClient;
    private final MediaType mediaTypeJson;
    private final String baseUrl;

    @NotNull
    public final /* synthetic */ String getClientId$calls_release() {
        return this.clientId;
    }

    @NotNull
    public final /* synthetic */ String getSessionToken$calls_release() {
        return this.sessionToken;
    }

    public final /* synthetic */ void setSessionToken$calls_release(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.sessionToken = string;
    }

    public final /* synthetic */ void send$calls_release(@NotNull Command command, @Nullable Function2<? super Command, ? super SendBirdException, Unit> handler) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Logger.d("[ApiClient] send(command: " + command + ", handler: " + handler + ") baseUrl: " + this.baseUrl + ", clientId: " + this.clientId);
        if (!(command instanceof ApiRequest)) {
            return;
        }
        CharSequence charSequence = ((ApiRequest)command).getUrl();
        boolean bl = false;
        if (charSequence.length() == 0) {
            Logger.e("[ApiClient] url is empty. " + ((ApiRequest)command).getClass().getSimpleName());
            Function2<? super Command, ? super SendBirdException, Unit> function2 = handler;
            if (function2 != null) {
                Unit cfr_ignored_0 = (Unit)function2.invoke(null, (Object)SendBirdException.Companion.getSendBirdException$calls_release("HTTP URL"));
            }
            return;
        }
        Request.Builder requestBuilder = new Request.Builder().header("Content-Type", "application/json").header("Connection", "Keep-Alive").header("User-Agent", "calls-android/1.4.2").header("SendBird", "android," + this.getOSVersion() + "," + "1.4.2").header("SBCall-Client-Id", this.clientId);
        CharSequence charSequence2 = this.sessionToken;
        boolean bl2 = false;
        if (charSequence2.length() > 0) {
            requestBuilder.header("SBCall-Session-Token", this.sessionToken);
        } else if (((ApiRequest)command).isSessionTokenRequired()) {
            Logger.e("[ApiClient] sessionToken is null.");
            Function2<? super Command, ? super SendBirdException, Unit> function2 = handler;
            if (function2 != null) {
                Unit cfr_ignored_1 = (Unit)function2.invoke(null, (Object)SendBirdException.Companion.getSendBirdException$calls_release(1800303));
            }
            return;
        }
        String string = ((ApiRequest)command).getShortLivedToken();
        if (string != null) {
            charSequence2 = string;
            bl2 = false;
            boolean bl3 = false;
            CharSequence it = charSequence2;
            boolean bl4 = false;
            requestBuilder.header("sbcall-short-time-token", (String)it);
        }
        Logger.d("[ApiClient] API request: " + (Object)((Object)((ApiRequest)command).getMethod()) + " " + this.getHttpUrl((ApiRequest)command) + " payload: " + ((ApiRequest)command).getPayload());
        switch (ApiClient$WhenMappings.$EnumSwitchMapping$0[((ApiRequest)command).getMethod().ordinal()]) {
            case 1: {
                requestBuilder.get();
                requestBuilder.url(this.getHttpUrl((ApiRequest)command));
                break;
            }
            case 2: {
                requestBuilder.post(RequestBody.create((MediaType)this.mediaTypeJson, (String)((ApiRequest)command).getPayload()));
                requestBuilder.url(this.baseUrl + ((ApiRequest)command).getUrl());
                break;
            }
            case 3: {
                requestBuilder.put(RequestBody.create((MediaType)this.mediaTypeJson, (String)((ApiRequest)command).getPayload()));
                requestBuilder.url(this.baseUrl + ((ApiRequest)command).getUrl());
                break;
            }
            case 4: {
                requestBuilder.delete(RequestBody.create((MediaType)this.mediaTypeJson, (String)((ApiRequest)command).getPayload()));
                requestBuilder.url(this.baseUrl + ((ApiRequest)command).getUrl());
                break;
            }
        }
        com.sendbird.calls.shadow.okhttp3.Request request = requestBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"requestBuilder.build()");
        this.newCall(request, (Function2<? super String, ? super SendBirdException, Unit>)((Function2)new Function2<String, SendBirdException, Unit>(command, handler){
            final /* synthetic */ Command $command;
            final /* synthetic */ Function2 $handler;

            public final void invoke(@Nullable String body, @Nullable SendBirdException e) {
                block12: {
                    String string = body;
                    if (string != null) {
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        Command response = CommandFactory.Companion.parseApiCommand$calls_release((Request)this.$command, body);
                        if (response == null) {
                            Logger.e("[ApiClient] Failed to parse response into Command.");
                            Function2 function2 = this.$handler;
                            if (function2 != null) {
                                Unit cfr_ignored_0 = (Unit)function2.invoke(null, (Object)SendBirdException.Companion.getSendBirdExceptionWithMessage$calls_release(1800205, "Failed to parse response"));
                            }
                        } else if (response instanceof ErrorResponse) {
                            Function2 function2 = this.$handler;
                            if (function2 != null) {
                                Unit cfr_ignored_1 = (Unit)function2.invoke((Object)response, (Object)SendBirdException.Companion.getSendBirdExceptionWithMessage$calls_release(((ErrorResponse)response).getCode(), ((ErrorResponse)response).getMessage()));
                            }
                        } else if (response instanceof ApiResponse) {
                            Function2 function2 = this.$handler;
                            if (function2 != null) {
                                Unit cfr_ignored_2 = (Unit)function2.invoke((Object)response, null);
                            }
                        } else {
                            Function2 function2 = this.$handler;
                            if (function2 != null) {
                                Unit cfr_ignored_3 = (Unit)function2.invoke(null, (Object)SendBirdException.Companion.getSendBirdExceptionWithMessage$calls_release(1800205, "Parsed command " + response.getClass().getSimpleName() + " is not a ApiResponse."));
                            }
                        }
                        return;
                    }
                    SendBirdException sendBirdException = e;
                    if (sendBirdException == null) break block12;
                    SendBirdException sendBirdException2 = sendBirdException;
                    boolean bl = false;
                    boolean bl4 = false;
                    SendBirdException it = sendBirdException2;
                    boolean bl5 = false;
                    Function2 function2 = this.$handler;
                    if (function2 != null) {
                        Unit cfr_ignored_4 = (Unit)function2.invoke(null, (Object)e);
                    }
                }
            }
            {
                this.$command = command;
                this.$handler = function2;
                super(2);
            }
        }));
    }

    private final void newCall(com.sendbird.calls.shadow.okhttp3.Request request, Function2<? super String, ? super SendBirdException, Unit> handler) {
        this.okHttpClient.newCall(request).enqueue(new Callback(this, request, handler){
            final /* synthetic */ ApiClient this$0;
            final /* synthetic */ com.sendbird.calls.shadow.okhttp3.Request $request;
            final /* synthetic */ Function2 $handler;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    Logger.e("[ApiClient] onFailure(). request = " + this.$request.toString() + " isCanceled = " + call.isCanceled() + ", " + Log.getStackTraceString((Throwable)e));
                    if (call.isCanceled()) break block1;
                    Function2 function2 = this.$handler;
                    if (function2 != null) {
                        Unit cfr_ignored_0 = (Unit)function2.invoke(null, (Object)SendBirdException.Companion.getSendBirdExceptionWithMessage$calls_release(1800200, e.getMessage()));
                    }
                }
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    try {
                        String body = ApiClient.access$parseResponse(this.this$0, response);
                        Function2 function2 = this.$handler;
                        if (function2 == null) break block2;
                        Unit cfr_ignored_0 = (Unit)function2.invoke((Object)body, null);
                    }
                    catch (SendBirdException e) {
                        Logger.e("[ApiClient] Failed to parse response. " + e);
                        Function2 function2 = this.$handler;
                        if (function2 == null) break block2;
                        Unit cfr_ignored_1 = (Unit)function2.invoke(null, (Object)e);
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$request = $captured_local_variable$1;
                this.$handler = $captured_local_variable$2;
            }
        });
    }

    private final String parseResponse(Response response) throws SendBirdException {
        ResponseBody responseBody = response.body();
        if (responseBody != null) {
            String string;
            try {
                String body = responseBody.string();
                Logger.d("[ApiClient] API response: " + response.code() + " " + body);
                String string2 = body;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"body");
                string = string2;
            }
            catch (Exception e) {
                Logger.e("[ApiClient] Failed to get Response's body. " + e.getMessage());
                throw (Throwable)SendBirdException.Companion.getSendBirdExceptionWithMessage$calls_release(1800200, e.getMessage());
            }
            return string;
        }
        throw (Throwable)SendBirdException.Companion.getSendBirdExceptionWithMessage$calls_release(1800200, "Response is null");
    }

    private final String getOSVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    private final String getHttpUrl(ApiRequest request) {
        if (request.getMethod() == ApiRequest.HttpRequestMethod.GET) {
            String url = this.baseUrl + request.getUrl();
            CharSequence charSequence = request.getPayload();
            boolean bl = false;
            if (charSequence.length() > 0) {
                url = url + "?" + request.getPayload();
            }
            return url;
        }
        return request.getUrl();
    }

    public ApiClient(@NotNull String baseUrl, @NotNull String clientId) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        this.baseUrl = baseUrl;
        this.clientId = clientId;
        this.sessionToken = "";
        this.okHttpClient = new OkHttpClient();
        this.mediaTypeJson = MediaType.parse((String)"application/json; charset=utf-8");
        Logger.d("[ApiClient] init(baseUrl: " + this.baseUrl + ", clientId: " + clientId + ')');
    }

    public static final /* synthetic */ String access$parseResponse(ApiClient $this, Response response) {
        return $this.parseResponse(response);
    }
}

