/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.os.Build;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.internal.util.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\r\u0010\u0016\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\tH\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0015\u0010!\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\"J\r\u0010#\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b&J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/sendbird/calls/internal/SoundManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "audioManager", "Landroid/media/AudioManager;", "playQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/sendbird/calls/SendBirdCall$SoundType;", "refCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "soundPool", "Landroid/media/SoundPool;", "soundTypeAndIsPlayingMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "soundTypeAndMetaDataMap", "Lcom/sendbird/calls/internal/SoundManager$SoundMetaData;", "init", "", "init$calls_release", "isNotPlayingAnySoundType", "isNotPlayingAnySoundType$calls_release", "isOnlySoundTypePlaying", "soundType", "isOnlySoundTypePlaying$calls_release", "isPlaying", "isPlayingForTest", "loadDefaultSounds", "loadSound", "resId", "", "playSound", "playSound$calls_release", "release", "release$calls_release", "stopSound", "stopSound$calls_release", "unloadSound", "SoundMetaData", "calls_release"})
public final class SoundManager {
    private final AudioManager audioManager;
    private SoundPool soundPool;
    private final AtomicInteger refCount;
    private final ConcurrentHashMap<SendBirdCall.SoundType, SoundMetaData> soundTypeAndMetaDataMap;
    private final ConcurrentLinkedQueue<SendBirdCall.SoundType> playQueue;
    private final ConcurrentHashMap<SendBirdCall.SoundType, Boolean> soundTypeAndIsPlayingMap;
    private final Context context;

    public final /* synthetic */ void init$calls_release() {
        if (this.refCount.getAndIncrement() == 0) {
            if (this.soundPool == null) {
                Logger.d("[SoundManager] init()");
                int maxStreams = 2;
                SoundPool soundPool = this.soundPool = Build.VERSION.SDK_INT >= 21 ? new SoundPool.Builder().setMaxStreams(maxStreams).build() : new SoundPool(maxStreams, 3, 0);
                if (soundPool != null) {
                    soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(this){
                        final /* synthetic */ SoundManager this$0;

                        public final void onLoadComplete(@Nullable SoundPool $noName_0, int sampleId, int status) {
                            Logger.d("[SoundManager] setOnLoadCompleteListener() => sampleId: " + sampleId + ", status: " + status);
                            for (SoundMetaData soundMetaData : SoundManager.access$getSoundTypeAndMetaDataMap$p(this.this$0).values()) {
                                Integer n = soundMetaData.getSoundId();
                                if (n == null || n != sampleId) continue;
                                soundMetaData.setLoadedInSoundPool(true);
                                break;
                            }
                            for (SendBirdCall.SoundType soundType : SoundManager.access$getPlayQueue$p(this.this$0)) {
                                SoundMetaData soundMetaData;
                                SoundMetaData soundMetaData2 = soundMetaData = (SoundMetaData)SoundManager.access$getSoundTypeAndMetaDataMap$p(this.this$0).get((Object)((Object)soundType));
                                Integer n = soundMetaData2 != null ? soundMetaData2.getSoundId() : null;
                                if (n == null || n != sampleId) continue;
                                SoundManager.access$getPlayQueue$p(this.this$0).remove((Object)((Object)soundType));
                                SendBirdCall.SoundType soundType2 = soundType;
                                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)soundType2), (String)"soundType");
                                this.this$0.playSound$calls_release(soundType2);
                                break;
                            }
                        }
                        {
                            this.this$0 = soundManager;
                        }
                    });
                }
            }
        } else {
            Logger.d("[SoundManager] init() => mRefCount: " + this.refCount);
        }
        this.loadDefaultSounds();
    }

    private final void loadDefaultSounds() {
        if (this.soundPool != null) {
            Logger.d("[SoundManager] loadDefaultSounds()");
            for (SendBirdCall.SoundType soundType : SendBirdCall.SoundType.values()) {
                Integer resId = SendBirdCall.Options.getSoundResIdMap().get((Object)soundType);
                if (resId != null) {
                    this.loadSound(soundType, resId);
                    continue;
                }
                this.unloadSound(soundType);
            }
        }
    }

    private final void loadSound(SendBirdCall.SoundType soundType, int resId) {
        SoundMetaData soundMetaData = this.soundTypeAndMetaDataMap.get((Object)soundType);
        if (soundMetaData != null) {
            if (soundMetaData.isLoaded(resId)) {
                return;
            }
            if (soundMetaData.isLoaded()) {
                this.unloadSound(soundType);
            }
        }
        if (soundType == SendBirdCall.SoundType.RECONNECTING || soundType == SendBirdCall.SoundType.RECONNECTED) {
            try {
                MediaPlayer mediaPlayer = MediaPlayer.create((Context)this.context, (int)resId);
                if (mediaPlayer != null) {
                    mediaPlayer.setLooping(false);
                    Logger.d("[SoundManager] loadSound(soundType: " + (Object)((Object)soundType) + ", resId: " + resId + ')');
                    ((Map)this.soundTypeAndMetaDataMap).put(soundType, new SoundMetaData(resId, null, null, mediaPlayer));
                }
            }
            catch (Exception e) {
                Logger.w("[SoundManager] loadSound(soundType: " + (Object)((Object)soundType) + ", resId: " + resId + ") => e: " + e.getMessage());
            }
            return;
        }
        try {
            SoundPool soundPool = this.soundPool;
            Integer soundId = soundPool != null ? Integer.valueOf(soundPool.load(this.context, resId, 1)) : null;
            Logger.d("[SoundManager] loadSound(soundType: " + (Object)((Object)soundType) + ", soundId: " + soundId + ", resId: " + resId + ')');
            ((Map)this.soundTypeAndMetaDataMap).put(soundType, new SoundMetaData(resId, soundId, null, null));
        }
        catch (Exception e) {
            Logger.w("[SoundManager] loadSound(soundType: " + (Object)((Object)soundType) + ", resId: " + resId + ") => e: " + e.getMessage());
        }
    }

    public final /* synthetic */ void playSound$calls_release(@NotNull SendBirdCall.SoundType soundType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)soundType), (String)"soundType");
        SoundMetaData soundMetaData = this.soundTypeAndMetaDataMap.get((Object)soundType);
        if (soundMetaData == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)soundMetaData, (String)"soundTypeAndMetaDataMap[soundType] ?: return");
        SoundMetaData soundMetaData2 = soundMetaData;
        if (soundType == SendBirdCall.SoundType.DIALING || soundType == SendBirdCall.SoundType.RINGING) {
            this.stopSound$calls_release(SendBirdCall.SoundType.DIALING);
            this.stopSound$calls_release(SendBirdCall.SoundType.RINGING);
        }
        ((Map)this.soundTypeAndIsPlayingMap).put(soundType, true);
        if (soundType == SendBirdCall.SoundType.RECONNECTING || soundType == SendBirdCall.SoundType.RECONNECTED) {
            MediaPlayer mediaPlayer = soundMetaData2.getMediaPlayer();
            if (mediaPlayer != null) {
                Logger.d("[SoundManager] playSound(soundType: " + (Object)((Object)soundType) + ')');
                mediaPlayer.start();
            }
            return;
        }
        Integer soundId = soundMetaData2.getSoundId();
        if (soundId != null) {
            boolean isLoaded = soundMetaData2.isLoadedInSoundPool();
            if (isLoaded) {
                int loop;
                float streamVolume = this.audioManager.getStreamVolume(3);
                float streamMaxVolume = this.audioManager.getStreamMaxVolume(3);
                float volume = streamVolume / streamMaxVolume;
                int n = loop = soundType == SendBirdCall.SoundType.DIALING || soundType == SendBirdCall.SoundType.RINGING ? -1 : 0;
                if (this.audioManager.getRingerMode() == 2 || soundType == SendBirdCall.SoundType.DIALING && SendBirdCall.Options.getDialingSoundOnWhenSilentOrVibrateMode()) {
                    SoundPool soundPool = this.soundPool;
                    Integer streamId = soundPool != null ? Integer.valueOf(soundPool.play(soundId.intValue(), volume, volume, 1, loop, 1.0f)) : null;
                    Logger.d("[SoundManager] playSound(soundType: " + (Object)((Object)soundType) + ") => soundId: " + soundId + ", volume: " + volume + ", streamVolume: " + streamVolume + ", streamMaxVolume: " + streamMaxVolume);
                    Logger.d("[SoundManager] playSound(soundType: " + (Object)((Object)soundType) + ") => streamId: " + streamId);
                    soundMetaData2.setStreamId(streamId);
                } else {
                    Logger.d("[SoundManager] playSound(soundType: " + (Object)((Object)soundType) + ") => mAudioManager.getRingerMode(): " + this.audioManager.getRingerMode());
                }
            } else {
                Logger.d("[SoundManager] mPlayQueue.add(soundType: " + (Object)((Object)soundType) + ", soundId: " + soundId + ')');
                this.playQueue.add(soundType);
            }
        }
    }

    public final /* synthetic */ void stopSound$calls_release(@NotNull SendBirdCall.SoundType soundType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)soundType), (String)"soundType");
        SoundMetaData soundMetaData = this.soundTypeAndMetaDataMap.get((Object)soundType);
        if (soundMetaData == null) {
            Logger.d("[SoundManager] soundMetaData is null");
            return;
        }
        ((Map)this.soundTypeAndIsPlayingMap).put(soundType, false);
        if (soundType == SendBirdCall.SoundType.RECONNECTING || soundType == SendBirdCall.SoundType.RECONNECTED) {
            MediaPlayer mediaPlayer = soundMetaData.getMediaPlayer();
            if (mediaPlayer != null && mediaPlayer.isPlaying()) {
                Logger.d("[SoundManager] stopSound(soundType: " + (Object)((Object)soundType) + ')');
                mediaPlayer.stop();
            }
            return;
        }
        Integer streamId = soundMetaData.getStreamId();
        if (streamId != null) {
            Logger.d("[SoundManager] stopSound(soundType: " + (Object)((Object)soundType) + ", streamId: " + streamId + ')');
            SoundPool soundPool = this.soundPool;
            if (soundPool != null) {
                soundPool.stop(streamId.intValue());
            }
            soundMetaData.setStreamId(null);
        }
        this.playQueue.remove((Object)soundType);
    }

    private final void unloadSound(SendBirdCall.SoundType soundType) {
        SoundMetaData soundMetaData = this.soundTypeAndMetaDataMap.get((Object)soundType);
        if (soundMetaData == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)soundMetaData, (String)"soundTypeAndMetaDataMap[soundType] ?: return");
        SoundMetaData soundMetaData2 = soundMetaData;
        this.stopSound$calls_release(soundType);
        if (soundType == SendBirdCall.SoundType.RECONNECTING || soundType == SendBirdCall.SoundType.RECONNECTED) {
            MediaPlayer mediaPlayer = soundMetaData2.getMediaPlayer();
            if (mediaPlayer != null) {
                Logger.d("[SoundManager] unloadSound(soundType: " + (Object)((Object)soundType) + ')');
                mediaPlayer.release();
                soundMetaData2.setMediaPlayer(null);
            }
            return;
        }
        Integer soundId = soundMetaData2.getSoundId();
        if (soundId != null) {
            Logger.d("[SoundManager] unloadSound(soundType: " + (Object)((Object)soundType) + ", soundId: " + soundId + ')');
            SoundPool soundPool = this.soundPool;
            if (soundPool != null) {
                soundPool.unload(soundId.intValue());
            }
            soundMetaData2.setSoundId(null);
            soundMetaData2.setLoadedInSoundPool(false);
        }
    }

    public final /* synthetic */ void release$calls_release() {
        if (this.refCount.getAndDecrement() == 1) {
            if (this.soundPool != null) {
                for (SendBirdCall.SoundType soundType : SendBirdCall.SoundType.values()) {
                    this.unloadSound(soundType);
                }
                Logger.d("[SoundManager] release()");
                this.soundTypeAndMetaDataMap.clear();
                this.playQueue.clear();
                SoundPool soundPool = this.soundPool;
                if (soundPool != null) {
                    soundPool.release();
                }
                this.soundPool = null;
            }
        } else {
            Logger.d("[SoundManager] release() => mRefCount: " + this.refCount);
        }
    }

    private final boolean isPlaying(SendBirdCall.SoundType soundType) {
        SoundMetaData soundMetaData = this.soundTypeAndMetaDataMap.get((Object)soundType);
        if (soundMetaData == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)soundMetaData, (String)"soundTypeAndMetaDataMap[soundType] ?: return false");
        SoundMetaData soundMetaData2 = soundMetaData;
        boolean result = false;
        if (soundType == SendBirdCall.SoundType.RECONNECTING || soundType == SendBirdCall.SoundType.RECONNECTED) {
            MediaPlayer mediaPlayer = soundMetaData2.getMediaPlayer();
            if (mediaPlayer != null && mediaPlayer.isPlaying()) {
                result = true;
            }
        } else {
            Integer streamId = soundMetaData2.getStreamId();
            if (streamId != null) {
                result = true;
            }
        }
        return result;
    }

    private final boolean isPlayingForTest(SendBirdCall.SoundType soundType) {
        Boolean isPlayingForTest = this.soundTypeAndIsPlayingMap.get((Object)soundType);
        return isPlayingForTest != null && isPlayingForTest != false;
    }

    public final /* synthetic */ boolean isOnlySoundTypePlaying$calls_release(@NotNull SendBirdCall.SoundType soundType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)soundType), (String)"soundType");
        boolean result = true;
        for (SendBirdCall.SoundType soundType1 : SendBirdCall.SoundType.values()) {
            if (soundType1 == soundType) {
                if (this.isPlayingForTest(soundType1)) continue;
                result = false;
                break;
            }
            if (!this.isPlayingForTest(soundType1)) continue;
            result = false;
            break;
        }
        return result;
    }

    public final /* synthetic */ boolean isNotPlayingAnySoundType$calls_release() {
        boolean result = true;
        for (SendBirdCall.SoundType soundType : SendBirdCall.SoundType.values()) {
            if (!this.isPlayingForTest(soundType)) continue;
            result = false;
            break;
        }
        return result;
    }

    public SoundManager(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.refCount = new AtomicInteger(0);
        this.soundTypeAndMetaDataMap = new ConcurrentHashMap();
        this.playQueue = new ConcurrentLinkedQueue();
        Logger.d("[SoundManager] SoundManager()");
        Object object = this.context.getSystemService("audio");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
        }
        this.audioManager = (AudioManager)object;
        this.soundTypeAndIsPlayingMap = new ConcurrentHashMap();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSoundTypeAndMetaDataMap$p(SoundManager $this) {
        return $this.soundTypeAndMetaDataMap;
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getPlayQueue$p(SoundManager $this) {
        return $this.playQueue;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000b\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lcom/sendbird/calls/internal/SoundManager$SoundMetaData;", "", "resId", "", "soundId", "streamId", "mediaPlayer", "Landroid/media/MediaPlayer;", "(ILjava/lang/Integer;Ljava/lang/Integer;Landroid/media/MediaPlayer;)V", "isLoaded", "", "()Z", "isLoadedInSoundPool", "setLoadedInSoundPool", "(Z)V", "getMediaPlayer", "()Landroid/media/MediaPlayer;", "setMediaPlayer", "(Landroid/media/MediaPlayer;)V", "getResId", "()I", "setResId", "(I)V", "getSoundId", "()Ljava/lang/Integer;", "setSoundId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getStreamId", "setStreamId", "calls_release"})
    private static final class SoundMetaData {
        private boolean isLoadedInSoundPool;
        private int resId;
        @Nullable
        private Integer soundId;
        @Nullable
        private Integer streamId;
        @Nullable
        private MediaPlayer mediaPlayer;

        public final boolean isLoadedInSoundPool() {
            return this.isLoadedInSoundPool;
        }

        public final void setLoadedInSoundPool(boolean bl) {
            this.isLoadedInSoundPool = bl;
        }

        public final boolean isLoaded() {
            return this.soundId != null || this.mediaPlayer != null;
        }

        public final boolean isLoaded(int resId) {
            return this.isLoaded() && this.resId == resId;
        }

        public final int getResId() {
            return this.resId;
        }

        public final void setResId(int n) {
            this.resId = n;
        }

        @Nullable
        public final Integer getSoundId() {
            return this.soundId;
        }

        public final void setSoundId(@Nullable Integer n) {
            this.soundId = n;
        }

        @Nullable
        public final Integer getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(@Nullable Integer n) {
            this.streamId = n;
        }

        @Nullable
        public final MediaPlayer getMediaPlayer() {
            return this.mediaPlayer;
        }

        public final void setMediaPlayer(@Nullable MediaPlayer mediaPlayer) {
            this.mediaPlayer = mediaPlayer;
        }

        public SoundMetaData(int resId, @Nullable Integer soundId, @Nullable Integer streamId, @Nullable MediaPlayer mediaPlayer) {
            this.resId = resId;
            this.soundId = soundId;
            this.streamId = streamId;
            this.mediaPlayer = mediaPlayer;
        }
    }
}

