/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.util;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.internal.model.IceConnection;
import com.sendbird.calls.internal.util.ExtensionsKt;
import com.sendbird.calls.shadow.com.google.gson.JsonElement;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.RTCStats;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0007Jh\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0007J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020 H\u0002J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010%\u001a\u00020\n2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\u001c\u0010&\u001a\u00020 2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\u001c\u0010'\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J>\u0010(\u001a\u00020\u00042\b\u0010)\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010+\u001a\u00020,2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006-"}, d2={"Lcom/sendbird/calls/internal/util/RtcStatsUtils;", "", "()V", "getAudioStreamStats", "Lcom/sendbird/calls/shadow/com/google/gson/JsonObject;", "audioStreamStats", "currentStatsMeasureCount", "", "rtcStatsMap", "", "", "Lorg/webrtc/RTCStats;", "prevTotalPacketsReceived", "", "prevTotalPacketsLost", "getCommonStats", "context", "Landroid/content/Context;", "appId", "callId", "callerId", "calleeId", "role", "Lcom/sendbird/calls/DirectCallUserRole;", "isVideoCall", "", "measureCount", "measureInterval", "getIceConnection", "Lcom/sendbird/calls/internal/model/IceConnection;", "commonStats", "getMos", "", "jitter", "latency", "packetsLostRate", "getNetworkOperatorName", "getNetworkType", "getTimestamp", "getTransportInfo", "getVideoStreamStats", "videoStreamStats", "getWifiLevel", "removeSpotValues", "", "calls_release"})
public final class RtcStatsUtils {
    public static final RtcStatsUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final /* synthetic */ JsonObject getCommonStats(@NotNull Context context, @NotNull Map<String, ? extends RTCStats> rtcStatsMap, @NotNull String appId, @Nullable String callId, @NotNull String callerId, @NotNull String calleeId, @Nullable DirectCallUserRole role, boolean isVideoCall, int measureCount, int measureInterval) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(rtcStatsMap, (String)"rtcStatsMap");
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        Intrinsics.checkParameterIsNotNull((Object)callerId, (String)"callerId");
        Intrinsics.checkParameterIsNotNull((Object)calleeId, (String)"calleeId");
        JsonObject obj = new JsonObject();
        obj.addProperty("webrtc_timestamp", (Number)INSTANCE.getTimestamp(rtcStatsMap));
        obj.addProperty("device_timestamp", (Number)System.currentTimeMillis());
        obj.addProperty("network_type", INSTANCE.getNetworkType(rtcStatsMap));
        obj.add("transport_info", (JsonElement)INSTANCE.getTransportInfo(rtcStatsMap));
        obj.addProperty("app_id", appId);
        obj.addProperty("call_id", String.valueOf(callId));
        obj.addProperty("role", String.valueOf(role));
        obj.addProperty("is_video_call", Boolean.valueOf(isVideoCall));
        obj.addProperty("caller_id", callerId);
        obj.addProperty("callee_id", calleeId);
        obj.addProperty("network_operator_name", INSTANCE.getNetworkOperatorName(context));
        obj.addProperty("wifi_signal_level", (Number)INSTANCE.getWifiLevel(context));
        JsonObject metaDataObj = new JsonObject();
        metaDataObj.addProperty("measure_count", (Number)measureCount);
        metaDataObj.addProperty("measure_interval", (Number)measureInterval);
        obj.add("metadata", (JsonElement)metaDataObj);
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final /* synthetic */ JsonObject getAudioStreamStats(@Nullable JsonObject audioStreamStats, int currentStatsMeasureCount, @NotNull Map<String, ? extends RTCStats> rtcStatsMap, long prevTotalPacketsReceived, int prevTotalPacketsLost) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(rtcStatsMap, (String)"rtcStatsMap");
        JsonObject obj = new JsonObject();
        int prevAverageCount = currentStatsMeasureCount - 1;
        Object object = rtcStatsMap;
        boolean bl2 = false;
        Iterator<Map.Entry<String, ? extends RTCStats>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Double d;
            boolean bl3;
            boolean bl4;
            JsonObject jsonObject;
            double it;
            Map<String, Object> members;
            void key;
            Map.Entry<String, ? extends RTCStats> entry;
            Map.Entry<String, ? extends RTCStats> entry2 = entry = iterator.next();
            boolean bl5 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl5 = false;
            RTCStats value = entry2.getValue();
            if (StringsKt.startsWith$default((String)key, (String)"RTCInboundRTPAudioStream", (boolean)false, (int)2, null)) {
                members = value.getMembers();
                Object object2 = rtcStatsMap;
                Object object3 = members.get("codecId");
                String string = "codec";
                JsonObject jsonObject2 = obj;
                bl = false;
                RTCStats rTCStats = object2.get(object3);
                Object object4 = rTCStats;
                ExtensionsKt.addNullable(jsonObject2, string, object4 != null && (object4 = ((RTCStats)object4).getMembers()) != null ? object4.get("mimeType") : null);
                ExtensionsKt.addNullable(obj, "jitter", members.get("jitter"));
                Object object5 = members.get("jitter");
                if (!(object5 instanceof Double)) {
                    object5 = null;
                }
                Double d2 = (Double)object5;
                if (d2 != null) {
                    object2 = d2;
                    boolean bl6 = false;
                    bl = false;
                    it = ((Number)object2).doubleValue();
                    boolean bl7 = false;
                    float v = (float)(it * (double)1000);
                    ExtensionsKt.addNullable(obj, "spot_jitter", Float.valueOf(v));
                    JsonObject jsonObject3 = audioStreamStats;
                    if (jsonObject3 != null && (jsonObject3 = jsonObject3.get("jitter")) != null) {
                        jsonObject = jsonObject3;
                        bl4 = false;
                        bl3 = false;
                        JsonObject jitter = jsonObject;
                        boolean bl8 = false;
                        v = (jitter.getAsFloat() * (float)prevAverageCount + v) / (float)currentStatsMeasureCount;
                    }
                    ExtensionsKt.addNullable(obj, "jitter", Float.valueOf(v));
                }
                ExtensionsKt.addNullable(obj, "total_packets_lost", members.get("packetsLost"));
                ExtensionsKt.addNullable(obj, "total_packets_received", members.get("packetsReceived"));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"RTCOutboundRTPAudioStream", (boolean)false, (int)2, null)) {
                members = value.getMembers();
                ExtensionsKt.addNullable(obj, "total_packets_sent", members.get("packetsSent"));
                ExtensionsKt.addNullable(obj, "retransmitted_packets_sent", members.get("retransmittedPacketsSent"));
                continue;
            }
            if (!StringsKt.startsWith$default((String)key, (String)"RTCRemoteInboundRtpAudioStream", (boolean)false, (int)2, null)) continue;
            members = value.getMembers();
            Object object6 = members.get("roundTripTime");
            if (!(object6 instanceof Double)) {
                object6 = null;
            }
            if ((Double)object6 == null) continue;
            boolean bl9 = false;
            bl = false;
            it = ((Number)d).doubleValue();
            boolean bl10 = false;
            int v = (int)(it * (double)1000);
            ExtensionsKt.addNullable(obj, "spot_rtt", v);
            JsonObject jsonObject4 = audioStreamStats;
            if (jsonObject4 != null && (jsonObject4 = jsonObject4.get("rtt")) != null) {
                jsonObject = jsonObject4;
                bl4 = false;
                bl3 = false;
                JsonObject rtt = jsonObject;
                boolean bl11 = false;
                v = (int)((rtt.getAsFloat() * (float)prevAverageCount + (float)v) / (float)currentStatsMeasureCount);
            }
            ExtensionsKt.addNullable(obj, "rtt", v);
        }
        if (obj.has("total_packets_lost") && obj.has("total_packets_received")) {
            if (obj.has("jitter") && obj.has("rtt")) {
                JsonElement jsonElement = obj.get("total_packets_lost");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj[\"total_packets_lost\"]");
                int packetsLost = jsonElement.getAsInt() - prevTotalPacketsLost;
                JsonElement jsonElement2 = obj.get("total_packets_received");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"obj[\"total_packets_received\"]");
                long packetsReceived = jsonElement2.getAsLong() - prevTotalPacketsReceived;
                double packetsLostRate = (double)packetsLost / (double)((long)packetsLost + packetsReceived) * (double)100;
                double v = packetsLostRate = Double.isNaN(packetsLostRate) ? 0.0 : packetsLostRate;
                obj.addProperty("spot_packets_lost_rate", (Number)v);
                JsonObject jsonObject = audioStreamStats;
                if (jsonObject != null && (jsonObject = jsonObject.get("packets_lost_rate")) != null) {
                    JsonObject jsonObject5 = jsonObject;
                    bl = false;
                    boolean bl12 = false;
                    JsonObject it = jsonObject5;
                    boolean bl13 = false;
                    v = ((double)(it.getAsFloat() * (float)prevAverageCount) + v) / (double)currentStatsMeasureCount;
                }
                obj.addProperty("packets_lost_rate", (Number)v);
                JsonObject jsonObject6 = audioStreamStats;
                if ((jsonObject6 != null ? jsonObject6.get("packets_lost") : null) != null) {
                    JsonElement jsonElement3 = audioStreamStats.get("packets_lost");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"audioStreamStats.get(\"packets_lost\")");
                    obj.addProperty("packets_lost", (Number)(jsonElement3.getAsInt() + packetsLost));
                } else {
                    obj.addProperty("packets_lost", (Number)packetsLost);
                }
                JsonElement jsonElement4 = obj.get("jitter");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"obj[\"jitter\"]");
                int n = jsonElement4.getAsInt();
                JsonElement jsonElement5 = obj.get("rtt");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement5, (String)"obj[\"rtt\"]");
                double mos = INSTANCE.getMos(n, jsonElement5.getAsInt() / 2, packetsLostRate);
                obj.addProperty("spot_mos", (Number)mos);
                JsonObject jsonObject7 = audioStreamStats;
                if (jsonObject7 != null && (jsonObject7 = jsonObject7.get("mos")) != null) {
                    JsonObject jsonObject8 = jsonObject7;
                    boolean bl14 = false;
                    boolean bl15 = false;
                    JsonObject it = jsonObject8;
                    boolean bl16 = false;
                    mos = ((double)(it.getAsFloat() * (float)prevAverageCount) + mos) / (double)currentStatsMeasureCount;
                }
                obj.addProperty("mos", (Number)mos);
            }
            JsonElement jsonElement = obj.get("total_packets_lost");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj[\"total_packets_lost\"]");
            double d = jsonElement.getAsInt();
            JsonElement jsonElement6 = obj.get("total_packets_lost");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement6, (String)"obj[\"total_packets_lost\"]");
            long l = jsonElement6.getAsInt();
            JsonElement jsonElement7 = obj.get("total_packets_received");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement7, (String)"obj[\"total_packets_received\"]");
            double totalPacketsLostRate = d / (double)(l + jsonElement7.getAsLong()) * (double)100;
            totalPacketsLostRate = Double.isNaN(totalPacketsLostRate) ? 0.0 : totalPacketsLostRate;
            obj.addProperty("total_packets_lost_rate", (Number)totalPacketsLostRate);
        }
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final /* synthetic */ JsonObject getVideoStreamStats(@Nullable JsonObject videoStreamStats, int currentStatsMeasureCount, @NotNull Map<String, ? extends RTCStats> rtcStatsMap, long prevTotalPacketsReceived, int prevTotalPacketsLost) {
        JsonObject it;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(rtcStatsMap, (String)"rtcStatsMap");
        JsonObject obj = new JsonObject();
        int prevAverageCount = currentStatsMeasureCount - 1;
        Object object = rtcStatsMap;
        boolean bl2 = false;
        Iterator<Map.Entry<String, ? extends RTCStats>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Unit unit;
            Map<String, Object> members;
            void key;
            Map.Entry<String, ? extends RTCStats> entry;
            Map.Entry<String, ? extends RTCStats> entry2 = entry = iterator.next();
            boolean bl3 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl3 = false;
            RTCStats value = entry2.getValue();
            if (StringsKt.startsWith$default((String)key, (String)"RTCInboundRTPVideoStream", (boolean)false, (int)2, null)) {
                members = value.getMembers();
                Map<String, ? extends RTCStats> map = rtcStatsMap;
                Object object2 = members.get("codecId");
                String string = "codec";
                JsonObject jsonObject = obj;
                bl = false;
                RTCStats rTCStats = map.get(object2);
                Object object3 = rTCStats;
                ExtensionsKt.addNullable(jsonObject, string, object3 != null && (object3 = ((RTCStats)object3).getMembers()) != null ? object3.get("mimeType") : null);
                ExtensionsKt.addNullable(obj, "fir_count", members.get("firCount"));
                ExtensionsKt.addNullable(obj, "pli_count", members.get("pliCount"));
                ExtensionsKt.addNullable(obj, "nack_count", members.get("nackCount"));
                ExtensionsKt.addNullable(obj, "qp_sum", members.get("qpSum"));
                ExtensionsKt.addNullable(obj, "bytes_received", members.get("bytesReceived"));
                ExtensionsKt.addNullable(obj, "total_packets_received", members.get("packetsReceived"));
                ExtensionsKt.addNullable(obj, "header_bytes_received", members.get("headerBytesReceived"));
                ExtensionsKt.addNullable(obj, "total_packets_lost", members.get("packetsLost"));
                ExtensionsKt.addNullable(obj, "frames_decoded", members.get("framesDecoded"));
                ExtensionsKt.addNullable(obj, "key_frames_decoded", members.get("keyFramesDecoded"));
                ExtensionsKt.addNullable(obj, "total_inter_frame_delay", members.get("totalInterFrameDelay"));
                ExtensionsKt.addNullable(obj, "total_squared_inter_frame_delay", members.get("totalSquaredInterFrameDelay"));
                ExtensionsKt.addNullable(obj, "total_decode_time", members.get("totalDecodeTime"));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"RTCMediaStreamTrack_receiver", (boolean)false, (int)2, null)) {
                Unit unit2;
                Unit unit3;
                boolean bl4;
                members = value.getMembers();
                if (Intrinsics.areEqual((Object)members.get("kind"), (Object)"video") ^ true) continue;
                Object v = members.get("frameWidth");
                ExtensionsKt.addNullable(obj, "spot_received_frame_width", v);
                JsonObject jsonObject = videoStreamStats;
                if (jsonObject != null && (jsonObject = jsonObject.get("received_frame_width")) != null) {
                    JsonObject jsonObject2 = jsonObject;
                    bl = false;
                    bl4 = false;
                    it = jsonObject2;
                    boolean bl5 = false;
                    Object object4 = v;
                    if (object4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                    }
                    v = Float.valueOf((it.getAsFloat() * (float)prevAverageCount + (float)((Long)object4).longValue()) / (float)currentStatsMeasureCount);
                    unit3 = Unit.INSTANCE;
                } else {
                    unit3 = null;
                }
                ExtensionsKt.addNullable(obj, "received_frame_width", v);
                v = members.get("frameHeight");
                ExtensionsKt.addNullable(obj, "spot_received_frame_height", v);
                JsonObject jsonObject3 = videoStreamStats;
                if (jsonObject3 != null && (jsonObject3 = jsonObject3.get("received_frame_height")) != null) {
                    JsonObject jsonObject4 = jsonObject3;
                    bl = false;
                    bl4 = false;
                    it = jsonObject4;
                    boolean bl6 = false;
                    Object object5 = v;
                    if (object5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                    }
                    v = Float.valueOf((it.getAsFloat() * (float)prevAverageCount + (float)((Long)object5).longValue()) / (float)currentStatsMeasureCount);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                ExtensionsKt.addNullable(obj, "received_frame_height", v);
                ExtensionsKt.addNullable(obj, "frames_received", members.get("framesReceived"));
                ExtensionsKt.addNullable(obj, "frames_dropped", members.get("framesDropped"));
                ExtensionsKt.addNullable(obj, "freeze_count", members.get("freezeCount"));
                ExtensionsKt.addNullable(obj, "pause_count", members.get("pauseCount"));
                ExtensionsKt.addNullable(obj, "jitter_buffer_delay", members.get("jitterBufferDelay"));
                ExtensionsKt.addNullable(obj, "jitter_buffer_emitted_count", members.get("jitterBufferEmittedCount"));
                ExtensionsKt.addNullable(obj, "total_freezes_duration", members.get("totalFreezesDuration"));
                ExtensionsKt.addNullable(obj, "total_pauses_duration", members.get("totalPausesDuration"));
                ExtensionsKt.addNullable(obj, "total_frames_duration", members.get("totalFramesDuration"));
                ExtensionsKt.addNullable(obj, "sum_of_squared_frames_duration", members.get("sumOfSquaredFramesDuration"));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"RTCMediaStreamTrack_sender", (boolean)false, (int)2, null)) {
                Unit unit4;
                Unit unit5;
                members = value.getMembers();
                if (Intrinsics.areEqual((Object)members.get("kind"), (Object)"video") ^ true) continue;
                Object v = members.get("frameWidth");
                ExtensionsKt.addNullable(obj, "spot_sent_frame_width", v);
                JsonObject jsonObject = videoStreamStats;
                if (jsonObject != null && (jsonObject = jsonObject.get("sent_frame_width")) != null) {
                    JsonObject jsonObject5 = jsonObject;
                    bl = false;
                    boolean bl7 = false;
                    it = jsonObject5;
                    boolean bl8 = false;
                    Object object6 = v;
                    if (object6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                    }
                    v = Float.valueOf((it.getAsFloat() * (float)prevAverageCount + (float)((Long)object6).longValue()) / (float)currentStatsMeasureCount);
                    unit5 = Unit.INSTANCE;
                } else {
                    unit5 = null;
                }
                ExtensionsKt.addNullable(obj, "sent_frame_width", v);
                v = members.get("frameHeight");
                ExtensionsKt.addNullable(obj, "spot_sent_frame_height", v);
                JsonObject jsonObject6 = videoStreamStats;
                if (jsonObject6 != null && (jsonObject6 = jsonObject6.get("sent_frame_height")) != null) {
                    JsonObject jsonObject7 = jsonObject6;
                    bl = false;
                    boolean bl9 = false;
                    it = jsonObject7;
                    boolean bl10 = false;
                    Object object7 = v;
                    if (object7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                    }
                    v = Float.valueOf((it.getAsFloat() * (float)prevAverageCount + (float)((Long)object7).longValue()) / (float)currentStatsMeasureCount);
                    unit4 = Unit.INSTANCE;
                } else {
                    unit4 = null;
                }
                ExtensionsKt.addNullable(obj, "sent_frame_height", v);
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"RTCVideoSource", (boolean)false, (int)2, null)) {
                Unit unit6;
                Unit unit7;
                Unit unit8;
                members = value.getMembers();
                Object v = members.get("width");
                ExtensionsKt.addNullable(obj, "spot_video_source_width", v);
                JsonObject jsonObject = videoStreamStats;
                if (jsonObject != null && (jsonObject = jsonObject.get("video_source_width")) != null) {
                    JsonObject jsonObject8 = jsonObject;
                    bl = false;
                    boolean bl11 = false;
                    it = jsonObject8;
                    boolean bl12 = false;
                    Object object8 = v;
                    if (object8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                    }
                    v = Float.valueOf((it.getAsFloat() * (float)prevAverageCount + (float)((Long)object8).longValue()) / (float)currentStatsMeasureCount);
                    unit8 = Unit.INSTANCE;
                } else {
                    unit8 = null;
                }
                ExtensionsKt.addNullable(obj, "video_source_width", v);
                v = members.get("height");
                ExtensionsKt.addNullable(obj, "spot_video_source_height", v);
                JsonObject jsonObject9 = videoStreamStats;
                if (jsonObject9 != null && (jsonObject9 = jsonObject9.get("video_source_height")) != null) {
                    JsonObject jsonObject10 = jsonObject9;
                    bl = false;
                    boolean bl13 = false;
                    it = jsonObject10;
                    boolean bl14 = false;
                    Object object9 = v;
                    if (object9 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                    }
                    v = Float.valueOf((it.getAsFloat() * (float)prevAverageCount + (float)((Long)object9).longValue()) / (float)currentStatsMeasureCount);
                    unit7 = Unit.INSTANCE;
                } else {
                    unit7 = null;
                }
                ExtensionsKt.addNullable(obj, "video_source_height", v);
                v = members.get("framesPerSecond");
                ExtensionsKt.addNullable(obj, "spot_video_source_frames_per_second", v);
                JsonObject jsonObject11 = videoStreamStats;
                if (jsonObject11 != null && (jsonObject11 = jsonObject11.get("video_source_frames_per_second")) != null) {
                    JsonObject jsonObject12 = jsonObject11;
                    bl = false;
                    boolean bl15 = false;
                    it = jsonObject12;
                    boolean bl16 = false;
                    Object object10 = v;
                    if (object10 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                    }
                    v = Float.valueOf((it.getAsFloat() * (float)prevAverageCount + (float)((Long)object10).longValue()) / (float)currentStatsMeasureCount);
                    unit6 = Unit.INSTANCE;
                } else {
                    unit6 = null;
                }
                ExtensionsKt.addNullable(obj, "video_source_frames_per_second", v);
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"RTCOutboundRTPVideoStream", (boolean)false, (int)2, null)) {
                members = value.getMembers();
                ExtensionsKt.addNullable(obj, "total_packets_sent", members.get("packetsSent"));
                ExtensionsKt.addNullable(obj, "retransmitted_packets_sent", members.get("retransmittedPacketsSent"));
                ExtensionsKt.addNullable(obj, "quality_limitation_reason", members.get("qualityLimitationReason"));
                ExtensionsKt.addNullable(obj, "quality_limitation_resolution_changes", members.get("qualityLimitationResolutionChanges"));
                continue;
            }
            if (!StringsKt.startsWith$default((String)key, (String)"RTCRemoteInboundRtpVideoStream", (boolean)false, (int)2, null)) continue;
            members = value.getMembers();
            Object object11 = members.get("roundTripTime");
            if (!(object11 instanceof Double)) {
                object11 = null;
            }
            if ((Double)object11 != null) {
                Double d;
                boolean bl17 = false;
                bl = false;
                double it2 = ((Number)d).doubleValue();
                boolean bl18 = false;
                ExtensionsKt.addNullable(obj, "rtt", (int)(it2 * (double)1000));
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        if (obj.has("total_packets_lost") && obj.has("total_packets_received")) {
            Unit unit;
            JsonElement jsonElement = obj.get("total_packets_lost");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj[\"total_packets_lost\"]");
            int packetsLost = jsonElement.getAsInt() - prevTotalPacketsLost;
            JsonElement jsonElement2 = obj.get("total_packets_received");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"obj[\"total_packets_received\"]");
            long packetsReceived = jsonElement2.getAsLong() - prevTotalPacketsReceived;
            double packetsLostRate = (double)packetsLost / (double)((long)packetsLost + packetsReceived) * (double)100;
            packetsLostRate = Double.isNaN(packetsLostRate) ? 0.0 : packetsLostRate;
            JsonObject jsonObject = videoStreamStats;
            if ((jsonObject != null ? jsonObject.get("packets_lost") : null) != null) {
                JsonElement jsonElement3 = videoStreamStats.get("packets_lost");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"videoStreamStats.get(\"packets_lost\")");
                obj.addProperty("packets_lost", (Number)(jsonElement3.getAsInt() + packetsLost));
            } else {
                obj.addProperty("packets_lost", (Number)packetsLost);
            }
            JsonObject jsonObject13 = videoStreamStats;
            if ((jsonObject13 != null ? jsonObject13.get("packets_received") : null) != null) {
                JsonElement jsonElement4 = videoStreamStats.get("packets_received");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"videoStreamStats.get(\"packets_received\")");
                obj.addProperty("packets_received", (Number)((long)jsonElement4.getAsInt() + packetsReceived));
            } else {
                obj.addProperty("packets_received", (Number)packetsReceived);
            }
            double v = packetsLostRate;
            obj.addProperty("spot_packets_lost_rate", (Number)v);
            JsonObject jsonObject14 = videoStreamStats;
            if (jsonObject14 != null && (jsonObject14 = jsonObject14.get("packets_lost_rate")) != null) {
                JsonObject jsonObject15 = jsonObject14;
                bl = false;
                boolean bl19 = false;
                it = jsonObject15;
                boolean bl20 = false;
                v = ((double)(it.getAsFloat() * (float)prevAverageCount) + v) / (double)currentStatsMeasureCount;
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            obj.addProperty("packets_lost_rate", (Number)v);
            JsonElement jsonElement5 = obj.get("total_packets_lost");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement5, (String)"obj[\"total_packets_lost\"]");
            double d = jsonElement5.getAsInt();
            JsonElement jsonElement6 = obj.get("total_packets_lost");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement6, (String)"obj[\"total_packets_lost\"]");
            long l = jsonElement6.getAsInt();
            JsonElement jsonElement7 = obj.get("total_packets_received");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement7, (String)"obj[\"total_packets_received\"]");
            double totalPacketsLostRate = d / (double)(l + jsonElement7.getAsLong()) * (double)100;
            totalPacketsLostRate = Double.isNaN(totalPacketsLostRate) ? 0.0 : totalPacketsLostRate;
            obj.addProperty("total_packets_lost_rate", (Number)totalPacketsLostRate);
        }
        return obj;
    }

    @JvmStatic
    public static final /* synthetic */ void removeSpotValues(@Nullable JsonObject audioStreamStats, @Nullable JsonObject videoStreamStats) {
        block11: {
            JsonObject jsonObject = audioStreamStats;
            if (jsonObject != null) {
                jsonObject.remove("spot_jitter");
            }
            JsonObject jsonObject2 = audioStreamStats;
            if (jsonObject2 != null) {
                jsonObject2.remove("spot_rtt");
            }
            JsonObject jsonObject3 = audioStreamStats;
            if (jsonObject3 != null) {
                jsonObject3.remove("spot_packets_lost_rate");
            }
            JsonObject jsonObject4 = audioStreamStats;
            if (jsonObject4 != null) {
                jsonObject4.remove("spot_mos");
            }
            JsonObject jsonObject5 = videoStreamStats;
            if (jsonObject5 != null) {
                jsonObject5.remove("spot_received_frame_width");
            }
            JsonObject jsonObject6 = videoStreamStats;
            if (jsonObject6 != null) {
                jsonObject6.remove("spot_received_frame_height");
            }
            JsonObject jsonObject7 = videoStreamStats;
            if (jsonObject7 != null) {
                jsonObject7.remove("spot_sent_frame_width");
            }
            JsonObject jsonObject8 = videoStreamStats;
            if (jsonObject8 != null) {
                jsonObject8.remove("spot_sent_frame_height");
            }
            JsonObject jsonObject9 = videoStreamStats;
            if (jsonObject9 != null) {
                jsonObject9.remove("spot_video_source_width");
            }
            JsonObject jsonObject10 = videoStreamStats;
            if (jsonObject10 != null) {
                jsonObject10.remove("spot_video_source_height");
            }
            JsonObject jsonObject11 = videoStreamStats;
            if (jsonObject11 != null) {
                jsonObject11.remove("spot_video_source_frames_per_second");
            }
            JsonObject jsonObject12 = videoStreamStats;
            if (jsonObject12 == null) break block11;
            jsonObject12.remove("spot_packets_lost_rate");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final double getTimestamp(Map<String, ? extends RTCStats> rtcStatsMap) {
        Object object = rtcStatsMap;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends RTCStats>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<String, ? extends RTCStats> entry;
            Map.Entry<String, ? extends RTCStats> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            RTCStats value = entry2.getValue();
            if (StringsKt.startsWith$default((String)key, (String)"RTCRemoteInbound", (boolean)false, (int)2, null)) continue;
            return value.getTimestampUs();
        }
        return 0.0;
    }

    @JvmStatic
    @Nullable
    public static final /* synthetic */ IceConnection getIceConnection(@NotNull JsonObject commonStats) {
        Object object;
        Object relayProtocol;
        Object object2;
        Object protocol;
        Object object3;
        Object candidateType;
        Intrinsics.checkParameterIsNotNull((Object)commonStats, (String)"commonStats");
        if (!commonStats.has("transport_info")) {
            return null;
        }
        JsonElement jsonElement = commonStats.get("transport_info");
        Object transportInfo = jsonElement != null ? jsonElement.getAsJsonObject() : null;
        Object object4 = transportInfo;
        if (object4 == null || (object4 = object4.get("candidate_type")) == null || (object4 = object4.getAsString()) == null) {
            object4 = candidateType = "";
        }
        if ((object3 = transportInfo) == null || (object3 = object3.get("protocol")) == null || (object3 = object3.getAsString()) == null) {
            object3 = protocol = "";
        }
        if ((object2 = transportInfo) == null || (object2 = object2.get("relay_protocol")) == null || (object2 = object2.getAsString()) == null) {
            object2 = relayProtocol = "";
        }
        if ((object = transportInfo) == null || (object = object.get("ip")) == null || (object = object.getAsString()) == null) {
            object = "";
        }
        Object ip = object;
        JsonObject jsonObject = transportInfo;
        int port = jsonObject != null && (jsonObject = jsonObject.get("port")) != null ? jsonObject.getAsInt() : 0;
        return new IceConnection((String)candidateType, (String)relayProtocol, (String)ip, port, (String)protocol);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject getTransportInfo(Map<String, ? extends RTCStats> rtcStatsMap) {
        Map.Entry element$iv$iv;
        void $this$filterTo$iv$iv;
        JsonObject jsonObject = new JsonObject();
        Map $this$filter$iv = rtcStatsMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var8_10 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var8_10.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry it2 = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!StringsKt.startsWith$default((String)((String)it2.getKey()), (String)"RTCTransport", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        map = $this$forEach$iv;
        boolean bl3 = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object it;
            boolean bl4;
            RTCStats localCandidateStat;
            Object v2;
            Map.Entry element$iv;
            Map.Entry $dstr$_u24__u24$value = element$iv = iterator2.next();
            boolean bl5 = false;
            element$iv$iv = $dstr$_u24__u24$value;
            boolean it2 = false;
            RTCStats value = (RTCStats)element$iv$iv.getValue();
            if (!value.getMembers().containsKey("selectedCandidatePairId")) continue;
            Object object6 = value.getMembers().get("selectedCandidatePairId");
            if (!(object6 instanceof String)) {
                object6 = null;
            }
            String selectedCandidatePairId = (String)object6;
            Map map2 = rtcStatsMap;
            boolean bl6 = false;
            RTCStats selectedCandidateStat = (RTCStats)map2.get(selectedCandidatePairId);
            Object object7 = selectedCandidateStat;
            if (!((object7 != null && (object7 = ((RTCStats)object7).getMembers()) != null ? object7.get("localCandidateId") : (v2 = null)) instanceof String)) {
                v2 = null;
            }
            String localCandidateId = v2;
            Object object8 = rtcStatsMap;
            boolean bl7 = false;
            if ((RTCStats)object8.get(localCandidateId) == null) {
                continue;
            }
            Object object9 = localCandidateStat.getMembers().get("networkType");
            if (!(object9 instanceof String)) {
                object9 = null;
            }
            String string = (String)object9;
            if (string != null) {
                object8 = string;
                bl7 = false;
                bl4 = false;
                it = object8;
                boolean bl8 = false;
                jsonObject.addProperty("network_type", (String)it);
            }
            if (!((object5 = localCandidateStat.getMembers().get("ip")) instanceof String)) {
                object5 = null;
            }
            String string2 = (String)object5;
            if (string2 != null) {
                object8 = string2;
                bl7 = false;
                bl4 = false;
                it = object8;
                boolean bl9 = false;
                jsonObject.addProperty("ip", (String)it);
            }
            if (!((object4 = localCandidateStat.getMembers().get("port")) instanceof Integer)) {
                object4 = null;
            }
            Integer n = (Integer)object4;
            if (n != null) {
                object8 = n;
                bl7 = false;
                bl4 = false;
                int it3 = ((Number)object8).intValue();
                boolean bl10 = false;
                jsonObject.addProperty("port", (Number)it3);
            }
            if (!((object3 = localCandidateStat.getMembers().get("protocol")) instanceof String)) {
                object3 = null;
            }
            String string3 = (String)object3;
            if (string3 != null) {
                object8 = string3;
                bl7 = false;
                bl4 = false;
                Object it4 = object8;
                boolean bl11 = false;
                jsonObject.addProperty("protocol", (String)it4);
            }
            if (!((object2 = localCandidateStat.getMembers().get("relayProtocol")) instanceof String)) {
                object2 = null;
            }
            String string4 = (String)object2;
            if (string4 != null) {
                object8 = string4;
                bl7 = false;
                bl4 = false;
                Object it5 = object8;
                boolean bl12 = false;
                jsonObject.addProperty("relay_protocol", (String)it5);
            }
            if (!((object = localCandidateStat.getMembers().get("candidateType")) instanceof String)) {
                object = null;
            }
            String string5 = (String)object;
            if (string5 == null) continue;
            object8 = string5;
            bl7 = false;
            bl4 = false;
            Object it6 = object8;
            boolean bl13 = false;
            jsonObject.addProperty("candidate_type", (String)it6);
        }
        return jsonObject;
    }

    private final String getNetworkType(Map<String, ? extends RTCStats> rtcStatsMap) {
        RTCStats rTCStats = rtcStatsMap.get("RTCTransport_0_1");
        if (rTCStats == null) {
            return "";
        }
        RTCStats transportStat = rTCStats;
        Object object = transportStat.getMembers().get("selectedCandidatePairId");
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return "";
        }
        String selectedCandidatePairId = string;
        RTCStats rTCStats2 = rtcStatsMap.get(selectedCandidatePairId);
        if (rTCStats2 == null) {
            return "";
        }
        RTCStats selectedCandidateStat = rTCStats2;
        Map<String, Object> map = selectedCandidateStat.getMembers();
        Object object2 = map != null ? map.get("localCandidateId") : null;
        if (!(object2 instanceof String)) {
            object2 = null;
        }
        String string2 = (String)object2;
        if (string2 == null) {
            return "";
        }
        String localCandidateId = string2;
        RTCStats rTCStats3 = rtcStatsMap.get(localCandidateId);
        if (rTCStats3 == null) {
            return "";
        }
        RTCStats localCandidateStat = rTCStats3;
        Map<String, Object> map2 = localCandidateStat.getMembers();
        Object object3 = map2 != null ? map2.get("networkType") : null;
        if (!(object3 instanceof String)) {
            object3 = null;
        }
        String string3 = (String)object3;
        if (string3 == null) {
            return "";
        }
        return string3;
    }

    private final String getNetworkOperatorName(Context context) {
        TelephonyManager telephonyManager;
        Object object;
        Object object2 = context.getSystemService("phone");
        if (!(object2 instanceof TelephonyManager)) {
            object2 = null;
        }
        if ((object = (telephonyManager = (TelephonyManager)object2)) == null || (object = object.getNetworkOperatorName()) == null) {
            object = "";
        }
        return object;
    }

    private final int getWifiLevel(Context context) {
        Object object = context.getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wifiManager = (WifiManager)object;
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)wifiInfo, (String)"wifiManager.connectionInfo");
        int rssi = wifiInfo.getRssi();
        return WifiManager.calculateSignalLevel((int)rssi, (int)5);
    }

    private final double getMos(int jitter, int latency, double packetsLostRate) {
        if (jitter < 0 || latency < 0 || Double.isNaN(packetsLostRate)) {
            return 0.0;
        }
        double effectiveLatency = (double)(latency + 2 * jitter) + 10.0;
        double R = effectiveLatency < (double)160 ? 93.2 - effectiveLatency / 40.0 : 93.2 - (effectiveLatency - 120.0) / 10.0;
        return R < 0.0 ? 1.0 : (R >= (double)100 ? 4.5 : 1.0 + 0.035 * (R -= 2.5 * packetsLostRate) + 7.0E-6 * R * (R - (double)60) * ((double)100 - R));
    }

    private RtcStatsUtils() {
    }

    static {
        RtcStatsUtils rtcStatsUtils;
        INSTANCE = rtcStatsUtils = new RtcStatsUtils();
    }
}

