/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.util;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.internal.model.IceConnection;
import com.sendbird.calls.internal.util.ExtensionsKt;
import com.sendbird.calls.shadow.com.google.gson.JsonElement;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.RTCStats;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007JX\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010!\u001a\u00020\u00072\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u001c\u0010\"\u001a\u00020\u001c2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u001c\u0010#\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J,\u0010$\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010%\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006&"}, d2={"Lcom/sendbird/calls/internal/util/RtcStatsUtils;", "", "()V", "getAudioStreamStats", "Lcom/sendbird/calls/shadow/com/google/gson/JsonObject;", "rtcStatsMap", "", "", "Lorg/webrtc/RTCStats;", "prevTotalPacketsReceived", "", "prevTotalPacketsLost", "", "getCommonStats", "context", "Landroid/content/Context;", "appId", "callId", "callerId", "calleeId", "role", "Lcom/sendbird/calls/DirectCallUserRole;", "isVideoCall", "", "getIceConnection", "Lcom/sendbird/calls/internal/model/IceConnection;", "commonStats", "getMos", "", "jitter", "latency", "packetsLostRate", "getNetworkOperatorName", "getNetworkType", "getTimestamp", "getTransportInfo", "getVideoStreamProperties", "getWifiLevel", "calls_release"})
public final class RtcStatsUtils {
    public static final RtcStatsUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final /* synthetic */ JsonObject getCommonStats(@NotNull Context context, @NotNull Map<String, ? extends RTCStats> rtcStatsMap, @NotNull String appId, @Nullable String callId, @NotNull String callerId, @NotNull String calleeId, @Nullable DirectCallUserRole role, boolean isVideoCall) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(rtcStatsMap, (String)"rtcStatsMap");
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        Intrinsics.checkParameterIsNotNull((Object)callerId, (String)"callerId");
        Intrinsics.checkParameterIsNotNull((Object)calleeId, (String)"calleeId");
        JsonObject obj = new JsonObject();
        obj.addProperty("webrtc_timestamp", (Number)INSTANCE.getTimestamp(rtcStatsMap));
        obj.addProperty("device_timestamp", (Number)System.currentTimeMillis());
        obj.addProperty("network_type", INSTANCE.getNetworkType(rtcStatsMap));
        obj.add("transport_info", (JsonElement)INSTANCE.getTransportInfo(rtcStatsMap));
        obj.addProperty("app_id", appId);
        obj.addProperty("call_id", String.valueOf(callId));
        obj.addProperty("role", String.valueOf(role));
        obj.addProperty("is_video_call", Boolean.valueOf(isVideoCall));
        obj.addProperty("caller_id", callerId);
        obj.addProperty("callee_id", calleeId);
        obj.addProperty("network_operator_name", INSTANCE.getNetworkOperatorName(context));
        obj.addProperty("wifi_signal_level", (Number)INSTANCE.getWifiLevel(context));
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final /* synthetic */ JsonObject getAudioStreamStats(@NotNull Map<String, ? extends RTCStats> rtcStatsMap, long prevTotalPacketsReceived, int prevTotalPacketsLost) {
        Intrinsics.checkParameterIsNotNull(rtcStatsMap, (String)"rtcStatsMap");
        JsonObject obj = new JsonObject();
        Object object = rtcStatsMap;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends RTCStats>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Double d;
            double it;
            boolean bl2;
            Map<String, Object> members;
            void key;
            Map.Entry<String, ? extends RTCStats> entry;
            Map.Entry<String, ? extends RTCStats> entry2 = entry = iterator.next();
            boolean bl3 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl3 = false;
            RTCStats value = entry2.getValue();
            if (StringsKt.startsWith$default((String)key, (String)"RTCInboundRTPAudioStream", (boolean)false, (int)2, null)) {
                members = value.getMembers();
                Object object2 = rtcStatsMap;
                Object object3 = members.get("codecId");
                String string = "codec";
                JsonObject jsonObject = obj;
                bl2 = false;
                RTCStats rTCStats = object2.get(object3);
                Object object4 = rTCStats;
                ExtensionsKt.addNullable(jsonObject, string, object4 != null && (object4 = ((RTCStats)object4).getMembers()) != null ? object4.get("mimeType") : null);
                ExtensionsKt.addNullable(obj, "jitter", members.get("jitter"));
                Object object5 = members.get("jitter");
                if (!(object5 instanceof Double)) {
                    object5 = null;
                }
                Double d2 = (Double)object5;
                if (d2 != null) {
                    object2 = d2;
                    boolean bl4 = false;
                    bl2 = false;
                    it = ((Number)object2).doubleValue();
                    boolean bl5 = false;
                    obj.addProperty("jitter", (Number)((int)(it * (double)1000)));
                }
                ExtensionsKt.addNullable(obj, "total_packets_lost", members.get("packetsLost"));
                ExtensionsKt.addNullable(obj, "total_packets_received", members.get("packetsReceived"));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"RTCOutboundRTPAudioStream", (boolean)false, (int)2, null)) {
                members = value.getMembers();
                ExtensionsKt.addNullable(obj, "total_packets_sent", members.get("packetsSent"));
                ExtensionsKt.addNullable(obj, "retransmitted_packets_sent", members.get("retransmittedPacketsSent"));
                continue;
            }
            if (!StringsKt.startsWith$default((String)key, (String)"RTCRemoteInboundRtpAudioStream", (boolean)false, (int)2, null)) continue;
            members = value.getMembers();
            Object object6 = members.get("roundTripTime");
            if (!(object6 instanceof Double)) {
                object6 = null;
            }
            if ((Double)object6 == null) continue;
            boolean bl6 = false;
            bl2 = false;
            it = ((Number)d).doubleValue();
            boolean bl7 = false;
            obj.addProperty("rtt", (Number)((int)(it * (double)1000)));
        }
        if (obj.has("total_packets_lost") && obj.has("total_packets_received")) {
            if (obj.has("jitter") && obj.has("rtt")) {
                JsonElement jsonElement = obj.get("total_packets_lost");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj[\"total_packets_lost\"]");
                int packetsLost = jsonElement.getAsInt() - prevTotalPacketsLost;
                JsonElement jsonElement2 = obj.get("total_packets_received");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"obj[\"total_packets_received\"]");
                long packetsReceived = jsonElement2.getAsLong() - prevTotalPacketsReceived;
                double packetsLostRate = (double)packetsLost / (double)((long)packetsLost + packetsReceived) * (double)100;
                packetsLostRate = Double.isNaN(packetsLostRate) ? 0.0 : packetsLostRate;
                obj.addProperty("packets_lost_rate", (Number)packetsLostRate);
                JsonElement jsonElement3 = obj.get("jitter");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"obj[\"jitter\"]");
                int n = jsonElement3.getAsInt();
                JsonElement jsonElement4 = obj.get("rtt");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"obj[\"rtt\"]");
                double mos = INSTANCE.getMos(n, jsonElement4.getAsInt() / 2, packetsLostRate);
                obj.addProperty("packets_lost", (Number)packetsLost);
                obj.addProperty("mos", (Number)mos);
            }
            JsonElement jsonElement = obj.get("total_packets_lost");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj[\"total_packets_lost\"]");
            double d = jsonElement.getAsInt();
            JsonElement jsonElement5 = obj.get("total_packets_lost");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement5, (String)"obj[\"total_packets_lost\"]");
            long l = jsonElement5.getAsInt();
            JsonElement jsonElement6 = obj.get("total_packets_received");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement6, (String)"obj[\"total_packets_received\"]");
            double totalPacketsLostRate = d / (double)(l + jsonElement6.getAsLong()) * (double)100;
            totalPacketsLostRate = Double.isNaN(totalPacketsLostRate) ? 0.0 : totalPacketsLostRate;
            obj.addProperty("total_packets_lost_rate", (Number)totalPacketsLostRate);
        }
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final /* synthetic */ JsonObject getVideoStreamProperties(@NotNull Map<String, ? extends RTCStats> rtcStatsMap, long prevTotalPacketsReceived, int prevTotalPacketsLost) {
        Intrinsics.checkParameterIsNotNull(rtcStatsMap, (String)"rtcStatsMap");
        JsonObject obj = new JsonObject();
        Object object = rtcStatsMap;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends RTCStats>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Double d;
            boolean bl2;
            Map<String, Object> members;
            void key;
            Map.Entry<String, ? extends RTCStats> entry;
            Map.Entry<String, ? extends RTCStats> entry2 = entry = iterator.next();
            boolean bl3 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl3 = false;
            RTCStats value = entry2.getValue();
            if (StringsKt.startsWith$default((String)key, (String)"RTCInboundRTPVideoStream", (boolean)false, (int)2, null)) {
                members = value.getMembers();
                Map<String, ? extends RTCStats> map = rtcStatsMap;
                Object object2 = members.get("codecId");
                String string = "codec";
                JsonObject jsonObject = obj;
                bl2 = false;
                RTCStats rTCStats = map.get(object2);
                Object object3 = rTCStats;
                ExtensionsKt.addNullable(jsonObject, string, object3 != null && (object3 = ((RTCStats)object3).getMembers()) != null ? object3.get("mimeType") : null);
                ExtensionsKt.addNullable(obj, "fir_count", members.get("firCount"));
                ExtensionsKt.addNullable(obj, "pli_count", members.get("pliCount"));
                ExtensionsKt.addNullable(obj, "nack_count", members.get("nackCount"));
                ExtensionsKt.addNullable(obj, "qp_sum", members.get("qpSum"));
                ExtensionsKt.addNullable(obj, "bytes_received", members.get("bytesReceived"));
                ExtensionsKt.addNullable(obj, "total_packets_received", members.get("packetsReceived"));
                ExtensionsKt.addNullable(obj, "header_bytes_received", members.get("headerBytesReceived"));
                ExtensionsKt.addNullable(obj, "total_packets_lost", members.get("packetsLost"));
                ExtensionsKt.addNullable(obj, "frames_decoded", members.get("framesDecoded"));
                ExtensionsKt.addNullable(obj, "key_frames_decoded", members.get("keyFramesDecoded"));
                ExtensionsKt.addNullable(obj, "total_inter_frame_delay", members.get("totalInterFrameDelay"));
                ExtensionsKt.addNullable(obj, "total_squared_inter_frame_delay", members.get("totalSquaredInterFrameDelay"));
                ExtensionsKt.addNullable(obj, "total_decode_time", members.get("totalDecodeTime"));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"RTCMediaStreamTrack_receiver", (boolean)false, (int)2, null)) {
                members = value.getMembers();
                if (Intrinsics.areEqual((Object)members.get("kind"), (Object)"video") ^ true) continue;
                ExtensionsKt.addNullable(obj, "received_frame_width", members.get("frameWidth"));
                ExtensionsKt.addNullable(obj, "received_frame_height", members.get("frameHeight"));
                ExtensionsKt.addNullable(obj, "frames_received", members.get("framesReceived"));
                ExtensionsKt.addNullable(obj, "frames_dropped", members.get("framesDropped"));
                ExtensionsKt.addNullable(obj, "freeze_count", members.get("freezeCount"));
                ExtensionsKt.addNullable(obj, "pause_count", members.get("pauseCount"));
                ExtensionsKt.addNullable(obj, "jitter_buffer_delay", members.get("jitterBufferDelay"));
                ExtensionsKt.addNullable(obj, "jitter_buffer_emitted_count", members.get("jitterBufferEmittedCount"));
                ExtensionsKt.addNullable(obj, "total_freezes_duration", members.get("totalFreezesDuration"));
                ExtensionsKt.addNullable(obj, "total_pauses_duration", members.get("totalPausesDuration"));
                ExtensionsKt.addNullable(obj, "total_frames_duration", members.get("totalFramesDuration"));
                ExtensionsKt.addNullable(obj, "sum_of_squared_frames_duration", members.get("sumOfSquaredFramesDuration"));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"RTCMediaStreamTrack_sender", (boolean)false, (int)2, null)) {
                members = value.getMembers();
                if (Intrinsics.areEqual((Object)members.get("kind"), (Object)"video") ^ true) continue;
                ExtensionsKt.addNullable(obj, "sent_frame_width", members.get("frameWidth"));
                ExtensionsKt.addNullable(obj, "sent_frame_height", members.get("frameHeight"));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"RTCVideoSource", (boolean)false, (int)2, null)) {
                members = value.getMembers();
                ExtensionsKt.addNullable(obj, "video_source_width", members.get("width"));
                ExtensionsKt.addNullable(obj, "video_source_height", members.get("height"));
                ExtensionsKt.addNullable(obj, "video_source_frames_per_second", members.get("framesPerSecond"));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"RTCOutboundRTPVideoStream", (boolean)false, (int)2, null)) {
                members = value.getMembers();
                ExtensionsKt.addNullable(obj, "total_packets_sent", members.get("packetsSent"));
                ExtensionsKt.addNullable(obj, "retransmitted_packets_sent", members.get("retransmittedPacketsSent"));
                ExtensionsKt.addNullable(obj, "quality_limitation_reason", members.get("qualityLimitationReason"));
                ExtensionsKt.addNullable(obj, "quality_limitation_resolution_changes", members.get("qualityLimitationResolutionChanges"));
                continue;
            }
            if (!StringsKt.startsWith$default((String)key, (String)"RTCRemoteInboundRtpVideoStream", (boolean)false, (int)2, null)) continue;
            members = value.getMembers();
            Object object4 = members.get("roundTripTime");
            if (!(object4 instanceof Double)) {
                object4 = null;
            }
            if ((Double)object4 == null) continue;
            boolean bl4 = false;
            bl2 = false;
            double it = ((Number)d).doubleValue();
            boolean bl5 = false;
            ExtensionsKt.addNullable(obj, "rtt", (int)(it * (double)1000));
        }
        if (obj.has("total_packets_lost") && obj.has("total_packets_received")) {
            JsonElement jsonElement = obj.get("total_packets_lost");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj[\"total_packets_lost\"]");
            int packetsLost = jsonElement.getAsInt() - prevTotalPacketsLost;
            JsonElement jsonElement2 = obj.get("total_packets_received");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"obj[\"total_packets_received\"]");
            long packetsReceived = jsonElement2.getAsLong() - prevTotalPacketsReceived;
            double packetsLostRate = (double)packetsLost / (double)((long)packetsLost + packetsReceived) * (double)100;
            packetsLostRate = Double.isNaN(packetsLostRate) ? 0.0 : packetsLostRate;
            obj.addProperty("packets_lost", (Number)packetsLost);
            obj.addProperty("packets_received", (Number)packetsReceived);
            obj.addProperty("packets_lost_rate", (Number)packetsLostRate);
            JsonElement jsonElement3 = obj.get("total_packets_lost");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"obj[\"total_packets_lost\"]");
            double d = jsonElement3.getAsInt();
            JsonElement jsonElement4 = obj.get("total_packets_lost");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"obj[\"total_packets_lost\"]");
            long l = jsonElement4.getAsInt();
            JsonElement jsonElement5 = obj.get("total_packets_received");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement5, (String)"obj[\"total_packets_received\"]");
            double totalPacketsLostRate = d / (double)(l + jsonElement5.getAsLong()) * (double)100;
            totalPacketsLostRate = Double.isNaN(totalPacketsLostRate) ? 0.0 : totalPacketsLostRate;
            obj.addProperty("total_packets_lost_rate", (Number)totalPacketsLostRate);
        }
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    private final double getTimestamp(Map<String, ? extends RTCStats> rtcStatsMap) {
        Object object = rtcStatsMap;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends RTCStats>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<String, ? extends RTCStats> entry;
            Map.Entry<String, ? extends RTCStats> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            RTCStats value = entry2.getValue();
            if (StringsKt.startsWith$default((String)key, (String)"RTCRemoteInbound", (boolean)false, (int)2, null)) continue;
            return value.getTimestampUs();
        }
        return 0.0;
    }

    @JvmStatic
    @Nullable
    public static final /* synthetic */ IceConnection getIceConnection(@NotNull JsonObject commonStats) {
        Integer port;
        Intrinsics.checkParameterIsNotNull((Object)commonStats, (String)"commonStats");
        if (!commonStats.has("transport_info")) {
            return null;
        }
        JsonElement jsonElement = commonStats.get("transport_info");
        Object transportInfo = jsonElement != null ? jsonElement.getAsJsonObject() : null;
        JsonObject jsonObject = transportInfo;
        String candidateType = jsonObject != null && (jsonObject = jsonObject.get("candidate_type")) != null ? jsonObject.getAsString() : null;
        JsonObject jsonObject2 = transportInfo;
        String protocol = jsonObject2 != null && (jsonObject2 = jsonObject2.get("protocol")) != null ? jsonObject2.getAsString() : null;
        JsonObject jsonObject3 = transportInfo;
        String relayProtocol = jsonObject3 != null && (jsonObject3 = jsonObject3.get("relay_protocol")) != null ? jsonObject3.getAsString() : null;
        JsonObject jsonObject4 = transportInfo;
        String ip = jsonObject4 != null && (jsonObject4 = jsonObject4.get("ip")) != null ? jsonObject4.getAsString() : null;
        JsonObject jsonObject5 = transportInfo;
        Integer n = jsonObject5 != null && (jsonObject5 = jsonObject5.get("port")) != null ? Integer.valueOf(jsonObject5.getAsInt()) : (port = null);
        if (candidateType != null && protocol != null && ip != null && port != null && relayProtocol != null) {
            return new IceConnection(candidateType, relayProtocol, ip, port, protocol);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject getTransportInfo(Map<String, ? extends RTCStats> rtcStatsMap) {
        Map.Entry element$iv$iv;
        void $this$filterTo$iv$iv;
        JsonObject jsonObject = new JsonObject();
        Map $this$filter$iv = rtcStatsMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var8_10 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var8_10.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry it2 = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!StringsKt.startsWith$default((String)((String)it2.getKey()), (String)"RTCTransport", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        map = $this$forEach$iv;
        boolean bl3 = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object it;
            boolean bl4;
            RTCStats localCandidateStat;
            Object v2;
            Map.Entry element$iv;
            Map.Entry $dstr$_u24__u24$value = element$iv = iterator2.next();
            boolean bl5 = false;
            element$iv$iv = $dstr$_u24__u24$value;
            boolean it2 = false;
            RTCStats value = (RTCStats)element$iv$iv.getValue();
            if (!value.getMembers().containsKey("selectedCandidatePairId")) continue;
            Object object6 = value.getMembers().get("selectedCandidatePairId");
            if (!(object6 instanceof String)) {
                object6 = null;
            }
            String selectedCandidatePairId = (String)object6;
            Map map2 = rtcStatsMap;
            boolean bl6 = false;
            RTCStats selectedCandidateStat = (RTCStats)map2.get(selectedCandidatePairId);
            Object object7 = selectedCandidateStat;
            if (!((object7 != null && (object7 = ((RTCStats)object7).getMembers()) != null ? object7.get("localCandidateId") : (v2 = null)) instanceof String)) {
                v2 = null;
            }
            String localCandidateId = v2;
            Object object8 = rtcStatsMap;
            boolean bl7 = false;
            if ((RTCStats)object8.get(localCandidateId) == null) {
                continue;
            }
            Object object9 = localCandidateStat.getMembers().get("networkType");
            if (!(object9 instanceof String)) {
                object9 = null;
            }
            String string = (String)object9;
            if (string != null) {
                object8 = string;
                bl7 = false;
                bl4 = false;
                it = object8;
                boolean bl8 = false;
                jsonObject.addProperty("network_type", (String)it);
            }
            if (!((object5 = localCandidateStat.getMembers().get("ip")) instanceof String)) {
                object5 = null;
            }
            String string2 = (String)object5;
            if (string2 != null) {
                object8 = string2;
                bl7 = false;
                bl4 = false;
                it = object8;
                boolean bl9 = false;
                jsonObject.addProperty("ip", (String)it);
            }
            if (!((object4 = localCandidateStat.getMembers().get("port")) instanceof String)) {
                object4 = null;
            }
            String string3 = (String)object4;
            if (string3 != null) {
                object8 = string3;
                bl7 = false;
                bl4 = false;
                it = object8;
                boolean bl10 = false;
                jsonObject.addProperty("port", (String)it);
            }
            if (!((object3 = localCandidateStat.getMembers().get("protocol")) instanceof String)) {
                object3 = null;
            }
            String string4 = (String)object3;
            if (string4 != null) {
                object8 = string4;
                bl7 = false;
                bl4 = false;
                it = object8;
                boolean bl11 = false;
                jsonObject.addProperty("protocol", (String)it);
            }
            if (!((object2 = localCandidateStat.getMembers().get("relayProtocol")) instanceof String)) {
                object2 = null;
            }
            String string5 = (String)object2;
            if (string5 != null) {
                object8 = string5;
                bl7 = false;
                bl4 = false;
                it = object8;
                boolean bl12 = false;
                jsonObject.addProperty("relayProtocol", (String)it);
            }
            if (!((object = localCandidateStat.getMembers().get("candidateType")) instanceof String)) {
                object = null;
            }
            String string6 = (String)object;
            if (string6 == null) continue;
            object8 = string6;
            bl7 = false;
            bl4 = false;
            it = object8;
            boolean bl13 = false;
            jsonObject.addProperty("candidateType", (String)it);
        }
        return jsonObject;
    }

    private final String getNetworkType(Map<String, ? extends RTCStats> rtcStatsMap) {
        RTCStats rTCStats = rtcStatsMap.get("RTCTransport_0_1");
        if (rTCStats == null) {
            return "";
        }
        RTCStats transportStat = rTCStats;
        Object object = transportStat.getMembers().get("selectedCandidatePairId");
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return "";
        }
        String selectedCandidatePairId = string;
        RTCStats rTCStats2 = rtcStatsMap.get(selectedCandidatePairId);
        if (rTCStats2 == null) {
            return "";
        }
        RTCStats selectedCandidateStat = rTCStats2;
        Map<String, Object> map = selectedCandidateStat.getMembers();
        Object object2 = map != null ? map.get("localCandidateId") : null;
        if (!(object2 instanceof String)) {
            object2 = null;
        }
        String string2 = (String)object2;
        if (string2 == null) {
            return "";
        }
        String localCandidateId = string2;
        RTCStats rTCStats3 = rtcStatsMap.get(localCandidateId);
        if (rTCStats3 == null) {
            return "";
        }
        RTCStats localCandidateStat = rTCStats3;
        Map<String, Object> map2 = localCandidateStat.getMembers();
        Object object3 = map2 != null ? map2.get("networkType") : null;
        if (!(object3 instanceof String)) {
            object3 = null;
        }
        String string3 = (String)object3;
        if (string3 == null) {
            return "";
        }
        return string3;
    }

    private final String getNetworkOperatorName(Context context) {
        TelephonyManager telephonyManager;
        Object object;
        Object object2 = context.getSystemService("phone");
        if (!(object2 instanceof TelephonyManager)) {
            object2 = null;
        }
        if ((object = (telephonyManager = (TelephonyManager)object2)) == null || (object = object.getNetworkOperatorName()) == null) {
            object = "";
        }
        return object;
    }

    private final int getWifiLevel(Context context) {
        Object object = context.getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wifiManager = (WifiManager)object;
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)wifiInfo, (String)"wifiManager.connectionInfo");
        int rssi = wifiInfo.getRssi();
        return WifiManager.calculateSignalLevel((int)rssi, (int)5);
    }

    private final double getMos(int jitter, int latency, double packetsLostRate) {
        if (jitter < 0 || latency < 0 || Double.isNaN(packetsLostRate)) {
            return 0.0;
        }
        double effectiveLatency = (double)(latency + 2 * jitter) + 10.0;
        double R = effectiveLatency < (double)160 ? 93.2 - effectiveLatency / 40.0 : 93.2 - (effectiveLatency - 120.0) / 10.0;
        return R < 0.0 ? 1.0 : (R >= (double)100 ? 4.5 : 1.0 + 0.035 * (R -= 2.5 * packetsLostRate) + 7.0E-6 * R * (R - (double)60) * ((double)100 - R));
    }

    private RtcStatsUtils() {
    }

    static {
        RtcStatsUtils rtcStatsUtils;
        INSTANCE = rtcStatsUtils = new RtcStatsUtils();
    }
}

