/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.pc;

import android.support.annotation.RequiresApi;
import com.sendbird.calls.RecordingOptions;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.internal.pc.MediaEncoder;
import com.sendbird.calls.internal.pc.MediaMixer;
import com.sendbird.calls.internal.pc.Recorder$WhenMappings;
import com.sendbird.calls.internal.util.Logger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.EglBase;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.audio.JavaAudioDeviceModule;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001:\u0002?@B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00100\u001a\u00020\u0003H\u0002J%\u00101\u001a\u00020 2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0000\u00a2\u0006\u0002\b7J\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u000209H\u0002J\b\u0010;\u001a\u000209H\u0002J\b\u0010<\u001a\u000209H\u0002J\r\u0010=\u001a\u00020 H\u0000\u00a2\u0006\u0002\b>R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u00f2\u0001\u0010\"\u001ah\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0015\u0012\u0013\u0018\u00010\u0003\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0015\u0012\u0013\u0018\u00010\u001e\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 \u0018\u00010\u0019j\u0004\u0018\u0001`!2l\u0010\u0018\u001ah\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0015\u0012\u0013\u0018\u00010\u0003\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0015\u0012\u0013\u0018\u00010\u001e\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 \u0018\u00010\u0019j\u0004\u0018\u0001`!8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000eR\u0011\u0010)\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0012R \u0010,\u001a\u00020+2\u0006\u0010\u0018\u001a\u00020+8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0010\u0010/\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/sendbird/calls/internal/pc/Recorder;", "", "callId", "", "recordingOptions", "Lcom/sendbird/calls/RecordingOptions;", "(Ljava/lang/String;Lcom/sendbird/calls/RecordingOptions;)V", "audioEncoder", "Lcom/sendbird/calls/internal/pc/MediaEncoder;", "audioSampleQueue", "Lcom/sendbird/calls/internal/pc/Recorder$AudioSampleQueue;", "localAudioSamplesReadyCallback", "Lorg/webrtc/audio/JavaAudioDeviceModule$SamplesReadyCallback;", "getLocalAudioSamplesReadyCallback", "()Lorg/webrtc/audio/JavaAudioDeviceModule$SamplesReadyCallback;", "localVideoSink", "Lorg/webrtc/VideoSink;", "getLocalVideoSink", "()Lorg/webrtc/VideoSink;", "mediaMixer", "Lcom/sendbird/calls/internal/pc/MediaMixer;", "recordingId", "getRecordingId", "()Ljava/lang/String;", "<set-?>", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "recordingOption", "filePath", "Lcom/sendbird/calls/SendBirdException;", "e", "", "Lcom/sendbird/calls/internal/util/DirectCallRecordingListener;", "recordingListener", "getRecordingListener", "()Lkotlin/jvm/functions/Function4;", "setRecordingListener", "(Lkotlin/jvm/functions/Function4;)V", "remoteAudioSamplesReadyCallback", "getRemoteAudioSamplesReadyCallback", "remoteVideoSink", "getRemoteVideoSink", "Lcom/sendbird/calls/internal/pc/Recorder$State;", "state", "getState", "()Lcom/sendbird/calls/internal/pc/Recorder$State;", "videoEncoder", "getFilePath", "initEncoders", "sharedContext", "Lorg/webrtc/EglBase$Context;", "width", "", "height", "initEncoders$calls_release", "isLocalAudioNeeded", "", "isLocalVideoNeeded", "isRemoteAudioNeeded", "isRemoteVideoNeeded", "stop", "stop$calls_release", "AudioSampleQueue", "State", "calls_release"})
@RequiresApi(api=18)
public final class Recorder {
    @NotNull
    private final String recordingId;
    @NotNull
    private State state;
    @Nullable
    private Function4<? super String, ? super RecordingOptions, ? super String, ? super SendBirdException, Unit> recordingListener;
    private MediaEncoder videoEncoder;
    private MediaEncoder audioEncoder;
    private MediaMixer mediaMixer;
    private final AudioSampleQueue audioSampleQueue;
    private final String callId;
    private final RecordingOptions recordingOptions;

    @NotNull
    public final /* synthetic */ String getRecordingId() {
        return this.recordingId;
    }

    @NotNull
    public final /* synthetic */ State getState() {
        return this.state;
    }

    @Nullable
    public final /* synthetic */ Function4<String, RecordingOptions, String, SendBirdException, Unit> getRecordingListener() {
        return this.recordingListener;
    }

    public final /* synthetic */ void setRecordingListener(@Nullable Function4<? super String, ? super RecordingOptions, ? super String, ? super SendBirdException, Unit> function4) {
        this.recordingListener = function4;
    }

    public final /* synthetic */ void initEncoders$calls_release(@NotNull EglBase.Context sharedContext, int width, int height) throws SendBirdException {
        Intrinsics.checkParameterIsNotNull((Object)sharedContext, (String)"sharedContext");
        Logger.d("[Recorder] initEncoders() width: " + width + ", height: " + height);
        switch (Recorder$WhenMappings.$EnumSwitchMapping$0[this.recordingOptions.getRecordingType$calls_release().ordinal()]) {
            case 1: 
            case 2: {
                this.audioEncoder = MediaEncoder.Companion.createAudioEncoder$calls_release(MediaEncoder.Type.AUDIO);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.audioEncoder = MediaEncoder.Companion.createAudioEncoder$calls_release(MediaEncoder.Type.AUDIO);
                this.videoEncoder = MediaEncoder.Companion.createVideoEncoder$calls_release(MediaEncoder.Type.VIDEO, sharedContext, width, height);
                break;
            }
        }
        try {
            this.mediaMixer = new MediaMixer(this.getFilePath(), CollectionsKt.listOfNotNull((Object[])new MediaEncoder[]{this.audioEncoder, this.videoEncoder}));
        }
        catch (SendBirdException e) {
            this.state = State.STOPPED;
            throw (Throwable)e;
        }
        this.state = State.RECORDING;
    }

    public final /* synthetic */ void stop$calls_release() {
        Logger.d("[Recorder] stop()");
        if (this.state != State.RECORDING) {
            Logger.d("[Recorder] Recorder(" + this.recordingId + ") is not recording.");
            return;
        }
        new Thread(new Runnable(this){
            final /* synthetic */ Recorder this$0;

            public final void run() {
                block5: {
                    Recorder.access$setState$p(this.this$0, State.STOPPED);
                    CountDownLatch countDownLatch = new CountDownLatch(2);
                    MediaEncoder mediaEncoder = Recorder.access$getAudioEncoder$p(this.this$0);
                    if (mediaEncoder != null) {
                        mediaEncoder.release$calls_release((Function0<Unit>)((Function0)new Function0<Unit>(countDownLatch){
                            final /* synthetic */ CountDownLatch $countDownLatch;

                            public final void invoke() {
                                this.$countDownLatch.countDown();
                            }
                            {
                                this.$countDownLatch = countDownLatch;
                                super(0);
                            }
                        }));
                    } else {
                        countDownLatch.countDown();
                    }
                    MediaEncoder mediaEncoder2 = Recorder.access$getVideoEncoder$p(this.this$0);
                    if (mediaEncoder2 != null) {
                        mediaEncoder2.release$calls_release((Function0<Unit>)((Function0)new Function0<Unit>(countDownLatch){
                            final /* synthetic */ CountDownLatch $countDownLatch;

                            public final void invoke() {
                                this.$countDownLatch.countDown();
                            }
                            {
                                this.$countDownLatch = countDownLatch;
                                super(0);
                            }
                        }));
                    } else {
                        countDownLatch.countDown();
                    }
                    countDownLatch.await();
                    MediaMixer mediaMixer = Recorder.access$getMediaMixer$p(this.this$0);
                    if (mediaMixer != null) {
                        mediaMixer.release$calls_release();
                    }
                    Function4<String, RecordingOptions, String, SendBirdException, Unit> function4 = this.this$0.getRecordingListener();
                    if (function4 == null) break block5;
                    MediaMixer mediaMixer2 = Recorder.access$getMediaMixer$p(this.this$0);
                    Unit cfr_ignored_0 = (Unit)function4.invoke((Object)this.this$0.getRecordingId(), (Object)Recorder.access$getRecordingOptions$p(this.this$0), (Object)(mediaMixer2 != null ? mediaMixer2.getFilePath() : null), null);
                }
            }
            {
                this.this$0 = recorder;
            }
        }).start();
    }

    @NotNull
    public final /* synthetic */ VideoSink getLocalVideoSink() {
        return new VideoSink(this){
            final /* synthetic */ Recorder this$0;

            public final void onFrame(@Nullable VideoFrame frame) {
                block1: {
                    if (!Recorder.access$isLocalVideoNeeded(this.this$0)) break block1;
                    MediaEncoder mediaEncoder = Recorder.access$getVideoEncoder$p(this.this$0);
                    if (mediaEncoder != null) {
                        mediaEncoder.onFrame(frame);
                    }
                }
            }
            {
                this.this$0 = recorder;
            }
        };
    }

    @NotNull
    public final /* synthetic */ VideoSink getRemoteVideoSink() {
        return new VideoSink(this){
            final /* synthetic */ Recorder this$0;

            public final void onFrame(@Nullable VideoFrame frame) {
                block1: {
                    if (!Recorder.access$isRemoteVideoNeeded(this.this$0)) break block1;
                    MediaEncoder mediaEncoder = Recorder.access$getVideoEncoder$p(this.this$0);
                    if (mediaEncoder != null) {
                        mediaEncoder.onFrame(frame);
                    }
                }
            }
            {
                this.this$0 = recorder;
            }
        };
    }

    @NotNull
    public final /* synthetic */ JavaAudioDeviceModule.SamplesReadyCallback getLocalAudioSamplesReadyCallback() {
        return new JavaAudioDeviceModule.SamplesReadyCallback(this){
            final /* synthetic */ Recorder this$0;

            public final void onWebRtcAudioRecordSamplesReady(JavaAudioDeviceModule.AudioSamples samples) {
                block1: {
                    AudioSampleQueue audioSampleQueue = Recorder.access$getAudioSampleQueue$p(this.this$0);
                    JavaAudioDeviceModule.AudioSamples audioSamples = samples;
                    Intrinsics.checkExpressionValueIsNotNull((Object)audioSamples, (String)"samples");
                    JavaAudioDeviceModule.AudioSamples audioSamples2 = audioSampleQueue.enqueueAudioPacket(true, audioSamples);
                    if (audioSamples2 == null) break block1;
                    JavaAudioDeviceModule.AudioSamples audioSamples3 = audioSamples2;
                    boolean bl = false;
                    boolean bl2 = false;
                    JavaAudioDeviceModule.AudioSamples it = audioSamples3;
                    boolean bl3 = false;
                    MediaEncoder mediaEncoder = Recorder.access$getAudioEncoder$p(this.this$0);
                    if (mediaEncoder != null) {
                        mediaEncoder.onWebRtcAudioRecordSamplesReady(it);
                    }
                }
            }
            {
                this.this$0 = recorder;
            }
        };
    }

    @NotNull
    public final /* synthetic */ JavaAudioDeviceModule.SamplesReadyCallback getRemoteAudioSamplesReadyCallback() {
        return new JavaAudioDeviceModule.SamplesReadyCallback(this){
            final /* synthetic */ Recorder this$0;

            public final void onWebRtcAudioRecordSamplesReady(JavaAudioDeviceModule.AudioSamples samples) {
                block1: {
                    AudioSampleQueue audioSampleQueue = Recorder.access$getAudioSampleQueue$p(this.this$0);
                    JavaAudioDeviceModule.AudioSamples audioSamples = samples;
                    Intrinsics.checkExpressionValueIsNotNull((Object)audioSamples, (String)"samples");
                    JavaAudioDeviceModule.AudioSamples audioSamples2 = audioSampleQueue.enqueueAudioPacket(false, audioSamples);
                    if (audioSamples2 == null) break block1;
                    JavaAudioDeviceModule.AudioSamples audioSamples3 = audioSamples2;
                    boolean bl = false;
                    boolean bl2 = false;
                    JavaAudioDeviceModule.AudioSamples it = audioSamples3;
                    boolean bl3 = false;
                    MediaEncoder mediaEncoder = Recorder.access$getAudioEncoder$p(this.this$0);
                    if (mediaEncoder != null) {
                        mediaEncoder.onWebRtcAudioRecordSamplesReady(it);
                    }
                }
            }
            {
                this.this$0 = recorder;
            }
        };
    }

    private final boolean isLocalAudioNeeded() {
        return this.recordingOptions.getRecordingType$calls_release() == RecordingOptions.RecordingType.LOCAL_REMOTE_AUDIOS || this.recordingOptions.getRecordingType$calls_release() == RecordingOptions.RecordingType.LOCAL_AUDIO_REMOTE_AUDIO_AND_VIDEO || this.recordingOptions.getRecordingType$calls_release() == RecordingOptions.RecordingType.LOCAL_AUDIO_AND_VIDEO_REMOTE_AUDIO;
    }

    private final boolean isRemoteAudioNeeded() {
        return true;
    }

    private final boolean isLocalVideoNeeded() {
        return this.recordingOptions.getRecordingType$calls_release() == RecordingOptions.RecordingType.LOCAL_AUDIO_AND_VIDEO_REMOTE_AUDIO;
    }

    private final boolean isRemoteVideoNeeded() {
        return this.recordingOptions.getRecordingType$calls_release() == RecordingOptions.RecordingType.REMOTE_AUDIO_AND_VIDEO || this.recordingOptions.getRecordingType$calls_release() == RecordingOptions.RecordingType.LOCAL_AUDIO_REMOTE_AUDIO_AND_VIDEO;
    }

    private final String getFilePath() {
        String directoryPath = this.recordingOptions.getDirectoryPath$calls_release();
        CharSequence charSequence = directoryPath;
        boolean bl = false;
        if (charSequence.length() == 0 || StringsKt.last((CharSequence)directoryPath) != '/') {
            directoryPath = directoryPath + '/';
        }
        Logger.d("[Recorder] getFilePath() directoryPath: " + directoryPath);
        charSequence = this.recordingOptions.getFileName$calls_release();
        bl = false;
        if (charSequence.length() == 0) {
            String dateAndTime = new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.getDefault()).format(new Date());
            return directoryPath + (Object)((Object)this.recordingOptions.getRecordingType$calls_release()) + '_' + this.callId + '_' + dateAndTime + ".mp4";
        }
        String fileName = this.recordingOptions.getFileName$calls_release();
        if (!StringsKt.contains$default((CharSequence)fileName, (CharSequence)".mp4", (boolean)false, (int)2, null)) {
            fileName = fileName + ".mp4";
        }
        return directoryPath + fileName;
    }

    public Recorder(@NotNull String callId, @NotNull RecordingOptions recordingOptions) {
        Intrinsics.checkParameterIsNotNull((Object)callId, (String)"callId");
        Intrinsics.checkParameterIsNotNull((Object)recordingOptions, (String)"recordingOptions");
        this.callId = callId;
        this.recordingOptions = recordingOptions;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        this.recordingId = string;
        this.state = State.UNINITIALIZED;
        this.audioSampleQueue = new AudioSampleQueue(this.recordingOptions.getRecordingType$calls_release());
    }

    public static final /* synthetic */ State access$getState$p(Recorder $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(Recorder $this, State state) {
        $this.state = state;
    }

    public static final /* synthetic */ MediaEncoder access$getAudioEncoder$p(Recorder $this) {
        return $this.audioEncoder;
    }

    public static final /* synthetic */ void access$setAudioEncoder$p(Recorder $this, MediaEncoder mediaEncoder) {
        $this.audioEncoder = mediaEncoder;
    }

    public static final /* synthetic */ MediaEncoder access$getVideoEncoder$p(Recorder $this) {
        return $this.videoEncoder;
    }

    public static final /* synthetic */ void access$setVideoEncoder$p(Recorder $this, MediaEncoder mediaEncoder) {
        $this.videoEncoder = mediaEncoder;
    }

    public static final /* synthetic */ MediaMixer access$getMediaMixer$p(Recorder $this) {
        return $this.mediaMixer;
    }

    public static final /* synthetic */ void access$setMediaMixer$p(Recorder $this, MediaMixer mediaMixer) {
        $this.mediaMixer = mediaMixer;
    }

    public static final /* synthetic */ RecordingOptions access$getRecordingOptions$p(Recorder $this) {
        return $this.recordingOptions;
    }

    public static final /* synthetic */ boolean access$isLocalVideoNeeded(Recorder $this) {
        return $this.isLocalVideoNeeded();
    }

    public static final /* synthetic */ boolean access$isRemoteVideoNeeded(Recorder $this) {
        return $this.isRemoteVideoNeeded();
    }

    public static final /* synthetic */ AudioSampleQueue access$getAudioSampleQueue$p(Recorder $this) {
        return $this.audioSampleQueue;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/sendbird/calls/internal/pc/Recorder$State;", "", "(Ljava/lang/String;I)V", "UNINITIALIZED", "RECORDING", "STOPPED", "calls_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State UNINITIALIZED;
        public static final /* enum */ State RECORDING;
        public static final /* enum */ State STOPPED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = UNINITIALIZED = new State();
            stateArray[1] = RECORDING = new State();
            stateArray[2] = STOPPED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0007J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/sendbird/calls/internal/pc/Recorder$AudioSampleQueue;", "", "type", "Lcom/sendbird/calls/RecordingOptions$RecordingType;", "(Lcom/sendbird/calls/internal/pc/Recorder;Lcom/sendbird/calls/RecordingOptions$RecordingType;)V", "localAudioQueue", "Ljava/util/Queue;", "Lorg/webrtc/audio/JavaAudioDeviceModule$AudioSamples;", "remoteAudioQueue", "getType", "()Lcom/sendbird/calls/RecordingOptions$RecordingType;", "dequeueAudioSamples", "isLocal", "", "enqueueAudioPacket", "packet", "merge", "localSample", "remoteSample", "calls_release"})
    public final class AudioSampleQueue {
        private final Queue<JavaAudioDeviceModule.AudioSamples> localAudioQueue;
        private final Queue<JavaAudioDeviceModule.AudioSamples> remoteAudioQueue;
        @NotNull
        private final RecordingOptions.RecordingType type;

        @Nullable
        public final synchronized /* synthetic */ JavaAudioDeviceModule.AudioSamples enqueueAudioPacket(boolean isLocal, @NotNull JavaAudioDeviceModule.AudioSamples packet) {
            boolean isRemoteAudioReady;
            boolean isLocalAudioReady;
            Intrinsics.checkParameterIsNotNull((Object)packet, (String)"packet");
            if (isLocal) {
                this.localAudioQueue.add(packet);
            } else {
                this.remoteAudioQueue.add(packet);
            }
            boolean bl = Recorder.this.isLocalAudioNeeded() ? this.localAudioQueue.size() >= 2 : (isLocalAudioReady = true);
            boolean bl2 = Recorder.this.isRemoteAudioNeeded() ? this.remoteAudioQueue.size() >= 2 : (isRemoteAudioReady = true);
            if (isLocalAudioReady && isRemoteAudioReady) {
                JavaAudioDeviceModule.AudioSamples localSample = this.dequeueAudioSamples(true);
                JavaAudioDeviceModule.AudioSamples remoteSample = this.dequeueAudioSamples(false);
                return this.merge(localSample, remoteSample);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final JavaAudioDeviceModule.AudioSamples merge(JavaAudioDeviceModule.AudioSamples localSample, JavaAudioDeviceModule.AudioSamples remoteSample) {
            JavaAudioDeviceModule.AudioSamples audioSamples = localSample;
            if (audioSamples == null) {
                return null;
            }
            JavaAudioDeviceModule.AudioSamples local = audioSamples;
            JavaAudioDeviceModule.AudioSamples audioSamples2 = remoteSample;
            if (audioSamples2 == null) {
                return null;
            }
            JavaAudioDeviceModule.AudioSamples remote = audioSamples2;
            if (local.getData().length != remote.getData().length || local.getSampleRate() != remote.getSampleRate() || local.getAudioFormat() != remote.getAudioFormat() || local.getChannelCount() != remote.getChannelCount()) {
                return null;
            }
            short[] localShortData = new short[local.getData().length / 2];
            short[] remoteShortData = new short[remote.getData().length / 2];
            ByteBuffer.wrap(local.getData()).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(localShortData);
            ByteBuffer.wrap(remote.getData()).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(remoteShortData);
            ByteBuffer mergedData = ByteBuffer.allocate(local.getData().length).order(ByteOrder.LITTLE_ENDIAN);
            int n = 0;
            int n2 = localShortData.length;
            while (n < n2) {
                void i;
                float mixedSample = ((float)localShortData[i] / 32768.0f + (float)remoteShortData[i] / 32768.0f) * 0.7f;
                mixedSample = mixedSample > 1.0f ? 1.0f : (mixedSample < -1.0f ? -1.0f : mixedSample);
                mergedData.putShort((short)(mixedSample * 32768.0f));
                ++i;
            }
            return new JavaAudioDeviceModule.AudioSamples(local.getAudioFormat(), local.getChannelCount(), local.getSampleRate(), mergedData.array());
        }

        private final JavaAudioDeviceModule.AudioSamples dequeueAudioSamples(boolean isLocal) {
            Queue<JavaAudioDeviceModule.AudioSamples> queue;
            Queue<JavaAudioDeviceModule.AudioSamples> queue2 = queue = isLocal ? this.localAudioQueue : this.remoteAudioQueue;
            if (queue.isEmpty() || queue.size() == 1) {
                return null;
            }
            JavaAudioDeviceModule.AudioSamples sample1 = queue.remove();
            JavaAudioDeviceModule.AudioSamples sample2 = queue.remove();
            JavaAudioDeviceModule.AudioSamples audioSamples = sample1;
            Intrinsics.checkExpressionValueIsNotNull((Object)audioSamples, (String)"sample1");
            int n = audioSamples.getAudioFormat();
            int n2 = sample1.getChannelCount();
            int n3 = sample1.getSampleRate();
            byte[] byArray = sample1.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"sample1.data");
            JavaAudioDeviceModule.AudioSamples audioSamples2 = sample2;
            Intrinsics.checkExpressionValueIsNotNull((Object)audioSamples2, (String)"sample2");
            byte[] byArray2 = audioSamples2.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"sample2.data");
            return new JavaAudioDeviceModule.AudioSamples(n, n2, n3, ArraysKt.plus((byte[])byArray, (byte[])byArray2));
        }

        @NotNull
        public final RecordingOptions.RecordingType getType() {
            return this.type;
        }

        public AudioSampleQueue(RecordingOptions.RecordingType type) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
            this.type = type;
            this.localAudioQueue = new ConcurrentLinkedQueue();
            this.remoteAudioQueue = new ConcurrentLinkedQueue();
        }
    }
}

