/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.pc;

import com.sendbird.calls.internal.pc.PeerConnectionParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.webrtc.MediaConstraints;
import org.webrtc.SessionDescription;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\u001a\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0001H\u0002\u001a#\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010'H\u0002\u00a2\u0006\u0002\u0010(\u001a\u0010\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020+H\u0002\u001a\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020%H\u0002\u001a\u0010\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020+H\u0002\u001a*\u00102\u001a\u0004\u0018\u00010\u00012\u000e\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u000105042\u0006\u00106\u001a\u00020\u00012\u0006\u00107\u001a\u00020%H\u0002\u001a \u00108\u001a\u0004\u0018\u00010\u00012\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00010:2\u0006\u0010;\u001a\u00020\u0001H\u0002\u001a\"\u0010<\u001a\u0004\u0018\u00010\u00012\u0006\u0010=\u001a\u00020\u00012\u0006\u0010>\u001a\u00020\u00012\u0006\u0010$\u001a\u00020%H\u0002\u001a(\u0010?\u001a\u00020\u00012\u0006\u0010>\u001a\u00020\u00012\u0006\u0010@\u001a\u00020%2\u0006\u0010=\u001a\u00020\u00012\u0006\u0010A\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000e\u001a\u00020\n8@X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0016\u0010\u0011\u001a\u00020\n8@X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT", "", "AUDIO_CODEC_ISAC", "AUDIO_CODEC_OPUS", "AUDIO_CODEC_PARAM_BITRATE", "AUDIO_ECHO_CANCELLATION_CONSTRAINT", "AUDIO_HIGH_PASS_FILTER_CONSTRAINT", "AUDIO_NOISE_SUPPRESSION_CONSTRAINT", "AUDIO_TRACK_ID", "BPS_IN_KBPS", "", "DEFAULT_FPS", "DISABLE_WEBRTC_AGC_FIELDTRIAL", "DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT", "HD_VIDEO_HEIGHT", "getHD_VIDEO_HEIGHT", "()I", "HD_VIDEO_WIDTH", "getHD_VIDEO_WIDTH", "RTCEVENTLOG_OUTPUT_DIR_NAME", "VIDEO_CODEC_H264", "VIDEO_CODEC_H264_BASELINE", "VIDEO_CODEC_H264_HIGH", "VIDEO_CODEC_PARAM_START_BITRATE", "VIDEO_CODEC_VP8", "VIDEO_CODEC_VP9", "VIDEO_FLEXFEC_FIELDTRIAL", "VIDEO_TRACK_ID", "VIDEO_TRACK_TYPE", "VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL", "createSessionDescription", "Lorg/webrtc/SessionDescription;", "type", "Lorg/webrtc/SessionDescription$Type;", "description", "findMediaDescriptionLine", "isAudio", "", "sdpLines", "", "(Z[Ljava/lang/String;)I", "getFieldTrials", "peerConnectionParameters", "Lcom/sendbird/calls/internal/pc/PeerConnectionParameters;", "getMediaConstraints", "Lorg/webrtc/MediaConstraints;", "isIceRestart", "isVideoCall", "getSdpVideoCodecName", "parameters", "joinString", "s", "", "", "delimiter", "delimiterAtEnd", "movePayloadTypesToFront", "preferredPayloadTypes", "", "mLine", "preferCodec", "sdpDescription", "codec", "setStartBitrate", "isVideoCodec", "bitrateKbps", "calls_release"})
public final class PeerConnectionKt {
    private static final String VIDEO_TRACK_ID = "ARDAMSv0";
    private static final String AUDIO_TRACK_ID = "ARDAMSa0";
    private static final String VIDEO_TRACK_TYPE = "video";
    private static final String VIDEO_CODEC_VP8 = "VP8";
    private static final String VIDEO_CODEC_VP9 = "VP9";
    private static final String VIDEO_CODEC_H264 = "H264";
    private static final String VIDEO_CODEC_H264_BASELINE = "H264 Baseline";
    private static final String VIDEO_CODEC_H264_HIGH = "H264 High";
    private static final String AUDIO_CODEC_OPUS = "opus";
    private static final String AUDIO_CODEC_ISAC = "ISAC";
    private static final String VIDEO_CODEC_PARAM_START_BITRATE = "x-google-start-bitrate";
    private static final String VIDEO_FLEXFEC_FIELDTRIAL = "WebRTC-FlexFEC-03-Advertised/Enabled/WebRTC-FlexFEC-03/Enabled/";
    private static final String VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL = "WebRTC-IntelVP8/Enabled/";
    private static final String DISABLE_WEBRTC_AGC_FIELDTRIAL = "WebRTC-Audio-MinimizeResamplingOnMobile/Enabled/";
    private static final String AUDIO_CODEC_PARAM_BITRATE = "maxaveragebitrate";
    private static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private static final int DEFAULT_FPS = 24;
    private static final int BPS_IN_KBPS = 1000;
    private static final String RTCEVENTLOG_OUTPUT_DIR_NAME = "rtc_event_log";
    private static final int HD_VIDEO_WIDTH = 1280;
    private static final int HD_VIDEO_HEIGHT = 720;

    public static final /* synthetic */ int getHD_VIDEO_WIDTH() {
        return HD_VIDEO_WIDTH;
    }

    public static final /* synthetic */ int getHD_VIDEO_HEIGHT() {
        return HD_VIDEO_HEIGHT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getSdpVideoCodecName(PeerConnectionParameters parameters) {
        String string = parameters.getVideoCodec();
        switch (string.hashCode()) {
            case -2140422726: {
                if (!string.equals(VIDEO_CODEC_H264_HIGH)) return VIDEO_CODEC_VP8;
                return VIDEO_CODEC_H264;
            }
            case -1031013795: {
                if (!string.equals(VIDEO_CODEC_H264_BASELINE)) return VIDEO_CODEC_VP8;
                return VIDEO_CODEC_H264;
            }
            case 85183: {
                if (!string.equals(VIDEO_CODEC_VP9)) return VIDEO_CODEC_VP8;
                return VIDEO_CODEC_VP9;
            }
            case 85182: {
                if (!string.equals(VIDEO_CODEC_VP8)) return VIDEO_CODEC_VP8;
                return VIDEO_CODEC_VP8;
            }
        }
        return VIDEO_CODEC_VP8;
    }

    private static final String getFieldTrials(PeerConnectionParameters peerConnectionParameters) {
        String fieldTrials = "";
        if (peerConnectionParameters.getVideoFlexfecEnabled()) {
            fieldTrials = fieldTrials + VIDEO_FLEXFEC_FIELDTRIAL;
        }
        fieldTrials = fieldTrials + VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL;
        if (peerConnectionParameters.getDisableWebRtcAGCAndHPF()) {
            fieldTrials = fieldTrials + DISABLE_WEBRTC_AGC_FIELDTRIAL;
        }
        return fieldTrials;
    }

    /*
     * WARNING - void declaration
     */
    private static final int findMediaDescriptionLine(boolean isAudio, String[] sdpLines) {
        String mediaDescription = isAudio ? "m=audio " : "m=video ";
        int n = 0;
        int n2 = sdpLines.length;
        while (n < n2) {
            void i;
            if (StringsKt.startsWith$default((String)sdpLines[i], (String)mediaDescription, (boolean)false, (int)2, null)) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    private static final String joinString(Iterable<? extends CharSequence> s, String delimiter, boolean delimiterAtEnd) {
        Iterator<? extends CharSequence> iter = s.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        CharSequence charSequence = iter.next();
        if (charSequence == null) {
            Intrinsics.throwNpe();
        }
        StringBuilder buffer = new StringBuilder(charSequence);
        while (iter.hasNext()) {
            buffer.append(delimiter).append(iter.next());
        }
        if (delimiterAtEnd) {
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private static final String movePayloadTypesToFront(List<String> preferredPayloadTypes, String mLine) {
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)mLine, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        List<String> origLineParts = Arrays.asList(Arrays.copyOf(stringArray, stringArray.length));
        if (origLineParts.size() <= 3) {
            return null;
        }
        List<String> header = origLineParts.subList(0, 3);
        List unpreferredPayloadTypes = new ArrayList(origLineParts.subList(3, origLineParts.size()));
        unpreferredPayloadTypes.removeAll((Collection)preferredPayloadTypes);
        List newLineParts = new ArrayList();
        newLineParts.addAll((Collection)header);
        newLineParts.addAll((Collection)preferredPayloadTypes);
        newLineParts.addAll(unpreferredPayloadTypes);
        return PeerConnectionKt.joinString(newLineParts, " ", false);
    }

    private static final String preferCodec(String sdpDescription, String codec, boolean isAudio) {
        String newMLine;
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)sdpDescription, (String[])new String[]{"\r\n"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] lines = stringArray;
        int mLineIndex = PeerConnectionKt.findMediaDescriptionLine(isAudio, lines);
        if (mLineIndex == -1) {
            return sdpDescription;
        }
        List codecPayloadTypes = new ArrayList();
        Pattern codecPattern = Pattern.compile("^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$");
        for (String line : lines) {
            Matcher codecMatcher = codecPattern.matcher(line);
            if (!codecMatcher.matches()) continue;
            String string = codecMatcher.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"codecMatcher.group(1)");
            codecPayloadTypes.add(string);
        }
        if (codecPayloadTypes.isEmpty()) {
            return sdpDescription;
        }
        String string = PeerConnectionKt.movePayloadTypesToFront(codecPayloadTypes, lines[mLineIndex]);
        if (string == null) {
            return sdpDescription;
        }
        lines[mLineIndex] = newMLine = string;
        return PeerConnectionKt.joinString(CollectionsKt.listOf((Object[])Arrays.copyOf(lines, lines.length)), "\r\n", true);
    }

    private static final MediaConstraints getMediaConstraints(boolean isIceRestart, boolean isVideoCall) {
        MediaConstraints sdpMediaConstraints = new MediaConstraints();
        sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", Boolean.toString(isVideoCall)));
        if (isIceRestart) {
            sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("IceRestart", "true"));
        }
        return sdpMediaConstraints;
    }

    /*
     * WARNING - void declaration
     */
    private static final String setStartBitrate(String codec, boolean isVideoCodec, String sdpDescription, int bitrateKbps) {
        Matcher codecMatcher;
        int i;
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)sdpDescription, (String[])new String[]{"\r\n"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] lines = stringArray;
        int rtpmapLineIndex = -1;
        boolean sdpFormatUpdated = false;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$";
        Pattern codecPattern = Pattern.compile(regex);
        int n = 0;
        int n2 = lines.length;
        while (n < n2) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (codecMatcher.matches()) {
                codecRtpMap = codecMatcher.group(1);
                rtpmapLineIndex = i;
                break;
            }
            ++i;
        }
        if (codecRtpMap == null) {
            return sdpDescription;
        }
        regex = "^a=fmtp:" + codecRtpMap + " \\w+=\\d+.*[\r]?$";
        codecPattern = Pattern.compile(regex);
        n2 = lines.length;
        for (i = 0; i < n2; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            if (isVideoCodec) {
                int n3 = i;
                lines[n3] = lines[n3] + "; x-google-start-bitrate=" + bitrateKbps;
            } else {
                int n4 = i;
                lines[n4] = lines[n4] + "; maxaveragebitrate=" + bitrateKbps * 1000;
            }
            sdpFormatUpdated = true;
            break;
        }
        StringBuilder newSdpDescription = new StringBuilder();
        n2 = 0;
        int n5 = lines.length;
        while (n2 < n5) {
            void i2;
            newSdpDescription.append(lines[i2]).append("\r\n");
            if (!sdpFormatUpdated && i2 == rtpmapLineIndex) {
                String bitrateSet = isVideoCodec ? "a=fmtp:" + codecRtpMap + " x-google-start-bitrate=" + bitrateKbps : "a=fmtp:" + codecRtpMap + " " + AUDIO_CODEC_PARAM_BITRATE + "=" + bitrateKbps * 1000;
                newSdpDescription.append(bitrateSet).append("\r\n");
            }
            ++i2;
        }
        String string = newSdpDescription.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newSdpDescription.toString()");
        return string;
    }

    private static final SessionDescription createSessionDescription(SessionDescription.Type type, String description) {
        String string = description;
        StringBuilder stringBuilder = new StringBuilder();
        SessionDescription.Type type2 = type;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        String string4 = stringBuilder.append(string3).append("\r\n").toString();
        SessionDescription.Type type3 = type2;
        return new SessionDescription(type3, string4);
    }

    static {
        HD_VIDEO_WIDTH = 1280;
        HD_VIDEO_HEIGHT = 720;
    }

    public static final /* synthetic */ String access$preferCodec(String sdpDescription, String codec, boolean isAudio) {
        return PeerConnectionKt.preferCodec(sdpDescription, codec, isAudio);
    }

    public static final /* synthetic */ String access$getSdpVideoCodecName(PeerConnectionParameters parameters) {
        return PeerConnectionKt.getSdpVideoCodecName(parameters);
    }

    public static final /* synthetic */ SessionDescription access$createSessionDescription(SessionDescription.Type type, String description) {
        return PeerConnectionKt.createSessionDescription(type, description);
    }

    public static final /* synthetic */ MediaConstraints access$getMediaConstraints(boolean isIceRestart, boolean isVideoCall) {
        return PeerConnectionKt.getMediaConstraints(isIceRestart, isVideoCall);
    }

    public static final /* synthetic */ String access$setStartBitrate(String codec, boolean isVideoCodec, String sdpDescription, int bitrateKbps) {
        return PeerConnectionKt.setStartBitrate(codec, isVideoCodec, sdpDescription, bitrateKbps);
    }

    public static final /* synthetic */ String access$getFieldTrials(PeerConnectionParameters peerConnectionParameters) {
        return PeerConnectionKt.getFieldTrials(peerConnectionParameters);
    }
}

