/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls.internal.pc;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import com.sendbird.calls.AudioDevice;
import com.sendbird.calls.internal.pc.AppRTCAudioManager;
import com.sendbird.calls.internal.pc.AppRTCAudioManager$WhenMappings;
import com.sendbird.calls.internal.pc.AppRTCBluetoothManager;
import com.sendbird.calls.internal.util.AppRTCUtils;
import java.util.HashSet;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.ThreadUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0000\u0018\u0000 @2\u00020\u0001:\u0003?@AB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010-\u001a\u00020\u0005J\b\u0010 \u001a\u00020\u0005H\u0003J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020,2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u00052\b\u00103\u001a\u0004\u0018\u00010\tJ\u0012\u00104\u001a\u00020\u001b2\b\u00103\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u00105\u001a\u00020\u001b2\b\u00106\u001a\u0004\u0018\u00010\tJ\u0010\u00107\u001a\u00020\u001b2\b\u00106\u001a\u0004\u0018\u00010\tJ\u0010\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u0005H\u0002J\u0010\u0010:\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u0005H\u0002JN\u0010;\u001a\u00020\u001b2F\u0010\u0015\u001aB\u0012\u0015\u0012\u0013\u0018\u00010\t\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\t0\u000e\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0016j\u0004\u0018\u0001`\u001cJ\u0006\u0010<\u001a\u00020\u001bJ\u0010\u0010=\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020,H\u0002J\u0006\u0010>\u001a\u00020\u001bR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0015\u001aB\u0012\u0015\u0012\u0013\u0018\u00010\t\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\t0\u000e\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0016j\u0004\u0018\u0001`\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u0004\u0018\u00010\t2\b\u0010%\u001a\u0004\u0018\u00010\t8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/sendbird/calls/internal/pc/AppRTCAudioManager;", "", "context", "Landroid/content/Context;", "isVideoCall", "", "(Landroid/content/Context;Z)V", "_audioDevices", "", "Lcom/sendbird/calls/AudioDevice;", "amState", "Lcom/sendbird/calls/internal/pc/AppRTCAudioManager$AudioManagerState;", "apprtcContext", "audioDevices", "", "getAudioDevices", "()Ljava/util/Set;", "audioFocusChangeListener", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "audioManager", "Landroid/media/AudioManager;", "audioManagerEvents", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "selectedAudioDevice", "availableAudioDevices", "", "Lcom/sendbird/calls/internal/util/AudioManagerEvents;", "bluetoothManager", "Lcom/sendbird/calls/internal/pc/AppRTCBluetoothManager;", "defaultAudioDevice", "hasWiredHeadset", "savedAudioMode", "", "savedIsMicrophoneMute", "savedIsSpeakerPhoneOn", "<set-?>", "getSelectedAudioDevice", "()Lcom/sendbird/calls/AudioDevice;", "useSpeakerphone", "", "userSelectedAudioDevice", "wiredHeadsetReceiver", "Landroid/content/BroadcastReceiver;", "hasEarpiece", "registerReceiver", "receiver", "filter", "Landroid/content/IntentFilter;", "selectAudioDevice", "device", "setAudioDeviceInternal", "setDefaultAudioDevice", "defaultDevice", "setDefaultAudioDeviceWithoutUpdate", "setMicrophoneMute", "on", "setSpeakerphoneOn", "start", "stop", "unregisterReceiver", "updateAudioDeviceState", "AudioManagerState", "Companion", "WiredHeadsetReceiver", "calls_release"})
public final class AppRTCAudioManager {
    private final Context apprtcContext;
    private final AudioManager audioManager;
    private Function2<? super AudioDevice, ? super Set<? extends AudioDevice>, Unit> audioManagerEvents;
    private AudioManagerState amState;
    private int savedAudioMode = -2;
    private boolean savedIsSpeakerPhoneOn;
    private boolean savedIsMicrophoneMute;
    private boolean hasWiredHeadset;
    private AudioDevice defaultAudioDevice;
    @Nullable
    private AudioDevice selectedAudioDevice;
    private AudioDevice userSelectedAudioDevice;
    private String useSpeakerphone;
    private final AppRTCBluetoothManager bluetoothManager;
    private Set<AudioDevice> _audioDevices = new HashSet();
    private final BroadcastReceiver wiredHeadsetReceiver;
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;
    private static final String TAG = "AppRTCAudioManager";
    private static final String SPEAKERPHONE_AUTO = "auto";
    private static final String SPEAKERPHONE_TRUE = "true";
    private static final String SPEAKERPHONE_FALSE = "false";
    private static final int STATE_UNPLUGGED = 0;
    private static final int STATE_PLUGGED = 1;
    private static final int HAS_NO_MIC = 0;
    private static final int HAS_MIC = 1;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final /* synthetic */ AudioDevice getSelectedAudioDevice() {
        return this.selectedAudioDevice;
    }

    @NotNull
    public final /* synthetic */ Set<AudioDevice> getAudioDevices() {
        return CollectionsKt.toSet((Iterable)this._audioDevices);
    }

    public final /* synthetic */ void start(@Nullable Function2<? super AudioDevice, ? super Set<? extends AudioDevice>, Unit> audioManagerEvents) {
        ThreadUtils.checkIsOnMainThread();
        if (this.amState == AudioManagerState.RUNNING) {
            return;
        }
        this.audioManagerEvents = audioManagerEvents;
        this.amState = AudioManagerState.RUNNING;
        AudioManager audioManager = this.audioManager;
        if (audioManager == null) {
            Intrinsics.throwNpe();
        }
        this.savedAudioMode = audioManager.getMode();
        this.savedIsSpeakerPhoneOn = this.audioManager.isSpeakerphoneOn();
        this.savedIsMicrophoneMute = this.audioManager.isMicrophoneMute();
        this.hasWiredHeadset = this.hasWiredHeadset();
        this.audioFocusChangeListener = start.1.INSTANCE;
        int result = this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 0, 2);
        if (result == 1) {
            // empty if block
        }
        this.audioManager.setMode(3);
        this.setMicrophoneMute(false);
        this.userSelectedAudioDevice = null;
        this.selectedAudioDevice = null;
        this._audioDevices.clear();
        this.bluetoothManager.start();
        this.updateAudioDeviceState();
        this.registerReceiver(this.wiredHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
    }

    public final /* synthetic */ void stop() {
        ThreadUtils.checkIsOnMainThread();
        if (this.amState != AudioManagerState.RUNNING) {
            return;
        }
        this.amState = AudioManagerState.UNINITIALIZED;
        this.unregisterReceiver(this.wiredHeadsetReceiver);
        this.bluetoothManager.stop();
        this.setSpeakerphoneOn(this.savedIsSpeakerPhoneOn);
        this.setMicrophoneMute(this.savedIsMicrophoneMute);
        AudioManager audioManager = this.audioManager;
        if (audioManager == null) {
            Intrinsics.throwNpe();
        }
        audioManager.setMode(this.savedAudioMode);
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        this.audioFocusChangeListener = null;
        this.audioManagerEvents = null;
    }

    private final void setAudioDeviceInternal(AudioDevice device) {
        AppRTCUtils.INSTANCE.assertIsTrue(CollectionsKt.contains((Iterable)this._audioDevices, (Object)((Object)device)));
        AudioDevice audioDevice = device;
        if (audioDevice != null) {
            switch (AppRTCAudioManager$WhenMappings.$EnumSwitchMapping$0[audioDevice.ordinal()]) {
                case 1: {
                    this.setSpeakerphoneOn(true);
                    break;
                }
                case 2: {
                    this.setSpeakerphoneOn(false);
                    break;
                }
                case 3: {
                    this.setSpeakerphoneOn(false);
                    break;
                }
                case 4: {
                    this.setSpeakerphoneOn(false);
                    break;
                }
            }
        }
        this.selectedAudioDevice = device;
    }

    public final /* synthetic */ void setDefaultAudioDevice(@Nullable AudioDevice defaultDevice) {
        ThreadUtils.checkIsOnMainThread();
        AudioDevice audioDevice = defaultDevice;
        if (audioDevice != null) {
            switch (AppRTCAudioManager$WhenMappings.$EnumSwitchMapping$1[audioDevice.ordinal()]) {
                case 1: {
                    this.defaultAudioDevice = defaultDevice;
                    break;
                }
                case 2: {
                    this.defaultAudioDevice = this.hasEarpiece() ? defaultDevice : AudioDevice.SPEAKERPHONE;
                    break;
                }
            }
        }
        this.updateAudioDeviceState();
    }

    public final /* synthetic */ void setDefaultAudioDeviceWithoutUpdate(@Nullable AudioDevice defaultDevice) {
        AudioDevice audioDevice = defaultDevice;
        if (audioDevice != null) {
            switch (AppRTCAudioManager$WhenMappings.$EnumSwitchMapping$2[audioDevice.ordinal()]) {
                case 1: {
                    this.defaultAudioDevice = defaultDevice;
                    break;
                }
                case 2: {
                    this.defaultAudioDevice = this.hasEarpiece() ? defaultDevice : AudioDevice.SPEAKERPHONE;
                    break;
                }
            }
        }
    }

    public final /* synthetic */ boolean selectAudioDevice(@Nullable AudioDevice device) {
        ThreadUtils.checkIsOnMainThread();
        if (!CollectionsKt.contains((Iterable)this._audioDevices, (Object)((Object)device))) {
            return false;
        }
        this.userSelectedAudioDevice = device;
        this.updateAudioDeviceState();
        return true;
    }

    private final void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.apprtcContext.registerReceiver(receiver, filter);
    }

    private final void unregisterReceiver(BroadcastReceiver receiver) {
        this.apprtcContext.unregisterReceiver(receiver);
    }

    private final void setSpeakerphoneOn(boolean on) {
        boolean wasOn;
        AudioManager audioManager = this.audioManager;
        if (audioManager == null) {
            Intrinsics.throwNpe();
        }
        if ((wasOn = audioManager.isSpeakerphoneOn()) == on) {
            return;
        }
        this.audioManager.setSpeakerphoneOn(on);
    }

    private final void setMicrophoneMute(boolean on) {
        boolean wasMuted;
        AudioManager audioManager = this.audioManager;
        if (audioManager == null) {
            Intrinsics.throwNpe();
        }
        if ((wasMuted = audioManager.isMicrophoneMute()) == on) {
            return;
        }
        this.audioManager.setMicrophoneMute(on);
    }

    public final /* synthetic */ boolean hasEarpiece() {
        return this.apprtcContext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @Deprecated(message="")
    private final boolean hasWiredHeadset() {
        boolean bl;
        if (Build.VERSION.SDK_INT < 23) {
            AudioManager audioManager = this.audioManager;
            if (audioManager == null) {
                Intrinsics.throwNpe();
            }
            bl = audioManager.isWiredHeadsetOn();
        } else {
            AudioDeviceInfo[] devices;
            AudioManager audioManager = this.audioManager;
            if (audioManager == null) {
                Intrinsics.throwNpe();
            }
            AudioDeviceInfo[] audioDeviceInfoArray = devices = audioManager.getDevices(3);
            int n = audioDeviceInfoArray.length;
            for (int i = 0; i < n; ++i) {
                AudioDeviceInfo device;
                AudioDeviceInfo audioDeviceInfo = device = audioDeviceInfoArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)audioDeviceInfo, (String)"device");
                int type = audioDeviceInfo.getType();
                if (type == 3) {
                    return true;
                }
                if (type != 11) continue;
                return true;
            }
            bl = false;
        }
        return bl;
    }

    public final /* synthetic */ void updateAudioDeviceState() {
        block12: {
            AudioDevice newAudioDevice;
            boolean needBluetoothAudioStop;
            ThreadUtils.checkIsOnMainThread();
            if (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_DISCONNECTING) {
                this.bluetoothManager.updateDevice();
            }
            Set newAudioDevices = new HashSet();
            if (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE) {
                newAudioDevices.add(AudioDevice.BLUETOOTH);
            }
            if (this.hasWiredHeadset) {
                newAudioDevices.add(AudioDevice.WIRED_HEADSET);
            } else {
                newAudioDevices.add(AudioDevice.SPEAKERPHONE);
                if (this.hasEarpiece()) {
                    newAudioDevices.add(AudioDevice.EARPIECE);
                }
            }
            boolean audioDeviceSetUpdated = Intrinsics.areEqual(this._audioDevices, (Object)newAudioDevices) ^ true;
            this._audioDevices = newAudioDevices;
            if (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE && this.userSelectedAudioDevice == AudioDevice.BLUETOOTH) {
                this.userSelectedAudioDevice = null;
            }
            if (this.hasWiredHeadset && this.userSelectedAudioDevice == AudioDevice.SPEAKERPHONE) {
                this.userSelectedAudioDevice = AudioDevice.WIRED_HEADSET;
            }
            if (!this.hasWiredHeadset && this.userSelectedAudioDevice == AudioDevice.WIRED_HEADSET) {
                this.userSelectedAudioDevice = AudioDevice.SPEAKERPHONE;
            }
            boolean needBluetoothAudioStart = this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE && (this.userSelectedAudioDevice == null || this.userSelectedAudioDevice == AudioDevice.BLUETOOTH);
            boolean bl = needBluetoothAudioStop = (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING) && this.userSelectedAudioDevice != null && this.userSelectedAudioDevice != AudioDevice.BLUETOOTH;
            if (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED) {
                // empty if block
            }
            if (needBluetoothAudioStop) {
                this.bluetoothManager.stopScoAudio();
                this.bluetoothManager.updateDevice();
            }
            if (needBluetoothAudioStart && !needBluetoothAudioStop && !this.bluetoothManager.startScoAudio()) {
                this._audioDevices.remove((Object)AudioDevice.BLUETOOTH);
                audioDeviceSetUpdated = true;
            }
            AudioDevice audioDevice = this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED ? AudioDevice.BLUETOOTH : (newAudioDevice = this.hasWiredHeadset ? AudioDevice.WIRED_HEADSET : this.defaultAudioDevice);
            if (newAudioDevice == this.selectedAudioDevice && !audioDeviceSetUpdated) break block12;
            this.setAudioDeviceInternal(newAudioDevice);
            Function2<? super AudioDevice, ? super Set<? extends AudioDevice>, Unit> function2 = this.audioManagerEvents;
            if (function2 != null) {
                Unit cfr_ignored_0 = (Unit)function2.invoke((Object)this.selectedAudioDevice, this.getAudioDevices());
            }
        }
    }

    private AppRTCAudioManager(Context context, boolean isVideoCall) {
        ThreadUtils.checkIsOnMainThread();
        this.apprtcContext = context;
        Object object = context.getSystemService("audio");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
        }
        this.audioManager = (AudioManager)object;
        this.bluetoothManager = AppRTCBluetoothManager.Companion.create(context, this);
        this.wiredHeadsetReceiver = new WiredHeadsetReceiver();
        this.amState = AudioManagerState.UNINITIALIZED;
        this.useSpeakerphone = !isVideoCall && this.hasEarpiece() ? SPEAKERPHONE_FALSE : SPEAKERPHONE_AUTO;
        this.defaultAudioDevice = Intrinsics.areEqual((Object)this.useSpeakerphone, (Object)SPEAKERPHONE_FALSE) ? AudioDevice.EARPIECE : AudioDevice.SPEAKERPHONE;
        AppRTCUtils.INSTANCE.logDeviceInfo(TAG);
    }

    public static final /* synthetic */ boolean access$getHasWiredHeadset$p(AppRTCAudioManager $this) {
        return $this.hasWiredHeadset;
    }

    public /* synthetic */ AppRTCAudioManager(Context context, boolean isVideoCall, DefaultConstructorMarker $constructor_marker) {
        this(context, isVideoCall);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/sendbird/calls/internal/pc/AppRTCAudioManager$AudioManagerState;", "", "(Ljava/lang/String;I)V", "UNINITIALIZED", "PREINITIALIZED", "RUNNING", "calls_release"})
    public static final class AudioManagerState
    extends Enum<AudioManagerState> {
        public static final /* enum */ AudioManagerState UNINITIALIZED;
        public static final /* enum */ AudioManagerState PREINITIALIZED;
        public static final /* enum */ AudioManagerState RUNNING;
        private static final /* synthetic */ AudioManagerState[] $VALUES;

        static {
            AudioManagerState[] audioManagerStateArray = new AudioManagerState[3];
            AudioManagerState[] audioManagerStateArray2 = audioManagerStateArray;
            audioManagerStateArray[0] = UNINITIALIZED = new AudioManagerState();
            audioManagerStateArray[1] = PREINITIALIZED = new AudioManagerState();
            audioManagerStateArray[2] = RUNNING = new AudioManagerState();
            $VALUES = audioManagerStateArray;
        }

        public static AudioManagerState[] values() {
            return (AudioManagerState[])$VALUES.clone();
        }

        public static AudioManagerState valueOf(String string) {
            return Enum.valueOf(AudioManagerState.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/sendbird/calls/internal/pc/AppRTCAudioManager$WiredHeadsetReceiver;", "Landroid/content/BroadcastReceiver;", "(Lcom/sendbird/calls/internal/pc/AppRTCAudioManager;)V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "calls_release"})
    private final class WiredHeadsetReceiver
    extends BroadcastReceiver {
        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            int state = intent.getIntExtra("state", 0);
            int microphone = intent.getIntExtra("microphone", 0);
            String name = intent.getStringExtra("name");
            AppRTCAudioManager.this.hasWiredHeadset = state == 1;
            AppRTCAudioManager.this.updateAudioDeviceState();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/sendbird/calls/internal/pc/AppRTCAudioManager$Companion;", "", "()V", "HAS_MIC", "", "HAS_NO_MIC", "SPEAKERPHONE_AUTO", "", "SPEAKERPHONE_FALSE", "SPEAKERPHONE_TRUE", "STATE_PLUGGED", "STATE_UNPLUGGED", "TAG", "create", "Lcom/sendbird/calls/internal/pc/AppRTCAudioManager;", "context", "Landroid/content/Context;", "isVideoCall", "", "calls_release"})
    public static final class Companion {
        @NotNull
        public final /* synthetic */ AppRTCAudioManager create(@NotNull Context context, boolean isVideoCall) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return new AppRTCAudioManager(context, isVideoCall, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

