/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.os.AsyncTask;
import android.util.Base64;
import com.sendbird.calls.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class StringUtils {
    private static final String CHARSET_NAME = "UTF-8";

    StringUtils() {
    }

    static void compress(final String str, final ResultHandler handler) {
        if (str != null && str.length() > 0) {
            Logger.d("[StringUtils] compress(" + str.length() + ")");
            new CompressTask(str, new ResultHandler(){

                @Override
                public void onResult(String result) {
                    Logger.d("[StringUtils] compress(" + str.length() + ") => " + (result != null ? Integer.valueOf(result.length()) : "null"));
                    if (handler != null) {
                        handler.onResult(result);
                    }
                }
            }).execute(new Void[0]);
        } else if (handler != null) {
            handler.onResult(null);
        }
    }

    static void uncompress(final String compressedStr, final ResultHandler handler) {
        if (compressedStr != null && compressedStr.length() > 0) {
            Logger.d("[StringUtils] uncompress(" + compressedStr.length() + ")");
            new UncompressTask(compressedStr, new ResultHandler(){

                @Override
                public void onResult(String result) {
                    Logger.d("[StringUtils] uncompress(" + compressedStr.length() + ") => " + (result != null ? Integer.valueOf(result.length()) : "null"));
                    if (handler != null) {
                        handler.onResult(result);
                    }
                }
            }).execute(new Void[0]);
        } else if (handler != null) {
            handler.onResult(null);
        }
    }

    static String uncompress(String compressedStr) {
        if (compressedStr != null && compressedStr.length() > 0) {
            return StringUtils.localUncompress(compressedStr);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String localCompress(String str) {
        String result = null;
        if (str != null && str.length() > 0) {
            byte[] bytes = str.getBytes(Charset.forName(CHARSET_NAME));
            ByteArrayOutputStream baos = null;
            GZIPWithBestCompressionOutputStream gzipos = null;
            FilterOutputStream bos = null;
            try {
                baos = new ByteArrayOutputStream();
                gzipos = new GZIPWithBestCompressionOutputStream(baos);
                bos = new BufferedOutputStream(gzipos);
                bos.write(bytes);
                bos.close();
                gzipos.close();
                baos.close();
                result = StringUtils.encode(baos.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (result == null) {
                    try {
                        if (bos != null) {
                            bos.close();
                        }
                        if (gzipos != null) {
                            gzipos.close();
                        }
                        if (baos != null) {
                            baos.close();
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String localUncompress(String compressedStr) {
        byte[] bytes;
        String result = null;
        if (compressedStr != null && compressedStr.length() > 0 && (bytes = StringUtils.decode(compressedStr)) != null) {
            ByteArrayInputStream bais = null;
            GZIPInputStream gzipis = null;
            BufferedInputStream bis = null;
            ByteArrayOutputStream baos = null;
            try {
                int length;
                bais = new ByteArrayInputStream(bytes);
                gzipis = new GZIPInputStream(bais);
                bis = new BufferedInputStream(gzipis);
                baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((length = bis.read(buffer)) > 0) {
                    baos.write(buffer, 0, length);
                }
                bis.close();
                gzipis.close();
                bais.close();
                baos.close();
                result = baos.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (result == null) {
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                        if (gzipis != null) {
                            gzipis.close();
                        }
                        if (bais != null) {
                            bais.close();
                        }
                        if (baos != null) {
                            baos.close();
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    private static String encode(byte[] bytes) {
        String result = null;
        try {
            if (bytes != null && bytes.length > 0) {
                result = Base64.encodeToString((byte[])bytes, (int)0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static byte[] decode(String encodedStr) {
        byte[] result = null;
        try {
            if (encodedStr != null && encodedStr.length() > 0) {
                result = Base64.decode((String)encodedStr, (int)0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static class GZIPWithBestCompressionOutputStream
    extends GZIPOutputStream {
        GZIPWithBestCompressionOutputStream(OutputStream out) throws IOException {
            super(out);
            if (this.def != null) {
                this.def.setLevel(9);
            }
        }
    }

    private static class UncompressTask
    extends AsyncTask<Void, Void, String> {
        private String mCompressedStr;
        private ResultHandler mHandler;

        UncompressTask(String compressedStr, ResultHandler handler) {
            this.mCompressedStr = compressedStr;
            this.mHandler = handler;
        }

        protected String doInBackground(Void ... voids) {
            String result = null;
            if (this.mCompressedStr != null && this.mCompressedStr.length() > 0) {
                result = StringUtils.localUncompress(this.mCompressedStr);
            }
            return result;
        }

        protected void onPostExecute(String str) {
            if (this.mHandler != null) {
                this.mHandler.onResult(str);
            }
        }
    }

    private static class CompressTask
    extends AsyncTask<Void, Void, String> {
        private String mStr;
        private ResultHandler mHandler;

        CompressTask(String str, ResultHandler handler) {
            this.mStr = str;
            this.mHandler = handler;
        }

        protected String doInBackground(Void ... voids) {
            String result = null;
            if (this.mStr != null && this.mStr.length() > 0) {
                result = StringUtils.localCompress(this.mStr);
            }
            return result;
        }

        protected void onPostExecute(String hexStr) {
            if (this.mHandler != null) {
                this.mHandler.onResult(hexStr);
            }
        }
    }

    static interface ResultHandler {
        public void onResult(String var1);
    }
}

