/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.Logger;
import com.sendbird.calls.Sequential;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class SequenceManager {
    private final Map<Integer, Sequential> mSequentialMap = new ConcurrentHashMap<Integer, Sequential>();
    private int mLastSequenceNumber = -1;
    private Listener mListener;

    SequenceManager() {
    }

    void setListener(Listener listener) {
        this.mListener = listener;
    }

    synchronized void insert(@NonNull Sequential sequential) {
        Logger.d("[SequenceManager] id: " + sequential.getIdentifier() + " insert: " + sequential.getClass().getSimpleName() + ", seq: " + sequential.getSequenceNumber() + ", lastSeq: " + this.mLastSequenceNumber);
        if (sequential.getSequenceNumber() == -1) {
            if (this.mListener != null) {
                this.mListener.onNext(sequential);
            }
            return;
        }
        this.mSequentialMap.put(sequential.getSequenceNumber(), sequential);
        this.flush();
    }

    void clear() {
        this.mSequentialMap.clear();
    }

    private void flush() {
        Sequential next;
        do {
            if ((next = this.next()) == null) continue;
            Logger.d("[SequenceManager] flush() next: " + next.getClass().getSimpleName() + ", seq: " + next.getSequenceNumber());
            if (this.mListener == null) continue;
            this.mListener.onNext(next);
        } while (next != null);
    }

    private synchronized Sequential next() {
        ++this.mLastSequenceNumber;
        if (this.mSequentialMap.containsKey(this.mLastSequenceNumber)) {
            return this.mSequentialMap.get(this.mLastSequenceNumber);
        }
        --this.mLastSequenceNumber;
        return null;
    }

    static interface Listener {
        public void onNext(Sequential var1);
    }
}

