/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import java.util.Set;

class PrefManager {
    private static final String PREF_NAME = "sendbird_call_sdk";
    private static final String PREF_KEY_MESSAGE_IDS = "message_ids";
    private static PrefManager mPrefManager;
    private SharedPreferences mPref;

    static synchronized PrefManager getInstance(@NonNull Context context) {
        if (mPrefManager == null) {
            mPrefManager = new PrefManager(context);
        }
        return mPrefManager;
    }

    private PrefManager(@NonNull Context context) {
        this.mPref = context.getSharedPreferences(PREF_NAME, 0);
    }

    void setMessageIds(@NonNull Set<String> messageIds) {
        SharedPreferences.Editor editor = this.mPref.edit();
        editor.putStringSet(PREF_KEY_MESSAGE_IDS, messageIds).apply();
    }

    Set<String> getMessageIds() {
        return this.mPref.getStringSet(PREF_KEY_MESSAGE_IDS, null);
    }
}

