/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.content.Context;
import android.support.annotation.NonNull;
import com.sendbird.calls.Command;
import com.sendbird.calls.EventDeDuplicator;
import com.sendbird.calls.EventDispatcher;
import com.sendbird.calls.InternalCommand;
import com.sendbird.calls.Logger;
import com.sendbird.calls.PushCommand;

class EventReceiver {
    private EventDeDuplicator mDeDuplicator;
    private EventDispatcher mEventDispatcher;

    EventReceiver(Context context, @NonNull EventDispatcher eventDispatcher) {
        this.mDeDuplicator = new EventDeDuplicator(context);
        this.mEventDispatcher = eventDispatcher;
    }

    void onPushCommandReceived(PushCommand command) {
        if (command == null) {
            return;
        }
        if (this.mDeDuplicator.isProcessed(command.getMessageId())) {
            Logger.d("[EventReceiver] onPushCommandReceived() => Ignored");
        } else {
            this.mEventDispatcher.dispatch((Command)command);
        }
    }

    void dispatchInternalCommand(InternalCommand command) {
        this.mEventDispatcher.dispatch((Command)command);
    }

    void dispatch(Command command) {
        Logger.d("[EventReceiver] command: " + command.getClass().getSimpleName());
        this.mEventDispatcher.dispatch(command);
    }
}

