/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.AcceptPushCommand;
import com.sendbird.calls.AcceptRequest;
import com.sendbird.calls.AcceptResponse;
import com.sendbird.calls.AnswerPushCommand;
import com.sendbird.calls.BaseEndPushCommand;
import com.sendbird.calls.BaseEndResponse;
import com.sendbird.calls.Candidate;
import com.sendbird.calls.CandidatePushCommand;
import com.sendbird.calls.Command;
import com.sendbird.calls.DialResponse;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.Logger;
import com.sendbird.calls.OfferPushCommand;
import com.sendbird.calls.OtherDeviceAcceptedPushCommand;
import com.sendbird.calls.RemoveCandidatesPushCommand;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.SendBirdException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.webrtc.IceCandidate;

class DirectCallStateManager {
    private DirectCallState mCurrentState;
    private ExecutorService mSingleThreadExecutor = Executors.newSingleThreadExecutor();
    private Timer mStateTimer = new Timer();
    private Timer mConnectionTimer = new Timer();
    private DirectCall mDirectCall;

    DirectCallStateManager(DirectCall directCall, DirectCallState initialState) {
        this.mDirectCall = directCall;
        this.mCurrentState = initialState;
    }

    void onCreate() {
        this.mCurrentState.onCreate(this);
    }

    DirectCall getDirectCall() {
        return this.mDirectCall;
    }

    void changeState(@NonNull DirectCallState nextState) {
        Logger.d("[StateManager] changeState(). " + this.mCurrentState.getStateName() + " => " + nextState.getStateName());
        if (this.mCurrentState.getStateName().equals(nextState.getStateName())) {
            return;
        }
        this.mCurrentState.onDestroy(this);
        this.mCurrentState = nextState;
        this.mCurrentState.onCreate(this);
    }

    void startStateTimer(long delayMillis) {
        Logger.d("[StateManager][" + this.mCurrentState.getStateName() + "] => startStateTimer(" + delayMillis + ")");
        this.mStateTimer = new Timer();
        this.mStateTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                DirectCallStateManager.this.doStateAction(() -> DirectCallStateManager.this.mCurrentState.onStateTimeout(DirectCallStateManager.this));
            }
        }, delayMillis);
    }

    void stopStateTimer() {
        Logger.d("[StateManager][" + this.mCurrentState.getStateName() + "] => stopStateTimer()");
        if (this.mStateTimer != null) {
            this.mStateTimer.cancel();
            this.mStateTimer = null;
        }
    }

    void startConnectionTimer() {
        long delayMillis = SendBirdCall.Options.mCallConnectionTimeoutSec * 1000;
        Logger.d("[StateManager][" + this.mCurrentState.getStateName() + "] => startConnectionTimer(" + delayMillis + ")");
        this.mConnectionTimer = new Timer();
        this.mConnectionTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                DirectCallStateManager.this.doStateAction(() -> DirectCallStateManager.this.mCurrentState.onConnectionTimeout(DirectCallStateManager.this));
            }
        }, delayMillis);
    }

    void stopConnectionTimer() {
        Logger.d("[StateManager][" + this.mCurrentState.getStateName() + "] => stopConnectionTimer()");
        this.mConnectionTimer.cancel();
    }

    void handleReceivedCommand(Command command) {
        this.handleReceivedCommand(command, null);
    }

    void handleReceivedCommand(Command command, SendBirdException e) {
        Logger.d("[StateManager] handleCommand(command: " + command + ", e: " + e + ")");
        this.doStateAction(() -> {
            List candidateList;
            if (command instanceof DialResponse) {
                this.mCurrentState.onDialAckReceived(this, (DialResponse)command, e);
            } else if (command instanceof AcceptRequest) {
                this.mCurrentState.accept(this);
            } else if (command instanceof AcceptResponse) {
                this.mCurrentState.onAcceptAckReceived(this, (AcceptResponse)command, e);
            } else if (command instanceof AcceptPushCommand) {
                this.mCurrentState.onAcceptReceived(this, (AcceptPushCommand)command);
            } else if (command instanceof OtherDeviceAcceptedPushCommand) {
                this.mCurrentState.onOtherDeviceAccepted(this);
            } else if (command instanceof BaseEndResponse) {
                this.mCurrentState.onEndAckReceived(this, (BaseEndResponse)command, e);
            } else if (command instanceof BaseEndPushCommand) {
                this.mCurrentState.onEndReceived(this, (BaseEndPushCommand)command);
            } else if (command instanceof OfferPushCommand) {
                this.mCurrentState.onOfferReceived(this, (OfferPushCommand)command);
            } else if (command instanceof AnswerPushCommand) {
                this.mCurrentState.onAnswerReceived(this, (AnswerPushCommand)command);
            } else if (command instanceof CandidatePushCommand) {
                Candidate candidate = ((CandidatePushCommand)command).getCandidate();
                if (candidate != null) {
                    IceCandidate iceCandidate = new IceCandidate(candidate.getSdpMid(), candidate.getSdpMlineIndex(), candidate.getSdp());
                    this.mDirectCall.addRemoteIceCandidate(iceCandidate);
                }
            } else if (command instanceof RemoveCandidatesPushCommand && (candidateList = ((RemoveCandidatesPushCommand)command).getCandidates()) != null && candidateList.size() > 0) {
                IceCandidate[] iceCandidates = new IceCandidate[candidateList.size()];
                for (int i = 0; i < candidateList.size(); ++i) {
                    Candidate candidate = (Candidate)candidateList.get(i);
                    if (candidate == null) continue;
                    iceCandidates[i] = new IceCandidate(candidate.getSdpMid(), candidate.getSdpMlineIndex(), candidate.getSdp());
                }
                this.mDirectCall.removeRemoteIceCandidates(iceCandidates);
            }
        });
    }

    void accept() {
        this.runOnSingleThreadExecutor(() -> this.doStateAction(() -> this.mCurrentState.accept(this)));
    }

    void end() {
        this.runOnSingleThreadExecutor(() -> this.doStateAction(() -> this.mCurrentState.end(this)));
    }

    void unknownEnd() {
        this.runOnSingleThreadExecutor(() -> this.doStateAction(() -> this.mCurrentState.unknownEnd(this)));
    }

    void onIceConnected() {
        this.runOnSingleThreadExecutor(() -> this.doStateAction(() -> this.mCurrentState.onIceConnected(this)));
    }

    void onIceDisconnected() {
        this.runOnSingleThreadExecutor(() -> this.doStateAction(() -> this.mCurrentState.onIceDisconnected(this)));
    }

    void onIceFailed() {
        this.runOnSingleThreadExecutor(() -> this.doStateAction(() -> this.mCurrentState.onIceFailed(this)));
    }

    void onClosed() {
        this.runOnSingleThreadExecutor(() -> this.doStateAction(() -> this.mCurrentState.onClosed(this)));
    }

    private synchronized void doStateAction(Runnable runnable) {
        runnable.run();
    }

    private void runOnSingleThreadExecutor(Runnable runnable) {
        if (this.mSingleThreadExecutor != null && !this.mSingleThreadExecutor.isShutdown()) {
            this.mSingleThreadExecutor.execute(runnable);
        }
    }
}

