/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.BaseEndPushCommand;
import com.sendbird.calls.BaseEndRequest;
import com.sendbird.calls.BaseEndResponse;
import com.sendbird.calls.DeclineRequest;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallAcceptingState;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.DirectCallStateManager;
import com.sendbird.calls.NoAnswerRequest;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.TurnCredential;
import com.sendbird.calls.UnknownEndRequest;

class DirectCallRingingState
extends DirectCallState {
    private TurnCredential mTurnCredential;

    DirectCallRingingState(TurnCredential turnCredential) {
        this.setStateTimerDelay(SendBirdCall.Options.mRingingTimeoutSec * 1000);
        this.mTurnCredential = turnCredential;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallRingingState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCallStateManager context) {
        context.startStateTimer(this.getStateTimerDelay());
        DirectCall call = context.getDirectCall();
        call.startAliveTimer();
        call.createPeerConnectionClient();
        call.dispatchEvent(DirectCall.DirectCallEventType.RINGING);
    }

    @Override
    void onDestroy(DirectCallStateManager context) {
        context.stopStateTimer();
    }

    @Override
    public void accept(DirectCallStateManager context) {
        super.accept(context);
        context.getDirectCall().sendAcceptRequest();
        context.changeState(new DirectCallAcceptingState(this.mTurnCredential));
    }

    @Override
    public void end(DirectCallStateManager context) {
        super.end(context);
        DirectCall call = context.getDirectCall();
        DeclineRequest request = new DeclineRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void unknownEnd(DirectCallStateManager context) {
        super.unknownEnd(context);
        DirectCall call = context.getDirectCall();
        UnknownEndRequest request = new UnknownEndRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onStateTimeout(DirectCallStateManager context) {
        super.onStateTimeout(context);
        DirectCall call = context.getDirectCall();
        NoAnswerRequest request = new NoAnswerRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onEndReceived(DirectCallStateManager context, BaseEndPushCommand command) {
        super.onEndReceived(context, command);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onEndAckReceived(DirectCallStateManager context, BaseEndResponse response, SendBirdException e) {
        super.onEndAckReceived(context, response, e);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onOtherDeviceAccepted(DirectCallStateManager context) {
        super.onOtherDeviceAccepted(context);
        context.changeState(new DirectCallClosingState());
    }
}

