/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.CommandSender;
import com.sendbird.calls.DirectCallEndResult;
import com.sendbird.calls.DirectCallLog;
import com.sendbird.calls.DirectCallLogListRequest;
import com.sendbird.calls.DirectCallLogListResponse;
import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.Request;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.UserContainer;
import com.sendbird.calls.handler.DirectCallLogListQueryResultHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class DirectCallLogListQuery {
    private CommandSender mCommandSender;
    private Params mParams;
    private UserContainer mUserContainer;
    private AtomicBoolean mIsLoading = new AtomicBoolean(false);
    private AtomicBoolean mHasNext = new AtomicBoolean(true);
    private String mToken;

    DirectCallLogListQuery(@NonNull CommandSender commandRouter, @NonNull Params params, @NonNull UserContainer userContainer) {
        this.mCommandSender = commandRouter;
        this.mParams = params;
        this.mUserContainer = userContainer;
    }

    public boolean isLoading() {
        return this.mIsLoading.get();
    }

    public boolean hasNext() {
        return this.mHasNext.get();
    }

    public void next(DirectCallLogListQueryResultHandler handler) {
        if (!this.mHasNext.get()) {
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(new ArrayList<DirectCallLog>(), null);
                }
            });
            return;
        }
        if (!this.mIsLoading.compareAndSet(false, true)) {
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(null, SendBirdException.getSendBirdException(1800206));
                }
            });
            return;
        }
        if (this.mUserContainer.getCurrentUser() == null) {
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(null, SendBirdException.getSendBirdException(1800303));
                }
            });
            return;
        }
        DirectCallLogListRequest request = new DirectCallLogListRequest(this.mUserContainer.getCurrentUser().getUserId(), this.mParams.mMyRole, this.mParams.mEndResults, this.mParams.mLimit, this.mToken);
        this.mCommandSender.send((Request)request, (response, e) -> {
            this.mIsLoading.set(false);
            if (e != null) {
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                });
                return;
            }
            if (response instanceof DirectCallLogListResponse) {
                DirectCallLogListResponse res = (DirectCallLogListResponse)response;
                this.mToken = res.getNextToken();
                this.mHasNext.set(res.hasNext());
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(res.getCallLogs(), null);
                    }
                });
            } else {
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(null, SendBirdException.getSendBirdException(1800205));
                    }
                });
            }
        });
    }

    public static class Params {
        DirectCallUserRole mMyRole;
        List<DirectCallEndResult> mEndResults;
        int mLimit = 10;

        public Params setMyRole(DirectCallUserRole myRole) {
            this.mMyRole = myRole;
            return this;
        }

        public Params setEndResults(List<DirectCallEndResult> endResults) {
            this.mEndResults = endResults;
            return this;
        }

        public Params setLimit(int limit) {
            this.mLimit = limit <= 0 ? 10 : (limit > 100 ? 100 : limit);
            return this;
        }
    }
}

