/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.BaseEndRequest;
import com.sendbird.calls.DialResponse;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallAbortedState;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallDialingState;
import com.sendbird.calls.DirectCallEndedState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.DirectCallStateManager;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.UnknownEndRequest;
import com.sendbird.calls.handler.DialHandler;

class DirectCallIdleState
extends DirectCallState {
    private String mCalleeId;
    private DialHandler mDialHandler;

    DirectCallIdleState(String calleeId, DialHandler dialHandler) {
        this.mCalleeId = calleeId;
        this.mDialHandler = dialHandler;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallIdleState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCallStateManager context) {
        DirectCall call = context.getDirectCall();
        call.createPeerConnectionClient();
        call.sendDialRequest(this.mCalleeId);
    }

    @Override
    void onDestroy(DirectCallStateManager context) {
    }

    @Override
    public void onDialAckReceived(DirectCallStateManager context, DialResponse response, SendBirdException e) {
        super.onDialAckReceived(context, response, e);
        DirectCall call = context.getDirectCall();
        if (e != null) {
            context.getDirectCall().onDialFailed();
            context.changeState(new DirectCallEndedState());
        } else {
            call.setVideoCall(response.isVideoCall());
            call.setCallId(response.getCallId());
            call.setCallUser(response.getCaller(), response.getCallee());
            context.changeState(new DirectCallDialingState());
        }
        if (this.mDialHandler != null) {
            this.mDialHandler.onResult(e == null ? call : null, e);
        }
    }

    @Override
    public void end(DirectCallStateManager context) {
        super.end(context);
        context.getDirectCall().abort();
        context.changeState(new DirectCallAbortedState(this.mCalleeId, this.mDialHandler));
    }

    @Override
    public void unknownEnd(DirectCallStateManager context) {
        super.unknownEnd(context);
        DirectCall call = context.getDirectCall();
        call.sendBaseEndRequest((BaseEndRequest)new UnknownEndRequest(call.getCallId()));
        context.changeState(new DirectCallClosingState());
    }
}

