/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.AnswerPushCommand;
import com.sendbird.calls.BaseEndPushCommand;
import com.sendbird.calls.BaseEndRequest;
import com.sendbird.calls.ConnectionLostRequest;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallConnectedState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.DirectCallStateManager;
import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.EndRequest;
import com.sendbird.calls.OfferPushCommand;
import com.sendbird.calls.StringUtils;
import com.sendbird.calls.UnknownEndRequest;
import org.webrtc.SessionDescription;

class DirectCallIceRestartingState
extends DirectCallState {
    private String mSdp;

    DirectCallIceRestartingState(String sdp) {
        this.setStateTimerDelay(30000L);
        this.mSdp = sdp;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallIceRestartingState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCallStateManager context) {
        context.startStateTimer(this.getStateTimerDelay());
        if (this.mSdp != null && context.getDirectCall().getMyRole() == DirectCallUserRole.CALLEE) {
            context.getDirectCall().setRemoteDescription(SessionDescription.Type.OFFER, this.mSdp);
        } else if (context.getDirectCall().getMyRole() == DirectCallUserRole.CALLER) {
            context.getDirectCall().createOffer(true);
        }
    }

    @Override
    void onDestroy(DirectCallStateManager context) {
        context.stopStateTimer();
    }

    @Override
    public void onOfferReceived(DirectCallStateManager context, OfferPushCommand command) {
        super.onOfferReceived(context, command);
        String sdp = StringUtils.uncompress(command.getSdp());
        context.getDirectCall().setRemoteDescription(SessionDescription.Type.OFFER, sdp);
    }

    @Override
    public void onAnswerReceived(DirectCallStateManager context, AnswerPushCommand command) {
        super.onAnswerReceived(context, command);
        String sdp = StringUtils.uncompress(command.getSdp());
        context.getDirectCall().setRemoteDescription(SessionDescription.Type.ANSWER, sdp);
    }

    @Override
    public void end(DirectCallStateManager context) {
        super.end(context);
        EndRequest request = new EndRequest(context.getDirectCall().getCallId());
        context.getDirectCall().sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void unknownEnd(DirectCallStateManager context) {
        super.unknownEnd(context);
        UnknownEndRequest request = new UnknownEndRequest(context.getDirectCall().getCallId());
        context.getDirectCall().sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onStateTimeout(DirectCallStateManager context) {
        super.onStateTimeout(context);
        ConnectionLostRequest request = new ConnectionLostRequest(context.getDirectCall().getCallId());
        context.getDirectCall().sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onEndReceived(DirectCallStateManager context, BaseEndPushCommand command) {
        super.onEndReceived(context, command);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onIceConnected(DirectCallStateManager context) {
        super.onIceConnected(context);
        context.changeState(new DirectCallConnectedState(true));
    }
}

