/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.BaseEndPushCommand;
import com.sendbird.calls.BaseEndRequest;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallReconnectingState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.DirectCallStateManager;
import com.sendbird.calls.EndRequest;
import com.sendbird.calls.OfferPushCommand;
import com.sendbird.calls.StringUtils;
import com.sendbird.calls.UnknownEndRequest;

class DirectCallConnectedState
extends DirectCallState {
    private boolean mIsReconnected;

    DirectCallConnectedState(boolean isReconnected) {
        this.mIsReconnected = isReconnected;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallConnectedState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCallStateManager context) {
        context.stopConnectionTimer();
        if (this.mIsReconnected) {
            context.getDirectCall().dispatchEvent(DirectCall.DirectCallEventType.RECONNECTED);
        } else {
            context.getDirectCall().dispatchEvent(DirectCall.DirectCallEventType.CONNECTED);
        }
        context.getDirectCall().startStatsTimer(this.mIsReconnected);
    }

    @Override
    void onDestroy(DirectCallStateManager context) {
        context.getDirectCall().stopStatsTimer();
    }

    @Override
    public void onOfferReceived(DirectCallStateManager context, OfferPushCommand command) {
        super.onOfferReceived(context, command);
        String sdp = StringUtils.uncompress(command.getSdp());
        context.changeState(new DirectCallReconnectingState(sdp));
    }

    @Override
    public void onIceDisconnected(DirectCallStateManager context) {
        super.onIceDisconnected(context);
        context.changeState(new DirectCallReconnectingState(null));
    }

    @Override
    public void onIceFailed(DirectCallStateManager context) {
        super.onIceFailed(context);
        context.changeState(new DirectCallReconnectingState(null));
    }

    @Override
    public void end(DirectCallStateManager context) {
        super.end(context);
        DirectCall call = context.getDirectCall();
        EndRequest request = new EndRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void unknownEnd(DirectCallStateManager context) {
        super.unknownEnd(context);
        DirectCall call = context.getDirectCall();
        UnknownEndRequest request = new UnknownEndRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onEndReceived(DirectCallStateManager context, BaseEndPushCommand command) {
        super.onEndReceived(context, command);
        context.changeState(new DirectCallClosingState());
    }
}

