/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.BaseEndPushCommand;
import com.sendbird.calls.BaseEndRequest;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallConnectedState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.DirectCallStateManager;
import com.sendbird.calls.EndRequest;
import com.sendbird.calls.Logger;
import com.sendbird.calls.OfferPushCommand;
import com.sendbird.calls.StringUtils;
import com.sendbird.calls.TimeoutRequest;
import com.sendbird.calls.UnknownEndRequest;
import org.webrtc.SessionDescription;

class DirectCallAnsweringState
extends DirectCallState {
    private String mSdp;
    private boolean mIsOfferReceived;

    DirectCallAnsweringState(String sdp) {
        this.mSdp = sdp;
        this.mIsOfferReceived = sdp != null;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallAnsweringState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCallStateManager context) {
        Logger.d("[DirectCallAnsweringState] onCreate() => (sdp == null) ? " + (this.mSdp == null));
        DirectCall call = context.getDirectCall();
        call.dispatchEvent(DirectCall.DirectCallEventType.ESTABLISHED);
        if (this.mSdp != null) {
            this.handleReceivedOffer(call, this.mSdp);
        }
    }

    @Override
    void onDestroy(DirectCallStateManager context) {
    }

    @Override
    public void onOfferReceived(DirectCallStateManager context, OfferPushCommand command) {
        super.onOfferReceived(context, command);
        String sdp = StringUtils.uncompress(command.getSdp());
        this.handleReceivedOffer(context.getDirectCall(), sdp);
    }

    @Override
    public void onIceConnected(DirectCallStateManager context) {
        super.onIceConnected(context);
        context.changeState(new DirectCallConnectedState(false));
    }

    @Override
    public void end(DirectCallStateManager context) {
        super.end(context);
        DirectCall call = context.getDirectCall();
        EndRequest request = new EndRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void unknownEnd(DirectCallStateManager context) {
        super.unknownEnd(context);
        DirectCall call = context.getDirectCall();
        UnknownEndRequest request = new UnknownEndRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onConnectionTimeout(DirectCallStateManager context) {
        super.onConnectionTimeout(context);
        DirectCall call = context.getDirectCall();
        TimeoutRequest request = this.mIsOfferReceived ? new TimeoutRequest(call.getCallId(), TimeoutRequest.Reason.WEBRTC_NOT_CONNECTED) : new TimeoutRequest(call.getCallId(), TimeoutRequest.Reason.OFFER_NOT_RECEIVED);
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onEndReceived(DirectCallStateManager context, BaseEndPushCommand command) {
        super.onEndReceived(context, command);
        context.changeState(new DirectCallClosingState());
    }

    private void handleReceivedOffer(DirectCall call, String sdp) {
        this.mIsOfferReceived = true;
        call.updateStartedAt();
        call.setRemoteDescription(SessionDescription.Type.OFFER, sdp);
        call.createAnswer();
    }
}

