/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.BaseEndRequest;
import com.sendbird.calls.CancelRequest;
import com.sendbird.calls.DialResponse;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallEndedState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.DirectCallStateManager;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.handler.DialHandler;

class DirectCallAbortedState
extends DirectCallState {
    private String mCalleeId;
    private DialHandler mDialHandler;

    DirectCallAbortedState(String calleeId, DialHandler handler) {
        this.mCalleeId = calleeId;
        this.mDialHandler = handler;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallAbortedState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCallStateManager context) {
        if (this.mDialHandler != null) {
            this.mDialHandler.onResult(null, SendBirdException.getSendBirdException(1800100));
        }
    }

    @Override
    void onDestroy(DirectCallStateManager context) {
    }

    @Override
    public void onDialAckReceived(DirectCallStateManager context, DialResponse response, SendBirdException e) {
        super.onDialAckReceived(context, response, e);
        if (e == null) {
            DirectCall call = context.getDirectCall();
            call.setVideoCall(response.isVideoCall());
            call.setCallId(response.getCallId());
            call.setCallUser(response.getCaller(), response.getCallee());
            CancelRequest request = new CancelRequest(call.getCallId());
            call.sendBaseEndRequest((BaseEndRequest)request);
        }
        context.changeState(new DirectCallEndedState());
    }
}

