/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.text.TextUtils;
import android.util.AndroidException;
import android.util.Size;
import com.sendbird.calls.Logger;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.VideoDevice;
import com.sendbird.calls.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.CapturerObserver;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;

class CameraManager {
    private Context mContext;
    private android.hardware.camera2.CameraManager mCamera2Manager;
    private CameraEnumerator mCameraEnumerator;
    private List<VideoDevice> mVideoDevices = new CopyOnWriteArrayList<VideoDevice>();
    private VideoDevice mCurrentDevice;
    private CameraVideoCapturer mCameraVideoCapturer;
    private AtomicBoolean mIsSwitchingCamera = new AtomicBoolean(false);
    private CameraDisconnectedListener mCameraDisconnectedListener;
    private CameraState mCameraState = CameraState.IDLE;
    static boolean TEST_MODE = false;

    CameraManager(Context context) {
        this.mContext = context;
        if (Build.VERSION.SDK_INT >= 21) {
            this.mCamera2Manager = (android.hardware.camera2.CameraManager)this.mContext.getSystemService("camera");
        }
        this.updateVideoDevices();
    }

    List<VideoDevice> getVideoDevices() {
        return new ArrayList<VideoDevice>(this.mVideoDevices);
    }

    VideoDevice getCurrentVideoDevice() {
        return this.mCurrentDevice;
    }

    Boolean isFrontCamera() {
        if (this.mCurrentDevice == null) {
            return null;
        }
        return this.mCurrentDevice.getPosition() == VideoDevice.Position.FRONT;
    }

    CameraState getCameraState() {
        return this.mCameraState;
    }

    VideoCapturer createVideoCapturer(Context context, boolean useFrontCamera) {
        Logger.d("[CameraManager] createVideoCapturer");
        if (TEST_MODE) {
            return new MockVideoCapturer();
        }
        if (Build.VERSION.SDK_INT >= 23 && context.checkCallingOrSelfPermission("android.permission.CAMERA") != 0) {
            Logger.d("[CameraManager] CAMERA permission not granted.");
            return null;
        }
        if (this.mVideoDevices.size() == 0) {
            return null;
        }
        CameraVideoCapturer.CameraEventsHandler cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

            public void onCameraError(String s) {
                Logger.d("[CameraManager] onCameraError(s: " + s + ")");
            }

            public void onCameraDisconnected() {
                Logger.d("[CameraManager] onCameraDisconnected()");
                CameraManager.this.mCameraState = CameraState.DISCONNECTED;
                if (CameraManager.this.mCameraDisconnectedListener != null) {
                    CameraManager.this.mCameraDisconnectedListener.onCameraDisconnected();
                }
            }

            public void onCameraFreezed(String s) {
                Logger.d("[CameraManager] onCameraFreeze(s: " + s + ")");
            }

            public void onCameraOpening(String s) {
                Logger.d("[CameraManager] onCameraOpening(s: " + s + ")");
                CameraManager.this.mCameraState = CameraState.OPENED;
            }

            public void onFirstFrameAvailable() {
                Logger.d("[CameraManager] onFirstFrameAvailable()");
            }

            public void onCameraClosed() {
                Logger.d("[CameraManager] onCameraClosed()");
                if (CameraManager.this.mCameraState != CameraState.DISCONNECTED) {
                    CameraManager.this.mCameraState = CameraState.CLOSED;
                }
            }
        };
        for (VideoDevice videoDevice : this.mVideoDevices) {
            if (useFrontCamera && videoDevice.getPosition() == VideoDevice.Position.FRONT) {
                this.mCurrentDevice = videoDevice;
                this.mCameraVideoCapturer = this.mCameraEnumerator.createCapturer(videoDevice.getDeviceName(), cameraEventsHandler);
                return this.mCameraVideoCapturer;
            }
            if (useFrontCamera || videoDevice.getPosition() != VideoDevice.Position.BACK) continue;
            this.mCurrentDevice = videoDevice;
            this.mCameraVideoCapturer = this.mCameraEnumerator.createCapturer(videoDevice.getDeviceName(), cameraEventsHandler);
            return this.mCameraVideoCapturer;
        }
        VideoDevice firstVideoDevice = this.mVideoDevices.get(0);
        this.mCameraVideoCapturer = this.mCameraEnumerator.createCapturer(firstVideoDevice.getDeviceName(), cameraEventsHandler);
        return this.mCameraVideoCapturer;
    }

    void switchCamera(CompletionHandler handler) {
        VideoDevice nextDevice = null;
        if (this.mVideoDevices.size() > 0) {
            int indexOfCurrentDevice = this.mVideoDevices.indexOf(this.mCurrentDevice);
            boolean targetFound = false;
            for (int i = 1; i <= this.mVideoDevices.size(); ++i) {
                int nextDeviceIndex = (indexOfCurrentDevice + i) % this.mVideoDevices.size();
                nextDevice = this.mVideoDevices.get(nextDeviceIndex);
                if (this.canCauseCrash(nextDevice)) continue;
                targetFound = true;
                break;
            }
            if (!targetFound) {
                nextDevice = null;
            }
        }
        this.switchCamera(nextDevice, handler);
    }

    void switchCamera(final VideoDevice device, final CompletionHandler handler) {
        Logger.d("[CameraManager] switchCamera. device => " + device);
        if (this.mCameraVideoCapturer == null || device == null || this.mVideoDevices.size() == 0) {
            if (handler != null) {
                handler.onResult(SendBirdException.getSendBirdException(1800401));
            }
            return;
        }
        if (this.mIsSwitchingCamera.get()) {
            if (handler != null) {
                handler.onResult(SendBirdException.getSendBirdException(1800400));
            }
            return;
        }
        CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler = new CameraVideoCapturer.CameraSwitchHandler(){

            public void onCameraSwitchDone(boolean isFrontCamera) {
                CameraManager.this.mCurrentDevice = device;
                Logger.d("[CameraManager] onCameraSwitchDone. currentDevice => " + CameraManager.this.mCurrentDevice);
                CameraManager.this.mIsSwitchingCamera.set(false);
                if (handler != null) {
                    handler.onResult(null);
                }
            }

            public void onCameraSwitchError(String s) {
                Logger.e("[CameraManager] onCameraSwitchError() => " + s);
                CameraManager.this.mIsSwitchingCamera.set(false);
                if (handler != null) {
                    handler.onResult(SendBirdException.getSendBirdException(1800401));
                }
            }
        };
        this.mIsSwitchingCamera.set(true);
        this.mCameraVideoCapturer.switchCamera(cameraSwitchHandler, device.getDeviceName());
    }

    void setCameraDisconnectedListener(CameraDisconnectedListener listener) {
        this.mCameraDisconnectedListener = listener;
    }

    private void updateVideoDevices() {
        this.mCameraEnumerator = Camera2Enumerator.isSupported((Context)this.mContext) ? new Camera2Enumerator(this.mContext) : new Camera1Enumerator(true);
        String[] stringArray = this.mCameraEnumerator.getDeviceNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String deviceName;
            VideoDevice.Position position = this.mCameraEnumerator.isBackFacing(deviceName = stringArray[i]) ? VideoDevice.Position.BACK : (this.mCameraEnumerator.isFrontFacing(deviceName) ? VideoDevice.Position.FRONT : VideoDevice.Position.UNSPECIFIED);
            VideoDevice device = new VideoDevice(deviceName, position, this.getCameraCharacteristics(deviceName));
            if (this.canCauseCrash(device)) continue;
            this.mVideoDevices.add(device);
        }
    }

    private CameraCharacteristics getCameraCharacteristics(String deviceName) {
        if (this.mCamera2Manager == null || Build.VERSION.SDK_INT < 21) {
            return null;
        }
        try {
            return this.mCamera2Manager.getCameraCharacteristics(deviceName);
        }
        catch (AndroidException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private VideoDevice getVideoDevice(String deviceName) {
        for (VideoDevice videoDevice : this.mVideoDevices) {
            if (!TextUtils.equals((CharSequence)videoDevice.getDeviceName(), (CharSequence)deviceName)) continue;
            return videoDevice;
        }
        return null;
    }

    private boolean canCauseCrash(VideoDevice videoDevice) {
        if (videoDevice == null || videoDevice.getCameraCharacteristics() == null) {
            return false;
        }
        CameraCharacteristics characteristics = videoDevice.getCameraCharacteristics();
        if (Build.VERSION.SDK_INT >= 21) {
            StreamConfigurationMap streamMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (streamMap == null) {
                return true;
            }
            Size[] nativeSizes = streamMap.getOutputSizes(SurfaceTexture.class);
            return nativeSizes == null;
        }
        return false;
    }

    static enum CameraState {
        IDLE,
        OPENED,
        DISCONNECTED,
        CLOSED;

    }

    static interface CameraDisconnectedListener {
        public void onCameraDisconnected();
    }

    private static class MockVideoCapturer
    implements VideoCapturer {
        private MockVideoCapturer() {
        }

        public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, CapturerObserver capturerObserver) {
        }

        public void startCapture(int width, int height, int framerate) {
        }

        public void stopCapture() throws InterruptedException {
        }

        public void changeCaptureFormat(int width, int height, int framerate) {
        }

        public void dispose() {
        }

        public boolean isScreencast() {
            return false;
        }
    }
}

