/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.content.Context;
import android.support.annotation.NonNull;
import com.sendbird.calls.AudioDevice;
import com.sendbird.calls.BroadcastListener;
import com.sendbird.calls.CallPushCommand;
import com.sendbird.calls.CancelPushCommand;
import com.sendbird.calls.Command;
import com.sendbird.calls.CommandSender;
import com.sendbird.calls.DialParams;
import com.sendbird.calls.DialPushCommand;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallSnapshot;
import com.sendbird.calls.DirectCallSnapshotCommand;
import com.sendbird.calls.EventListener;
import com.sendbird.calls.Logger;
import com.sendbird.calls.OtherDeviceDeclinedPushCommand;
import com.sendbird.calls.RingingListener;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.User;
import com.sendbird.calls.WebSocketConnectedCommand;
import com.sendbird.calls.handler.DialHandler;
import com.sendbird.calls.handler.SendBirdCallListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class CallManager
implements EventListener,
RingingListener,
BroadcastListener {
    @NonNull
    private Context mContext;
    @NonNull
    private Map<String, DirectCall> mCallMap;
    @NonNull
    private Map<String, DirectCall> mTempCallMap;
    @NonNull
    private CommandSender mCommandSender;
    @NonNull
    private Map<String, SendBirdCallListener> mSendBirdCallListeners;

    CallManager(@NonNull Context context, @NonNull CommandSender commandSender) {
        this.mContext = context;
        this.mCallMap = new ConcurrentHashMap<String, DirectCall>();
        this.mTempCallMap = new ConcurrentHashMap<String, DirectCall>();
        this.mCommandSender = commandSender;
        this.mSendBirdCallListeners = new ConcurrentHashMap<String, SendBirdCallListener>();
    }

    DirectCall getCall(String callId) {
        DirectCall call = null;
        if (callId != null) {
            call = this.mCallMap.get(callId);
            Logger.d("[CallManager] getCall(callId: " + callId + ") => " + (call != null));
        }
        return call;
    }

    @NonNull
    Map<String, SendBirdCallListener> getSendBirdCallListeners() {
        return this.mSendBirdCallListeners;
    }

    void addSendBirdCallListener(String identifier, SendBirdCallListener listener) {
        Logger.d("[CallManager] addListener(identifier: " + identifier + ")");
        this.mSendBirdCallListeners.put(identifier, listener);
    }

    SendBirdCallListener removeSendBirdCallListener(String identifier) {
        Logger.d("[CallManager] removeListener(identifier: " + identifier + ")");
        return this.mSendBirdCallListeners.remove(identifier);
    }

    void removeAllSendBirdCallListeners() {
        Logger.d("[CallManager] removeAllListeners()");
        for (String identifier : this.mSendBirdCallListeners.keySet()) {
            this.removeSendBirdCallListener(identifier);
        }
    }

    private void putCall(@NonNull DirectCall call) {
        Logger.d("[CallManager] putCall(callId: " + call.getCallId() + ")");
        if (call.getCallId() != null) {
            this.mCallMap.put(call.getCallId(), call);
        }
    }

    private void removeCall(@NonNull DirectCall call) {
        Logger.d("[CallManager] removeCall(callId: " + call.getCallId() + ")");
        if (call.getCallId() != null) {
            this.mCallMap.remove(call.getCallId());
        }
    }

    private void putTempCall(@NonNull String tempCallId, @NonNull DirectCall call) {
        Logger.d("[CallManager] putTempCall(tempCallId: " + tempCallId + ")");
        if (call.getCallId() == null) {
            this.mTempCallMap.put(tempCallId, call);
        }
    }

    private void removeTempCall(@NonNull String tempCallId) {
        Logger.d("[CallManager] removeTempCall(tempCallId: " + tempCallId + ")");
        this.mTempCallMap.remove(tempCallId);
    }

    DirectCall dial(@NonNull User currentUser, @NonNull DialParams params, DialHandler handler) {
        Logger.d("[CallManager] dial(calleeId: " + params.mCalleeId + ")");
        DirectCall directCall = new DirectCall(this.mContext, this.mCommandSender, this, this, null);
        String tempCallId = UUID.randomUUID().toString();
        this.putTempCall(tempCallId, directCall);
        directCall.dial(currentUser, params, (call, e) -> {
            Logger.i("[CallManager] onDialAckReceived(e: " + e + ")");
            this.removeTempCall(tempCallId);
            if (e != null) {
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                });
                return;
            }
            this.putCall(call);
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(call, null);
                }
            });
        });
        return directCall;
    }

    private void onDialReceived(@NonNull DialPushCommand command) {
        Logger.d("[CallManager] onDialReceived(callId: " + command.getCallId() + ")");
        DirectCall directCall = this.getCall(command.getCallId());
        if (directCall == null) {
            directCall = new DirectCall(this.mContext, this.mCommandSender, this, this, command.getCallId());
            this.putCall(directCall);
            directCall.onDialReceived(command);
        }
    }

    private void onCancelReceivedWithoutCall(@NonNull CancelPushCommand command) {
        Logger.d("[CallManager] onCancelReceivedWithoutCall()");
        DirectCall directCall = new DirectCall(this.mContext, this.mCommandSender, this, this, command.getCallId());
        this.putCall(directCall);
        directCall.onCancelReceivedWithoutCall(command);
    }

    @Override
    public void onEvent(@NonNull Command command) {
        String callId;
        DirectCall call;
        if (command instanceof DialPushCommand) {
            Logger.d("[CallManager] onEvent(command: DialPushCommand)");
            this.onDialReceived((DialPushCommand)command);
        } else if (command instanceof CallPushCommand) {
            String callId2 = ((CallPushCommand)command).getCallId();
            DirectCall call2 = this.getCall(callId2);
            if (call2 == null && command instanceof CancelPushCommand) {
                Logger.d("[CallManager] onEvent(command: CancelPushCommand, callId: " + callId2 + ")");
                this.onCancelReceivedWithoutCall((CancelPushCommand)command);
                return;
            }
            Logger.d("[CallManager] onEvent(command: " + command.getClass().getSimpleName() + ", callId: " + callId2 + ")");
            if (call2 != null) {
                call2.onEvent(command);
            }
        } else if (command instanceof DirectCallSnapshotCommand) {
            String callId3 = ((DirectCallSnapshotCommand)command).getCallId();
            DirectCallSnapshot snapshot = ((DirectCallSnapshotCommand)command).getSnapshot();
            DirectCall call3 = this.getCall(callId3);
            if (call3 != null) {
                call3.onSnapshotReceived(snapshot);
            }
        } else if (command instanceof WebSocketConnectedCommand) {
            Logger.d("[CallManager] " + command.getClass().getSimpleName() + " received.");
            this.retrieveCommands();
        } else if (command instanceof OtherDeviceDeclinedPushCommand && (call = this.getCall(callId = ((OtherDeviceDeclinedPushCommand)command).getCallId())) != null) {
            call.onEvent(command);
        }
    }

    @Override
    public void onRinging(DirectCall call) {
        for (String identifier : this.mSendBirdCallListeners.keySet()) {
            SendBirdCallListener handler = this.mSendBirdCallListeners.get(identifier);
            if (handler == null) continue;
            SendBirdCall.runOnThreadOption(() -> {
                Logger.i("[CallManager] onRinging(callId: " + call.getCallId() + ")");
                handler.onRinging(call);
            });
        }
    }

    @Override
    public void onAudioDeviceChanged(AudioDevice currentAudioDevice, Set<AudioDevice> availableAudioDevices) {
        Logger.d("[CallManager] onAudioDeviceChanged(currentAudioDevice: " + (Object)((Object)currentAudioDevice) + ", availableAudioDevices: " + availableAudioDevices + ")");
        for (DirectCall call : this.mCallMap.values()) {
            if (call == null || !call.isOngoing()) continue;
            call.onAudioDeviceChanged(currentAudioDevice, availableAudioDevices);
        }
    }

    void retrieveCommands() {
        ArrayList<String> ongoingCallIds = new ArrayList<String>();
        for (DirectCall call : this.mCallMap.values()) {
            if (!call.isOngoing() || call.getCallId() == null) continue;
            ongoingCallIds.add(call.getCallId());
        }
        this.mCommandSender.retrieveCommands(ongoingCallIds);
    }

    void endAllCalls() {
        Logger.d("[CallManager] endAllCalls() calls = " + this.mCallMap.size());
        ArrayList<DirectCall> calls = new ArrayList<DirectCall>(this.mCallMap.values());
        CountDownLatch lock = new CountDownLatch(calls.size());
        this.mCallMap.clear();
        for (DirectCall call : calls) {
            if (call != null && call.isOngoing()) {
                call.setEndListener(call1 -> lock.countDown());
                call.end();
                continue;
            }
            lock.countDown();
        }
        try {
            lock.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    int getOngoingCallCount() {
        int ongoingCalls = 0;
        for (DirectCall call : this.mCallMap.values()) {
            if (!call.isOngoing()) continue;
            ++ongoingCalls;
        }
        for (DirectCall call : this.mTempCallMap.values()) {
            if (!call.isOngoing()) continue;
            ++ongoingCalls;
        }
        return ongoingCalls;
    }

    void clearAllCalls() {
        for (DirectCall call : this.mCallMap.values()) {
            call.setListener(null);
        }
        this.mCallMap.clear();
    }
}

