/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.sendbird.calls.ApiRequest;
import com.sendbird.calls.ApiResponse;
import com.sendbird.calls.Command;
import com.sendbird.calls.CommandFactory;
import com.sendbird.calls.ErrorResponse;
import com.sendbird.calls.Logger;
import com.sendbird.calls.Request;
import com.sendbird.calls.ResponseHandler;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.shadow.okhttp3.Call;
import com.sendbird.calls.shadow.okhttp3.Callback;
import com.sendbird.calls.shadow.okhttp3.MediaType;
import com.sendbird.calls.shadow.okhttp3.OkHttpClient;
import com.sendbird.calls.shadow.okhttp3.Request;
import com.sendbird.calls.shadow.okhttp3.RequestBody;
import com.sendbird.calls.shadow.okhttp3.Response;
import java.io.IOException;

class ApiClient {
    private String mBaseUrl;
    private String mSessionToken;
    private String mClientId;
    private OkHttpClient mOkHttpClient = new OkHttpClient();
    private static final MediaType MIME_JSON = MediaType.parse((String)"application/json; charset=utf-8");

    ApiClient(String baseUrl, String clientId) {
        this.mBaseUrl = baseUrl;
        this.mClientId = clientId;
    }

    String getClientId() {
        return this.mClientId;
    }

    void send(Command command, ResponseHandler handler) {
        ApiRequest apiRequest = (ApiRequest)command;
        if (apiRequest.getMethod() == null || apiRequest.getUrl() == null) {
            Logger.e("[APIClient] getMethod() or geUrl() is null. " + apiRequest.getClass().getSimpleName());
            if (handler != null) {
                String invalidParameter = apiRequest.getMethod() == null ? "HTTP Method" : "HTTP URL";
                handler.onResponse(null, SendBirdException.getSendBirdException(invalidParameter));
            }
            return;
        }
        Request.Builder requestBuilder = new Request.Builder().header("Content-Type", "application/json").header("Connection", "Keep-Alive").header("User-Agent", "calls-android/" + SendBirdCall.getSdkVersion()).header("SendBird", "android," + this.getOSVersion() + "," + SendBirdCall.getSdkVersion()).header("SBCall-Client-Id", this.mClientId);
        if (!TextUtils.isEmpty((CharSequence)this.mSessionToken)) {
            requestBuilder.header("SBCall-Session-Token", this.mSessionToken);
        } else if (apiRequest.isSessionTokenNeeded()) {
            Logger.e("[APIClient] mSessionToken is null.");
            if (handler != null) {
                handler.onResponse(null, SendBirdException.getSendBirdException(1800303));
            }
            return;
        }
        if (apiRequest.isInternalApi()) {
            requestBuilder.addHeader("internal-key", "fd267a0ec7a5a57a4477217970644e548308cb22");
        }
        Logger.d("[APIClient] API request: " + apiRequest.getMethod() + " " + this.getHttpUrl(apiRequest) + " payload: " + apiRequest.getPayload());
        switch (apiRequest.getMethod()) {
            case GET: {
                requestBuilder.get();
                requestBuilder.url(this.getHttpUrl(apiRequest));
                break;
            }
            case POST: {
                requestBuilder.post(RequestBody.create((MediaType)MIME_JSON, (String)apiRequest.getPayload()));
                requestBuilder.url(this.mBaseUrl + apiRequest.getUrl());
                break;
            }
            case PUT: {
                requestBuilder.put(RequestBody.create((MediaType)MIME_JSON, (String)apiRequest.getPayload()));
                requestBuilder.url(this.mBaseUrl + apiRequest.getUrl());
                break;
            }
            case DELETE: {
                requestBuilder.delete(RequestBody.create((MediaType)MIME_JSON, (String)apiRequest.getPayload()));
                requestBuilder.url(this.mBaseUrl + apiRequest.getUrl());
            }
        }
        this.newCall(requestBuilder.build(), (body, e) -> {
            if (handler == null) {
                return;
            }
            if (e == null) {
                Command response = CommandFactory.parseApiCommand((Request)apiRequest, (String)body);
                if (response == null) {
                    Logger.e("[APIClient] Failed to parse response into Command.");
                    handler.onResponse(null, SendBirdException.getSendBirdExceptionWithMessage(1800205, "Failed to parse response"));
                } else if (response instanceof ErrorResponse) {
                    ErrorResponse errorResponse = (ErrorResponse)response;
                    handler.onResponse((Command)errorResponse, SendBirdException.getSendBirdExceptionWithMessage(errorResponse.getCode(), errorResponse.getMessage()));
                } else if (response instanceof ApiResponse) {
                    handler.onResponse(response, null);
                } else {
                    handler.onResponse(null, SendBirdException.getSendBirdExceptionWithMessage(1800205, "Parsed command " + response.getClass().getSimpleName() + " is not a ApiResponse."));
                }
            } else {
                handler.onResponse(null, e);
            }
        });
    }

    void setSessionToken(String sessionToken) {
        if (TextUtils.isEmpty((CharSequence)sessionToken)) {
            return;
        }
        this.mSessionToken = sessionToken;
    }

    void evictAllConnections() {
        Logger.d("[APIClient] evictAllConnections()");
        new Thread(() -> this.mOkHttpClient.connectionPool().evictAll()).start();
    }

    void cancelAllRequests() {
        Logger.d("[APIClient] cancelAllRequests()");
        this.mOkHttpClient.dispatcher().cancelAll();
    }

    private void newCall(final com.sendbird.calls.shadow.okhttp3.Request request, final APIResponseHandler handler) {
        this.mOkHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                Logger.e("[APIClient] onFailure(). request = " + request.toString() + " isCanceled = " + call.isCanceled() + ", " + Log.getStackTraceString((Throwable)e));
                if (handler != null && !call.isCanceled()) {
                    handler.onResponse(null, SendBirdException.getSendBirdExceptionWithMessage(1800200, e.getMessage()));
                }
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) {
                block3: {
                    try {
                        String body = ApiClient.this.parseResponse(response);
                        if (handler != null) {
                            handler.onResponse(body, null);
                        }
                    }
                    catch (SendBirdException e) {
                        if (handler == null) break block3;
                        handler.onResponse(null, e);
                    }
                }
            }
        });
    }

    private String getOSVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    private String parseResponse(Response response) throws SendBirdException {
        if (response.body() == null) {
            Logger.e("[APIClient] Response's body is null.");
            throw SendBirdException.getSendBirdExceptionWithMessage(1800200, "Response is null");
        }
        try {
            String body = response.body().string();
            Logger.d("[APIClient] API response: " + response.code() + " " + body);
            return body;
        }
        catch (Exception e) {
            Logger.e("[APIClient] Failed to get Response's body. " + e.getMessage());
            throw SendBirdException.getSendBirdExceptionWithMessage(1800200, e.getMessage());
        }
    }

    private String getHttpUrl(ApiRequest request) {
        if (request.getMethod() == ApiRequest.HttpRequestMethod.GET) {
            String url = this.mBaseUrl + request.getUrl();
            if (!TextUtils.isEmpty((CharSequence)request.getPayload())) {
                url = url + "?" + request.getPayload();
            }
            return url;
        }
        return request.getUrl();
    }

    private static interface APIResponseHandler {
        public void onResponse(String var1, SendBirdException var2);
    }
}

