/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import com.sendbird.calls.ApiRequest;
import com.sendbird.calls.UrlUtils;
import java.util.HashMap;
import java.util.List;

class CommandListRequest
implements ApiRequest {
    private List<String> mCallIds;

    CommandListRequest(List<String> callIds) {
        this.mCallIds = callIds;
    }

    @Override
    public String getUrl() {
        return "/v1/direct_calls/missed_signal";
    }

    @Override
    public ApiRequest.HttpRequestMethod getMethod() {
        return ApiRequest.HttpRequestMethod.GET;
    }

    @Override
    public boolean isSessionTokenNeeded() {
        return true;
    }

    @Override
    public boolean isInternalApi() {
        return false;
    }

    @Override
    public String getPayload() {
        if (this.mCallIds != null && this.mCallIds.size() > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            StringBuilder sb = new StringBuilder();
            for (String callId : this.mCallIds) {
                sb.append(callId);
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("call_ids", sb.toString());
            return UrlUtils.getQueryString(params);
        }
        return null;
    }
}

