/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import com.sendbird.calls.ApiRequest;
import com.sendbird.calls.DirectCallEndResult;
import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.UrlUtils;
import java.util.HashMap;
import java.util.List;

class DirectCallLogListRequest
implements ApiRequest {
    private String mMyUserId;
    private DirectCallUserRole mMyRole;
    private List<DirectCallEndResult> mEndResults;
    private int mLimit;
    private String mNextToken;

    public DirectCallLogListRequest(String myUserId, DirectCallUserRole myRole, List<DirectCallEndResult> endResults, int limit, String nextToken) {
        this.mMyUserId = UrlUtils.urlEncodeUTF8(myUserId);
        this.mMyRole = myRole;
        this.mEndResults = endResults;
        this.mLimit = limit;
        this.mNextToken = nextToken;
    }

    @Override
    public String getUrl() {
        return "/v1/users/" + this.mMyUserId + "/calls";
    }

    @Override
    public ApiRequest.HttpRequestMethod getMethod() {
        return ApiRequest.HttpRequestMethod.GET;
    }

    @Override
    public boolean isSessionTokenNeeded() {
        return true;
    }

    @Override
    public boolean isInternalApi() {
        return false;
    }

    @Override
    public String getPayload() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", "direct_call");
        params.put("limit", String.valueOf(this.mLimit));
        if (this.mMyRole != null) {
            params.put("role", this.mMyRole.toString());
        }
        if (this.mEndResults != null && this.mEndResults.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (DirectCallEndResult reason : this.mEndResults) {
                sb.append(reason.toString());
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("end_result", sb.toString());
        }
        if (this.mNextToken != null) {
            params.put("next", this.mNextToken);
        }
        return UrlUtils.getQueryString(params);
    }
}

