/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import com.sendbird.calls.DirectCallEndResult;
import com.sendbird.calls.DirectCallUser;
import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.shadow.com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DirectCallLog
implements Serializable {
    @SerializedName(value="call_id")
    private String mCallId;
    @SerializedName(value="started_at")
    private long mStartedAt = 0L;
    @SerializedName(value="ended_at")
    private long mEndedAt = 0L;
    @SerializedName(value="duration")
    private long mDuration = 0L;
    @SerializedName(value="user_role")
    private DirectCallUserRole mMyRole;
    @SerializedName(value="ended_by")
    private String mEndedBy;
    @SerializedName(value="participants")
    private List<DirectCallUser> mUsers;
    @SerializedName(value="end_result")
    private DirectCallEndResult mEndResult;
    @SerializedName(value="is_video_call")
    private boolean mIsVideoCall;
    @SerializedName(value="custom_items")
    private Map<String, String> mCustomItems;
    private boolean mIsFromServer;

    DirectCallLog() {
        this.mIsFromServer = true;
    }

    DirectCallLog(long startedAt, long endedAt, long duration, DirectCallUserRole myRole, String endedByUserId, DirectCallUser caller, DirectCallUser callee, DirectCallEndResult endResult, boolean isVideoCall, Map<String, String> customItems) {
        this.mStartedAt = startedAt;
        this.mEndedAt = endedAt;
        this.mDuration = duration;
        this.mMyRole = myRole;
        this.mEndedBy = endedByUserId;
        this.mUsers = new ArrayList<DirectCallUser>();
        this.mUsers.add(caller);
        this.mUsers.add(callee);
        this.mEndResult = endResult;
        this.mIsVideoCall = isVideoCall;
        this.mCustomItems = customItems;
        this.mIsFromServer = false;
    }

    public String getCallId() {
        return this.mCallId;
    }

    public long getStartedAt() {
        return this.mStartedAt;
    }

    public long getEndedAt() {
        return this.mEndedAt;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public DirectCallUserRole getMyRole() {
        return this.mMyRole;
    }

    public DirectCallUser getEndedBy() {
        if (this.mEndedBy == null) {
            return null;
        }
        for (DirectCallUser user : this.mUsers) {
            if (!user.getUserId().equals(this.mEndedBy)) continue;
            return user;
        }
        return null;
    }

    public DirectCallUser getCaller() {
        for (DirectCallUser user : this.mUsers) {
            if (user.getRole() != DirectCallUserRole.CALLER) continue;
            return user;
        }
        return null;
    }

    public DirectCallUser getCallee() {
        for (DirectCallUser user : this.mUsers) {
            if (user.getRole() != DirectCallUserRole.CALLEE) continue;
            return user;
        }
        return null;
    }

    public DirectCallEndResult getEndResult() {
        return this.mEndResult;
    }

    public boolean isVideoCall() {
        return this.mIsVideoCall;
    }

    public Map<String, String> getCustomItems() {
        if (this.mCustomItems == null) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(this.mCustomItems);
    }

    public boolean isFromServer() {
        return this.mIsFromServer;
    }
}

