/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import com.sendbird.calls.AcceptResponse;
import com.sendbird.calls.Command;
import com.sendbird.calls.CommandFactory;
import com.sendbird.calls.DeclineResponse;
import com.sendbird.calls.DirectCallSnapshot;
import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.shadow.com.google.gson.JsonArray;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;
import com.sendbird.calls.shadow.com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

class CommandList {
    @SerializedName(value="call_id")
    private String mCallId;
    @SerializedName(value="caller_client_id")
    private String mCallerClientId;
    @SerializedName(value="callee_client_id")
    private String mCalleeClientId;
    @SerializedName(value="user_role")
    private DirectCallUserRole mUserRole;
    @SerializedName(value="signal_seq")
    private JsonArray mCommandsAsJson;
    @SerializedName(value="signal_snapshot")
    private DirectCallSnapshot mSnapshot;
    private List<Command> mCommands;

    CommandList() {
    }

    String getCallId() {
        return this.mCallId;
    }

    String getCallerClientId() {
        return this.mCallerClientId;
    }

    String getCalleeClientId() {
        return this.mCalleeClientId;
    }

    DirectCallUserRole getUserRole() {
        return this.mUserRole;
    }

    List<Command> getCommands() {
        if (this.mCommands != null) {
            return this.mCommands;
        }
        this.mCommands = new ArrayList<Command>();
        if (this.mCommandsAsJson != null) {
            for (int i = 0; i < this.mCommandsAsJson.size(); ++i) {
                JsonObject json = this.mCommandsAsJson.get(i).getAsJsonObject();
                Command command = CommandFactory.parseCallCommand(json);
                if (command == null) continue;
                this.mCommands.add(command);
            }
        }
        return this.mCommands;
    }

    DirectCallSnapshot getSnapshot() {
        return this.mSnapshot;
    }

    AcceptResponse getAcceptAck() {
        for (Command command : this.getCommands()) {
            if (!(command instanceof AcceptResponse)) continue;
            return (AcceptResponse)command;
        }
        return null;
    }

    DeclineResponse getDeclineAck() {
        for (Command command : this.getCommands()) {
            if (!(command instanceof DeclineResponse)) continue;
            return (DeclineResponse)command;
        }
        return null;
    }
}

