/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import com.sendbird.calls.ApiRequest;
import com.sendbird.calls.CommandFactory;
import com.sendbird.calls.UrlUtils;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;

class AuthenticateRequest
implements ApiRequest {
    private String mAppId;
    private String mUserId;
    private String mAccessToken;
    private String mPushToken;
    private boolean mIsUnique;

    AuthenticateRequest(String appId, String userId, String accessToken, String pushToken, boolean isUnique) {
        this.mAppId = appId;
        this.mUserId = UrlUtils.urlEncodeUTF8(userId);
        this.mAccessToken = accessToken;
        this.mPushToken = pushToken;
        this.mIsUnique = isUnique;
    }

    @Override
    public String getUrl() {
        return "/v1/users/" + this.mUserId + "/login";
    }

    @Override
    public ApiRequest.HttpRequestMethod getMethod() {
        return ApiRequest.HttpRequestMethod.POST;
    }

    @Override
    public boolean isSessionTokenNeeded() {
        return false;
    }

    @Override
    public boolean isInternalApi() {
        return false;
    }

    @Override
    public String getPayload() {
        JsonObject obj = new JsonObject();
        obj.addProperty("app_id", this.mAppId);
        obj.addProperty("access_token", this.mAccessToken);
        if (this.mPushToken != null && this.mPushToken.length() > 0) {
            JsonObject pushInfoObj = new JsonObject();
            pushInfoObj.addProperty("type", "fcm_voip");
            pushInfoObj.addProperty("token", this.mPushToken);
            pushInfoObj.addProperty("is_unique", this.mIsUnique);
            obj.add("push_token", pushInfoObj);
        }
        return CommandFactory.sGson.toJson(obj);
    }
}

