/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.Command;
import com.sendbird.calls.CommandFactory;
import com.sendbird.calls.ErrorResponse;
import com.sendbird.calls.Logger;
import com.sendbird.calls.LoginPushCommand;
import com.sendbird.calls.ResponseHandler;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.WebSocketRequest;
import com.sendbird.calls.shadow.okhttp3.OkHttpClient;
import com.sendbird.calls.shadow.okhttp3.Request;
import com.sendbird.calls.shadow.okhttp3.Response;
import com.sendbird.calls.shadow.okhttp3.WebSocket;
import com.sendbird.calls.shadow.okhttp3.WebSocketListener;
import com.sendbird.calls.shadow.okio.ByteString;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

class WebSocketClient {
    private static final long RECONNECTION_BACK_OFF_PERIOD = 1000L;
    private String mSessionToken;
    private String mClientId;
    private OkHttpClient mOkHttpClient;
    private WebSocket mWebSocket;
    private Request mRequest;
    private String mWebSocketHost;
    private ConnectionState mConnectionState = ConnectionState.CLOSED;
    private ExecutorService mWriteExecutor = Executors.newSingleThreadExecutor();
    private ExecutorService mReceiveExecutor = Executors.newSingleThreadExecutor();
    private boolean mExplicitDisconnect = false;
    private WebSocketEventListener mWebSocketEventListener;
    private WebSocketListener mWebSocketListener = new WebSocketListener(){

        public void onOpen(WebSocket webSocket, Response response) {
            Logger.d("[WebSocketClient] onOpen().");
            WebSocketClient.this.mConnectionState = ConnectionState.CONNECTED;
            if (WebSocketClient.this.mWebSocketEventListener != null) {
                WebSocketClient.this.mWebSocketEventListener.onOpened();
            }
        }

        public void onMessage(WebSocket webSocket, String text) {
            Logger.d("[WebSocketClient][" + WebSocketClient.this.mClientId + "] onMessage(). Received text: \n" + text);
            WebSocketClient.this.mReceiveExecutor.execute(() -> WebSocketClient.this.onMessageReceived(text));
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
            Logger.d("[WebSocketClient] onMessage(). bytes = " + bytes);
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            Logger.d("[WebSocketClient] onClosing(code: " + code + ", reason: " + reason + ")");
            WebSocketClient.this.mConnectionState = ConnectionState.CLOSING;
            if (!WebSocketClient.this.mExplicitDisconnect) {
                WebSocketClient.this.reconnect();
            }
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            Logger.d("[WebSocketClient] onClosed(code: " + code + ", reason: " + reason + ")");
            if (!WebSocketClient.this.mExplicitDisconnect) {
                WebSocketClient.this.reconnect();
            }
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            Logger.d("[WebSocketClient] onFailure(t: " + t.getMessage() + ")");
            if (!WebSocketClient.this.mExplicitDisconnect) {
                WebSocketClient.this.reconnect();
            }
        }
    };

    WebSocketClient() {
    }

    void init(@NonNull String webSocketHost, String clientId) {
        this.mWebSocketHost = webSocketHost;
        this.mClientId = clientId;
    }

    boolean isConnectingOrConnected() {
        return this.mConnectionState == ConnectionState.CONNECTING || this.mConnectionState == ConnectionState.CONNECTED;
    }

    String getClientId() {
        return this.mClientId;
    }

    void setWebSocketEventListener(WebSocketEventListener listener) {
        this.mWebSocketEventListener = listener;
    }

    void send(WebSocketRequest request, ResponseHandler handler) {
        if (this.getConnectionState() == ConnectionState.CONNECTED) {
            if (this.mWriteExecutor != null && !this.mWriteExecutor.isShutdown()) {
                try {
                    this.mWriteExecutor.execute(() -> {
                        Logger.d("[WebSocketClient] Send message: " + request.getClass().getSimpleName() + " " + request.getPayload());
                        this.mWebSocket.send(request.getPayload() + "\n");
                    });
                }
                catch (RejectedExecutionException e) {
                    if (handler != null) {
                        int code = 1800204;
                        String message = e.getMessage();
                        handler.onResponse((Command)new ErrorResponse(request.getRequestId(), code, message), SendBirdException.getSendBirdExceptionWithMessage(code, message));
                    }
                }
            }
        } else if (handler != null) {
            int code = 1800204;
            String message = "Connection closed.";
            handler.onResponse((Command)new ErrorResponse(request.getRequestId(), code, message), SendBirdException.getSendBirdExceptionWithMessage(code, message));
        }
    }

    void setSessionToken(String sessionToken) {
        this.mSessionToken = sessionToken;
    }

    synchronized void connect() {
        Logger.d("[WebSocketClient] connect(). currentState = " + (Object)((Object)this.getConnectionState()));
        if (this.getConnectionState() == ConnectionState.CONNECTED || this.getConnectionState() == ConnectionState.CONNECTING) {
            return;
        }
        if (this.mSessionToken == null) {
            Logger.e("[WebSocketClient] connect(). mSessionToken is null.");
            return;
        }
        this.mExplicitDisconnect = false;
        StringBuilder sb = new StringBuilder(this.mWebSocketHost);
        sb.append("/?sendbird_app_id=").append(SendBirdCall.getApplicationId()).append("&sbcall_session_token=").append(this.mSessionToken).append("&sbcall_client_id=").append(this.mClientId);
        this.mRequest = new Request.Builder().header("User-Agent", "calls-android/" + SendBirdCall.getSdkVersion()).header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(sb.toString()).build();
        Logger.d("[WebSocketClient] WS request: " + sb.toString());
        this.mOkHttpClient = new OkHttpClient.Builder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
        if (this.mWriteExecutor == null) {
            this.mWriteExecutor = Executors.newSingleThreadExecutor();
        }
        if (this.mOkHttpClient != null) {
            this.mConnectionState = ConnectionState.CONNECTING;
            this.mWebSocket = this.mOkHttpClient.newWebSocket(this.mRequest, this.mWebSocketListener);
            this.mOkHttpClient.dispatcher().executorService().shutdown();
        }
    }

    void disconnect() {
        this.mExplicitDisconnect = true;
        this.quit();
    }

    ConnectionState getConnectionState() {
        return this.mConnectionState;
    }

    private void dispatchCommand(@NonNull Command command) {
        Logger.d("[WebSocketClient] dispatchCommand(command: " + command.getClass().getSimpleName() + ")");
        if (this.mWebSocketEventListener != null) {
            this.mWebSocketEventListener.onCommandReceived(command);
        }
    }

    private synchronized void quit() {
        Logger.d("[WebSocketClient] quit() mExplicitDisconnect: " + this.mExplicitDisconnect);
        if (this.mWriteExecutor != null) {
            try {
                this.mWriteExecutor.shutdown();
                if (this.mExplicitDisconnect) {
                    this.mWriteExecutor.awaitTermination(10L, TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.mWriteExecutor = null;
            }
        }
        if (!this.mExplicitDisconnect && this.mWebSocket != null) {
            this.mWebSocket.cancel();
        }
        try {
            if (this.mWebSocket != null) {
                boolean isClosedGracefully = this.mWebSocket.close(1000, "");
                Logger.d("[WebSocketClient] isClosedGracefully: " + isClosedGracefully);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mConnectionState = ConnectionState.CLOSED;
        this.mWebSocket = null;
        this.mOkHttpClient = null;
        this.mRequest = null;
        if (this.mExplicitDisconnect && this.mWebSocketEventListener != null) {
            this.mWebSocketEventListener.onClosed();
        }
    }

    private void reconnect() {
        this.quit();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.connect();
    }

    private void onMessageReceived(String text) {
        Command command = CommandFactory.parseCallCommand((String)text);
        if (command == null) {
            Logger.e("[WebSocketClient] Failed to parse received text into Command.");
            return;
        }
        if (command instanceof LoginPushCommand) {
            return;
        }
        this.dispatchCommand(command);
    }

    static interface WebSocketEventListener {
        public void onOpened();

        public void onClosed();

        public void onCommandReceived(Command var1);
    }

    static enum ConnectionState {
        CLOSED,
        CLOSING,
        CONNECTING,
        CONNECTED;

    }
}

