/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.sendbird.calls.AudioDevice;
import com.sendbird.calls.CallOptions;
import com.sendbird.calls.CameraManager;
import com.sendbird.calls.Logger;
import com.sendbird.calls.PeerConnectionEvents;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.SendBirdVideoView;
import com.sendbird.calls.VideoDevice;
import com.sendbird.calls._AppRTCAudioManager;
import com.sendbird.calls._PeerConnectionClient;
import com.sendbird.calls.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.ScreenCapturerAndroid;
import org.webrtc.SessionDescription;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFileRenderer;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

class PeerConnectionClient {
    private static final int STAT_CALLBACK_PERIOD_MS = 3000;
    private final EglBase mEglBase = EglBase.create();
    private ProxyVideoSink mRemoteProxyVideoSink = new ProxyVideoSink();
    private ProxyVideoSink mLocalProxyVideoSink = new ProxyVideoSink();
    private List<VideoSink> mRemoteSinks = new ArrayList<VideoSink>();
    private VideoFileRenderer mRemoteVideoFileRenderer;
    private _PeerConnectionClient mPeerConnectionClient;
    private _AppRTCAudioManager mAudioManager;
    private CameraManager mCameraManager;
    private SendBirdVideoView mLocalVideoView;
    private SendBirdVideoView mRemoteVideoView;
    private boolean mIsSwappedFeeds;

    PeerConnectionClient(Context context, boolean isVideoCall, List<PeerConnection.IceServer> iceServers, PeerConnectionEvents peerConnectionEvents) {
        this.mCameraManager = new CameraManager(context);
        this.mPeerConnectionClient = this.ready(context, isVideoCall, iceServers, peerConnectionEvents);
    }

    private _PeerConnectionClient ready(Context context, boolean isVideoCall, List<PeerConnection.IceServer> iceServers, PeerConnectionEvents peerConnectionEvents) {
        this.initViewRenderers();
        _PeerConnectionClient peerConnectionClient = this.createPeerConnectionClient(context, isVideoCall, iceServers, peerConnectionEvents);
        return peerConnectionClient;
    }

    private void initViewRenderers() {
        Logger.d("[PeerConnectionClient] initViewRenderers()");
        this.mRemoteSinks.clear();
        this.mRemoteSinks.add(this.mRemoteProxyVideoSink);
        this.setSwappedFeeds(false);
    }

    private void setMirror(SendBirdVideoView videoView, boolean tryToMirror) {
        if (videoView != null) {
            Boolean isFrontCamera = this.mCameraManager.isFrontCamera();
            boolean doMirror = tryToMirror;
            if (tryToMirror && (isFrontCamera == null || !isFrontCamera.booleanValue())) {
                doMirror = false;
            }
            Logger.d("[PeerConnectionClient] setMirror(mirror: " + doMirror + ") => isFrontCamera: " + isFrontCamera);
            videoView.setMirror(doMirror);
        }
    }

    private void setSwappedFeeds(boolean isSwappedFeeds) {
        this.mIsSwappedFeeds = isSwappedFeeds;
        if (this.mLocalVideoView != null) {
            this.setMirror(this.mLocalVideoView, !isSwappedFeeds);
        }
        if (this.mRemoteVideoView != null) {
            this.setMirror(this.mRemoteVideoView, isSwappedFeeds);
        }
        this.mLocalProxyVideoSink.setTarget((VideoSink)(isSwappedFeeds ? this.mRemoteVideoView : this.mLocalVideoView));
        this.mRemoteProxyVideoSink.setTarget((VideoSink)(isSwappedFeeds ? this.mLocalVideoView : this.mRemoteVideoView));
    }

    private _PeerConnectionClient createPeerConnectionClient(Context context, boolean isVideoCall, List<PeerConnection.IceServer> iceServers, PeerConnectionEvents peerConnectionEvents) {
        Logger.d("[PeerConnectionClient] createPeerConnectionClient()");
        boolean videoCallEnabled = isVideoCall;
        boolean videoMaxBitrate = false;
        String videoCodec = "VP8";
        boolean videoCodecHwAcceleration = true;
        boolean videoFlexFecEnabled = false;
        boolean audioStartBitrate = false;
        String audioCodec = "OPUS";
        boolean noAudioProcessing = false;
        boolean useOpenSLES = false;
        boolean disableBuiltInAEC = false;
        boolean disableBuiltInAGC = false;
        boolean disableBuiltInNS = false;
        boolean disableWebRtcAGCAndHPF = false;
        _PeerConnectionClient.PeerConnectionParameters mPeerConnectionParameters = new _PeerConnectionClient.PeerConnectionParameters(videoCallEnabled, 0, "VP8", true, false, 0, "OPUS", false, false, false, false, false, false);
        this.mPeerConnectionClient = new _PeerConnectionClient(context, this.mEglBase, mPeerConnectionParameters, peerConnectionEvents);
        VideoCapturer videoCapturer = null;
        if (videoCallEnabled) {
            videoCapturer = this.mCameraManager.createVideoCapturer(context, true);
        }
        this.mPeerConnectionClient.createPeerConnection(this.mLocalProxyVideoSink, this.mRemoteSinks, videoCapturer, iceServers);
        return this.mPeerConnectionClient;
    }

    @UiThread
    void setCallOptions(CallOptions callOptions) {
        if (callOptions == null) {
            return;
        }
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.setVideoConstraints(callOptions.mVideoWidth, callOptions.mVideoHeight, callOptions.mVideoFps);
        }
        this.setLocalVideoView(callOptions.mLocalVideoView);
        this.setRemoteVideoView(callOptions.mRemoteVideoView);
        this.setVideoEnabled(callOptions.mVideoEnabled);
        this.setAudioEnabled(callOptions.mAudioEnabled);
        if (this.mPeerConnectionClient != null && this.mCameraManager.isFrontCamera() != null && this.mCameraManager.isFrontCamera() != callOptions.mFrontCamera) {
            this.mCameraManager.switchCamera(null);
        }
    }

    void setConfiguration(@Nullable List<PeerConnection.IceServer> iceServers) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.setConfiguration(iceServers);
        }
    }

    @TargetApi(value=21)
    private VideoCapturer createScreenCapturer(Intent screenCaptureIntent) {
        return new ScreenCapturerAndroid(screenCaptureIntent, new MediaProjection.Callback(){

            public void onStop() {
                Logger.d("[PeerConnectionClient] User revoked permission to capture the screen.");
            }
        });
    }

    @UiThread
    void startAudioManager(Context context, boolean isVideoCall, _AppRTCAudioManager.AudioManagerEvents audioManagerEvents) {
        Logger.d("[PeerConnectionClient] startAudioManager()");
        this.mAudioManager = _AppRTCAudioManager.create(context, isVideoCall);
        this.mAudioManager.start(audioManagerEvents);
    }

    AudioDevice getCurrentAudioDevice() {
        AudioDevice audioDevice = null;
        if (this.mAudioManager != null) {
            audioDevice = this.mAudioManager.getSelectedAudioDevice();
        }
        return audioDevice;
    }

    Set<AudioDevice> getAvailableAudioDevices() {
        Set<AudioDevice> audioDevices = new HashSet<AudioDevice>();
        if (this.mAudioManager != null) {
            audioDevices = this.mAudioManager.getAudioDevices();
        }
        return audioDevices;
    }

    VideoDevice getCurrentVideoDevice() {
        if (this.mCameraManager == null) {
            return null;
        }
        return this.mCameraManager.getCurrentVideoDevice();
    }

    List<VideoDevice> getAvailableVideoDevices() {
        if (this.mCameraManager == null) {
            return null;
        }
        return this.mCameraManager.getVideoDevices();
    }

    @UiThread
    boolean selectAudioDevice(AudioDevice audioDevice) {
        boolean result = false;
        if (this.mAudioManager != null) {
            if (audioDevice == AudioDevice.SPEAKERPHONE) {
                this.mAudioManager.setDefaultAudioDeviceWithoutUpdate(AudioDevice.SPEAKERPHONE);
            } else {
                this.mAudioManager.setDefaultAudioDeviceWithoutUpdate(AudioDevice.EARPIECE);
            }
            result = this.mAudioManager.selectAudioDevice(audioDevice);
        }
        return result;
    }

    void enableStatsEvents() {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.enableStatsEvents(true, 3000);
        }
    }

    void createOffer(boolean isIceRestart) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createOffer(isIceRestart);
        }
    }

    void createAnswer() {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createAnswer();
        }
    }

    void setRemoteDescription(SessionDescription sessionDescription) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.setRemoteDescription(sessionDescription);
        }
    }

    void addRemoteIceCandidate(IceCandidate iceCandidate) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.addRemoteIceCandidate(iceCandidate);
        }
    }

    void removeRemoteIceCandidates(IceCandidate[] iceCandidates) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.removeRemoteIceCandidates(iceCandidates);
        }
    }

    boolean setVideoEnabled(boolean isEnabled) {
        if (this.mPeerConnectionClient != null) {
            return this.mPeerConnectionClient.setVideoEnabled(isEnabled);
        }
        return false;
    }

    boolean setAudioEnabled(boolean isEnabled) {
        if (this.mPeerConnectionClient != null) {
            return this.mPeerConnectionClient.setAudioEnabled(isEnabled);
        }
        return false;
    }

    void switchCamera(VideoDevice videoDevice, CompletionHandler handler) {
        if (this.mPeerConnectionClient != null && this.mPeerConnectionClient.isVideoCallEnabled()) {
            this.mCameraManager.switchCamera(videoDevice, e -> {
                if (this.mLocalVideoView != null) {
                    this.setMirror(this.mLocalVideoView, true);
                }
                if (handler != null) {
                    handler.onResult(e);
                }
            });
        } else if (handler != null) {
            handler.onResult(SendBirdException.getSendBirdException(1800401));
        }
    }

    void switchCamera(CompletionHandler handler) {
        if (this.mPeerConnectionClient != null && this.mPeerConnectionClient.isVideoCallEnabled()) {
            this.mCameraManager.switchCamera(e -> {
                if (this.mLocalVideoView != null) {
                    this.setMirror(this.mLocalVideoView, true);
                }
                if (handler != null) {
                    handler.onResult(e);
                }
            });
        } else if (handler != null) {
            handler.onResult(SendBirdException.getSendBirdException(1800401));
        }
    }

    void toggleSwappedFeeds() {
        this.setSwappedFeeds(!this.mIsSwappedFeeds);
    }

    @UiThread
    void setLocalVideoView(SendBirdVideoView videoView) {
        if (videoView == this.mLocalVideoView) {
            return;
        }
        if (videoView == null) {
            if (this.mLocalProxyVideoSink != null) {
                this.mLocalProxyVideoSink.setTarget(null);
            }
            this.mLocalVideoView.release();
            this.mLocalVideoView = null;
            return;
        }
        if (videoView == this.mRemoteVideoView) {
            this.mLocalVideoView = videoView;
            this.mRemoteVideoView = null;
            this.mRemoteProxyVideoSink.setTarget(null);
        } else {
            if (this.mLocalProxyVideoSink != null) {
                this.mLocalProxyVideoSink.setTarget(null);
            }
            videoView.release();
            if (this.mLocalVideoView != null) {
                this.mLocalVideoView.release();
            }
            this.mLocalVideoView = videoView;
            this.mLocalVideoView.init(this.mEglBase.getEglBaseContext(), null);
        }
        this.setMirror(this.mLocalVideoView, true);
        this.mLocalProxyVideoSink.setTarget((VideoSink)this.mLocalVideoView);
    }

    @UiThread
    void setRemoteVideoView(SendBirdVideoView videoView) {
        if (videoView == this.mRemoteVideoView) {
            return;
        }
        if (videoView == null) {
            if (this.mRemoteProxyVideoSink != null) {
                this.mRemoteProxyVideoSink.setTarget(null);
            }
            this.mRemoteVideoView.release();
            this.mRemoteVideoView = null;
            return;
        }
        if (videoView == this.mLocalVideoView) {
            this.mRemoteVideoView = videoView;
            this.mLocalVideoView = null;
            this.mLocalProxyVideoSink.setTarget(null);
        } else {
            if (this.mRemoteProxyVideoSink != null) {
                this.mRemoteProxyVideoSink.setTarget(null);
            }
            videoView.release();
            if (this.mRemoteVideoView != null) {
                this.mRemoteVideoView.release();
            }
            this.mRemoteVideoView = videoView;
            this.mRemoteVideoView.init(this.mEglBase.getEglBaseContext(), null);
        }
        this.setMirror(this.mRemoteVideoView, false);
        this.mRemoteProxyVideoSink.setTarget((VideoSink)this.mRemoteVideoView);
    }

    @UiThread
    void close() {
        this.mIsSwappedFeeds = false;
        if (this.mLocalProxyVideoSink != null) {
            this.mLocalProxyVideoSink.setTarget(null);
        }
        if (this.mRemoteProxyVideoSink != null) {
            this.mRemoteProxyVideoSink.setTarget(null);
        }
        if (this.mLocalVideoView != null) {
            this.mLocalVideoView.release();
            this.mLocalVideoView = null;
        }
        if (this.mRemoteVideoView != null) {
            this.mRemoteVideoView.release();
            this.mRemoteVideoView = null;
        }
        if (this.mRemoteVideoFileRenderer != null) {
            this.mRemoteVideoFileRenderer.release();
            this.mRemoteVideoFileRenderer = null;
        }
        if (this.mAudioManager != null) {
            this.mAudioManager.stop();
            this.mAudioManager = null;
        }
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.close();
        }
    }

    private static class ProxyVideoSink
    implements VideoSink {
        private VideoSink mTarget;

        private ProxyVideoSink() {
        }

        public synchronized void onFrame(VideoFrame frame) {
            if (this.mTarget == null) {
                return;
            }
            this.mTarget.onFrame(frame);
        }

        synchronized void setTarget(VideoSink target) {
            this.mTarget = target;
        }
    }
}

