/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.content.Context;
import android.support.annotation.NonNull;
import com.sendbird.calls.Command;
import com.sendbird.calls.CommandFactory;
import com.sendbird.calls.EventDeDuplicator;
import com.sendbird.calls.EventDispatcher;
import com.sendbird.calls.FcmPushCommand;
import com.sendbird.calls.InternalCommand;
import com.sendbird.calls.Logger;
import com.sendbird.calls.PushCommand;
import com.sendbird.calls.WebSocketPushCommand;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;

class EventReceiver {
    private EventDeDuplicator mDeDuplicator;
    private EventDispatcher mEventDispatcher;

    EventReceiver(Context context, @NonNull EventDispatcher eventDispatcher) {
        this.mDeDuplicator = new EventDeDuplicator(context);
        this.mEventDispatcher = eventDispatcher;
    }

    void onPushMessageReceived(JsonObject payload) {
        Logger.d("[EventReceiver] onPushMessageReceived(payload: " + payload + ")");
        Command command = CommandFactory.parseCallCommand((JsonObject)payload);
        if (command instanceof FcmPushCommand) {
            this.onPushCommandReceived((PushCommand)command);
        } else {
            Logger.e("[EventReceiver] Failed to parse fcm push message into FcmPushCommand.");
        }
    }

    void onWebSocketCommandReceived(WebSocketPushCommand command) {
        Logger.d("[EventReceiver] onWebSocketCommandReceived()");
        if (this.mDeDuplicator.isProcessed(command.getMessageId())) {
            Logger.d("[EventReceiver] onWebSocketCommandReceived() => Ignored");
        } else {
            this.mEventDispatcher.dispatch((Command)command);
        }
    }

    void onPushCommandReceived(PushCommand command) {
        if (command == null) {
            return;
        }
        if (this.mDeDuplicator.isProcessed(command.getMessageId())) {
            Logger.d("[EventReceiver] onPushCommandReceived() => Ignored");
        } else {
            this.mEventDispatcher.dispatch((Command)command);
        }
    }

    void dispatchInternalCommand(InternalCommand command) {
        this.mEventDispatcher.dispatch((Command)command);
    }

    void dispatch(Command command) {
        Logger.d("[EventReceiver] command: " + command.getClass().getSimpleName());
        this.mEventDispatcher.dispatch(command);
    }
}

