/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.AcceptPushCommand;
import com.sendbird.calls.AcceptResponse;
import com.sendbird.calls.AnswerPushCommand;
import com.sendbird.calls.BaseEndPushCommand;
import com.sendbird.calls.BaseEndResponse;
import com.sendbird.calls.DialResponse;
import com.sendbird.calls.DirectCallEndResult;
import com.sendbird.calls.DirectCallStateAction;
import com.sendbird.calls.DirectCallStateManager;
import com.sendbird.calls.Logger;
import com.sendbird.calls.OfferPushCommand;
import com.sendbird.calls.SendBirdException;

abstract class DirectCallState
implements DirectCallStateAction {
    private long mTimerDelay = 60000L;

    DirectCallState() {
    }

    @NonNull
    abstract String getStateName();

    abstract void onCreate(DirectCallStateManager var1);

    abstract void onDestroy(DirectCallStateManager var1);

    void setTimerDelay(long delayMillis) {
        this.mTimerDelay = delayMillis;
    }

    long getTimerDelay() {
        return this.mTimerDelay;
    }

    @Override
    public void onDialAckReceived(DirectCallStateManager context, DialResponse response, SendBirdException e) {
        Logger.d("[" + this.getStateName() + "] onDialAckReceived(callId: " + context.getDirectCall().getCallId() + ")");
    }

    @Override
    public void accept(DirectCallStateManager context) {
        Logger.d("[" + this.getStateName() + "] accept(callId: " + context.getDirectCall().getCallId() + ")");
    }

    @Override
    public void onAcceptAckReceived(DirectCallStateManager context, AcceptResponse response, SendBirdException e) {
        Logger.d("[" + this.getStateName() + "] onAcceptAckReceived(callId: " + context.getDirectCall().getCallId() + ", e: " + e + ")");
    }

    @Override
    public void onAcceptReceived(DirectCallStateManager context, AcceptPushCommand command) {
        Logger.d("[" + this.getStateName() + "] onAcceptReceived(callId: " + context.getDirectCall().getCallId() + ")");
    }

    @Override
    public void onOtherDeviceAccepted(DirectCallStateManager context) {
        Logger.d("[" + this.getStateName() + "] onOtherDeviceAccepted(callId: " + context.getDirectCall().getCallId() + ")");
        context.getDirectCall().setLocalEndedCall(DirectCallEndResult.OTHER_DEVICE_ACCEPTED);
    }

    @Override
    public void end(DirectCallStateManager context) {
        Logger.d("[" + this.getStateName() + "] end(callId: " + context.getDirectCall().getCallId() + ")");
    }

    @Override
    public void unknownEnd(DirectCallStateManager context) {
        Logger.d("[" + this.getStateName() + "] unknownEnd(callId: " + context.getDirectCall().getCallId() + ")");
    }

    @Override
    public void onEndAckReceived(DirectCallStateManager context, BaseEndResponse response, SendBirdException e) {
        Logger.d("[" + this.getStateName() + "] onEndAckReceived(callId: " + context.getDirectCall().getCallId() + ", type: " + response.getClass().getSimpleName() + ", e: " + e + ")");
        if (e == null) {
            context.getDirectCall().setEndedCall(response.getEndResult(), response.getEndedCallLog());
        }
    }

    @Override
    public void onEndReceived(DirectCallStateManager context, BaseEndPushCommand command) {
        Logger.d("[" + this.getStateName() + "] onEndReceived(callId: " + context.getDirectCall().getCallId() + ", type: " + command.getClass().getSimpleName() + ")");
        context.getDirectCall().setEndedCall(command.getEndResult(), command.getEndedCallLog());
    }

    @Override
    public void onOfferReceived(DirectCallStateManager context, OfferPushCommand command) {
        Logger.d("[" + this.getStateName() + "] onOfferReceived(callId: " + context.getDirectCall().getCallId() + ")");
    }

    @Override
    public void onAnswerReceived(DirectCallStateManager context, AnswerPushCommand command) {
        Logger.d("[" + this.getStateName() + "] onAnswerReceived(callId: " + context.getDirectCall().getCallId() + ")");
    }

    @Override
    public void onStateTimeout(DirectCallStateManager context) {
        Logger.d("[" + this.getStateName() + "] onStateTimeout(callId: " + context.getDirectCall().getCallId() + ")");
    }

    @Override
    public void onIceConnected(DirectCallStateManager context) {
        Logger.d("[" + this.getStateName() + "] onIceConnected(callId: " + context.getDirectCall().getCallId() + ")");
    }

    @Override
    public void onIceDisconnected(DirectCallStateManager context) {
        Logger.d("[" + this.getStateName() + "] onIceDisconnected(callId: " + context.getDirectCall().getCallId() + ")");
    }

    @Override
    public void onIceFailed(DirectCallStateManager context) {
        Logger.d("[" + this.getStateName() + "] onIceFailed(callId: " + context.getDirectCall().getCallId() + ")");
    }

    @Override
    public void onClosed(DirectCallStateManager context) {
        Logger.d("[" + this.getStateName() + "] onClosed(callId: " + context.getDirectCall().getCallId() + ")");
    }
}

