/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.BaseEndPushCommand;
import com.sendbird.calls.BaseEndRequest;
import com.sendbird.calls.ConnectionLostRequest;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallConnectedState;
import com.sendbird.calls.DirectCallIceRestartingState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.DirectCallStateManager;
import com.sendbird.calls.EndRequest;
import com.sendbird.calls.OfferPushCommand;
import com.sendbird.calls.StringUtils;
import com.sendbird.calls.UnknownEndRequest;

class DirectCallReconnectingState
extends DirectCallState {
    private String mSdp;

    DirectCallReconnectingState(String sdp) {
        this.setTimerDelay(30000L);
        this.mSdp = sdp;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallReconnectingState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCallStateManager context) {
        context.startStateTimer(this.getTimerDelay());
        context.getDirectCall().dispatchEvent(DirectCall.DirectCallEventType.RECONNECTING);
        if (this.mSdp != null) {
            context.changeState(new DirectCallIceRestartingState(this.mSdp));
        }
    }

    @Override
    void onDestroy(DirectCallStateManager context) {
        context.stopStateTimer();
    }

    @Override
    public void onIceConnected(DirectCallStateManager context) {
        super.onIceConnected(context);
        context.changeState(new DirectCallConnectedState(true));
    }

    @Override
    public void end(DirectCallStateManager context) {
        super.end(context);
        DirectCall call = context.getDirectCall();
        EndRequest request = new EndRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void unknownEnd(DirectCallStateManager context) {
        super.unknownEnd(context);
        DirectCall call = context.getDirectCall();
        UnknownEndRequest request = new UnknownEndRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onEndReceived(DirectCallStateManager context, BaseEndPushCommand command) {
        super.onEndReceived(context, command);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onStateTimeout(DirectCallStateManager context) {
        super.onStateTimeout(context);
        DirectCall call = context.getDirectCall();
        ConnectionLostRequest request = new ConnectionLostRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onOfferReceived(DirectCallStateManager context, OfferPushCommand command) {
        super.onOfferReceived(context, command);
        String sdp = StringUtils.uncompress(command.getSdp());
        context.changeState(new DirectCallIceRestartingState(sdp));
    }

    @Override
    public void onIceFailed(DirectCallStateManager context) {
        super.onIceFailed(context);
        context.changeState(new DirectCallIceRestartingState(null));
    }
}

