/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.AnswerPushCommand;
import com.sendbird.calls.BaseEndPushCommand;
import com.sendbird.calls.BaseEndRequest;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallConnectedState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.DirectCallStateManager;
import com.sendbird.calls.EndRequest;
import com.sendbird.calls.StringUtils;
import com.sendbird.calls.TimeoutRequest;
import com.sendbird.calls.UnknownEndRequest;
import org.webrtc.SessionDescription;

class DirectCallOfferingState
extends DirectCallState {
    private boolean mIsAnswerReceived = false;

    DirectCallOfferingState() {
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallOfferingState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCallStateManager context) {
        context.startStateTimer(this.getTimerDelay());
        context.getDirectCall().dispatchEvent(DirectCall.DirectCallEventType.ESTABLISHED);
        context.getDirectCall().createOffer(false);
    }

    @Override
    void onDestroy(DirectCallStateManager context) {
        context.stopStateTimer();
    }

    @Override
    public void onAnswerReceived(DirectCallStateManager context, AnswerPushCommand command) {
        super.onAnswerReceived(context, command);
        this.mIsAnswerReceived = true;
        String sdp = StringUtils.uncompress(command.getSdp());
        DirectCall call = context.getDirectCall();
        call.updateStartedAt();
        call.setRemoteDescription(SessionDescription.Type.ANSWER, sdp);
    }

    @Override
    public void onIceConnected(DirectCallStateManager context) {
        super.onIceConnected(context);
        context.changeState(new DirectCallConnectedState(false));
    }

    @Override
    public void end(DirectCallStateManager context) {
        super.end(context);
        DirectCall call = context.getDirectCall();
        EndRequest request = new EndRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void unknownEnd(DirectCallStateManager context) {
        super.unknownEnd(context);
        DirectCall call = context.getDirectCall();
        UnknownEndRequest request = new UnknownEndRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onStateTimeout(DirectCallStateManager context) {
        super.onStateTimeout(context);
        DirectCall call = context.getDirectCall();
        TimeoutRequest request = this.mIsAnswerReceived ? new TimeoutRequest(call.getCallId(), TimeoutRequest.Reason.WEBRTC_NOT_CONNECTED) : new TimeoutRequest(call.getCallId(), TimeoutRequest.Reason.ANSWER_NOT_RECEIVED);
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onEndReceived(DirectCallStateManager context, BaseEndPushCommand command) {
        super.onEndReceived(context, command);
        context.changeState(new DirectCallClosingState());
    }
}

