/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.AcceptPushCommand;
import com.sendbird.calls.BaseEndPushCommand;
import com.sendbird.calls.BaseEndRequest;
import com.sendbird.calls.CancelRequest;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallOfferingState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.DirectCallStateManager;
import com.sendbird.calls.NoAnswerRequest;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.UnknownEndRequest;

class DirectCallDialingState
extends DirectCallState {
    DirectCallDialingState() {
        this.setTimerDelay(SendBirdCall.Options.mRingingTimeoutSec * 1000);
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallDialingState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCallStateManager context) {
        DirectCall call = context.getDirectCall();
        context.startStateTimer(this.getTimerDelay());
        call.startAliveTimer();
        call.startAudioManager();
        call.sendPendingStatusRequests();
    }

    @Override
    void onDestroy(DirectCallStateManager context) {
        context.stopStateTimer();
    }

    @Override
    public void onAcceptReceived(DirectCallStateManager context, AcceptPushCommand command) {
        super.onAcceptReceived(context, command);
        context.getDirectCall().setRemoteConstraints(command.getConstraints());
        context.getDirectCall().setPeerConnectionClientConfiguration(command.getTurnCredential());
        context.changeState(new DirectCallOfferingState());
    }

    @Override
    public void end(DirectCallStateManager context) {
        super.end(context);
        DirectCall call = context.getDirectCall();
        CancelRequest request = new CancelRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void unknownEnd(DirectCallStateManager context) {
        super.unknownEnd(context);
        DirectCall call = context.getDirectCall();
        UnknownEndRequest request = new UnknownEndRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onStateTimeout(DirectCallStateManager context) {
        super.onStateTimeout(context);
        DirectCall call = context.getDirectCall();
        NoAnswerRequest request = new NoAnswerRequest(call.getCallId());
        call.sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onEndReceived(DirectCallStateManager context, BaseEndPushCommand command) {
        super.onEndReceived(context, command);
        context.changeState(new DirectCallClosingState());
    }
}

