/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.AcceptResponse;
import com.sendbird.calls.BaseEndPushCommand;
import com.sendbird.calls.BaseEndRequest;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallAnsweringState;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallEndResult;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.DirectCallStateManager;
import com.sendbird.calls.EndRequest;
import com.sendbird.calls.OfferPushCommand;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.StringUtils;
import com.sendbird.calls.TurnCredential;
import com.sendbird.calls.UnknownEndRequest;

class DirectCallAcceptingState
extends DirectCallState {
    private TurnCredential mTurnCredential;

    DirectCallAcceptingState(TurnCredential turnCredential) {
        this.mTurnCredential = turnCredential;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallAcceptingState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCallStateManager context) {
        DirectCall call = context.getDirectCall();
        call.setCallOptions();
        call.setPeerConnectionClientConfiguration(this.mTurnCredential);
        call.startAudioManager();
    }

    @Override
    void onDestroy(DirectCallStateManager context) {
    }

    @Override
    public void onAcceptAckReceived(DirectCallStateManager context, AcceptResponse response, SendBirdException e) {
        super.onAcceptAckReceived(context, response, e);
        if (e != null) {
            context.getDirectCall().setLocalEndedCall(DirectCallEndResult.ACCEPT_FAILED);
            context.changeState(new DirectCallClosingState());
            return;
        }
        context.changeState(new DirectCallAnsweringState(null));
    }

    @Override
    public void onOfferReceived(DirectCallStateManager context, OfferPushCommand command) {
        super.onOfferReceived(context, command);
        String sdp = StringUtils.uncompress(command.getSdp());
        context.changeState(new DirectCallAnsweringState(sdp));
    }

    @Override
    public void end(DirectCallStateManager context) {
        super.end(context);
        EndRequest request = new EndRequest(context.getDirectCall().getCallId());
        context.getDirectCall().sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void unknownEnd(DirectCallStateManager context) {
        super.unknownEnd(context);
        UnknownEndRequest request = new UnknownEndRequest(context.getDirectCall().getCallId());
        context.getDirectCall().sendBaseEndRequest((BaseEndRequest)request);
        context.changeState(new DirectCallClosingState());
    }

    @Override
    public void onEndReceived(DirectCallStateManager context, BaseEndPushCommand command) {
        super.onEndReceived(context, command);
        context.changeState(new DirectCallClosingState());
    }
}

