/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.sendbird.calls.AcceptParams;
import com.sendbird.calls.AcceptRequest;
import com.sendbird.calls.AcceptResponse;
import com.sendbird.calls.AliveRequest;
import com.sendbird.calls.AnswerRequest;
import com.sendbird.calls.AudioDevice;
import com.sendbird.calls.AudioStatusPushCommand;
import com.sendbird.calls.AudioStatusRequest;
import com.sendbird.calls.BaseCall;
import com.sendbird.calls.BaseEndRequest;
import com.sendbird.calls.BroadcastListener;
import com.sendbird.calls.CallOptions;
import com.sendbird.calls.CancelPushCommand;
import com.sendbird.calls.CancelRequest;
import com.sendbird.calls.CancelResponse;
import com.sendbird.calls.Candidate;
import com.sendbird.calls.CandidateRequest;
import com.sendbird.calls.Command;
import com.sendbird.calls.CommandSender;
import com.sendbird.calls.ConnectionLostRequest;
import com.sendbird.calls.ConnectionLostResponse;
import com.sendbird.calls.Constraints;
import com.sendbird.calls.DeclineRequest;
import com.sendbird.calls.DeclineResponse;
import com.sendbird.calls.DeleteCustomItemsPushCommand;
import com.sendbird.calls.DeleteCustomItemsRequest;
import com.sendbird.calls.DeleteCustomItemsResponse;
import com.sendbird.calls.DialParams;
import com.sendbird.calls.DialPushCommand;
import com.sendbird.calls.DialRequest;
import com.sendbird.calls.DialResponse;
import com.sendbird.calls.DirectCallCanceledState;
import com.sendbird.calls.DirectCallEndListener;
import com.sendbird.calls.DirectCallEndResult;
import com.sendbird.calls.DirectCallIdleState;
import com.sendbird.calls.DirectCallLog;
import com.sendbird.calls.DirectCallRingingState;
import com.sendbird.calls.DirectCallSnapshot;
import com.sendbird.calls.DirectCallStateManager;
import com.sendbird.calls.DirectCallUser;
import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.EndRequest;
import com.sendbird.calls.EndResponse;
import com.sendbird.calls.Logger;
import com.sendbird.calls.NoAnswerRequest;
import com.sendbird.calls.NoAnswerResponse;
import com.sendbird.calls.OfferRequest;
import com.sendbird.calls.OtherDeviceDeclinedPushCommand;
import com.sendbird.calls.PeerConnectionClient;
import com.sendbird.calls.PeerConnectionClientFactory;
import com.sendbird.calls.PeerConnectionEvents;
import com.sendbird.calls.PendingStatusRequests;
import com.sendbird.calls.RemoveCandidatesRequest;
import com.sendbird.calls.Request;
import com.sendbird.calls.RingingListener;
import com.sendbird.calls.RtcStatsUtils;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.SendBirdVideoView;
import com.sendbird.calls.StatsLogRequest;
import com.sendbird.calls.StringUtils;
import com.sendbird.calls.TimeoutRequest;
import com.sendbird.calls.TimeoutResponse;
import com.sendbird.calls.TurnCredential;
import com.sendbird.calls.UnknownEndRequest;
import com.sendbird.calls.UnknownEndResponse;
import com.sendbird.calls.UpdateCustomItemsPushCommand;
import com.sendbird.calls.UpdateCustomItemsRequest;
import com.sendbird.calls.UpdateCustomItemsResponse;
import com.sendbird.calls.User;
import com.sendbird.calls.VideoDevice;
import com.sendbird.calls.VideoStatusPushCommand;
import com.sendbird.calls.VideoStatusRequest;
import com.sendbird.calls.handler.CompletionHandler;
import com.sendbird.calls.handler.CustomItemsHandler;
import com.sendbird.calls.handler.DialHandler;
import com.sendbird.calls.handler.DirectCallListener;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.RTCStats;
import org.webrtc.SessionDescription;
import org.webrtc.StatsReport;

public class DirectCall
extends BaseCall {
    private static final boolean ENABLE_STATS_EVENTS = true;
    private static final long ALIVE_INTERVAL = 10000L;
    private Context mContext;
    private CommandSender mCommandSender;
    private RingingListener mRingingListener;
    private BroadcastListener mBroadcastListener;
    private DirectCallEndListener mEndListener;
    private CallOptions mCallOptions;
    private boolean mIsVideoCall;
    private boolean mAmICallee;
    private DirectCallUserRole mMyRole;
    private String mCallId;
    private DirectCallUser mCaller;
    private DirectCallUser mCallee;
    private Map<String, String> mCustomItems;
    private long mCustomItemsLastAffectedAt = 0L;
    private PeerConnectionClient mPeerConnectionClient;
    private List<String> mTurnUrls = new ArrayList<String>();
    private long mStartedAt = 0L;
    private long mEndedAt = 0L;
    private DirectCallEndResult mEndResult = DirectCallEndResult.NONE;
    private DirectCallUser mEndedBy;
    private long mDuration;
    private DirectCallLog mEndedCallLog;
    private DirectCallStateManager mStateManager;
    private Timer mAliveTimer = new Timer();
    private DirectCallListener mListener;
    private boolean mIsLocalVideoEnabled = true;
    private boolean mIsRemoteVideoEnabled = true;
    private boolean mIsLocalAudioEnabled = true;
    private boolean mIsRemoteAudioEnabled = true;
    private PendingStatusRequests mPendingStatusRequests = new PendingStatusRequests();
    private PeerConnectionEvents mPeerConnectionEvents = new PeerConnectionEvents(){
        private int mPrevTotalAudioPacketsLost = 0;
        private long mPrevTotalAudioPacketsReceived = 0L;
        private int mPrevTotalVideoPacketsLost = 0;
        private long mPrevTotalVideoPacketsReceived = 0L;

        @Override
        public void onLocalDescription(boolean isInitiator, SessionDescription sdp) {
            Logger.d(DirectCall.this.tag() + "[PCE] onLocalDescription()");
            if (sdp != null && sdp.description != null) {
                StringUtils.compress(sdp.description, result -> {
                    if (result != null && result.length() > 0) {
                        if (isInitiator) {
                            DirectCall.this.sendOfferRequest(result);
                        } else {
                            DirectCall.this.sendAnswerRequest(result);
                        }
                    }
                });
            }
        }

        @Override
        public void onIceCandidate(IceCandidate candidate) {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceCandidate(" + (candidate != null ? candidate.toString() : null) + ")");
            DirectCall.this.sendCandidateRequest(candidate);
        }

        @Override
        public void onIceCandidatesRemoved(IceCandidate[] candidates) {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceCandidatesRemoved(" + (candidates != null ? candidates.length : 0) + ")");
            if (candidates != null) {
                DirectCall.this.sendRemoveCandidatesRequest(candidates);
            }
        }

        @Override
        public void onIceConnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceConnected()");
            DirectCall.this.mStateManager.onIceConnected();
        }

        @Override
        public void onConnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onConnected()");
            if (DirectCall.this.mPeerConnectionClient != null) {
                DirectCall.this.mPeerConnectionClient.enableStatsEvents();
            }
        }

        @Override
        public void onIceDisconnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceDisconnected()");
            DirectCall.this.mStateManager.onIceDisconnected();
        }

        @Override
        public void onIceFailed() {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceFailed()");
            DirectCall.this.mStateManager.onIceFailed();
        }

        @Override
        public void onDisconnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onDisconnected()");
        }

        @Override
        public void onFailed() {
            Logger.d(DirectCall.this.tag() + "[PCE] onFailed()");
        }

        @Override
        public void onPeerConnectionClosed() {
            Logger.d(DirectCall.this.tag() + "[PCE] onPeerConnectionClosed()");
            DirectCall.this.mStateManager.onClosed();
        }

        @Override
        public void onPeerConnectionStatsReady(StatsReport[] reports) {
        }

        @Override
        public void onPeerConnectionError(String description) {
            Logger.e(DirectCall.this.tag() + "[PCE] onPeerConnectionError() => " + description);
            DirectCall.this.mStateManager.unknownEnd();
        }

        @Override
        public void onPeerConnectionAudioError(String description) {
            Logger.e(DirectCall.this.tag() + "[PCE] onPeerConnectionAudioError() => " + description);
        }

        @Override
        public void onRtcStatsEvent(Map<String, RTCStats> rtcStatsMap) {
            String callerId = DirectCall.this.mCaller != null ? DirectCall.this.mCaller.getUserId() : "";
            String calleeId = DirectCall.this.mCallee != null ? DirectCall.this.mCallee.getUserId() : "";
            JsonObject commonStat = RtcStatsUtils.getCommonStats(DirectCall.this.mContext, rtcStatsMap, SendBirdCall.getApplicationId(), DirectCall.this.mCallId, callerId, calleeId, DirectCall.this.mMyRole, DirectCall.this.mIsVideoCall);
            JsonObject audioStreamStat = RtcStatsUtils.getAudioStreamStats(rtcStatsMap, this.mPrevTotalAudioPacketsReceived, this.mPrevTotalAudioPacketsLost);
            JsonObject videoStreamStat = RtcStatsUtils.getVideoStreamProperties(rtcStatsMap, this.mPrevTotalVideoPacketsReceived, this.mPrevTotalVideoPacketsLost);
            if (audioStreamStat.has("total_packets_lost")) {
                this.mPrevTotalAudioPacketsLost = audioStreamStat.get("total_packets_lost").getAsInt();
            }
            if (audioStreamStat.has("total_packets_received")) {
                this.mPrevTotalAudioPacketsReceived = audioStreamStat.get("total_packets_received").getAsLong();
            }
            if (videoStreamStat.has("total_packets_lost")) {
                this.mPrevTotalVideoPacketsLost = videoStreamStat.get("total_packets_lost").getAsInt();
            }
            if (videoStreamStat.has("total_packets_received")) {
                this.mPrevTotalVideoPacketsReceived = videoStreamStat.get("total_packets_received").getAsLong();
            }
            StatsLogRequest request = new StatsLogRequest(commonStat, audioStreamStat, videoStreamStat);
            DirectCall.this.mCommandSender.send((Request)request, null);
        }
    };

    DirectCall(Context context, CommandSender sender, @NonNull User currentUser, @NonNull DialParams params, DialHandler dialHandler, RingingListener ringingListener, BroadcastListener broadcastListener) {
        Logger.d("[DirectCall] DirectCall() as caller");
        this.mContext = context;
        this.mCommandSender = sender;
        this.mRingingListener = ringingListener;
        this.mBroadcastListener = broadcastListener;
        this.mIsVideoCall = params.mIsVideoCall;
        this.mAmICallee = false;
        this.mMyRole = DirectCallUserRole.CALLER;
        this.mCallOptions = params.mCallOptions;
        this.mCustomItems = params.mCustomItems;
        this.mCaller = new DirectCallUser(currentUser, DirectCallUserRole.CALLER);
        this.mCallee = new DirectCallUser(new User(params.mCalleeId, null, null, null, false), DirectCallUserRole.CALLEE);
        this.setLocalVideoEnabled(params.mCallOptions.mVideoEnabled);
        this.setLocalAudioEnabled(params.mCallOptions.mAudioEnabled);
        this.mStateManager = new DirectCallStateManager(this, new DirectCallIdleState(params.mCalleeId, dialHandler));
        this.mStateManager.onCreate();
    }

    DirectCall(Context context, CommandSender sender, DialPushCommand command, RingingListener ringingListener, BroadcastListener broadcastListener) {
        Logger.d("[DirectCall] DirectCall(command: DialPushCommand) as callee");
        this.mContext = context;
        this.mCommandSender = sender;
        this.mRingingListener = ringingListener;
        this.mBroadcastListener = broadcastListener;
        this.mIsVideoCall = command.isVideoCall();
        this.mAmICallee = true;
        this.mMyRole = DirectCallUserRole.CALLEE;
        this.mCallId = command.getCallId();
        this.mCaller = command.getCaller();
        this.mCallee = command.getCallee();
        this.mCustomItems = command.getCustomItems();
        this.setRemoteConstraints(command.getConstraints());
        this.mStateManager = new DirectCallStateManager(this, new DirectCallRingingState(command.getTurnCredential()));
        this.mStateManager.onCreate();
    }

    DirectCall(Context context, CommandSender sender, CancelPushCommand command, RingingListener ringingListener, BroadcastListener broadcastListener) {
        Logger.d("[DirectCall] DirectCall(command: CancelPushCommand) as callee");
        this.mContext = context;
        this.mCommandSender = sender;
        this.mRingingListener = ringingListener;
        this.mBroadcastListener = broadcastListener;
        this.mIsVideoCall = command.getEndedCallLog().isVideoCall();
        this.mAmICallee = true;
        this.mMyRole = DirectCallUserRole.CALLEE;
        this.mCallId = command.getCallId();
        this.mCaller = command.getEndedCallLog().getCaller();
        this.mCallee = command.getEndedCallLog().getCallee();
        this.setEndedCall(DirectCallEndResult.CANCELED, command.getEndedCallLog());
        this.mStateManager = new DirectCallStateManager(this, new DirectCallCanceledState());
        this.mStateManager.onCreate();
    }

    public String getCallId() {
        return this.mCallId;
    }

    public boolean isVideoCall() {
        return this.mIsVideoCall;
    }

    public DirectCallUser getCaller() {
        return this.mCaller;
    }

    public DirectCallUser getCallee() {
        return this.mCallee;
    }

    public DirectCallUser getLocalUser() {
        if (this.mAmICallee) {
            return this.mCallee;
        }
        return this.mCaller;
    }

    public DirectCallUser getRemoteUser() {
        if (this.mAmICallee) {
            return this.mCaller;
        }
        return this.mCallee;
    }

    public DirectCallUserRole getMyRole() {
        return this.mMyRole;
    }

    public DirectCallUser getEndedBy() {
        return this.mEndedBy;
    }

    public DirectCallEndResult getEndResult() {
        return this.mEndResult;
    }

    public long getDuration() {
        long duration = this.mDuration;
        if (duration == 0L && this.mStartedAt > 0L) {
            duration = Math.max(System.currentTimeMillis() - this.mStartedAt, 0L);
        }
        return duration;
    }

    public void setListener(DirectCallListener listener) {
        Logger.d(this.tag() + "setListener()");
        this.mListener = listener;
    }

    public void accept(AcceptParams params) {
        Logger.i(this.tag() + "accept()");
        if (params == null) {
            params = new AcceptParams();
        }
        if (params.mCallOptions == null) {
            params.mCallOptions = new CallOptions();
        }
        this.mCallOptions = params.mCallOptions;
        this.setLocalVideoEnabled(params.mCallOptions.mVideoEnabled);
        this.setLocalAudioEnabled(params.mCallOptions.mAudioEnabled);
        this.mStateManager.accept();
    }

    public void end() {
        Logger.i(this.tag() + "end()");
        this.mStateManager.end();
    }

    public boolean isEnded() {
        return this.mEndResult != DirectCallEndResult.NONE;
    }

    public boolean isLocalVideoEnabled() {
        return this.mIsLocalVideoEnabled;
    }

    public boolean isRemoteVideoEnabled() {
        return this.mIsRemoteVideoEnabled;
    }

    public boolean isLocalAudioEnabled() {
        return this.mIsLocalAudioEnabled;
    }

    public boolean isRemoteAudioEnabled() {
        return this.mIsRemoteAudioEnabled;
    }

    void sendPendingStatusRequests() {
        this.mPendingStatusRequests.send(this.mCommandSender, this.mCallId, this.mCallOptions.mVideoEnabled, this.mCallOptions.mAudioEnabled);
    }

    public boolean stopVideo() {
        Logger.i(this.tag() + "stopVideo()");
        if (this.mPeerConnectionClient != null && this.mIsVideoCall) {
            boolean isApplied = this.mPeerConnectionClient.setVideoEnabled(false);
            if (isApplied) {
                this.setLocalVideoEnabled(false);
                if (this.mCallId != null) {
                    this.mCommandSender.send((Request)new VideoStatusRequest(this.mCallId, false), null);
                } else {
                    this.mPendingStatusRequests.setLocalVideoEnabled(false);
                }
            }
            return isApplied;
        }
        return false;
    }

    public boolean startVideo() {
        Logger.i(this.tag() + "startVideo()");
        if (this.mPeerConnectionClient != null && this.mIsVideoCall) {
            boolean isApplied = this.mPeerConnectionClient.setVideoEnabled(true);
            if (isApplied) {
                this.setLocalVideoEnabled(true);
                if (this.mCallId != null) {
                    this.mCommandSender.send((Request)new VideoStatusRequest(this.mCallId, true), null);
                } else {
                    this.mPendingStatusRequests.setLocalVideoEnabled(true);
                }
            }
            return isApplied;
        }
        return false;
    }

    public boolean muteMicrophone() {
        Logger.i(this.tag() + "muteMicrophone()");
        if (this.mPeerConnectionClient != null) {
            boolean isApplied = this.mPeerConnectionClient.setAudioEnabled(false);
            if (isApplied) {
                this.setLocalAudioEnabled(false);
                if (this.mCallId != null) {
                    this.mCommandSender.send((Request)new AudioStatusRequest(this.mCallId, false), null);
                } else {
                    this.mPendingStatusRequests.setLocalAudioEnabled(false);
                }
            }
            return isApplied;
        }
        return false;
    }

    public boolean unmuteMicrophone() {
        Logger.i(this.tag() + "unmuteMicrophone()");
        if (this.mPeerConnectionClient != null) {
            boolean isApplied = this.mPeerConnectionClient.setAudioEnabled(true);
            if (isApplied) {
                this.setLocalAudioEnabled(true);
                if (this.mCallId != null) {
                    this.mCommandSender.send((Request)new AudioStatusRequest(this.mCallId, true), null);
                } else {
                    this.mPendingStatusRequests.setLocalAudioEnabled(true);
                }
            }
            return isApplied;
        }
        return false;
    }

    public AudioDevice getCurrentAudioDevice() {
        AudioDevice audioDevice = null;
        if (this.mPeerConnectionClient != null) {
            audioDevice = this.mPeerConnectionClient.getCurrentAudioDevice();
        }
        Logger.d(this.tag() + "getCurrentAudioDevice() => " + (Object)((Object)audioDevice));
        return audioDevice;
    }

    public Set<AudioDevice> getAvailableAudioDevices() {
        HashSet<AudioDevice> audioDevices = new HashSet();
        if (this.mPeerConnectionClient != null) {
            audioDevices = this.mPeerConnectionClient.getAvailableAudioDevices();
        }
        Logger.d(this.tag() + "getAvailableAudioDevices() => " + audioDevices);
        return audioDevices;
    }

    public void selectAudioDevice(AudioDevice audioDevice, CompletionHandler handler) {
        SendBirdCall.runOnUIThread(() -> {
            boolean result = false;
            if (this.mPeerConnectionClient != null) {
                result = this.mPeerConnectionClient.selectAudioDevice(audioDevice);
            }
            SendBirdException e = result ? null : SendBirdException.getSendBirdException(1800402);
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(e);
                }
            });
        });
    }

    public VideoDevice getCurrentVideoDevice() {
        VideoDevice videoDevice = null;
        if (this.mPeerConnectionClient != null) {
            videoDevice = this.mPeerConnectionClient.getCurrentVideoDevice();
        }
        Logger.d(this.tag() + "getCurrentVideoDevice() => " + videoDevice);
        return videoDevice;
    }

    public List<VideoDevice> getAvailableVideoDevices() {
        ArrayList<VideoDevice> videoDevices = new ArrayList();
        if (this.mPeerConnectionClient != null) {
            videoDevices = this.mPeerConnectionClient.getAvailableVideoDevices();
        }
        Logger.d(this.tag() + "getAvailableVideoDevices() => " + videoDevices);
        return videoDevices;
    }

    public void selectVideoDevice(VideoDevice videoDevice, CompletionHandler handler) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.switchCamera(videoDevice, e -> SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(null);
                }
            }));
        } else {
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(SendBirdException.getSendBirdException(1800401));
                }
            });
        }
    }

    public void switchCamera(CompletionHandler handler) {
        Logger.d(this.tag() + "switchCamera()");
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.switchCamera(e -> SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(e);
                }
            }));
        } else {
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(SendBirdException.getSendBirdException(1800401));
                }
            });
        }
    }

    public void setLocalVideoView(SendBirdVideoView videoView) {
        Logger.d(this.tag() + "setLocalVideoView()");
        SendBirdCall.runOnUIThread(() -> {
            if (this.mPeerConnectionClient != null) {
                this.mPeerConnectionClient.setLocalVideoView(videoView);
            }
        });
    }

    public void setRemoteVideoView(SendBirdVideoView videoView) {
        Logger.d(this.tag() + "setRemoteVideoView()");
        SendBirdCall.runOnUIThread(() -> {
            if (this.mPeerConnectionClient != null) {
                this.mPeerConnectionClient.setRemoteVideoView(videoView);
            }
        });
    }

    public Map<String, String> getCustomItems() {
        if (this.mCustomItems == null) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(this.mCustomItems);
    }

    public void updateCustomItems(Map<String, String> customItems, CustomItemsHandler handler) {
        if (customItems == null) {
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(null, null, SendBirdException.getSendBirdException("customItems"));
                }
            });
            return;
        }
        UpdateCustomItemsRequest request = new UpdateCustomItemsRequest(this.mCallId, customItems);
        this.mCommandSender.send((Request)request, (response, e) -> {
            if (response instanceof UpdateCustomItemsResponse) {
                Map result = ((UpdateCustomItemsResponse)response).getCustomItems();
                List affectedKeys = ((UpdateCustomItemsResponse)response).getUpdatedKeys();
                long affectedAt = ((UpdateCustomItemsResponse)response).getAffectedAt();
                if (e == null && result != null) {
                    this.setCustomItems(result, affectedAt);
                }
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(result, affectedKeys, e);
                    }
                });
            } else {
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(null, null, SendBirdException.getSendBirdException(1800208));
                    }
                });
            }
        });
    }

    public void deleteCustomItems(Set<String> customItemKeys, CustomItemsHandler handler) {
        DeleteCustomItemsRequest request = new DeleteCustomItemsRequest(this.mCallId, customItemKeys);
        this.mCommandSender.send((Request)request, (response, e) -> {
            if (response instanceof DeleteCustomItemsResponse) {
                Map result = ((DeleteCustomItemsResponse)response).getCustomItems();
                List affectedKeys = ((DeleteCustomItemsResponse)response).getDeletedKeys();
                long affectedAt = ((DeleteCustomItemsResponse)response).getAffectedAt();
                if (e == null && result != null) {
                    this.setCustomItems(result, affectedAt);
                }
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(result, affectedKeys, null);
                    }
                });
            } else {
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(null, null, SendBirdException.getSendBirdException(1800208));
                    }
                });
            }
        });
    }

    public void deleteAllCustomItems(CustomItemsHandler handler) {
        this.deleteCustomItems(null, handler);
    }

    void updateStartedAt() {
        Logger.d(this.tag() + "updateStartedAt()");
        this.mStartedAt = System.currentTimeMillis();
    }

    void updateEndedAt() {
        this.mEndedAt = System.currentTimeMillis();
        if (this.mStartedAt > 0L) {
            this.mDuration = Math.max(this.mEndedAt - this.mStartedAt, 0L);
        }
        Logger.d(this.tag() + "updateEndedAt() => mDuration: " + this.mDuration);
    }

    void startAliveTimer() {
        Logger.d(this.tag() + "startAliveTimer(" + 10000L + ")");
        this.mAliveTimer = new Timer();
        this.mAliveTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)DirectCall.this.mCallId)) {
                    AliveRequest aliveRequest = new AliveRequest(DirectCall.this.mCallId);
                    DirectCall.this.mCommandSender.send((Request)aliveRequest, null);
                }
            }
        }, 0L, 10000L);
    }

    void stopAliveTimer() {
        Logger.d(this.tag() + "stopAliveTimer()");
        this.mAliveTimer.cancel();
    }

    void sendDialRequest(String calleeId) {
        Logger.d(this.tag() + "sendDialRequest(calleeId: " + calleeId + ")");
        DialRequest request = new DialRequest(calleeId, this.mIsVideoCall, this.mCallOptions.mAudioEnabled, this.mCallOptions.mVideoEnabled, this.mCustomItems);
        this.mCommandSender.send((Request)request, (response, e) -> {
            if (e != null) {
                this.mStateManager.handleReceivedCommand((Command)new DialResponse(), e);
            } else {
                this.mStateManager.handleReceivedCommand(response);
            }
        });
    }

    void sendAcceptRequest() {
        Logger.d(this.tag() + "sendAcceptRequest()");
        AcceptRequest request = new AcceptRequest(this.mCallId, this.mCallOptions.mAudioEnabled, this.mCallOptions.mVideoEnabled);
        this.mCommandSender.send((Request)request, (response, e) -> {
            if (e != null) {
                this.mStateManager.handleReceivedCommand((Command)new AcceptResponse(), e);
            } else {
                this.mStateManager.handleReceivedCommand(response);
            }
        });
    }

    void sendBaseEndRequest(BaseEndRequest request) {
        Logger.d(this.tag() + "sendBaseEndRequest() " + request.getClass().getSimpleName());
        this.setLocalEndedCall(request.getEndResult());
        this.mCommandSender.send((Request)request, (response, e) -> {
            if (e != null) {
                CancelResponse mockResponse = null;
                if (request instanceof CancelRequest) {
                    mockResponse = new CancelResponse();
                } else if (request instanceof DeclineRequest) {
                    mockResponse = new DeclineResponse();
                } else if (request instanceof NoAnswerRequest) {
                    mockResponse = new NoAnswerResponse();
                } else if (request instanceof EndRequest) {
                    mockResponse = new EndResponse();
                } else if (request instanceof UnknownEndRequest) {
                    mockResponse = new UnknownEndResponse();
                } else if (request instanceof TimeoutRequest) {
                    mockResponse = new TimeoutResponse();
                } else if (request instanceof ConnectionLostRequest) {
                    mockResponse = new ConnectionLostResponse();
                }
                this.mStateManager.handleReceivedCommand((Command)mockResponse, e);
            } else {
                this.mStateManager.handleReceivedCommand(response);
            }
        });
    }

    void createOffer(boolean isIceRestart) {
        Logger.d(this.tag() + "createOffer(isIceRestart: " + isIceRestart + ")");
        if (!this.mAmICallee && this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createOffer(isIceRestart);
        }
    }

    void createAnswer() {
        Logger.d(this.tag() + "createAnswer()");
        if (this.mAmICallee && this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createAnswer();
        }
    }

    void setRemoteDescription(SessionDescription.Type type, String sdp) {
        Logger.d(this.tag() + "setRemoteDescription(type: " + type.canonicalForm() + ")");
        if (sdp != null && sdp.length() > 0 && this.mPeerConnectionClient != null) {
            SessionDescription sessionDescription = new SessionDescription(type, sdp);
            this.mPeerConnectionClient.setRemoteDescription(sessionDescription);
        }
    }

    void abort() {
        Logger.d(this.tag() + "abort()");
        this.setLocalEndedCall(DirectCallEndResult.CANCELED);
        this.close();
    }

    void close() {
        Logger.d(this.tag() + "close()");
        this.closePeerConnectionClient();
    }

    void setVideoCall(boolean isVideoCall) {
        this.mIsVideoCall = isVideoCall;
    }

    void setCallId(String callId) {
        this.mCallId = callId;
    }

    void setCallUser(DirectCallUser caller, DirectCallUser callee) {
        this.mCaller = caller;
        this.mCallee = callee;
    }

    void addRemoteIceCandidate(IceCandidate candidate) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.addRemoteIceCandidate(candidate);
        }
    }

    void removeRemoteIceCandidates(IceCandidate[] iceCandidates) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.removeRemoteIceCandidates(iceCandidates);
        }
    }

    void dispatchEvent(DirectCallEventType type) {
        this.dispatchEvent(type, null);
    }

    private void dispatchEvent(DirectCallEventType type, List<String> customItemKeys) {
        Logger.d(this.tag() + "dispatchEvent(type: " + (Object)((Object)type) + "), mListener = " + this.mListener);
        if (type == DirectCallEventType.RINGING && this.mRingingListener != null) {
            this.mRingingListener.onRinging(this);
            return;
        }
        if (type == DirectCallEventType.ENDED && this.mEndListener != null) {
            this.mEndListener.onEnded(this);
        }
        switch (type) {
            case ESTABLISHED: {
                SendBirdCall.runOnThreadOption(() -> {
                    Logger.i(this.tag() + "onEstablished()");
                    if (this.mListener != null) {
                        this.mListener.onEstablished(this);
                    }
                });
                return;
            }
            case CONNECTED: {
                SendBirdCall.runOnThreadOption(() -> {
                    Logger.i(this.tag() + "onConnected()");
                    if (this.mListener != null) {
                        this.mListener.onConnected(this);
                    }
                });
                return;
            }
            case RECONNECTING: {
                SendBirdCall.runOnThreadOption(() -> {
                    Logger.i(this.tag() + "onReconnecting()");
                    if (this.mListener != null) {
                        this.mListener.onReconnecting(this);
                    }
                });
                return;
            }
            case RECONNECTED: {
                SendBirdCall.runOnThreadOption(() -> {
                    Logger.i(this.tag() + "onReconnected()");
                    if (this.mListener != null) {
                        this.mListener.onReconnected(this);
                    }
                });
                return;
            }
            case ENDED: {
                SendBirdCall.runOnThreadOption(() -> {
                    switch (this.mEndResult) {
                        case CONNECTION_LOST: 
                        case UNKNOWN: 
                        case DIAL_FAILED: 
                        case ACCEPT_FAILED: {
                            Logger.e(this.tag() + "onEnded() => " + this.mEndResult.toString().toUpperCase());
                            break;
                        }
                        case TIMED_OUT: {
                            Logger.w(this.tag() + "onEnded() => " + this.mEndResult.toString().toUpperCase());
                            break;
                        }
                        default: {
                            Logger.i(this.tag() + "onEnded() => " + this.mEndResult.toString().toUpperCase());
                        }
                    }
                    if (this.mListener != null) {
                        this.mListener.onEnded(this);
                    }
                });
                return;
            }
            case UPDATE_CUSTOM_ITEMS: {
                SendBirdCall.runOnThreadOption(() -> {
                    Logger.i(this.tag() + "onCustomItemsUpdated()");
                    if (this.mListener != null && !this.isEnded()) {
                        this.mListener.onCustomItemsUpdated(this, customItemKeys);
                    }
                });
                return;
            }
            case DELETE_CUSTOM_ITEMS: {
                SendBirdCall.runOnThreadOption(() -> {
                    Logger.i(this.tag() + "onCustomItemsDeleted()");
                    if (this.mListener != null && !this.isEnded()) {
                        this.mListener.onCustomItemsDeleted(this, customItemKeys);
                    }
                });
                return;
            }
        }
    }

    void setEndListener(DirectCallEndListener listener) {
        this.mEndListener = listener;
    }

    private void sendOfferRequest(@NonNull String sdp) {
        Logger.d(this.tag() + "sendOfferRequest()");
        OfferRequest request = new OfferRequest(this.mCallId, sdp);
        this.mCommandSender.send((Request)request, null);
    }

    private void sendAnswerRequest(@NonNull String sdp) {
        Logger.d(this.tag() + "sendAnswerRequest()");
        AnswerRequest request = new AnswerRequest(this.mCallId, sdp);
        this.mCommandSender.send((Request)request, null);
    }

    private void sendCandidateRequest(@NonNull IceCandidate candidate) {
        Logger.d(this.tag() + "sendCandidateRequest()");
        CandidateRequest request = new CandidateRequest(this.mCallId, new Candidate(candidate.sdp, candidate.sdpMLineIndex, candidate.sdpMid));
        this.mCommandSender.send((Request)request, null);
    }

    private void sendRemoveCandidatesRequest(@NonNull IceCandidate[] removeCandidates) {
        Logger.d(this.tag() + "sendRemoveCandidatesRequest()");
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (IceCandidate candidate : removeCandidates) {
            candidates.add(new Candidate(candidate.sdp, candidate.sdpMLineIndex, candidate.sdpMid));
        }
        RemoveCandidatesRequest request = new RemoveCandidatesRequest(this.mCallId, candidates);
        this.mCommandSender.send((Request)request, null);
    }

    void setRemoteConstraints(Constraints constraints) {
        this.setRemoteAudioEnabled(constraints.getAudioConstraints());
        this.setRemoteVideoEnabled(constraints.getVideoConstraints());
    }

    void createPeerConnectionClient(@Nullable TurnCredential turnCredential) {
        this.mPeerConnectionClient = PeerConnectionClientFactory.create(this.mContext, this.mIsVideoCall, this.createIceServers(turnCredential), this.mPeerConnectionEvents);
        this.setCallOptions();
    }

    void setCallOptions() {
        SendBirdCall.runOnUIThread(() -> {
            if (this.mPeerConnectionClient != null && this.mCallOptions != null) {
                this.mPeerConnectionClient.setCallOptions(this.mCallOptions);
            }
        });
    }

    void startAudioManager() {
        SendBirdCall.runOnUIThread(() -> {
            if (this.mPeerConnectionClient != null) {
                this.mPeerConnectionClient.startAudioManager(this.mContext, this.mIsVideoCall, (currentAudioDevice, availableAudioDevices) -> {
                    if (this.mBroadcastListener != null) {
                        this.mBroadcastListener.onAudioDeviceChanged(currentAudioDevice, availableAudioDevices);
                    }
                });
            }
        });
    }

    private List<PeerConnection.IceServer> createIceServers(@Nullable TurnCredential turnCredential) {
        ArrayList<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
        if (turnCredential != null) {
            String userName = turnCredential.getUserName();
            String password = turnCredential.getPassword();
            List turnUrls = turnCredential.getTurnUrls();
            if (userName != null && password != null && turnUrls != null && turnUrls.size() > 0) {
                this.mTurnUrls = new ArrayList<String>(turnUrls);
                for (String turnUrl : turnUrls) {
                    PeerConnection.IceServer turnServer = PeerConnection.IceServer.builder((String)turnUrl).setUsername(userName).setPassword(password).createIceServer();
                    iceServers.add(turnServer);
                }
            }
        }
        return iceServers;
    }

    void setPeerConnectionClientConfiguration(@Nullable TurnCredential turnCredential) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.setConfiguration(this.createIceServers(turnCredential));
        }
    }

    void setLocalEndedCall(@NonNull DirectCallEndResult endResult) {
        Logger.d(this.tag() + "setLocalEndedCall(endResult: " + endResult + ")");
        this.mEndResult = endResult;
        this.mEndedBy = this.getLocalUser();
        if (this.mStartedAt == 0L) {
            this.updateStartedAt();
            this.mEndedAt = this.mStartedAt;
            this.mDuration = 0L;
        }
        if (this.mEndedCallLog == null) {
            this.mEndedCallLog = new DirectCallLog(this.mStartedAt, this.mEndedAt, this.mDuration, this.mMyRole, this.mEndedBy.getUserId(), this.mCaller, this.mCallee, this.mEndResult, this.mIsVideoCall, this.mCustomItems);
        }
    }

    void setEndedCall(@NonNull DirectCallEndResult endResult, @NonNull DirectCallLog endedCallLog) {
        Logger.d(this.tag() + "setEndedCall(endResult: " + endResult + ", duration: " + endedCallLog.getDuration() + ")");
        this.mEndedCallLog = endedCallLog;
        this.mEndResult = endResult;
        this.mEndedBy = endedCallLog.getEndedBy();
        this.mDuration = endedCallLog.getDuration();
        this.mCaller = endedCallLog.getCaller();
        this.mCallee = endedCallLog.getCallee();
    }

    public DirectCallLog getCallLog() {
        if (this.isEnded()) {
            return this.mEndedCallLog;
        }
        return null;
    }

    private void closePeerConnectionClient() {
        if (this.mPeerConnectionClient != null) {
            Logger.d(this.tag() + "closePeerConnectionClient()");
            SendBirdCall.runOnUIThread(() -> this.mPeerConnectionClient.close());
        } else {
            this.mStateManager.onClosed();
        }
    }

    private void setLocalVideoEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setLocalVideoEnabled(isEnabled: " + isEnabled + ")");
        this.mIsLocalVideoEnabled = this.mIsVideoCall ? isEnabled : false;
    }

    private void setLocalAudioEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setLocalAudioEnabled(isEnabled: " + isEnabled + ")");
        this.mIsLocalAudioEnabled = isEnabled;
    }

    private void setRemoteVideoEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setRemoteVideoEnabled(isEnabled: " + isEnabled + ")");
        boolean isToggled = this.mIsRemoteVideoEnabled != isEnabled;
        this.mIsRemoteVideoEnabled = isEnabled;
        if (isToggled && this.mListener != null) {
            SendBirdCall.runOnThreadOption(() -> {
                Logger.i(this.tag() + "onRemoteVideoSettingsChanged(isEnabled: " + isEnabled + ")");
                if (this.mListener != null) {
                    this.mListener.onRemoteVideoSettingsChanged(this);
                }
            });
        }
    }

    private void setRemoteAudioEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setRemoteAudioEnabled(isEnabled: " + isEnabled + ")");
        boolean isToggled = this.mIsRemoteAudioEnabled != isEnabled;
        this.mIsRemoteAudioEnabled = isEnabled;
        if (isToggled && this.mListener != null) {
            SendBirdCall.runOnThreadOption(() -> {
                Logger.i(this.tag() + "onRemoteAudioSettingsChanged(isEnabled: " + isEnabled + ")");
                if (this.mListener != null) {
                    this.mListener.onRemoteAudioSettingsChanged(this);
                }
            });
        }
    }

    private void applyCustomItemSnapshot(DirectCallSnapshot.CustomItemSnapshot snapshot) {
        if (snapshot == null) {
            return;
        }
        Logger.d("[DirectCall] applyCustomItemSnapshot() current custom item: " + this.mCustomItems + ", snapshot: " + snapshot.getCustomItems());
        if (this.mCustomItemsLastAffectedAt >= snapshot.getAffectedAt()) {
            Logger.d("[DirectCall] applyCustomItemSnapshot() current custom item is up to date.");
            return;
        }
        Map newCustomItems = snapshot.getCustomItems();
        Map<String, String> oldCustomItems = this.getCustomItems();
        ArrayList<String> updatedKeys = new ArrayList<String>();
        Set<String> oldKeySet = oldCustomItems.keySet();
        for (String key : newCustomItems.keySet()) {
            if (oldKeySet.contains(key)) {
                String oldValue;
                String newValue = (String)newCustomItems.get(key);
                if (!TextUtils.equals((CharSequence)newValue, (CharSequence)(oldValue = oldCustomItems.get(key)))) {
                    updatedKeys.add(key);
                }
                oldKeySet.remove(key);
                continue;
            }
            updatedKeys.add(key);
        }
        ArrayList<String> deletedKeys = new ArrayList<String>(oldKeySet);
        this.setCustomItems(newCustomItems, snapshot.getAffectedAt());
        if (updatedKeys.size() > 0) {
            this.dispatchEvent(DirectCallEventType.UPDATE_CUSTOM_ITEMS, updatedKeys);
        }
        if (deletedKeys.size() > 0) {
            this.dispatchEvent(DirectCallEventType.DELETE_CUSTOM_ITEMS, deletedKeys);
        }
    }

    private void setCustomItems(Map<String, String> customItems, long affectedAt) {
        if (this.mCustomItemsLastAffectedAt > affectedAt) {
            return;
        }
        this.mCustomItems = new HashMap<String, String>(customItems);
        this.mCustomItemsLastAffectedAt = affectedAt;
    }

    private String tag() {
        return this.mAmICallee ? "[DirectCall][Callee] " : "[DirectCall][Caller] ";
    }

    void onSnapshotReceived(DirectCallSnapshot snapshot) {
        if (snapshot == null) {
            return;
        }
        if (snapshot.isAudioEnabled() != null) {
            this.setRemoteAudioEnabled(snapshot.isAudioEnabled());
        }
        if (snapshot.isVideoEnabled() != null) {
            this.setRemoteVideoEnabled(snapshot.isVideoEnabled());
        }
        this.applyCustomItemSnapshot(snapshot.getCustomItemSnapshot());
    }

    void onEvent(Command command) {
        Logger.d(this.tag() + "onEvent(command: " + command.getClass().getSimpleName() + ")");
        if (command instanceof VideoStatusPushCommand) {
            boolean isEnabled = ((VideoStatusPushCommand)command).isEnabled();
            this.setRemoteVideoEnabled(isEnabled);
        } else if (command instanceof AudioStatusPushCommand) {
            boolean isEnabled = ((AudioStatusPushCommand)command).isEnabled();
            this.setRemoteAudioEnabled(isEnabled);
        } else if (command instanceof UpdateCustomItemsPushCommand) {
            this.setCustomItems(((UpdateCustomItemsPushCommand)command).getCustomItems(), ((UpdateCustomItemsPushCommand)command).getAffectedAt());
            this.dispatchEvent(DirectCallEventType.UPDATE_CUSTOM_ITEMS, ((UpdateCustomItemsPushCommand)command).getUpdatedKeys());
        } else if (command instanceof DeleteCustomItemsPushCommand) {
            this.setCustomItems(((DeleteCustomItemsPushCommand)command).getCustomItems(), ((DeleteCustomItemsPushCommand)command).getAffectedAt());
            this.dispatchEvent(DirectCallEventType.DELETE_CUSTOM_ITEMS, ((DeleteCustomItemsPushCommand)command).getDeletedKeys());
        } else if (command instanceof OtherDeviceDeclinedPushCommand) {
            this.mStateManager.handleReceivedCommand((Command)((OtherDeviceDeclinedPushCommand)command).getDeclineResponse());
        } else {
            this.mStateManager.handleReceivedCommand(command);
        }
    }

    void onAudioDeviceChanged(AudioDevice currentAudioDevice, Set<AudioDevice> availableAudioDevices) {
        SendBirdCall.runOnThreadOption(() -> {
            Logger.i(this.tag() + "onAudioDeviceChanged(currentAudioDevice: " + (Object)((Object)currentAudioDevice) + ", availableAudioDevices: " + availableAudioDevices + ")");
            if (this.mListener != null) {
                this.mListener.onAudioDeviceChanged(this, currentAudioDevice, availableAudioDevices);
            }
        });
    }

    void setStateTimerDelay(long delayMillis) {
        this.mStateManager.stopStateTimer();
        this.mStateManager.startStateTimer(delayMillis);
    }

    PeerConnectionEvents getPeerConnectionEvents() {
        return this.mPeerConnectionEvents;
    }

    static enum DirectCallEventType {
        ESTABLISHED,
        CONNECTED,
        RECONNECTING,
        RECONNECTED,
        ENDED,
        RINGING,
        UPDATE_CUSTOM_ITEMS,
        DELETE_CUSTOM_ITEMS;

    }
}

