/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.sendbird.calls.AcceptResponse;
import com.sendbird.calls.ApiClient;
import com.sendbird.calls.ApiRequest;
import com.sendbird.calls.CallRequest;
import com.sendbird.calls.Command;
import com.sendbird.calls.CommandList;
import com.sendbird.calls.CommandListRequest;
import com.sendbird.calls.CommandListResponse;
import com.sendbird.calls.CommandSender;
import com.sendbird.calls.DeclineResponse;
import com.sendbird.calls.DirectCallSnapshot;
import com.sendbird.calls.DirectCallSnapshotCommand;
import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.ErrorResponse;
import com.sendbird.calls.EventReceiver;
import com.sendbird.calls.FcmPushCommand;
import com.sendbird.calls.InternalCommand;
import com.sendbird.calls.Logger;
import com.sendbird.calls.OtherDeviceAcceptedPushCommand;
import com.sendbird.calls.OtherDeviceDeclinedPushCommand;
import com.sendbird.calls.PushCommand;
import com.sendbird.calls.Request;
import com.sendbird.calls.Response;
import com.sendbird.calls.ResponseHandler;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.SequenceManager;
import com.sendbird.calls.Sequential;
import com.sendbird.calls.WebSocketClient;
import com.sendbird.calls.WebSocketConnectedCommand;
import com.sendbird.calls.WebSocketRequest;
import com.sendbird.calls.WebSocketResponse;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class CommandRouter
implements CommandSender {
    private ApiClient mApiClient;
    private WebSocketClient mWebSocketClient;
    private EventReceiver mEventReceiver;
    private ExecutorService mSingleThreadExecutor = Executors.newSingleThreadExecutor();
    @NonNull
    private Map<String, SequenceManager> mSequenceManagerMap;
    @NonNull
    private Map<String, AckHandler> mAckMap;
    private WebSocketClient.WebSocketEventListener mWebSocketEventListener = new WebSocketClient.WebSocketEventListener(){

        @Override
        public void onOpened() {
            if (CommandRouter.this.mTestWebSocketOpenListener != null) {
                CommandRouter.this.mTestWebSocketOpenListener.onOpened();
            }
            CommandRouter.this.route((Command)new WebSocketConnectedCommand(), null, null);
        }

        @Override
        public void onClosed() {
        }

        @Override
        public void onCommandReceived(Command command) {
            CommandRouter.this.handleReceivedCommand(command, null, null);
        }
    };
    private boolean mIsApiOnlyMode = false;
    private WebSocketOpenListener mTestWebSocketOpenListener;

    CommandRouter() {
        this.mSequenceManagerMap = new ConcurrentHashMap<String, SequenceManager>();
        this.mAckMap = new ConcurrentHashMap<String, AckHandler>();
    }

    void setApiClient(@NonNull ApiClient apiClient) {
        this.mApiClient = apiClient;
    }

    void setWebSocketClient(@NonNull WebSocketClient webSocketClient) {
        this.mWebSocketClient = webSocketClient;
        this.mWebSocketClient.setWebSocketEventListener(this.mWebSocketEventListener);
    }

    void setEventReceiver(@NonNull EventReceiver eventReceiver) {
        this.mEventReceiver = eventReceiver;
    }

    @Override
    public void send(Request request, ResponseHandler handler) {
        if (request instanceof CallRequest) {
            CallRequest callRequest = (CallRequest)request;
            String requestId = callRequest.getRequestId();
            if (requestId != null && handler != null) {
                this.mAckMap.put(requestId, new AckHandler(requestId, handler));
            }
            if (this.mWebSocketClient.getConnectionState() == WebSocketClient.ConnectionState.CONNECTED && !this.mIsApiOnlyMode) {
                this.mWebSocketClient.send((WebSocketRequest)callRequest, (Command response, SendBirdException e) -> this.handleReceivedCommand(response, e, handler));
            } else {
                if (!this.mWebSocketClient.isConnectingOrConnected()) {
                    this.mWebSocketClient.connect();
                }
                this.mApiClient.send((Command)request, (Command response, SendBirdException e) -> this.handleReceivedCommand(response, e, handler));
            }
        } else if (request instanceof ApiRequest) {
            this.mApiClient.send((Command)request, (Command response, SendBirdException e) -> this.handleReceivedCommand(response, e, handler));
        }
    }

    @Override
    public void setSessionToken(String sessionToken) {
        Logger.d("[CommandRouter] setSessionToken()");
        this.mApiClient.setSessionToken(sessionToken);
        this.mWebSocketClient.setSessionToken(sessionToken);
    }

    @Override
    public void destroy() {
        Logger.d("[CommandRouter] destroy()");
        this.mWebSocketClient.disconnect();
        this.setSessionToken(null);
    }

    @Override
    public void onFcmPushMessageReceived(Command command) {
        if (!(command instanceof FcmPushCommand)) {
            return;
        }
        this.handleReceivedCommand(command, null, null);
    }

    @Override
    public void retrieveCommands(List<String> callIds) {
        Logger.d("[CommandRouter] retrieveCommands(callIds: " + callIds + ")");
        CommandListRequest request = new CommandListRequest(callIds);
        this.send((Request)request, (response, e) -> {
            if (response instanceof CommandListResponse) {
                List commandLists = ((CommandListResponse)response).getCommandLists();
                for (CommandList commandList : commandLists) {
                    if (commandList.getUserRole() == DirectCallUserRole.CALLER && !TextUtils.equals((CharSequence)this.getClientId(), (CharSequence)commandList.getCallerClientId())) continue;
                    if (commandList.getUserRole() == DirectCallUserRole.CALLEE && !TextUtils.equals((CharSequence)this.getClientId(), (CharSequence)commandList.getCalleeClientId())) {
                        AcceptResponse acceptResponse = commandList.getAcceptAck();
                        if (acceptResponse != null) {
                            this.handleReceivedCommand((Command)new OtherDeviceAcceptedPushCommand(acceptResponse.getCallId()), null, null);
                            continue;
                        }
                        DeclineResponse declineResponse = commandList.getDeclineAck();
                        if (declineResponse != null) {
                            this.route((Command)new OtherDeviceDeclinedPushCommand(declineResponse), null, null);
                        }
                    }
                    String callId = commandList.getCallId();
                    DirectCallSnapshot snapshot = commandList.getSnapshot();
                    for (Command command : commandList.getCommands()) {
                        this.handleReceivedCommand(command, null, null);
                    }
                    this.route((Command)new DirectCallSnapshotCommand(callId, snapshot), null, null);
                }
            }
        });
    }

    void handleReceivedCommand(Command command, SendBirdException e, ResponseHandler handler) {
        if (command instanceof Sequential) {
            SequenceManager sequenceManager;
            String identifier = ((Sequential)command).getIdentifier();
            if (this.mSequenceManagerMap.containsKey(identifier)) {
                sequenceManager = this.mSequenceManagerMap.get(identifier);
            } else {
                sequenceManager = new SequenceManager();
                sequenceManager.setListener(sequential -> this.route((Command)sequential, null, null));
                this.mSequenceManagerMap.put(identifier, sequenceManager);
            }
            if (sequenceManager != null) {
                sequenceManager.insert((Sequential)command);
            }
        } else {
            this.route(command, e, handler);
        }
    }

    private void route(Command command, SendBirdException e, ResponseHandler handler) {
        Logger.d("[CommandRouter] route(command: " + command + ", e: " + e + ", handler: " + handler + ")");
        if (command instanceof PushCommand) {
            this.runOnSingleThreadPool(() -> this.mEventReceiver.onPushCommandReceived((PushCommand)command));
            return;
        }
        if (command instanceof InternalCommand) {
            this.runOnSingleThreadPool(() -> this.mEventReceiver.dispatchInternalCommand((InternalCommand)command));
            return;
        }
        if (command instanceof Response) {
            AckHandler ackHandler;
            String requestId;
            if (command instanceof ErrorResponse) {
                ErrorResponse er = (ErrorResponse)command;
                e = SendBirdException.getSendBirdExceptionWithMessage(er.getCode(), er.getMessage());
            }
            if (command instanceof WebSocketResponse && !TextUtils.isEmpty((CharSequence)(requestId = ((WebSocketResponse)command).getRequestId())) && (ackHandler = this.mAckMap.remove(requestId)) != null) {
                ackHandler.cancelAckTimer();
                handler = ackHandler.mResponseHandler;
            }
        }
        ResponseHandler finalHandler = handler;
        SendBirdException finalE = e;
        this.runOnSingleThreadPool(() -> {
            if (finalHandler != null) {
                finalHandler.onResponse(command, finalE);
            }
        });
    }

    private String getClientId() {
        if (this.mApiClient != null) {
            return this.mApiClient.getClientId();
        }
        if (this.mWebSocketClient != null) {
            return this.mWebSocketClient.getClientId();
        }
        return "";
    }

    private void runOnSingleThreadPool(Runnable runnable) {
        if (this.mSingleThreadExecutor != null && !this.mSingleThreadExecutor.isShutdown()) {
            this.mSingleThreadExecutor.execute(runnable);
        }
    }

    void connectWebSocket(WebSocketOpenListener listener) {
        this.mTestWebSocketOpenListener = listener;
        this.mWebSocketClient.connect();
    }

    void disconnectWebSocket() {
        this.mWebSocketClient.disconnect();
    }

    void setApiOnlyMode(boolean enable) {
        this.mIsApiOnlyMode = enable;
    }

    @NonNull
    EventReceiver getEventReceiver() {
        return this.mEventReceiver;
    }

    static interface WebSocketOpenListener {
        public void onOpened();
    }

    private class AckHandler {
        private static final int ACK_TIMEOUT_IN_MILLIS = 60000;
        @NonNull
        String mRequestId;
        @NonNull
        ResponseHandler mResponseHandler;
        Timer mTimer = new Timer();

        AckHandler(final @NonNull String requestId, ResponseHandler responseHandler) {
            this.mRequestId = requestId;
            this.mResponseHandler = responseHandler;
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    CommandRouter.this.mAckMap.remove(AckHandler.this.mRequestId);
                    CommandRouter.this.handleReceivedCommand(null, SendBirdException.getSendBirdExceptionWithMessage(1800203, "Ack Timeout. requestId: " + requestId), AckHandler.this.mResponseHandler);
                }
            }, 60000L);
        }

        void cancelAckTimer() {
            this.mTimer.cancel();
        }
    }
}

