/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import com.sendbird.calls.ApiRequest;
import com.sendbird.calls.CommandFactory;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;
import java.util.Map;

class UpdateCustomItemsRequest
implements ApiRequest {
    private Map<String, String> mCustomItems;
    private String mCallId;

    public UpdateCustomItemsRequest(String callId, Map<String, String> customItems) {
        this.mCustomItems = customItems;
        this.mCallId = callId;
    }

    @Override
    public String getUrl() {
        return "/v1/direct_calls/" + this.mCallId + "/custom_items";
    }

    @Override
    public ApiRequest.HttpRequestMethod getMethod() {
        return ApiRequest.HttpRequestMethod.PUT;
    }

    @Override
    public boolean isSessionTokenNeeded() {
        return true;
    }

    @Override
    public boolean isInternalApi() {
        return false;
    }

    @Override
    public String getPayload() {
        JsonObject obj = new JsonObject();
        if (this.mCustomItems != null && this.mCustomItems.size() > 0) {
            JsonObject customItemsObj = new JsonObject();
            for (Map.Entry<String, String> entry : this.mCustomItems.entrySet()) {
                customItemsObj.addProperty(entry.getKey(), entry.getValue());
            }
            obj.add("custom_items", customItemsObj);
        }
        obj.addProperty("mode", "upsert");
        return CommandFactory.sGson.toJson(obj);
    }
}

